/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Searchables {
    public static String ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME;
    public static String GOOGLE_SEARCH_COMPONENT_NAME;
    private static final String LOG_TAG = "Searchables";
    private static final String MD_LABEL_DEFAULT_SEARCHABLE = "android.app.default_searchable";
    private static final String MD_SEARCHABLE_SYSTEM_SEARCH = "*";
    private Context mContext;
    private ComponentName mGlobalSearchActivity = null;
    private ArrayList<SearchableInfo> mSearchablesInGlobalSearchList = null;
    private ArrayList<SearchableInfo> mSearchablesList = null;
    private HashMap<ComponentName, SearchableInfo> mSearchablesMap = null;
    private ComponentName mWebSearchActivity = null;

    static {
        GOOGLE_SEARCH_COMPONENT_NAME = "com.android.googlesearch/.GoogleSearch";
        ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME = "com.google.android.providers.enhancedgooglesearch/.Launcher";
    }

    public Searchables(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ComponentName findGlobalSearchActivity() {
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentActivities(intent, 65536);
        int n = list == null ? 0 : list.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Log.w(LOG_TAG, "No global search activity found");
                return null;
            }
            ActivityInfo activityInfo = list.get((int)n2).activityInfo;
            if (packageManager.checkPermission("android.permission.GLOBAL_SEARCH", activityInfo.packageName) == 0) {
                return new ComponentName(activityInfo.packageName, activityInfo.name);
            }
            Log.w(LOG_TAG, "Package " + activityInfo.packageName + " wants to handle GLOBAL_SEARCH, " + "but does not have the GLOBAL_SEARCH permission.");
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ComponentName findWebSearchActivity(ComponentName componentName) {
        if (componentName == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.setPackage(componentName.getPackageName());
        List<ResolveInfo> list = this.mContext.getPackageManager().queryIntentActivities(intent, 65536);
        int n = list == null ? 0 : list.size();
        if (n < 0) {
            ActivityInfo activityInfo = list.get((int)0).activityInfo;
            return new ComponentName(activityInfo.packageName, activityInfo.name);
        }
        Log.w(LOG_TAG, "No web search activity found");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildSearchableList() {
        HashMap<ComponentName, SearchableInfo> hashMap = new HashMap<ComponentName, SearchableInfo>();
        ArrayList<SearchableInfo> arrayList = new ArrayList<SearchableInfo>();
        ArrayList<SearchableInfo> arrayList2 = new ArrayList<SearchableInfo>();
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.SEARCH");
        List<ResolveInfo> list = packageManager.queryIntentActivities(intent, 128);
        Intent intent2 = new Intent("android.intent.action.WEB_SEARCH");
        List<ResolveInfo> list2 = packageManager.queryIntentActivities(intent2, 128);
        if (list != null || list2 != null) {
            int n = list == null ? 0 : list.size();
            int n2 = list2 == null ? 0 : list2.size();
            int n3 = n + n2;
            for (int i = 0; i < n3; ++i) {
                SearchableInfo searchableInfo;
                ResolveInfo resolveInfo = i < n ? list.get(i) : list2.get(i - n);
                ActivityInfo activityInfo = resolveInfo.activityInfo;
                if (hashMap.get(new ComponentName(activityInfo.packageName, activityInfo.name)) != null || (searchableInfo = SearchableInfo.getActivityMetaData((Context)this.mContext, (ActivityInfo)activityInfo)) == null) continue;
                arrayList.add(searchableInfo);
                hashMap.put(searchableInfo.getSearchActivity(), searchableInfo);
                if (!searchableInfo.shouldIncludeInGlobalSearch()) continue;
                arrayList2.add(searchableInfo);
            }
        }
        ComponentName componentName = this.findGlobalSearchActivity();
        ComponentName componentName2 = this.findWebSearchActivity(componentName);
        synchronized (this) {
            this.mSearchablesMap = hashMap;
            this.mSearchablesList = arrayList;
            this.mSearchablesInGlobalSearchList = arrayList2;
            this.mGlobalSearchActivity = componentName;
            this.mWebSearchActivity = componentName2;
            return;
        }
    }

    public ComponentName getGlobalSearchActivity() {
        synchronized (this) {
            ComponentName componentName = this.mGlobalSearchActivity;
            return componentName;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        SearchableInfo searchableInfo;
        synchronized (this) {
            SearchableInfo searchableInfo2 = this.mSearchablesMap.get(componentName);
            if (searchableInfo2 != null) {
                return searchableInfo2;
            }
        }
        try {
            ComponentName componentName2;
            Bundle bundle;
            ActivityInfo activityInfo = this.mContext.getPackageManager().getActivityInfo(componentName, 128);
            Bundle bundle2 = activityInfo.metaData;
            String string2 = null;
            if (bundle2 != null) {
                string2 = bundle2.getString(MD_LABEL_DEFAULT_SEARCHABLE);
            }
            if (string2 == null && (bundle = activityInfo.applicationInfo.metaData) != null) {
                string2 = bundle.getString(MD_LABEL_DEFAULT_SEARCHABLE);
            }
            if (string2 == null) return null;
            boolean bl = string2.equals(MD_SEARCHABLE_SYSTEM_SEARCH);
            if (bl) {
                return null;
            }
            String string3 = componentName.getPackageName();
            if (string2.charAt(0) == '.') {
                componentName2 = new ComponentName(string3, string3 + string2);
            } else {
                componentName2 = new ComponentName(string3, string2);
            }
            synchronized (this) {
                searchableInfo = this.mSearchablesMap.get(componentName2);
                if (searchableInfo == null) return null;
                this.mSearchablesMap.put(componentName, searchableInfo);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        {
            return searchableInfo;
        }
    }

    public ArrayList<SearchableInfo> getSearchablesInGlobalSearchList() {
        synchronized (this) {
            ArrayList<SearchableInfo> arrayList = new ArrayList<SearchableInfo>(this.mSearchablesInGlobalSearchList);
            return arrayList;
        }
    }

    public ArrayList<SearchableInfo> getSearchablesList() {
        synchronized (this) {
            ArrayList<SearchableInfo> arrayList = new ArrayList<SearchableInfo>(this.mSearchablesList);
            return arrayList;
        }
    }

    public ComponentName getWebSearchActivity() {
        synchronized (this) {
            ComponentName componentName = this.mWebSearchActivity;
            return componentName;
        }
    }
}

