/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WaveHeader {
    public static final short FORMAT_ALAW = 6;
    public static final short FORMAT_PCM = 1;
    public static final short FORMAT_ULAW = 7;
    private static final int HEADER_LENGTH = 44;
    private static final String TAG = "WaveHeader";
    private short mBitsPerSample;
    private short mFormat;
    private int mNumBytes;
    private short mNumChannels;
    private int mSampleRate;

    public WaveHeader() {
    }

    public WaveHeader(short s, short s2, int n, short s3, int n2) {
        this.mFormat = s;
        this.mSampleRate = n;
        this.mNumChannels = s2;
        this.mBitsPerSample = s3;
        this.mNumBytes = n2;
    }

    private static void readId(InputStream inputStream, String string2) throws IOException {
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == inputStream.read()) continue;
            throw new IOException(string2 + " tag not present");
        }
    }

    private static int readInt(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
    }

    private static short readShort(InputStream inputStream) throws IOException {
        return (short)(inputStream.read() | inputStream.read() << 8);
    }

    private static void writeId(OutputStream outputStream, String string2) throws IOException {
        for (int i = 0; i < string2.length(); ++i) {
            outputStream.write(string2.charAt(i));
        }
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 0);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    private static void writeShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s >> 0);
        outputStream.write(s >> 8);
    }

    public short getBitsPerSample() {
        return this.mBitsPerSample;
    }

    public short getFormat() {
        return this.mFormat;
    }

    public int getNumBytes() {
        return this.mNumBytes;
    }

    public short getNumChannels() {
        return this.mNumChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int read(InputStream inputStream) throws IOException {
        WaveHeader.readId(inputStream, "RIFF");
        int cfr_ignored_0 = WaveHeader.readInt(inputStream) - 36;
        WaveHeader.readId(inputStream, "WAVE");
        WaveHeader.readId(inputStream, "fmt ");
        if (16 != WaveHeader.readInt(inputStream)) {
            throw new IOException("fmt chunk length not 16");
        }
        this.mFormat = WaveHeader.readShort(inputStream);
        this.mNumChannels = WaveHeader.readShort(inputStream);
        this.mSampleRate = WaveHeader.readInt(inputStream);
        int n = WaveHeader.readInt(inputStream);
        short s = WaveHeader.readShort(inputStream);
        this.mBitsPerSample = WaveHeader.readShort(inputStream);
        if (n != this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8) {
            throw new IOException("fmt.ByteRate field inconsistent");
        }
        if (s != this.mNumChannels * this.mBitsPerSample / 8) {
            throw new IOException("fmt.BlockAlign field inconsistent");
        }
        WaveHeader.readId(inputStream, "data");
        this.mNumBytes = WaveHeader.readInt(inputStream);
        return 44;
    }

    public WaveHeader setBitsPerSample(short s) {
        this.mBitsPerSample = s;
        return this;
    }

    public WaveHeader setFormat(short s) {
        this.mFormat = s;
        return this;
    }

    public WaveHeader setNumBytes(int n) {
        this.mNumBytes = n;
        return this;
    }

    public WaveHeader setNumChannels(short s) {
        this.mNumChannels = s;
        return this;
    }

    public WaveHeader setSampleRate(int n) {
        this.mSampleRate = n;
        return this;
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.mFormat, this.mNumChannels, this.mSampleRate, this.mBitsPerSample, this.mNumBytes};
        return String.format("WaveHeader format=%d numChannels=%d sampleRate=%d bitsPerSample=%d numBytes=%d", objectArray);
    }

    public int write(OutputStream outputStream) throws IOException {
        WaveHeader.writeId(outputStream, "RIFF");
        WaveHeader.writeInt(outputStream, 36 + this.mNumBytes);
        WaveHeader.writeId(outputStream, "WAVE");
        WaveHeader.writeId(outputStream, "fmt ");
        WaveHeader.writeInt(outputStream, 16);
        WaveHeader.writeShort(outputStream, this.mFormat);
        WaveHeader.writeShort(outputStream, this.mNumChannels);
        WaveHeader.writeInt(outputStream, this.mSampleRate);
        WaveHeader.writeInt(outputStream, this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8);
        WaveHeader.writeShort(outputStream, (short)(this.mNumChannels * this.mBitsPerSample / 8));
        WaveHeader.writeShort(outputStream, this.mBitsPerSample);
        WaveHeader.writeId(outputStream, "data");
        WaveHeader.writeInt(outputStream, this.mNumBytes);
        return 44;
    }
}

