/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.provider.Calendar;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class CalendarUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = "CalendarUtils";

    public static SharedPreferences getSharedPreferences(Context context, String string2) {
        return context.getSharedPreferences(string2, 0);
    }

    public static void setSharedPreference(SharedPreferences sharedPreferences, String string2, String string3) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(string2, string3);
        editor.apply();
    }

    public static void setSharedPreference(SharedPreferences sharedPreferences, String string2, boolean bl) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(string2, bl);
        editor.apply();
    }

    public static class TimeZoneUtils {
        public static final String KEY_HOME_TZ = "preferences_home_tz";
        public static final String KEY_HOME_TZ_ENABLED = "preferences_home_tz_enabled";
        private static final String[] TIMEZONE_INSTANCES_ARGS;
        private static final String[] TIMEZONE_TYPE_ARGS;
        private static Formatter mF;
        private static volatile boolean mFirstTZRequest;
        private static AsyncTZHandler mHandler;
        private static volatile String mHomeTZ;
        private static StringBuilder mSB;
        private static HashSet<Runnable> mTZCallbacks;
        private static volatile boolean mTZQueryInProgress;
        private static int mToken;
        private static volatile boolean mUseHomeTZ;
        private final String mPrefsName;

        static {
            TIMEZONE_TYPE_ARGS = new String[]{"timezoneType"};
            TIMEZONE_INSTANCES_ARGS = new String[]{"timezoneInstances"};
            mSB = new StringBuilder(50);
            mF = new Formatter(mSB, Locale.getDefault());
            mFirstTZRequest = true;
            mTZQueryInProgress = false;
            mUseHomeTZ = false;
            mHomeTZ = Time.getCurrentTimezone();
            mTZCallbacks = new HashSet();
            mToken = 1;
        }

        public TimeZoneUtils(String string2) {
            this.mPrefsName = string2;
        }

        static /* synthetic */ boolean access$102(boolean bl) {
            mUseHomeTZ = bl;
            return bl;
        }

        static /* synthetic */ String access$202(String string2) {
            mHomeTZ = string2;
            return string2;
        }

        static /* synthetic */ boolean access$402(boolean bl) {
            mTZQueryInProgress = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void forceDBRequery(Context context, Runnable runnable) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if (mTZQueryInProgress) {
                    mTZCallbacks.add(runnable);
                    return;
                }
                mFirstTZRequest = true;
                this.getTimeZone(context, runnable);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String formatDateRange(Context context, long l, long l2, int n) {
            String string2 = (n & 0x2000) != 0 ? "UTC" : this.getTimeZone(context, null);
            StringBuilder stringBuilder = mSB;
            synchronized (stringBuilder) {
                mSB.setLength(0);
                return DateUtils.formatDateRange(context, mF, l, l2, n, string2).toString();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public String getTimeZone(Context context, Runnable runnable) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            // MONITORENTER : hashSet
            if (mFirstTZRequest) {
                mTZQueryInProgress = true;
                mFirstTZRequest = false;
                SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences(context, this.mPrefsName);
                mUseHomeTZ = sharedPreferences.getBoolean(KEY_HOME_TZ_ENABLED, false);
                mHomeTZ = sharedPreferences.getString(KEY_HOME_TZ, Time.getCurrentTimezone());
                if (mHandler == null) {
                    mHandler = new AsyncTZHandler(context.getContentResolver());
                }
                mHandler.startQuery(0, context, Calendar.CalendarCache.URI, Calendar.CalendarCache.POJECTION, null, null, null);
            }
            if (mTZQueryInProgress) {
                mTZCallbacks.add(runnable);
            }
            // MONITOREXIT : hashSet
            if (!mUseHomeTZ) return Time.getCurrentTimezone();
            return mHomeTZ;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setTimeZone(Context context, String string2) {
            block17: {
                block12: {
                    int n;
                    AsyncTZHandler asyncTZHandler;
                    if (TextUtils.isEmpty(string2)) break block12;
                    HashSet<Runnable> hashSet = mTZCallbacks;
                    synchronized (hashSet) {
                        boolean bl;
                        block14: {
                            block16: {
                                block15: {
                                    block13: {
                                        if (!"auto".equals(string2)) break block13;
                                        boolean bl2 = mUseHomeTZ;
                                        bl = false;
                                        if (bl2) {
                                            bl = true;
                                        }
                                        mUseHomeTZ = false;
                                        break block14;
                                    }
                                    if (!mUseHomeTZ) break block15;
                                    boolean bl3 = TextUtils.equals(mHomeTZ, string2);
                                    bl = false;
                                    if (bl3) break block16;
                                }
                                bl = true;
                            }
                            mUseHomeTZ = true;
                            mHomeTZ = string2;
                        }
                        if (!bl) break block12;
                    }
                    SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences(context, this.mPrefsName);
                    CalendarUtils.setSharedPreference(sharedPreferences, KEY_HOME_TZ_ENABLED, mUseHomeTZ);
                    CalendarUtils.setSharedPreference(sharedPreferences, KEY_HOME_TZ, mHomeTZ);
                    ContentValues contentValues = new ContentValues();
                    if (mHandler != null) {
                        mHandler.cancelOperation(mToken);
                    }
                    mHandler = asyncTZHandler = new AsyncTZHandler(context.getContentResolver());
                    mToken = n = 1 + mToken;
                    if (n == 0) {
                        mToken = 1;
                    }
                    String string3 = mUseHomeTZ ? "home" : "auto";
                    contentValues.put("value", string3);
                    mHandler.startUpdate(mToken, null, Calendar.CalendarCache.URI, contentValues, "key=?", TIMEZONE_TYPE_ARGS);
                    if (mUseHomeTZ) break block17;
                }
                return;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("value", mHomeTZ);
            mHandler.startUpdate(mToken, null, Calendar.CalendarCache.URI, contentValues, "key=?", TIMEZONE_INSTANCES_ARGS);
        }

        private class AsyncTZHandler
        extends AsyncQueryHandler {
            public AsyncTZHandler(ContentResolver contentResolver) {
                super(contentResolver);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void onQueryComplete(int n, Object object, Cursor cursor) {
                HashSet hashSet = mTZCallbacks;
                synchronized (hashSet) {
                    boolean bl = false;
                    int n2 = cursor.getColumnIndexOrThrow("key");
                    int n3 = cursor.getColumnIndexOrThrow("value");
                    while (cursor.moveToNext()) {
                        String string2 = cursor.getString(n2);
                        String string3 = cursor.getString(n3);
                        if (TextUtils.equals(string2, "timezoneType")) {
                            boolean bl2 = !TextUtils.equals(string3, "auto");
                            if (bl2 == mUseHomeTZ) continue;
                            bl = true;
                            TimeZoneUtils.access$102(bl2);
                            continue;
                        }
                        if (!TextUtils.equals(string2, "timezoneInstancesPrevious") || TextUtils.isEmpty(string3) || TextUtils.equals(mHomeTZ, string3)) continue;
                        bl = true;
                        TimeZoneUtils.access$202(string3);
                    }
                    cursor.close();
                    if (bl) {
                        SharedPreferences sharedPreferences = CalendarUtils.getSharedPreferences((Context)object, TimeZoneUtils.this.mPrefsName);
                        CalendarUtils.setSharedPreference(sharedPreferences, TimeZoneUtils.KEY_HOME_TZ_ENABLED, mUseHomeTZ);
                        CalendarUtils.setSharedPreference(sharedPreferences, TimeZoneUtils.KEY_HOME_TZ, mHomeTZ);
                    }
                    TimeZoneUtils.access$402(false);
                    Iterator iterator = mTZCallbacks.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            mTZCallbacks.clear();
                            return;
                        }
                        Runnable runnable = (Runnable)iterator.next();
                        if (runnable == null) continue;
                        runnable.run();
                    }
                }
            }
        }
    }
}

