/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Build;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public final class CharsetUtils {
    private static final String VENDOR_DOCOMO = "docomo";

    private CharsetUtils() {
    }

    public static Charset charsetForVendor(String string2) throws UnsupportedCharsetException, IllegalCharsetNameException {
        return CharsetUtils.charsetForVendor(string2, CharsetUtils.getDefaultVendor());
    }

    public static Charset charsetForVendor(String string2, String string3) throws UnsupportedCharsetException, IllegalCharsetNameException {
        return Charset.forName(CharsetUtils.nameForVendor(string2, string3));
    }

    private static String getDefaultVendor() {
        return Build.BRAND;
    }

    private static boolean isShiftJis(String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n != 4 && n != 9) {
            return false;
        }
        return string2.equalsIgnoreCase("shift_jis") || string2.equalsIgnoreCase("shift-jis") || string2.equalsIgnoreCase("sjis");
    }

    public static String nameForDefaultVendor(String string2) {
        return CharsetUtils.nameForVendor(string2, CharsetUtils.getDefaultVendor());
    }

    public static String nameForVendor(String string2, String string3) {
        if (string3.equalsIgnoreCase(VENDOR_DOCOMO) && CharsetUtils.isShiftJis(string2)) {
            return "docomo-shift_jis-2007";
        }
        return string2;
    }
}

