/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.android.internal.util.ArrayUtils;

public class LongSparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private long[] mKeys;
    private int mSize;
    private Object[] mValues;

    public LongSparseArray() {
        this(10);
    }

    public LongSparseArray(int n) {
        int n2 = ArrayUtils.idealIntArraySize(n);
        this.mKeys = new long[n2];
        this.mValues = new Object[n2];
        this.mSize = 0;
    }

    private static int binarySearch(long[] lArray, int n, int n2, long l) {
        int n3 = n + n2;
        int n4 = n - 1;
        while (n3 - n4 > 1) {
            int n5 = (n3 + n4) / 2;
            if (lArray[n5] < l) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        if (n3 == n + n2) {
            return 0xFFFFFFFF ^ n + n2;
        }
        if (lArray[n3] == l) {
            return n3;
        }
        return ~n3;
    }

    private void checkIntegrity() {
        for (int i = 1; i < this.mSize; ++i) {
            if (this.mKeys[i] > this.mKeys[i - 1]) continue;
            for (int j = 0; j < this.mSize; ++j) {
                Log.e("FAIL", j + ": " + this.mKeys[j] + " -> " + this.mValues[j]);
            }
            throw new RuntimeException();
        }
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        long[] lArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == DELETED) continue;
            if (i != n2) {
                lArray[n2] = lArray[i];
                objectArray[n2] = object;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    public void append(long l, E e) {
        int n;
        if (this.mSize != 0 && l <= this.mKeys[this.mSize - 1]) {
            this.put(l, e);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n = this.mSize) >= this.mKeys.length) {
            int n2 = ArrayUtils.idealIntArraySize(n + 1);
            long[] lArray = new long[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = lArray;
            this.mValues = objectArray;
        }
        this.mKeys[n] = l;
        this.mValues[n] = e;
        this.mSize = n + 1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void delete(long l) {
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0 && this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public E get(long l) {
        return this.get(l, null);
    }

    public E get(long l, E e) {
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n < 0 || this.mValues[n] == DELETED) {
            return e;
        }
        return (E)this.mValues[n];
    }

    public long[] getKeys() {
        int n = this.mKeys.length;
        long[] lArray = new long[n];
        System.arraycopy(this.mKeys, 0, lArray, 0, n);
        return lArray;
    }

    public int indexOfKey(long l) {
        if (this.mGarbage) {
            this.gc();
        }
        return LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
    }

    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != e) continue;
            return i;
        }
        return -1;
    }

    public long keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    public void put(long l, E e) {
        int n = LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        if (n >= 0) {
            this.mValues[n] = e;
            return;
        }
        int n2 = ~n;
        if (n2 < this.mSize && this.mValues[n2] == DELETED) {
            this.mKeys[n2] = l;
            this.mValues[n2] = e;
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            n2 = 0xFFFFFFFF ^ LongSparseArray.binarySearch(this.mKeys, 0, this.mSize, l);
        }
        if (this.mSize >= this.mKeys.length) {
            int n3 = ArrayUtils.idealIntArraySize(1 + this.mSize);
            long[] lArray = new long[n3];
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.mKeys, 0, lArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = lArray;
            this.mValues = objectArray;
        }
        if (this.mSize - n2 != 0) {
            System.arraycopy(this.mKeys, n2, this.mKeys, n2 + 1, this.mSize - n2);
            System.arraycopy(this.mValues, n2, this.mValues, n2 + 1, this.mSize - n2);
        }
        this.mKeys[n2] = l;
        this.mValues[n2] = e;
        this.mSize = 1 + this.mSize;
    }

    public void remove(long l) {
        this.delete(l);
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public void setValues(long[] lArray, E e) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this.put(lArray[i], e);
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }
}

