/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Pool;
import android.util.Poolable;

class SynchronizedPool<T extends Poolable<T>>
implements Pool<T> {
    private final Object mLock;
    private final Pool<T> mPool;

    public SynchronizedPool(Pool<T> pool) {
        this.mPool = pool;
        this.mLock = this;
    }

    public SynchronizedPool(Pool<T> pool, Object object) {
        this.mPool = pool;
        this.mLock = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T acquire() {
        Object object = this.mLock;
        synchronized (object) {
            T t = this.mPool.acquire();
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release(T t) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPool.release(t);
            return;
        }
    }
}

