/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.IApplicationToken;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import java.util.List;

public interface IWindowManager
extends IInterface {
    public void addAppToken(int var1, IApplicationToken var2, int var3, int var4, boolean var5) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    public void disableKeyguard(IBinder var1, String var2) throws RemoteException;

    public void executeAppTransition() throws RemoteException;

    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    public float getAnimationScale(int var1) throws RemoteException;

    public float[] getAnimationScales() throws RemoteException;

    public int getAppOrientation(IApplicationToken var1) throws RemoteException;

    public int getDPadKeycodeState(int var1) throws RemoteException;

    public int getDPadScancodeState(int var1) throws RemoteException;

    public InputDevice getInputDevice(int var1) throws RemoteException;

    public int[] getInputDeviceIds() throws RemoteException;

    public int getKeycodeState(int var1) throws RemoteException;

    public int getKeycodeStateForDevice(int var1, int var2) throws RemoteException;

    public int getPendingAppTransition() throws RemoteException;

    public int getRotation() throws RemoteException;

    public int getScancodeState(int var1) throws RemoteException;

    public int getScancodeStateForDevice(int var1, int var2) throws RemoteException;

    public int getSwitchState(int var1) throws RemoteException;

    public int getSwitchStateForDevice(int var1, int var2) throws RemoteException;

    public int getTrackballKeycodeState(int var1) throws RemoteException;

    public int getTrackballScancodeState(int var1) throws RemoteException;

    public boolean hasKeys(int[] var1, boolean[] var2) throws RemoteException;

    public boolean inKeyguardRestrictedInputMode() throws RemoteException;

    public boolean injectInputEventNoWait(InputEvent var1) throws RemoteException;

    public boolean injectKeyEvent(KeyEvent var1, boolean var2) throws RemoteException;

    public boolean injectPointerEvent(MotionEvent var1, boolean var2) throws RemoteException;

    public boolean injectTrackballEvent(MotionEvent var1, boolean var2) throws RemoteException;

    public boolean inputMethodClientHasFocus(IInputMethodClient var1) throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public InputChannel monitorInput(String var1) throws RemoteException;

    public void moveAppToken(int var1, IBinder var2) throws RemoteException;

    public void moveAppTokensToBottom(List<IBinder> var1) throws RemoteException;

    public void moveAppTokensToTop(List<IBinder> var1) throws RemoteException;

    public IWindowSession openSession(IInputMethodClient var1, IInputContext var2) throws RemoteException;

    public void overridePendingAppTransition(String var1, int var2, int var3) throws RemoteException;

    public void pauseKeyDispatching(IBinder var1) throws RemoteException;

    public void prepareAppTransition(int var1) throws RemoteException;

    public void reenableKeyguard(IBinder var1) throws RemoteException;

    public void removeAppToken(IBinder var1) throws RemoteException;

    public void removeWindowToken(IBinder var1) throws RemoteException;

    public void resumeKeyDispatching(IBinder var1) throws RemoteException;

    public void setAnimationScale(int var1, float var2) throws RemoteException;

    public void setAnimationScales(float[] var1) throws RemoteException;

    public void setAppGroupId(IBinder var1, int var2) throws RemoteException;

    public void setAppOrientation(IApplicationToken var1, int var2) throws RemoteException;

    public void setAppStartingWindow(IBinder var1, String var2, int var3, CharSequence var4, int var5, int var6, IBinder var7, boolean var8) throws RemoteException;

    public void setAppVisibility(IBinder var1, boolean var2) throws RemoteException;

    public void setAppWillBeHidden(IBinder var1) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public void setFocusedApp(IBinder var1, boolean var2) throws RemoteException;

    public void setInTouchMode(boolean var1) throws RemoteException;

    public void setNewConfiguration(Configuration var1) throws RemoteException;

    public void setRotation(int var1, boolean var2, int var3) throws RemoteException;

    public void startAppFreezingScreen(IBinder var1, int var2) throws RemoteException;

    public boolean startViewServer(int var1) throws RemoteException;

    public void stopAppFreezingScreen(IBinder var1, boolean var2) throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public Configuration updateOrientationFromAppTokens(Configuration var1, IBinder var2) throws RemoteException;

    public int watchRotation(IRotationWatcher var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        private static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_addAppToken = 15;
        static final int TRANSACTION_addWindowToken = 13;
        static final int TRANSACTION_closeSystemDialogs = 39;
        static final int TRANSACTION_disableKeyguard = 35;
        static final int TRANSACTION_executeAppTransition = 23;
        static final int TRANSACTION_exitKeyguardSecurely = 37;
        static final int TRANSACTION_getAnimationScale = 40;
        static final int TRANSACTION_getAnimationScales = 41;
        static final int TRANSACTION_getAppOrientation = 18;
        static final int TRANSACTION_getDPadKeycodeState = 53;
        static final int TRANSACTION_getDPadScancodeState = 49;
        static final int TRANSACTION_getInputDevice = 56;
        static final int TRANSACTION_getInputDeviceIds = 57;
        static final int TRANSACTION_getKeycodeState = 50;
        static final int TRANSACTION_getKeycodeStateForDevice = 51;
        static final int TRANSACTION_getPendingAppTransition = 21;
        static final int TRANSACTION_getRotation = 60;
        static final int TRANSACTION_getScancodeState = 46;
        static final int TRANSACTION_getScancodeStateForDevice = 47;
        static final int TRANSACTION_getSwitchState = 44;
        static final int TRANSACTION_getSwitchStateForDevice = 45;
        static final int TRANSACTION_getTrackballKeycodeState = 52;
        static final int TRANSACTION_getTrackballScancodeState = 48;
        static final int TRANSACTION_hasKeys = 55;
        static final int TRANSACTION_inKeyguardRestrictedInputMode = 38;
        static final int TRANSACTION_injectInputEventNoWait = 9;
        static final int TRANSACTION_injectKeyEvent = 6;
        static final int TRANSACTION_injectPointerEvent = 7;
        static final int TRANSACTION_injectTrackballEvent = 8;
        static final int TRANSACTION_inputMethodClientHasFocus = 5;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_monitorInput = 54;
        static final int TRANSACTION_moveAppToken = 30;
        static final int TRANSACTION_moveAppTokensToBottom = 32;
        static final int TRANSACTION_moveAppTokensToTop = 31;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_overridePendingAppTransition = 22;
        static final int TRANSACTION_pauseKeyDispatching = 10;
        static final int TRANSACTION_prepareAppTransition = 20;
        static final int TRANSACTION_reenableKeyguard = 36;
        static final int TRANSACTION_removeAppToken = 29;
        static final int TRANSACTION_removeWindowToken = 14;
        static final int TRANSACTION_resumeKeyDispatching = 11;
        static final int TRANSACTION_setAnimationScale = 42;
        static final int TRANSACTION_setAnimationScales = 43;
        static final int TRANSACTION_setAppGroupId = 16;
        static final int TRANSACTION_setAppOrientation = 17;
        static final int TRANSACTION_setAppStartingWindow = 24;
        static final int TRANSACTION_setAppVisibility = 26;
        static final int TRANSACTION_setAppWillBeHidden = 25;
        static final int TRANSACTION_setEventDispatching = 12;
        static final int TRANSACTION_setFocusedApp = 19;
        static final int TRANSACTION_setInTouchMode = 58;
        static final int TRANSACTION_setNewConfiguration = 34;
        static final int TRANSACTION_setRotation = 59;
        static final int TRANSACTION_startAppFreezingScreen = 27;
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_stopAppFreezingScreen = 28;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_updateOrientationFromAppTokens = 33;
        static final int TRANSACTION_watchRotation = 61;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWindowManager) {
                return (IWindowManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.startViewServer(parcel.readInt());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.stopViewServer();
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isViewServerRunning();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindowSession iWindowSession = this.openSession(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()), IInputContext.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    IBinder iBinder = iWindowSession != null ? iWindowSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.inputMethodClientHasFocus(IInputMethodClient.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    KeyEvent keyEvent = parcel.readInt() != 0 ? KeyEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.injectKeyEvent(keyEvent, bl);
                    parcel2.writeNoException();
                    int n7 = bl2 ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    MotionEvent motionEvent = parcel.readInt() != 0 ? MotionEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.injectPointerEvent(motionEvent, bl);
                    parcel2.writeNoException();
                    int n8 = bl3 ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    MotionEvent motionEvent = parcel.readInt() != 0 ? MotionEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl4 = this.injectTrackballEvent(motionEvent, bl);
                    parcel2.writeNoException();
                    int n9 = bl4 ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputEvent inputEvent = parcel.readInt() != 0 ? InputEvent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.injectInputEventNoWait(inputEvent);
                    parcel2.writeNoException();
                    int n10 = bl ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.pauseKeyDispatching(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.resumeKeyDispatching(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setEventDispatching(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addWindowToken(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeWindowToken(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = parcel.readInt();
                    IApplicationToken iApplicationToken = IApplicationToken.Stub.asInterface(parcel.readStrongBinder());
                    int n12 = parcel.readInt();
                    int n13 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.addAppToken(n11, iApplicationToken, n12, n13, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppGroupId(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppOrientation(IApplicationToken.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = this.getAppOrientation(IApplicationToken.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setFocusedApp(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.prepareAppTransition(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n15 = this.getPendingAppTransition();
                    parcel2.writeNoException();
                    parcel2.writeInt(n15);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.overridePendingAppTransition(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.executeAppTransition();
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string2 = parcel.readString();
                    int n16 = parcel.readInt();
                    CharSequence charSequence = parcel.readInt() != 0 ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel) : null;
                    int n17 = parcel.readInt();
                    int n18 = parcel.readInt();
                    IBinder iBinder2 = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setAppStartingWindow(iBinder, string2, n16, charSequence, n17, n18, iBinder2, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAppWillBeHidden(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.setAppVisibility(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.startAppFreezingScreen(parcel.readStrongBinder(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    boolean bl = parcel.readInt() != 0;
                    this.stopAppFreezingScreen(iBinder, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeAppToken(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.moveAppToken(parcel.readInt(), parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.moveAppTokensToTop(parcel.createBinderArrayList());
                    parcel2.writeNoException();
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.moveAppTokensToBottom(parcel.createBinderArrayList());
                    parcel2.writeNoException();
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Configuration configuration = parcel.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel) : null;
                    Configuration configuration2 = this.updateOrientationFromAppTokens(configuration, parcel.readStrongBinder());
                    parcel2.writeNoException();
                    if (configuration2 != null) {
                        parcel2.writeInt(1);
                        configuration2.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Configuration configuration = parcel.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel) : null;
                    this.setNewConfiguration(configuration);
                    parcel2.writeNoException();
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disableKeyguard(parcel.readStrongBinder(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.reenableKeyguard(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.exitKeyguardSecurely(IOnKeyguardExitResult.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.inKeyguardRestrictedInputMode();
                    parcel2.writeNoException();
                    int n19 = bl ? 1 : 0;
                    parcel2.writeInt(n19);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.closeSystemDialogs(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float f = this.getAnimationScale(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeFloat(f);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    float[] fArray = this.getAnimationScales();
                    parcel2.writeNoException();
                    parcel2.writeFloatArray(fArray);
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAnimationScale(parcel.readInt(), parcel.readFloat());
                    parcel2.writeNoException();
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAnimationScales(parcel.createFloatArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n20 = this.getSwitchState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n20);
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n21 = this.getSwitchStateForDevice(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n21);
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n22 = this.getScancodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n23 = this.getScancodeStateForDevice(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = this.getTrackballScancodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n25 = this.getDPadScancodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n25);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n26 = this.getKeycodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n27 = this.getKeycodeStateForDevice(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n27);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n28 = this.getTrackballKeycodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n29 = this.getDPadKeycodeState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n29);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputChannel inputChannel = this.monitorInput(parcel.readString());
                    parcel2.writeNoException();
                    if (inputChannel != null) {
                        parcel2.writeInt(1);
                        inputChannel.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = parcel.createIntArray();
                    boolean[] blArray = parcel.createBooleanArray();
                    boolean bl = this.hasKeys(nArray, blArray);
                    parcel2.writeNoException();
                    int n30 = bl ? 1 : 0;
                    parcel2.writeInt(n30);
                    parcel2.writeBooleanArray(blArray);
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    InputDevice inputDevice = this.getInputDevice(parcel.readInt());
                    parcel2.writeNoException();
                    if (inputDevice != null) {
                        parcel2.writeInt(1);
                        inputDevice.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.getInputDeviceIds();
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setInTouchMode(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n31 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setRotation(n31, bl, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n32 = this.getRotation();
                    parcel2.writeNoException();
                    parcel2.writeInt(n32);
                    return true;
                }
                case 61: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n33 = this.watchRotation(IRotationWatcher.Stub.asInterface(parcel.readStrongBinder()));
            parcel2.writeNoException();
            parcel2.writeInt(n33);
            return true;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addAppToken(int n, IApplicationToken iApplicationToken, int n2, int n3, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    int n4 = bl ? 1 : 0;
                    parcel.writeInt(n4);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void addWindowToken(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void closeSystemDialogs(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void disableKeyguard(IBinder iBinder, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void executeAppTransition() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult iOnKeyguardExitResult) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iOnKeyguardExitResult != null ? iOnKeyguardExitResult.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public float getAnimationScale(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    float f = parcel2.readFloat();
                    return f;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public float[] getAnimationScales() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    float[] fArray = parcel2.createFloatArray();
                    return fArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getAppOrientation(IApplicationToken iApplicationToken) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getDPadKeycodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDPadScancodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputDevice getInputDevice(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    InputDevice inputDevice = parcel2.readInt() != 0 ? InputDevice.CREATOR.createFromParcel(parcel2) : null;
                    return inputDevice;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] getInputDeviceIds() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getKeycodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getKeycodeStateForDevice(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPendingAppTransition() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getRotation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getScancodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getScancodeStateForDevice(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getSwitchState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getSwitchStateForDevice(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getTrackballKeycodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getTrackballScancodeState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasKeys(int[] nArray, boolean[] blArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeIntArray(nArray);
                    parcel.writeBooleanArray(blArray);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    boolean bl = parcel2.readInt() != 0;
                    parcel2.readBooleanArray(blArray);
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean inKeyguardRestrictedInputMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean injectInputEventNoWait(InputEvent inputEvent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (inputEvent != null) {
                        parcel.writeInt(1);
                        inputEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean injectKeyEvent(KeyEvent keyEvent, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (keyEvent != null) {
                        parcel.writeInt(1);
                        keyEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n = bl ? 1 : 0;
                parcel.writeInt(n);
                this.mRemote.transact(6, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                boolean bl2 = n2 != 0;
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean injectPointerEvent(MotionEvent motionEvent, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (motionEvent != null) {
                        parcel.writeInt(1);
                        motionEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n = bl ? 1 : 0;
                parcel.writeInt(n);
                this.mRemote.transact(7, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                boolean bl2 = n2 != 0;
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean injectTrackballEvent(MotionEvent motionEvent, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (motionEvent != null) {
                        parcel.writeInt(1);
                        motionEvent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n = bl ? 1 : 0;
                parcel.writeInt(n);
                this.mRemote.transact(8, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                boolean bl2 = n2 != 0;
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean inputMethodClientHasFocus(IInputMethodClient iInputMethodClient) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isViewServerRunning() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InputChannel monitorInput(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    InputChannel inputChannel = parcel2.readInt() != 0 ? InputChannel.CREATOR.createFromParcel(parcel2) : null;
                    return inputChannel;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void moveAppToken(int n, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void moveAppTokensToBottom(List<IBinder> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeBinderList(list);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void moveAppTokensToTop(List<IBinder> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeBinderList(list);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IWindowSession openSession(IInputMethodClient iInputMethodClient, IInputContext iInputContext) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iInputMethodClient != null ? iInputMethodClient.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    IBinder iBinder2 = iInputContext != null ? iInputContext.asBinder() : null;
                    parcel.writeStrongBinder(iBinder2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    IWindowSession iWindowSession = IWindowSession.Stub.asInterface(parcel2.readStrongBinder());
                    parcel2.recycle();
                    parcel.recycle();
                    return iWindowSession;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void overridePendingAppTransition(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void pauseKeyDispatching(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void prepareAppTransition(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void reenableKeyguard(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeAppToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeWindowToken(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void resumeKeyDispatching(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAnimationScale(int n, float f) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeFloat(f);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAnimationScales(float[] fArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeFloatArray(fArray);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAppGroupId(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAppOrientation(IApplicationToken iApplicationToken, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iApplicationToken != null ? iApplicationToken.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAppStartingWindow(IBinder iBinder, String string2, int n, CharSequence charSequence, int n2, int n3, IBinder iBinder2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    if (charSequence != null) {
                        parcel.writeInt(1);
                        TextUtils.writeToParcel(charSequence, parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeStrongBinder(iBinder2);
                    int n4 = bl ? 1 : 0;
                    parcel.writeInt(n4);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setAppVisibility(IBinder iBinder, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setAppWillBeHidden(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setEventDispatching(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setFocusedApp(IBinder iBinder, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInTouchMode(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setNewConfiguration(Configuration configuration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (configuration != null) {
                        parcel.writeInt(1);
                        configuration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setRotation(int n, boolean bl, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    parcel.writeInt(n2);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void startAppFreezingScreen(IBinder iBinder, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean startViewServer(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void stopAppFreezingScreen(IBinder iBinder, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean stopViewServer() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Configuration updateOrientationFromAppTokens(Configuration configuration, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (configuration != null) {
                        parcel.writeInt(1);
                        configuration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    Configuration configuration2 = parcel2.readInt() != 0 ? Configuration.CREATOR.createFromParcel(parcel2) : null;
                    return configuration2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int watchRotation(IRotationWatcher iRotationWatcher) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iRotationWatcher != null ? iRotationWatcher.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

