/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.InputChannel;
import android.view.Surface;
import android.view.WindowManager;

public interface IWindowSession
extends IInterface {
    public int add(IWindow var1, WindowManager.LayoutParams var2, int var3, Rect var4, InputChannel var5) throws RemoteException;

    public int addWithoutInputChannel(IWindow var1, WindowManager.LayoutParams var2, int var3, Rect var4) throws RemoteException;

    public void finishDrawing(IWindow var1) throws RemoteException;

    public void getDisplayFrame(IWindow var1, Rect var2) throws RemoteException;

    public boolean getInTouchMode() throws RemoteException;

    public boolean performHapticFeedback(IWindow var1, int var2, boolean var3) throws RemoteException;

    public int relayout(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, boolean var6, Rect var7, Rect var8, Rect var9, Configuration var10, Surface var11) throws RemoteException;

    public void remove(IWindow var1) throws RemoteException;

    public Bundle sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    public void setInTouchMode(boolean var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4) throws RemoteException;

    public void setTransparentRegion(IWindow var1, Region var2) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        private static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_add = 1;
        static final int TRANSACTION_addWithoutInputChannel = 2;
        static final int TRANSACTION_finishDrawing = 8;
        static final int TRANSACTION_getDisplayFrame = 7;
        static final int TRANSACTION_getInTouchMode = 10;
        static final int TRANSACTION_performHapticFeedback = 11;
        static final int TRANSACTION_relayout = 4;
        static final int TRANSACTION_remove = 3;
        static final int TRANSACTION_sendWallpaperCommand = 14;
        static final int TRANSACTION_setInTouchMode = 9;
        static final int TRANSACTION_setInsets = 6;
        static final int TRANSACTION_setTransparentRegion = 5;
        static final int TRANSACTION_setWallpaperPosition = 12;
        static final int TRANSACTION_wallpaperCommandComplete = 15;
        static final int TRANSACTION_wallpaperOffsetsComplete = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowSession asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWindowSession) {
                return (IWindowSession)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n3 = parcel.readInt();
                    Rect rect = new Rect();
                    InputChannel inputChannel = new InputChannel();
                    int n4 = this.add(iWindow, layoutParams, n3, rect, inputChannel);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (inputChannel != null) {
                        parcel2.writeInt(1);
                        inputChannel.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n5 = parcel.readInt();
                    Rect rect = new Rect();
                    int n6 = this.addWithoutInputChannel(iWindow, layoutParams, n5, rect);
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.remove(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    int n9 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    Rect rect = new Rect();
                    Rect rect2 = new Rect();
                    Rect rect3 = new Rect();
                    Configuration configuration = new Configuration();
                    Surface surface = new Surface();
                    int n10 = this.relayout(iWindow, layoutParams, n7, n8, n9, bl, rect, rect2, rect3, configuration, surface);
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect2 != null) {
                        parcel2.writeInt(1);
                        rect2.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect3 != null) {
                        parcel2.writeInt(1);
                        rect3.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (configuration != null) {
                        parcel2.writeInt(1);
                        configuration.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (surface != null) {
                        parcel2.writeInt(1);
                        surface.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Region region = parcel.readInt() != 0 ? Region.CREATOR.createFromParcel(parcel) : null;
                    this.setTransparentRegion(iWindow, region);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n11 = parcel.readInt();
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    Rect rect4 = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    this.setInsets(iWindow, n11, rect, rect4);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Rect rect = new Rect();
                    this.getDisplayFrame(iWindow, rect);
                    parcel2.writeNoException();
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishDrawing(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setInTouchMode(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getInTouchMode();
                    parcel2.writeNoException();
                    int n12 = bl ? 1 : 0;
                    parcel2.writeInt(n12);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n13 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.performHapticFeedback(iWindow, n13, bl);
                    parcel2.writeNoException();
                    int n14 = bl2 ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setWallpaperPosition(parcel.readStrongBinder(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.wallpaperOffsetsComplete(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string2 = parcel.readString();
                    int n15 = parcel.readInt();
                    int n16 = parcel.readInt();
                    int n17 = parcel.readInt();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    Bundle bundle2 = this.sendWallpaperCommand(iBinder, string2, n15, n16, n17, bundle, bl);
                    parcel2.writeNoException();
                    if (bundle2 != null) {
                        parcel2.writeInt(1);
                        bundle2.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 15: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            IBinder iBinder = parcel.readStrongBinder();
            Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
            this.wallpaperCommandComplete(iBinder, bundle);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int add(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, Rect rect, InputChannel inputChannel) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        inputChannel.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addWithoutInputChannel(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishDrawing(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getDisplayFrame(IWindow iWindow, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean getInTouchMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performHapticFeedback(IWindow iWindow, int n, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    int n2 = bl ? 1 : 0;
                    parcel.writeInt(n2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl2 = n3 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int relayout(IWindow iWindow, WindowManager.LayoutParams layoutParams, int n, int n2, int n3, boolean bl, Rect rect, Rect rect2, Rect rect3, Configuration configuration, Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    int n4 = bl ? 1 : 0;
                    parcel.writeInt(n4);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n5 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect2.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect3.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        configuration.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        surface.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n5;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void remove(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n4 = bl ? 1 : 0;
                parcel.writeInt(n4);
                this.mRemote.transact(14, parcel, parcel2, 0);
                parcel2.readException();
                Bundle bundle2 = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                parcel2.recycle();
                parcel.recycle();
                return bundle2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInTouchMode(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInsets(IWindow iWindow, int n, Rect rect, Rect rect2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (rect2 != null) {
                        parcel.writeInt(1);
                        rect2.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTransparentRegion(IWindow iWindow, Region region) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (region != null) {
                        parcel.writeInt(1);
                        region.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setWallpaperPosition(IBinder iBinder, float f, float f2, float f3, float f4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    parcel.writeFloat(f3);
                    parcel.writeFloat(f4);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void wallpaperCommandComplete(IBinder iBinder, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void wallpaperOffsetsComplete(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

