/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public final class InputChannel
implements Parcelable {
    public static final Parcelable.Creator<InputChannel> CREATOR = new Parcelable.Creator<InputChannel>(){

        @Override
        public InputChannel createFromParcel(Parcel parcel) {
            InputChannel inputChannel = new InputChannel();
            inputChannel.readFromParcel(parcel);
            return inputChannel;
        }

        public InputChannel[] newArray(int n) {
            return new InputChannel[n];
        }
    };
    private static final boolean DEBUG = false;
    private static final String TAG = "InputChannel";
    private boolean mDisposeAfterWriteToParcel;
    private int mPtr;

    private native void nativeDispose(boolean var1);

    private native String nativeGetName();

    private static native InputChannel[] nativeOpenInputChannelPair(String var0);

    private native void nativeReadFromParcel(Parcel var1);

    private native void nativeTransferTo(InputChannel var1);

    private native void nativeWriteToParcel(Parcel var1);

    public static InputChannel[] openInputChannelPair(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return InputChannel.nativeOpenInputChannelPair(string2);
    }

    @Override
    public int describeContents() {
        return 1;
    }

    public void dispose() {
        this.nativeDispose(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public String getName() {
        String string2 = this.nativeGetName();
        if (string2 != null) {
            return string2;
        }
        return "uninitialized";
    }

    public void readFromParcel(Parcel parcel) {
        if (parcel == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        this.nativeReadFromParcel(parcel);
    }

    public String toString() {
        return this.getName();
    }

    public void transferToBinderOutParameter(InputChannel inputChannel) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("outParameter must not be null");
        }
        this.nativeTransferTo(inputChannel);
        inputChannel.mDisposeAfterWriteToParcel = true;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (parcel == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        this.nativeWriteToParcel(parcel);
        if (this.mDisposeAfterWriteToParcel) {
            this.dispose();
        }
    }
}

