/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManagerNative;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.LatencyTimer;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.FocusFinder;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.RootViewSurfaceTaker;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL11;

public final class ViewRoot
extends Handler
implements ViewParent,
View.AttachInfo.Callbacks {
    public static final int CHECK_FOCUS = 1013;
    public static final int CLOSE_SYSTEM_DIALOGS = 1014;
    private static final boolean DBG = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_INPUT = true;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    public static final int DIE = 1001;
    public static final int DISPATCH_APP_VISIBILITY = 1008;
    public static final int DISPATCH_GET_NEW_SURFACE = 1009;
    public static final int DISPATCH_KEY = 1005;
    public static final int DISPATCH_KEY_FROM_IME = 1011;
    public static final int DISPATCH_POINTER = 1006;
    public static final int DISPATCH_TRACKBALL = 1007;
    public static final int DO_TRAVERSAL = 1000;
    public static final int FINISHED_EVENT = 1010;
    public static final int FINISH_INPUT_CONNECTION = 1012;
    private static final boolean LOCAL_LOGV = false;
    static final int MAX_TRACKBALL_DELAY = 250;
    private static final boolean MEASURE_LATENCY = false;
    public static final int RESIZED = 1002;
    public static final int RESIZED_REPORT = 1003;
    private static final boolean SHOW_FPS = false;
    private static final String TAG = "ViewRoot";
    private static final boolean WATCH_POINTER = false;
    public static final int WINDOW_FOCUS_CHANGED = 1004;
    private static LatencyTimer lt;
    static boolean mInitialized;
    static final Object mStaticInit;
    static final ArrayList<ComponentCallbacks> sConfigCallbacks;
    private static int sDrawTime;
    static boolean sFirstDrawComplete;
    static final ArrayList<Runnable> sFirstDrawHandlers;
    static long sInstanceCount;
    static final ThreadLocal<RunQueue> sRunQueues;
    static IWindowSession sWindowSession;
    int mAddNesting;
    boolean mAdded;
    boolean mAddedTouchMode;
    boolean mAppVisible = true;
    final View.AttachInfo mAttachInfo;
    AudioManager mAudioManager;
    int mCurScrollY;
    private final int mDensity;
    Rect mDirty;
    boolean mDrawingAllowed;
    EGL10 mEgl;
    EGLContext mEglContext;
    EGLDisplay mEglDisplay;
    EGLSurface mEglSurface;
    private Runnable mFinishedCallback;
    boolean mFirst;
    View mFocusedView;
    boolean mFullRedrawNeeded;
    GL11 mGL;
    Canvas mGlCanvas;
    boolean mGlWanted;
    boolean mHasHadWindowFocus;
    int mHeight;
    private SurfaceHolder mHolder;
    InputChannel mInputChannel;
    private final InputHandler mInputHandler;
    final InputMethodCallback mInputMethodCallback;
    InputQueue mInputQueue;
    InputQueue.Callback mInputQueueCallback;
    boolean mIsAnimating;
    boolean mIsCreating;
    final Configuration mLastConfiguration;
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets;
    View mLastScrolledFocus;
    long mLastTrackballTime = 0L;
    boolean mLastWasImTarget;
    boolean mLayoutRequested;
    final WindowLeaked mLocation;
    boolean mNewSurfaceNeeded;
    final Configuration mPendingConfiguration;
    final Rect mPendingContentInsets;
    int mPendingEventSeq = 0;
    final SparseArray<Object> mPendingEvents;
    final Rect mPendingVisibleInsets;
    final Region mPreviousTransparentRegion;
    private boolean mProfile = false;
    View mRealFocusedView;
    boolean mReportNextDraw;
    boolean mScrollMayChange;
    int mScrollY;
    Scroller mScroller;
    int mSoftInputMode;
    private final Surface mSurface;
    BaseSurfaceHolder mSurfaceHolder;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    final Rect mTempRect;
    final Thread mThread;
    final int[] mTmpLocation;
    final TrackballAxis mTrackballAxisX = new TrackballAxis();
    final TrackballAxis mTrackballAxisY = new TrackballAxis();
    CompatibilityInfo.Translator mTranslator;
    final Region mTransparentRegion;
    boolean mTraversalScheduled;
    boolean mUseGL;
    View mView;
    final ViewConfiguration mViewConfiguration;
    int mViewVisibility;
    final Rect mVisRect;
    int mWidth;
    boolean mWillDrawSoon;
    final Rect mWinFrame;
    final W mWindow;
    final WindowManager.LayoutParams mWindowAttributes;
    boolean mWindowAttributesChanged = false;

    static {
        sInstanceCount = 0L;
        mStaticInit = new Object();
        mInitialized = false;
        sRunQueues = new ThreadLocal();
        sFirstDrawHandlers = new ArrayList();
        sFirstDrawComplete = false;
        sConfigCallbacks = new ArrayList();
    }

    public ViewRoot(Context context) {
        this.mTmpLocation = new int[2];
        this.mPendingEvents = new SparseArray();
        this.mWindowAttributes = new WindowManager.LayoutParams();
        this.mSurface = new Surface();
        this.mPendingVisibleInsets = new Rect();
        this.mPendingContentInsets = new Rect();
        this.mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
        this.mLastConfiguration = new Configuration();
        this.mPendingConfiguration = new Configuration();
        this.mInputHandler = new InputHandler(){

            @Override
            public void handleKey(KeyEvent keyEvent, Runnable runnable) {
                ViewRoot.this.startInputEvent(runnable);
                ViewRoot.this.dispatchKey(keyEvent, true);
            }

            @Override
            public void handleMotion(MotionEvent motionEvent, Runnable runnable) {
                ViewRoot.this.startInputEvent(runnable);
                ViewRoot.this.dispatchMotion(motionEvent, true);
            }
        };
        this.mHolder = new SurfaceHolder(){

            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
            }

            @Override
            public Surface getSurface() {
                return ViewRoot.this.mSurface;
            }

            @Override
            public Rect getSurfaceFrame() {
                return null;
            }

            @Override
            public boolean isCreating() {
                return false;
            }

            @Override
            public Canvas lockCanvas() {
                return null;
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            @Override
            public void setFixedSize(int n, int n2) {
            }

            @Override
            public void setFormat(int n) {
            }

            @Override
            public void setKeepScreenOn(boolean bl) {
            }

            @Override
            public void setSizeFromLayout() {
            }

            @Override
            public void setType(int n) {
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
            }
        };
        ViewRoot.getWindowSession(context.getMainLooper());
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this, context);
        this.mInputMethodCallback = new InputMethodCallback(this);
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mAdded = false;
        this.mAttachInfo = new View.AttachInfo(sWindowSession, this.mWindow, this, this);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addConfigCallback(ComponentCallbacks componentCallbacks) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(componentCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addFirstDrawHandler(Runnable runnable) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(runnable);
            }
            return;
        }
    }

    private static void captureKeyLog(String string2, KeyEvent keyEvent) {
        if (keyEvent == null || SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string2 + ": ");
        stringBuilder.append(keyEvent.getDownTime()).append(',');
        stringBuilder.append(keyEvent.getEventTime()).append(',');
        stringBuilder.append(keyEvent.getAction()).append(',');
        stringBuilder.append(keyEvent.getKeyCode()).append(',');
        stringBuilder.append(keyEvent.getRepeatCount()).append(',');
        stringBuilder.append(keyEvent.getMetaState()).append(',');
        stringBuilder.append(keyEvent.getDeviceId()).append(',');
        stringBuilder.append(keyEvent.getScanCode());
        Log.d(TAG, stringBuilder.toString());
    }

    private static void captureMotionLog(String string2, MotionEvent motionEvent) {
        if (motionEvent == null || SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string2 + ": ");
        stringBuilder.append(motionEvent.getDownTime()).append(',');
        stringBuilder.append(motionEvent.getEventTime()).append(',');
        stringBuilder.append(motionEvent.getAction()).append(',');
        stringBuilder.append(motionEvent.getX()).append(',');
        stringBuilder.append(motionEvent.getY()).append(',');
        stringBuilder.append(motionEvent.getPressure()).append(',');
        stringBuilder.append(motionEvent.getSize()).append(',');
        stringBuilder.append(motionEvent.getMetaState()).append(',');
        stringBuilder.append(motionEvent.getXPrecision()).append(',');
        stringBuilder.append(motionEvent.getYPrecision()).append(',');
        stringBuilder.append(motionEvent.getDeviceId()).append(',');
        stringBuilder.append(motionEvent.getEdgeFlags());
        Log.d(TAG, stringBuilder.toString());
    }

    private void checkEglErrors() {
        int n;
        if (this.mUseGL && (n = this.mEgl.eglGetError()) != 12288) {
            this.destroyGL();
            if (n != 12302) {
                this.mGlWanted = false;
            }
        }
    }

    private boolean checkForLeavingTouchModeAndConsume(KeyEvent keyEvent) {
        int n = keyEvent.getAction();
        if (n != 0 && n != 2) {
            return false;
        }
        if ((4 & keyEvent.getFlags()) != 0) {
            return false;
        }
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        if (ViewRoot.isKeyboardKey(keyEvent) && this.mView != null && this.mView.hasFocus()) {
            this.mFocusedView = this.mView.findFocus();
            if (this.mFocusedView instanceof ViewGroup && ((ViewGroup)this.mFocusedView).getDescendantFocusability() == 262144) {
                return false;
            }
            if (this.ensureTouchMode(false)) {
                throw new IllegalStateException("should not have changed focus when leaving touch mode while a view has focus.");
            }
            return false;
        }
        if (ViewRoot.isDirectional(keyEvent.getKeyCode())) {
            return this.ensureTouchMode(false);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverKeyEvent(KeyEvent keyEvent, boolean bl) {
        InputMethodManager inputMethodManager;
        boolean bl2 = this.mView != null ? this.mView.dispatchKeyEventPreIme(keyEvent) : true;
        if (bl2) {
            if (bl) {
                this.finishInputEvent();
            }
            return;
        }
        if (this.mLastWasImTarget && (inputMethodManager = InputMethodManager.peekInstance()) != null && this.mView != null) {
            int n = this.enqueuePendingEvent(keyEvent, bl);
            inputMethodManager.dispatchKeyEvent(this.mView.getContext(), n, keyEvent, this.mInputMethodCallback);
            return;
        }
        this.deliverKeyEventToViewHierarchy(keyEvent, bl);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void deliverKeyEventToViewHierarchy(KeyEvent var1_1, boolean var2_2) {
        block16: {
            block15: {
                try {
                    if (this.mView == null || !this.mAdded) break block15;
                    var4_3 = var1_1.getAction() == 0;
                    var5_4 = this.checkForLeavingTouchModeAndConsume(var1_1);
                    if (var5_4) {
                        if (var2_2 == false) return;
                        break block16;
                    }
                    if (this.mView.dispatchKeyEvent(var1_1) || !var4_3) break block15;
                    var6_5 = var1_1.getKeyCode();
                    var7_6 = 0;
                }
                catch (Throwable var3_10) {
                    if (var2_2 == false) throw var3_10;
                    this.finishInputEvent();
                    throw var3_10;
                }
                switch (var6_5) {
                    case 21: {
                        var7_6 = 17;
                        break;
                    }
                    case 22: {
                        var7_6 = 66;
                        break;
                    }
                    case 19: {
                        var7_6 = 33;
                        break;
                    }
                    case 20: {
                        var7_6 = 130;
                    }
                }
                if (var7_6 == 0) break block15;
                var8_7 = this.mView != null ? this.mView.findFocus() : null;
                if (var8_7 == null) break block15;
                var9_8 = var8_7.focusSearch(var7_6);
                var10_9 = false;
                if (var9_8 == null) ** GOTO lbl42
                var10_9 = false;
                if (var9_8 == var8_7) ** GOTO lbl42
                var8_7.getFocusedRect(this.mTempRect);
                if (this.mView instanceof ViewGroup) {
                    ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(var8_7, this.mTempRect);
                    ((ViewGroup)this.mView).offsetRectIntoDescendantCoords(var9_8, this.mTempRect);
                }
                var10_9 = var9_8.requestFocus(var7_6, this.mTempRect);
lbl42:
                // 3 sources

                if (!var10_9) {
                    this.mView.dispatchUnhandledMove(var8_7, var7_6);
                } else {
                    this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(var7_6));
                }
            }
            if (var2_2 == false) return;
        }
        this.finishInputEvent();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverPointerEvent(MotionEvent motionEvent) {
        block13: {
            int[] nArray;
            int n;
            int n2;
            int n3;
            int n4;
            block15: {
                block16: {
                    int n5;
                    block14: {
                        if (this.mTranslator != null) {
                            this.mTranslator.translateEventInScreenToAppWindow(motionEvent);
                        }
                        if (this.mView == null || !this.mAdded) break block13;
                        boolean bl = motionEvent.getAction() == 0;
                        if (bl) {
                            this.ensureTouchMode(true);
                        }
                        if (this.mCurScrollY != 0) {
                            motionEvent.offsetLocation(0.0f, this.mCurScrollY);
                        }
                        if (this.mView.dispatchTouchEvent(motionEvent) || !bl) break block13;
                        n5 = this.mViewConfiguration.getScaledEdgeSlop();
                        n4 = motionEvent.getEdgeFlags();
                        n3 = 33;
                        n2 = (int)motionEvent.getX();
                        n = (int)motionEvent.getY();
                        nArray = new int[2];
                        if ((n4 & 1) == 0) break block14;
                        n3 = 130;
                        if ((n4 & 4) != 0) {
                            nArray[0] = n5;
                            n2 += n5;
                            break block15;
                        } else if ((n4 & 8) != 0) {
                            nArray[0] = -n5;
                            n2 -= n5;
                        }
                        break block15;
                    }
                    if ((n4 & 2) == 0) break block16;
                    n3 = 33;
                    if ((n4 & 4) != 0) {
                        nArray[0] = n5;
                        n2 += n5;
                        break block15;
                    } else if ((n4 & 8) != 0) {
                        nArray[0] = -n5;
                        n2 -= n5;
                    }
                    break block15;
                }
                if ((n4 & 4) != 0) {
                    n3 = 66;
                } else if ((n4 & 8) != 0) {
                    n3 = 17;
                }
            }
            if (n4 != 0 && this.mView instanceof ViewGroup && FocusFinder.getInstance().findNearestTouchable((ViewGroup)this.mView, n2, n, n3, nArray) != null) {
                motionEvent.offsetLocation(nArray[0], nArray[1]);
                motionEvent.setEdgeFlags(0);
                this.mView.dispatchTouchEvent(motionEvent);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deliverTrackballEvent(MotionEvent motionEvent) {
        int n;
        int n2;
        int n3;
        if (this.mView != null && this.mAdded && this.mView.dispatchTrackballEvent(motionEvent)) {
            this.ensureTouchMode(false);
            return;
        }
        TrackballAxis trackballAxis = this.mTrackballAxisX;
        TrackballAxis trackballAxis2 = this.mTrackballAxisY;
        long l = SystemClock.uptimeMillis();
        if (250L + this.mLastTrackballTime < l) {
            trackballAxis.reset(0);
            trackballAxis2.reset(0);
            this.mLastTrackballTime = l;
        }
        int n4 = motionEvent.getAction();
        int n5 = motionEvent.getMetaState();
        switch (n4) {
            case 0: {
                trackballAxis.reset(2);
                trackballAxis2.reset(2);
                this.deliverKeyEvent(new KeyEvent(l, l, 0, 23, 0, n5), false);
                break;
            }
            case 1: {
                trackballAxis.reset(2);
                trackballAxis2.reset(2);
                this.deliverKeyEvent(new KeyEvent(l, l, 1, 23, 0, n5), false);
            }
        }
        float f = trackballAxis.collect(motionEvent.getX(), motionEvent.getEventTime(), "X");
        float f2 = trackballAxis2.collect(motionEvent.getY(), motionEvent.getEventTime(), "Y");
        float f3 = 1.0f;
        if (f > f2) {
            n3 = trackballAxis.generate(2.0f / motionEvent.getXPrecision());
            n2 = 0;
            if (n3 != 0) {
                n2 = n3 > 0 ? 22 : 21;
                f3 = trackballAxis.acceleration;
                trackballAxis2.reset(2);
            }
        } else {
            float f4 = f2 - 0.0f;
            float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
            n2 = 0;
            n3 = 0;
            if (f5 > 0) {
                n3 = trackballAxis2.generate(2.0f / motionEvent.getYPrecision());
                n2 = 0;
                if (n3 != 0) {
                    n2 = n3 > 0 ? 20 : 19;
                    f3 = trackballAxis2.acceleration;
                    trackballAxis.reset(2);
                }
            }
        }
        if (n2 == 0) return;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n = (int)(f3 * (float)n3)) > n3) {
            int n6 = n - --n3;
            this.deliverKeyEvent(new KeyEvent(l, l, 2, n2, n6, n5), false);
        }
        while (n3 > 0) {
            --n3;
            l = SystemClock.uptimeMillis();
            int n7 = motionEvent.getMetaState();
            this.deliverKeyEvent(new KeyEvent(l, l, 0, n2, 0, n7), false);
            this.deliverKeyEvent(new KeyEvent(l, l, 1, n2, 0, n5), false);
        }
        this.mLastTrackballTime = l;
    }

    private void destroyGL() {
        ViewRoot.nativeAbandonGlCaches();
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
        this.mEgl.eglTerminate(this.mEglDisplay);
        this.mEglContext = null;
        this.mEglSurface = null;
        this.mEglDisplay = null;
        this.mEgl = null;
        this.mGlCanvas = null;
        this.mGL = null;
        this.mUseGL = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchKey(KeyEvent keyEvent, boolean bl) {
        Message message = this.obtainMessage(1005);
        message.obj = keyEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        this.sendMessageAtTime(message, keyEvent.getEventTime());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchMotion(MotionEvent motionEvent, boolean bl) {
        int n = motionEvent.getSource();
        if ((n & 2) != 0) {
            this.dispatchPointer(motionEvent, bl);
            return;
        } else {
            if ((n & 4) != 0) {
                this.dispatchTrackball(motionEvent, bl);
                return;
            }
            Log.v(TAG, "Dropping unsupported motion event (unimplemented): " + motionEvent);
            if (!bl) return;
            this.finishInputEvent();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchPointer(MotionEvent motionEvent, boolean bl) {
        Message message = this.obtainMessage(1006);
        message.obj = motionEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        this.sendMessageAtTime(message, motionEvent.getEventTime());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchTrackball(MotionEvent motionEvent, boolean bl) {
        Message message = this.obtainMessage(1007);
        message.obj = motionEvent;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        this.sendMessageAtTime(message, motionEvent.getEventTime());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void draw(boolean bl) {
        int n;
        Canvas canvas;
        boolean bl2;
        Surface surface;
        block31: {
            int n2;
            surface = this.mSurface;
            if (surface == null) return;
            if (!surface.isValid()) {
                return;
            }
            if (!sFirstDrawComplete) {
                ArrayList<Runnable> arrayList = sFirstDrawHandlers;
                synchronized (arrayList) {
                    int n3;
                    sFirstDrawComplete = true;
                    for (int i = 0; i < (n3 = sFirstDrawHandlers.size()); ++i) {
                        this.post(sFirstDrawHandlers.get(i));
                    }
                }
            }
            this.scrollToRectOrFocus(null, false);
            if (this.mAttachInfo.mViewScrollChanged) {
                this.mAttachInfo.mViewScrollChanged = false;
                this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
            }
            if (this.mCurScrollY != (n2 = (bl2 = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
                this.mCurScrollY = n2;
                bl = true;
            }
            float f = this.mAttachInfo.mApplicationScale;
            boolean bl3 = this.mAttachInfo.mScalingRequired;
            Rect rect = this.mDirty;
            if (this.mSurfaceHolder != null) {
                rect.setEmpty();
                return;
            }
            if (this.mUseGL) {
                int n4;
                Canvas canvas2;
                if (!rect.isEmpty()) {
                    canvas2 = this.mGlCanvas;
                    if (this.mGL != null && canvas2 != null) {
                        this.mGL.glDisable(3089);
                        this.mGL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        this.mGL.glClear(16384);
                        this.mGL.glEnable(3089);
                        this.mAttachInfo.mDrawingTime = SystemClock.uptimeMillis();
                        this.mAttachInfo.mIgnoreDirtyState = true;
                        View view = this.mView;
                        view.mPrivateFlags = 0x20 | view.mPrivateFlags;
                        n4 = canvas2.save(1);
                        float f2 = -n2;
                        canvas2.translate(0.0f, f2);
                        if (this.mTranslator != null) {
                            this.mTranslator.translateCanvas(canvas2);
                        }
                        int n5 = bl3 ? DisplayMetrics.DENSITY_DEVICE : 0;
                        canvas2.setScreenDensity(n5);
                        this.mView.draw(canvas2);
                        canvas2.restoreToCount(n4);
                        this.mAttachInfo.mIgnoreDirtyState = false;
                        this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
                        this.checkEglErrors();
                    }
                }
                if (!bl2) return;
                this.mFullRedrawNeeded = true;
                this.scheduleTraversals();
                return;
                catch (Throwable throwable) {
                    canvas2.restoreToCount(n4);
                    throw throwable;
                }
            }
            if (bl) {
                this.mAttachInfo.mIgnoreDirtyState = true;
                rect.union(0, 0, (int)(0.5f + f * (float)this.mWidth), (int)(0.5f + f * (float)this.mHeight));
            }
            if (!rect.isEmpty() || this.mIsAnimating) {
                int n6 = rect.left;
                int n7 = rect.top;
                int n8 = rect.right;
                int n9 = rect.bottom;
                canvas = surface.lockCanvas(rect);
                if (n6 != rect.left || n7 != rect.top || n8 != rect.right || n9 != rect.bottom) {
                    this.mAttachInfo.mIgnoreDirtyState = true;
                }
                canvas.setDensity(this.mDensity);
                if (rect.isEmpty() && !this.mIsAnimating) break block31;
                if (!canvas.isOpaque() || n2 != 0) {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                }
                rect.setEmpty();
                this.mIsAnimating = false;
                this.mAttachInfo.mDrawingTime = SystemClock.uptimeMillis();
                View view = this.mView;
                view.mPrivateFlags = 0x20 | view.mPrivateFlags;
                n = canvas.save(1);
                float f3 = -n2;
                canvas.translate(0.0f, f3);
                if (this.mTranslator != null) {
                    this.mTranslator.translateCanvas(canvas);
                }
                int n10 = bl3 ? DisplayMetrics.DENSITY_DEVICE : 0;
                canvas.setScreenDensity(n10);
                this.mView.draw(canvas);
                this.mAttachInfo.mIgnoreDirtyState = false;
                canvas.restoreToCount(n);
            }
        }
        if (!bl2) return;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
        return;
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            Log.e(TAG, "OutOfResourcesException locking surface", outOfResourcesException);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "IllegalArgumentException locking surface", illegalArgumentException);
            return;
        }
        catch (Throwable throwable) {
            this.mAttachInfo.mIgnoreDirtyState = false;
            canvas.restoreToCount(n);
            throw throwable;
        }
        finally {
            surface.unlockCanvasAndPost(canvas);
        }
    }

    private boolean ensureTouchModeLocally(boolean bl) {
        if (this.mAttachInfo.mInTouchMode == bl) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = bl;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(bl);
        if (bl) {
            return this.enterTouchMode();
        }
        return this.leaveTouchMode();
    }

    private boolean enterTouchMode() {
        View view;
        if (this.mView != null && this.mView.hasFocus() && (view = this.mView.findFocus()) != null && !view.isFocusableInTouchMode()) {
            ViewGroup viewGroup = this.findAncestorToTakeFocusInTouchMode(view);
            if (viewGroup != null) {
                return viewGroup.requestFocus();
            }
            this.mView.unFocus();
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view, null);
            this.mFocusedView = null;
            return true;
        }
        return false;
    }

    private ViewGroup findAncestorToTakeFocusInTouchMode(View view) {
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup.getDescendantFocusability() == 262144 && viewGroup.isFocusableInTouchMode()) {
                return viewGroup;
            }
            if (viewGroup.isRootNamespace()) {
                return null;
            }
            viewParent = viewGroup.getParent();
        }
        return null;
    }

    private void finishInputEvent() {
        if (this.mFinishedCallback != null) {
            this.mFinishedCallback.run();
            this.mFinishedCallback = null;
            return;
        }
        Slog.w(TAG, "Attempted to tell the input queue that the current input event is finished but there is no input event actually in progress.");
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ViewRoot.forceLayout(viewGroup.getChildAt(i));
            }
        }
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    public static long getInstanceCount() {
        return sInstanceCount;
    }

    private int getRootMeasureSpec(int n, int n2) {
        switch (n2) {
            default: {
                return View.MeasureSpec.makeMeasureSpec(n2, 0x40000000);
            }
            case -1: {
                return View.MeasureSpec.makeMeasureSpec(n, 0x40000000);
            }
            case -2: 
        }
        return View.MeasureSpec.makeMeasureSpec(n, Integer.MIN_VALUE);
    }

    static RunQueue getRunQueue() {
        RunQueue runQueue = sRunQueues.get();
        if (runQueue != null) {
            return runQueue;
        }
        RunQueue runQueue2 = new RunQueue();
        sRunQueues.set(runQueue2);
        return runQueue2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IWindowSession getWindowSession(Looper looper) {
        Object object = mStaticInit;
        synchronized (object) {
            boolean bl = mInitialized;
            if (bl) return sWindowSession;
            try {
                InputMethodManager inputMethodManager = InputMethodManager.getInstance((Looper)looper);
                sWindowSession = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).openSession(inputMethodManager.getClient(), inputMethodManager.getInputContext());
                mInitialized = true;
                return sWindowSession;
            }
            catch (RemoteException remoteException) {}
            return sWindowSession;
        }
    }

    private void initializeGL() {
        this.initializeGLInner();
        if (this.mEgl.eglGetError() != 12288) {
            this.destroyGL();
            this.mGlWanted = false;
        }
    }

    private void initializeGLInner() {
        GL11 gL11;
        EGLSurface eGLSurface;
        EGLContext eGLContext;
        EGLDisplay eGLDisplay;
        EGL10 eGL10;
        this.mEgl = eGL10 = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        eGL10.eglInitialize(eGLDisplay, new int[2]);
        int[] nArray = new int[]{12324, 5, 12323, 6, 12322, 5, 12325, 0, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        eGL10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, 1, new int[1]);
        EGLConfig eGLConfig = eGLConfigArray[0];
        this.mEglContext = eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, null);
        this.mEglSurface = eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, this.mHolder, null);
        eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface, eGLContext);
        this.mGL = gL11 = (GL11)eGLContext.getGL();
        this.mGlCanvas = new Canvas(gL11);
        this.mUseGL = true;
    }

    static boolean isDirectional(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
        }
        return true;
    }

    static boolean isInTouchMode() {
        if (mInitialized) {
            try {
                boolean bl = sWindowSession.getInTouchMode();
                return bl;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isKeyboardKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    private static boolean isViewDescendantOf(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        return viewParent instanceof ViewGroup && ViewRoot.isViewDescendantOf((View)((Object)viewParent), view2);
    }

    private boolean leaveTouchMode() {
        if (this.mView != null) {
            View view;
            if (this.mView.hasFocus()) {
                this.mFocusedView = this.mView.findFocus();
                if (!(this.mFocusedView instanceof ViewGroup)) {
                    return false;
                }
                if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) {
                    return false;
                }
            }
            if ((view = this.focusSearch(null, 130)) != null) {
                return view.requestFocus(130);
            }
        }
        return false;
    }

    private static native void nativeAbandonGlCaches();

    private static native void nativeShowFPS(Canvas var0, int var1);

    /*
     * Unable to fully structure code
     */
    private void performTraversals() {
        block106: {
            block107: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block99: {
                                    block98: {
                                        block100: {
                                            block101: {
                                                block95: {
                                                    block97: {
                                                        block94: {
                                                            block93: {
                                                                block92: {
                                                                    block91: {
                                                                        block110: {
                                                                            block89: {
                                                                                block90: {
                                                                                    block87: {
                                                                                        block88: {
                                                                                            block109: {
                                                                                                block85: {
                                                                                                    block86: {
                                                                                                        block108: {
                                                                                                            var1_1 = this.mView;
                                                                                                            if (var1_1 == null || !this.mAdded) {
                                                                                                                return;
                                                                                                            }
                                                                                                            this.mTraversalScheduled = false;
                                                                                                            this.mWillDrawSoon = true;
                                                                                                            var2_2 = false;
                                                                                                            var3_3 = this.mFullRedrawNeeded;
                                                                                                            var4_4 = false;
                                                                                                            var5_5 = this.mWindowAttributes;
                                                                                                            var6_6 = this.mAttachInfo;
                                                                                                            var7_7 = this.getHostVisibility();
                                                                                                            if (this.mViewVisibility == var7_7 && !this.mNewSurfaceNeeded) break block108;
                                                                                                            var8_8 = true;
lbl15:
                                                                                                            // 2 sources

                                                                                                            while (true) {
                                                                                                                var9_9 = this.mAttachInfo.mApplicationScale;
                                                                                                                var10_10 = this.mWindowAttributesChanged;
                                                                                                                var11_11 = null;
                                                                                                                var12_12 = false;
                                                                                                                if (var10_10) {
                                                                                                                    this.mWindowAttributesChanged = false;
                                                                                                                    var12_12 = true;
                                                                                                                    var11_11 = var5_5;
                                                                                                                }
                                                                                                                var13_13 = this.mWinFrame;
                                                                                                                if (!this.mFirst) break block85;
                                                                                                                var3_3 = true;
                                                                                                                this.mLayoutRequested = true;
                                                                                                                var97_14 = this.mView.getContext().getResources().getDisplayMetrics();
                                                                                                                var14_15 = var97_14.widthPixels;
                                                                                                                var15_16 = var97_14.heightPixels;
                                                                                                                var6_6.mSurface = this.mSurface;
                                                                                                                if (!PixelFormat.formatHasAlpha(var5_5.format) && var5_5.format != 2) break block86;
                                                                                                                var98_17 = true;
lbl34:
                                                                                                                // 2 sources

                                                                                                                while (true) {
                                                                                                                    var6_6.mUse32BitDrawingCache = var98_17;
                                                                                                                    var6_6.mHasWindowFocus = false;
                                                                                                                    var6_6.mWindowVisibility = var7_7;
                                                                                                                    var6_6.mRecomputeGlobalAttributes = false;
                                                                                                                    var6_6.mKeepScreenOn = false;
                                                                                                                    var8_8 = false;
                                                                                                                    this.mLastConfiguration.setTo(var1_1.getResources().getConfiguration());
                                                                                                                    var1_1.dispatchAttachedToWindow(var6_6, 0);
lbl43:
                                                                                                                    // 3 sources

                                                                                                                    while (true) {
                                                                                                                        if (var8_8) {
                                                                                                                            var6_6.mWindowVisibility = var7_7;
                                                                                                                            var1_1.dispatchWindowVisibilityChanged(var7_7);
                                                                                                                            if ((var7_7 != 0 || this.mNewSurfaceNeeded) && this.mUseGL) {
                                                                                                                                this.destroyGL();
                                                                                                                            }
                                                                                                                            if (var7_7 == 8) {
                                                                                                                                this.mHasHadWindowFocus = false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        var17_21 = this.mLayoutRequested;
                                                                                                                        var18_22 = false;
                                                                                                                        if (!var17_21) ** GOTO lbl70
                                                                                                                        ViewRoot.getRunQueue().executeActions(var6_6.mHandler);
                                                                                                                        if (!this.mFirst) break block87;
                                                                                                                        var1_1.fitSystemWindows(this.mAttachInfo.mContentInsets);
                                                                                                                        var92_23 = this.mAttachInfo;
                                                                                                                        if (this.mAddedTouchMode) break block88;
                                                                                                                        var93_24 = true;
lbl61:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            var92_23.mInTouchMode = var93_24;
                                                                                                                            this.ensureTouchModeLocally(this.mAddedTouchMode);
lbl65:
                                                                                                                            // 3 sources

                                                                                                                            while (true) {
                                                                                                                                var87_27 = var5_5.width;
                                                                                                                                var88_28 = this.getRootMeasureSpec(var14_15, var87_27);
                                                                                                                                var89_29 = var5_5.height;
                                                                                                                                var1_1.measure(var88_28, this.getRootMeasureSpec(var15_16, var89_29));
lbl70:
                                                                                                                                // 2 sources

                                                                                                                                if (var6_6.mRecomputeGlobalAttributes) {
                                                                                                                                    var6_6.mRecomputeGlobalAttributes = false;
                                                                                                                                    var84_30 = var6_6.mKeepScreenOn;
                                                                                                                                    var6_6.mKeepScreenOn = false;
                                                                                                                                    var1_1.dispatchCollectViewAttributes(0);
                                                                                                                                    if (var6_6.mKeepScreenOn != var84_30) {
                                                                                                                                        var11_11 = var5_5;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (!this.mFirst && !var6_6.mViewVisibilityChanged) break block89;
                                                                                                                                var6_6.mViewVisibilityChanged = false;
                                                                                                                                var19_31 = 240 & this.mSoftInputMode;
                                                                                                                                if (var19_31 != 0) break block89;
                                                                                                                                var82_32 = var6_6.mScrollContainers.size();
                                                                                                                                for (var83_33 = 0; var83_33 < var82_32; ++var83_33) {
                                                                                                                                    if (!var6_6.mScrollContainers.get(var83_33).isShown()) continue;
                                                                                                                                    var19_31 = 16;
                                                                                                                                }
                                                                                                                                break block90;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    break;
                                                                                                                }
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        var8_8 = false;
                                                                                                        ** while (true)
                                                                                                    }
                                                                                                    var98_17 = false;
                                                                                                    ** while (true)
                                                                                                }
                                                                                                var14_15 = var13_13.width();
                                                                                                var15_16 = var13_13.height();
                                                                                                var16_19 = this.mWidth;
                                                                                                if (var14_15 != var16_19) break block109;
                                                                                                var95_20 = this.mHeight;
                                                                                                var96_18 = var15_16;
                                                                                                var2_2 = false;
                                                                                                if (var96_18 == var95_20) ** GOTO lbl43
                                                                                            }
                                                                                            var3_3 = true;
                                                                                            this.mLayoutRequested = true;
                                                                                            var2_2 = true;
                                                                                            ** while (true)
                                                                                        }
                                                                                        var93_24 = false;
                                                                                        ** while (true)
                                                                                    }
                                                                                    var85_25 = this.mAttachInfo.mContentInsets.equals(this.mPendingContentInsets);
                                                                                    var18_22 = false;
                                                                                    if (!var85_25) {
                                                                                        this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                                                                                        var1_1.fitSystemWindows(this.mAttachInfo.mContentInsets);
                                                                                        var18_22 = true;
                                                                                    }
                                                                                    if (!this.mAttachInfo.mVisibleInsets.equals(this.mPendingVisibleInsets)) {
                                                                                        this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                                                                                    }
                                                                                    if (var5_5.width != -2 && var5_5.height != -2) ** GOTO lbl65
                                                                                    var2_2 = true;
                                                                                    var86_26 = this.mView.getContext().getResources().getDisplayMetrics();
                                                                                    var14_15 = var86_26.widthPixels;
                                                                                    var15_16 = var86_26.heightPixels;
                                                                                    ** while (true)
                                                                                }
                                                                                if (var19_31 == 0) {
                                                                                    var19_31 = 32;
                                                                                }
                                                                                if ((240 & var5_5.softInputMode) != var19_31) {
                                                                                    var5_5.softInputMode = var19_31 | -241 & var5_5.softInputMode;
                                                                                    var11_11 = var5_5;
                                                                                }
                                                                            }
                                                                            if (var11_11 != null && (512 & var1_1.mPrivateFlags) != 0 && !PixelFormat.formatHasAlpha(var11_11.format)) {
                                                                                var11_11.format = -3;
                                                                            }
                                                                            if (!this.mLayoutRequested || !var2_2 || this.mWidth == var1_1.mMeasuredWidth && this.mHeight == var1_1.mMeasuredHeight && (var5_5.width != -2 || var13_13.width() >= var14_15 || var13_13.width() == this.mWidth) && (var5_5.height != -2 || var13_13.height() >= var15_16 || var13_13.height() == this.mHeight)) break block110;
                                                                            var20_34 = true;
lbl137:
                                                                            // 2 sources

                                                                            while (true) {
                                                                                block111: {
                                                                                    var21_35 = var6_6.mTreeObserver.hasComputeInternalInsetsListeners();
                                                                                    var22_36 = 0;
                                                                                    if (this.mFirst || var20_34 || var18_22 || var8_8) break block111;
                                                                                    var23_37 = false;
                                                                                    var4_4 = false;
                                                                                    var22_36 = 0;
                                                                                    if (var11_11 == null) ** GOTO lbl315
                                                                                }
                                                                                var23_37 = false;
                                                                                if (var7_7 != 0) ** GOTO lbl155
                                                                                if (!var21_35 || !this.mFirst && !var8_8) break block91;
                                                                                var23_37 = true;
lbl150:
                                                                                // 2 sources

                                                                                while (true) {
                                                                                    if (this.mWindowAttributes.memoryType == 2) {
                                                                                        if (var11_11 == null) {
                                                                                            var11_11 = this.mWindowAttributes;
                                                                                        }
                                                                                        this.mGlWanted = true;
                                                                                    }
lbl155:
                                                                                    // 4 sources

                                                                                    if (this.mSurfaceHolder != null) {
                                                                                        this.mSurfaceHolder.mSurfaceLock.lock();
                                                                                        this.mDrawingAllowed = true;
                                                                                    }
                                                                                    var24_38 = false;
                                                                                    var25_39 = this.mSurface.isValid();
                                                                                    var26_40 = 0;
                                                                                    if (var11_11 == null) ** GOTO lbl166
                                                                                    var26_40 = var11_11.flags;
                                                                                    if (var6_6.mKeepScreenOn) {
                                                                                        var11_11.flags = var81_41 = 128 | var11_11.flags;
                                                                                    }
lbl166:
                                                                                    // 4 sources

                                                                                    var22_36 = this.relayoutWindow(var11_11, var7_7, var23_37);
                                                                                    if (var11_11 == null) ** GOTO lbl171
                                                                                    var80_42 = var26_40;
                                                                                    var11_11.flags = var80_42;
lbl171:
                                                                                    // 2 sources

                                                                                    if (this.mPendingConfiguration.seq == 0) ** GOTO lbl179
                                                                                    var78_43 = this.mPendingConfiguration;
                                                                                    if (this.mFirst) break block92;
                                                                                    var79_44 = true;
lbl175:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        this.updateConfiguration(var78_43, var79_44);
                                                                                        this.mPendingConfiguration.seq = 0;
lbl179:
                                                                                        // 2 sources

                                                                                        if (this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets)) break block93;
                                                                                        var24_38 = true;
lbl181:
                                                                                        // 2 sources

                                                                                        while (true) {
                                                                                            if (this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets)) break block94;
                                                                                            var70_45 = true;
lbl185:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                block96: {
                                                                                                    if (var24_38) {
                                                                                                        this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                                                                                                        var1_1.fitSystemWindows(this.mAttachInfo.mContentInsets);
                                                                                                    }
                                                                                                    if (var70_45) {
                                                                                                        this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                                                                                                    }
                                                                                                    if (var25_39) break block95;
                                                                                                    var72_46 = this.mSurface.isValid();
                                                                                                    var28_47 = false;
                                                                                                    var4_4 = false;
                                                                                                    if (!var72_46) break block96;
                                                                                                    var4_4 = true;
                                                                                                    var3_3 = true;
                                                                                                    this.mPreviousTransparentRegion.setEmpty();
                                                                                                    var73_48 = this.mGlWanted;
                                                                                                    var28_47 = false;
                                                                                                    if (!var73_48) break block96;
                                                                                                    var74_49 = this.mUseGL;
                                                                                                    var28_47 = false;
                                                                                                    if (var74_49) break block96;
                                                                                                    this.initializeGL();
                                                                                                    var75_50 = this.mGlCanvas;
                                                                                                    if (var75_50 == null) break block97;
                                                                                                    var28_47 = true;
                                                                                                }
lbl217:
                                                                                                // 5 sources

                                                                                                while (true) {
                                                                                                    var6_6.mWindowLeft = var13_13.left;
                                                                                                    var6_6.mWindowTop = var13_13.top;
                                                                                                    this.mWidth = var13_13.width();
                                                                                                    this.mHeight = var13_13.height();
                                                                                                    if (this.mSurfaceHolder == null) break block98;
                                                                                                    if (this.mSurface.isValid()) {
                                                                                                        this.mSurfaceHolder.mSurface = this.mSurface;
                                                                                                    }
                                                                                                    this.mSurfaceHolder.mSurfaceLock.unlock();
                                                                                                    if (!this.mSurface.isValid()) break block99;
                                                                                                    if (var25_39) break block100;
                                                                                                    this.mSurfaceHolder.ungetCallbacks();
                                                                                                    this.mIsCreating = true;
                                                                                                    this.mSurfaceHolderCallback.surfaceCreated(this.mSurfaceHolder);
                                                                                                    var67_54 = this.mSurfaceHolder.getCallbacks();
                                                                                                    if (var67_54 != null) {
                                                                                                        var68_55 = var67_54.length;
                                                                                                        for (var69_56 = 0; var69_56 < var68_55; ++var69_56) {
                                                                                                            var67_54[var69_56].surfaceCreated(this.mSurfaceHolder);
                                                                                                        }
                                                                                                    }
                                                                                                    break block101;
                                                                                                    break;
                                                                                                }
                                                                                                break;
                                                                                            }
                                                                                            break;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                    break;
                                                                                }
                                                                                break;
                                                                            }
                                                                        }
                                                                        var20_34 = false;
                                                                        ** while (true)
                                                                    }
                                                                    var23_37 = false;
                                                                    ** while (true)
                                                                }
                                                                var79_44 = false;
                                                                ** while (true)
                                                            }
                                                            var24_38 = false;
                                                            ** while (true)
                                                        }
                                                        var70_45 = false;
                                                        ** while (true)
                                                    }
                                                    var28_47 = false;
                                                    ** GOTO lbl217
                                                }
                                                var76_52 = this.mSurface.isValid();
                                                var28_47 = false;
                                                var4_4 = false;
                                                if (var76_52) ** GOTO lbl217
                                                this.mLastScrolledFocus = null;
                                                this.mCurScrollY = 0;
                                                this.mScrollY = 0;
                                                var77_53 = this.mScroller;
                                                var28_47 = false;
                                                var4_4 = false;
                                                if (var77_53 == null) ** GOTO lbl217
                                                try {
                                                    this.mScroller.abortAnimation();
                                                    var28_47 = false;
                                                    var4_4 = false;
                                                }
                                                catch (RemoteException var27_51) {
                                                    var28_47 = false;
                                                }
                                                ** while (true)
                                            }
                                            var12_12 = true;
                                        }
                                        if (var12_12) {
                                            this.mSurfaceHolderCallback.surfaceChanged(this.mSurfaceHolder, var5_5.format, this.mWidth, this.mHeight);
                                            var64_57 = this.mSurfaceHolder.getCallbacks();
                                            if (var64_57 != null) {
                                                var65_58 = var64_57.length;
                                                for (var66_59 = 0; var66_59 < var65_58; ++var66_59) {
                                                    var64_57[var66_59].surfaceChanged(this.mSurfaceHolder, var5_5.format, this.mWidth, this.mHeight);
                                                }
                                            }
                                        }
                                        this.mIsCreating = false;
                                    }
lbl291:
                                    // 3 sources

                                    while (true) {
                                        if (var28_47) {
                                            this.mGlCanvas.setViewport((int)(0.5f + var9_9 * (float)this.mWidth), (int)(0.5f + var9_9 * (float)this.mHeight));
                                        }
                                        if ((var22_36 & 1) == 0) break block102;
                                        var29_63 = true;
lbl296:
                                        // 2 sources

                                        while (true) {
                                            if (this.ensureTouchModeLocally(var29_63) || this.mWidth != var1_1.mMeasuredWidth || this.mHeight != var1_1.mMeasuredHeight || var24_38) {
                                                var30_64 = this.getRootMeasureSpec(this.mWidth, var5_5.width);
                                                var31_65 = this.getRootMeasureSpec(this.mHeight, var5_5.height);
                                                var1_1.measure(var30_64, var31_65);
                                                var32_66 = var1_1.mMeasuredWidth;
                                                var33_67 = var1_1.mMeasuredHeight;
                                                cfr_temp_0 = var5_5.horizontalWeight - 0.0f;
                                                var34_68 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                                                var35_69 = false;
                                                if (var34_68 > 0) {
                                                    var30_64 = View.MeasureSpec.makeMeasureSpec(var32_66 + (int)((float)(this.mWidth - var32_66) * var5_5.horizontalWeight), 0x40000000);
                                                    var35_69 = true;
                                                }
                                                if (var5_5.verticalWeight > 0.0f) {
                                                    var31_65 = View.MeasureSpec.makeMeasureSpec(var33_67 + (int)((float)(this.mHeight - var33_67) * var5_5.verticalWeight), 0x40000000);
                                                    var35_69 = true;
                                                }
                                                if (var35_69) {
                                                    var1_1.measure(var30_64, var31_65);
                                                }
                                                this.mLayoutRequested = true;
                                            }
lbl315:
                                            // 4 sources

                                            if (!(var36_70 = this.mLayoutRequested) && !var6_6.mRecomputeGlobalAttributes) break block103;
                                            var37_71 = true;
lbl317:
                                            // 2 sources

                                            while (true) {
                                                if (var36_70) {
                                                    this.mLayoutRequested = false;
                                                    this.mScrollMayChange = true;
                                                    var1_1.layout(0, 0, var1_1.mMeasuredWidth, var1_1.mMeasuredHeight);
                                                    if ((512 & var1_1.mPrivateFlags) != 0) {
                                                        var1_1.getLocationInWindow(this.mTmpLocation);
                                                        this.mTransparentRegion.set(this.mTmpLocation[0], this.mTmpLocation[1], this.mTmpLocation[0] + var1_1.mRight - var1_1.mLeft, this.mTmpLocation[1] + var1_1.mBottom - var1_1.mTop);
                                                        var1_1.gatherTransparentRegion(this.mTransparentRegion);
                                                        if (this.mTranslator != null) {
                                                            this.mTranslator.translateRegionInWindowToScreen(this.mTransparentRegion);
                                                        }
                                                        if (!this.mTransparentRegion.equals(this.mPreviousTransparentRegion)) {
                                                            this.mPreviousTransparentRegion.set(this.mTransparentRegion);
                                                            ViewRoot.sWindowSession.setTransparentRegion(this.mWindow, this.mTransparentRegion);
                                                        }
                                                    }
                                                }
lbl335:
                                                // 8 sources

                                                while (true) {
                                                    if (var37_71) {
                                                        var6_6.mRecomputeGlobalAttributes = false;
                                                        var6_6.mTreeObserver.dispatchOnGlobalLayout();
                                                    }
                                                    if (var21_35) {
                                                        var51_73 = var6_6.mGivenInternalInsets;
                                                        var52_74 = var6_6.mGivenInternalInsets.contentInsets;
                                                        var53_75 = var6_6.mGivenInternalInsets.visibleInsets;
                                                        var53_75.bottom = 0;
                                                        var53_75.right = 0;
                                                        var53_75.top = 0;
                                                        var53_75.left = 0;
                                                        var52_74.bottom = 0;
                                                        var52_74.right = 0;
                                                        var52_74.top = 0;
                                                        var52_74.left = 0;
                                                        var6_6.mTreeObserver.dispatchOnComputeInternalInsets(var51_73);
                                                        var54_76 = var51_73.contentInsets;
                                                        var55_77 = var51_73.visibleInsets;
                                                        if (this.mTranslator != null) {
                                                            var54_76 = this.mTranslator.getTranslatedContentInsets(var54_76);
                                                            var55_77 = this.mTranslator.getTranslatedVisbileInsets(var55_77);
                                                        }
                                                        if (var23_37 || !this.mLastGivenInsets.equals(var51_73)) {
                                                            this.mLastGivenInsets.set(var51_73);
                                                            ViewRoot.sWindowSession.setInsets(this.mWindow, var51_73.mTouchableInsets, var54_76, var55_77);
                                                        }
                                                    }
lbl361:
                                                    // 6 sources

                                                    while (true) {
                                                        if (this.mFirst && this.mView != null) {
                                                            if (this.mView.hasFocus()) break block104;
                                                            this.mView.requestFocus(2);
                                                            this.mRealFocusedView = var50_79 = this.mView.findFocus();
                                                            this.mFocusedView = var50_79;
                                                        }
lbl368:
                                                        // 4 sources

                                                        while (true) {
                                                            this.mFirst = false;
                                                            this.mWillDrawSoon = false;
                                                            this.mNewSurfaceNeeded = false;
                                                            this.mViewVisibility = var7_7;
                                                            if (!this.mAttachInfo.mHasWindowFocus || (var43_80 = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags)) == this.mLastWasImTarget) ** GOTO lbl385
                                                            this.mLastWasImTarget = var43_80;
                                                            var44_81 = InputMethodManager.peekInstance();
                                                            if (var44_81 == null || !var43_80) ** GOTO lbl385
                                                            var44_81.startGettingWindowFocus(this.mView);
                                                            var45_82 = this.mView;
                                                            var46_83 = this.mView.findFocus();
                                                            var47_84 = this.mWindowAttributes.softInputMode;
                                                            if (this.mHasHadWindowFocus) break block105;
                                                            var48_85 = true;
lbl383:
                                                            // 2 sources

                                                            while (true) {
                                                                var44_81.onWindowFocus(var45_82, var46_83, var47_84, var48_85, this.mWindowAttributes.flags);
lbl385:
                                                                // 3 sources

                                                                if (var6_6.mTreeObserver.dispatchOnPreDraw() || var4_4) break block106;
                                                                this.mFullRedrawNeeded = false;
                                                                this.draw(var3_3);
                                                                if ((var22_36 & 2) == 0 && !this.mReportNextDraw) ** continue;
                                                                this.mReportNextDraw = false;
                                                                if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
                                                                    this.mSurfaceHolderCallback.surfaceRedrawNeeded(this.mSurfaceHolder);
                                                                    var39_86 = this.mSurfaceHolder.getCallbacks();
                                                                    if (var39_86 != null) {
                                                                        for (SurfaceHolder.Callback var42_89 : var39_86) {
                                                                            if (!(var42_89 instanceof SurfaceHolder.Callback2)) continue;
                                                                            ((SurfaceHolder.Callback2)var42_89).surfaceRedrawNeeded(this.mSurfaceHolder);
                                                                        }
                                                                    }
                                                                }
                                                                break block107;
                                                                break;
                                                            }
                                                            break;
                                                        }
                                                        break;
                                                    }
                                                    break;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                }
                                if (!var25_39) ** GOTO lbl291
                                this.mSurfaceHolder.ungetCallbacks();
                                var61_60 = this.mSurfaceHolder.getCallbacks();
                                this.mSurfaceHolderCallback.surfaceDestroyed(this.mSurfaceHolder);
                                if (var61_60 != null) {
                                    var62_61 = var61_60.length;
                                    for (var63_62 = 0; var63_62 < var62_61; ++var63_62) {
                                        var61_60[var63_62].surfaceDestroyed(this.mSurfaceHolder);
                                    }
                                }
                                this.mSurfaceHolder.mSurfaceLock.lock();
                                this.mSurfaceHolder.mSurface = new Surface();
                                this.mSurfaceHolder.mSurfaceLock.unlock();
                                ** while (true)
                            }
                            var29_63 = false;
                            ** while (true)
                        }
                        var37_71 = false;
                        ** while (true)
                    }
                    this.mRealFocusedView = this.mView.findFocus();
                    ** while (true)
                }
                var48_85 = false;
                ** while (true)
            }
            try {
                ViewRoot.sWindowSession.finishDrawing(this.mWindow);
                return;
            }
            catch (RemoteException var38_90) {
                return;
            }
        }
        if ((var22_36 & 2) != 0) {
            this.mReportNextDraw = true;
        }
        if (var3_3) {
            this.mFullRedrawNeeded = true;
        }
        this.scheduleTraversals();
        return;
        catch (RemoteException var56_78) {
            ** continue;
        }
        catch (RemoteException var60_72) {
            ** continue;
        }
    }

    private int relayoutWindow(WindowManager.LayoutParams layoutParams, int n, boolean bl) throws RemoteException {
        float f = this.mAttachInfo.mApplicationScale;
        boolean bl2 = false;
        if (layoutParams != null) {
            CompatibilityInfo.Translator translator = this.mTranslator;
            bl2 = false;
            if (translator != null) {
                bl2 = true;
                layoutParams.backup();
                this.mTranslator.translateWindowLayout(layoutParams);
            }
        }
        if (layoutParams != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        int n2 = sWindowSession.relayout(this.mWindow, layoutParams, (int)(0.5f + f * (float)this.mView.mMeasuredWidth), (int)(0.5f + f * (float)this.mView.mMeasuredHeight), n, bl, this.mWinFrame, this.mPendingContentInsets, this.mPendingVisibleInsets, this.mPendingConfiguration, this.mSurface);
        if (bl2) {
            layoutParams.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWinFrame(this.mWinFrame);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingContentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingVisibleInsets);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendAccessibilityEvents() {
        View view;
        block3: {
            block2: {
                if (!AccessibilityManager.getInstance((Context)this.mView.getContext()).isEnabled()) break block2;
                this.mView.sendAccessibilityEvent(32);
                view = this.mView.findFocus();
                if (view != null && view != this.mView) break block3;
            }
            return;
        }
        view.sendAccessibilityEvent(8);
    }

    private void startInputEvent(Runnable runnable) {
        if (this.mFinishedCallback != null) {
            Slog.w(TAG, "Received a new input event from the input queue but there is already an unfinished input event in progress.");
        }
        this.mFinishedCallback = runnable;
    }

    @Override
    public void bringChildToFront(View view) {
    }

    void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    @Override
    public void childDrawableStateChanged(View view) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void clearChildFocus(View view) {
        this.checkThread();
        View view2 = this.mFocusedView;
        this.mRealFocusedView = null;
        this.mFocusedView = null;
        if (this.mView != null && !this.mView.hasFocus()) {
            if (this.mView.requestFocus(2)) return;
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view2, null);
            return;
        }
        if (view2 == null) return;
        this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(view2, null);
    }

    @Override
    public void createContextMenu(ContextMenu contextMenu) {
    }

    public void debug() {
        this.mView.debug();
    }

    public void die(boolean bl) {
        if (bl) {
            this.doDie();
            return;
        }
        this.sendEmptyMessage(1001);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchAppVisibility(boolean bl) {
        Message message = this.obtainMessage(1008);
        int n = bl ? 1 : 0;
        message.arg1 = n;
        this.sendMessage(message);
    }

    public void dispatchCloseSystemDialogs(String string2) {
        Message message = Message.obtain();
        message.what = 1014;
        message.obj = string2;
        this.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchDetachedFromWindow() {
        if (this.mView != null) {
            this.mView.dispatchDetachedFromWindow();
        }
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mAttachInfo.mSurface = null;
        if (this.mUseGL) {
            this.destroyGL();
        }
        this.mSurface.release();
        if (this.mInputChannel != null) {
            if (this.mInputQueueCallback != null) {
                this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
                this.mInputQueueCallback = null;
            } else {
                InputQueue.unregisterInputChannel((InputChannel)this.mInputChannel);
            }
        }
        try {
            sWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {}
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchFinishedEvent(int n, boolean bl) {
        Message message = this.obtainMessage(1010);
        message.arg1 = n;
        int n2 = bl ? 1 : 0;
        message.arg2 = n2;
        this.sendMessage(message);
    }

    public void dispatchGetNewSurface() {
        this.sendMessage(this.obtainMessage(1009));
    }

    public void dispatchKey(KeyEvent keyEvent) {
        this.dispatchKey(keyEvent, false);
    }

    public void dispatchMotion(MotionEvent motionEvent) {
        this.dispatchMotion(motionEvent, false);
    }

    public void dispatchPointer(MotionEvent motionEvent) {
        this.dispatchPointer(motionEvent, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchResized(int n, int n2, Rect rect, Rect rect2, boolean bl, Configuration configuration) {
        int n3 = bl ? 1003 : 1002;
        Message message = this.obtainMessage(n3);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(rect);
            this.mTranslator.translateRectInScreenToAppWindow(rect2);
            n = (int)((float)n * this.mTranslator.applicationInvertedScale);
            n2 = (int)((float)n2 * this.mTranslator.applicationInvertedScale);
        }
        message.arg1 = n;
        message.arg2 = n2;
        ResizedInfo resizedInfo = new ResizedInfo();
        resizedInfo.coveredInsets = new Rect(rect);
        resizedInfo.visibleInsets = new Rect(rect2);
        resizedInfo.newConfig = configuration;
        message.obj = resizedInfo;
        this.sendMessage(message);
    }

    public void dispatchTrackball(MotionEvent motionEvent) {
        this.dispatchTrackball(motionEvent, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doDie() {
        this.checkThread();
        synchronized (this) {
            if (this.mAdded && !this.mFirst) {
                int n = this.mView.getVisibility();
                boolean bl = this.mViewVisibility != n;
                boolean bl2 = this.mWindowAttributesChanged;
                if (bl2 || bl) {
                    try {
                        if ((2 & this.relayoutWindow(this.mWindowAttributes, n, false)) != 0) {
                            sWindowSession.finishDrawing(this.mWindow);
                        }
                    }
                    catch (RemoteException remoteException) {}
                }
                this.mSurface.release();
            }
            if (this.mAdded) {
                this.mAdded = false;
                this.dispatchDetachedFromWindow();
            }
            return;
        }
    }

    int enqueuePendingEvent(Object object, boolean bl) {
        int n = 1 + this.mPendingEventSeq;
        if (n < 0) {
            n = 0;
        }
        this.mPendingEventSeq = n;
        this.mPendingEvents.put(n, object);
        if (bl) {
            return n;
        }
        return -n;
    }

    boolean ensureTouchMode(boolean bl) {
        if (this.mAttachInfo.mInTouchMode == bl) {
            return false;
        }
        try {
            sWindowSession.setInTouchMode(bl);
            return this.ensureTouchModeLocally(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @Override
    public View focusSearch(View view, int n) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, view, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void focusableViewAvailable(View view) {
        this.checkThread();
        if (this.mView != null && !this.mView.hasFocus()) {
            view.requestFocus();
            return;
        }
        this.mFocusedView = this.mView.findFocus();
        if (!(this.mFocusedView instanceof ViewGroup)) return;
        if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) return;
        boolean bl = true;
        if (!bl) return;
        if (!ViewRoot.isViewDescendantOf(view, this.mFocusedView)) return;
        view.requestFocus();
    }

    @Override
    public boolean getChildVisibleRect(View view, Rect rect, Point point) {
        if (view != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return rect.intersect(0, 0, this.mWidth, this.mHeight);
    }

    int getHostVisibility() {
        if (this.mAppVisible) {
            return this.mView.getVisibility();
        }
        return 8;
    }

    final WindowLeaked getLocation() {
        return this.mLocation;
    }

    @Override
    public ViewParent getParent() {
        return null;
    }

    public View getView() {
        return this.mView;
    }

    protected Rect getWindowFrame() {
        return this.mWinFrame;
    }

    void handleAppVisibility(boolean bl) {
        if (this.mAppVisible != bl) {
            this.mAppVisible = bl;
            this.scheduleTraversals();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleFinishedEvent(int n, boolean bl) {
        boolean bl2;
        KeyEvent keyEvent;
        block5: {
            block4: {
                keyEvent = (KeyEvent)this.retrievePendingEvent(n);
                if (keyEvent == null) break block4;
                bl2 = n >= 0;
                if (bl) break block5;
                this.deliverKeyEventToViewHierarchy(keyEvent, bl2);
            }
            return;
        }
        if (bl2) {
            this.finishInputEvent();
            return;
        }
        Log.w(TAG, "handleFinishedEvent(seq=" + n + " handled=" + bl + " ev=" + keyEvent + ") neither delivering nor finishing key");
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                ((View)message.obj).invalidate();
                return;
            }
            case 2: {
                View.AttachInfo.InvalidateInfo invalidateInfo = (View.AttachInfo.InvalidateInfo)message.obj;
                invalidateInfo.target.invalidate(invalidateInfo.left, invalidateInfo.top, invalidateInfo.right, invalidateInfo.bottom);
                invalidateInfo.release();
                return;
            }
            case 1000: {
                if (this.mProfile) {
                    Debug.startMethodTracing(TAG);
                }
                this.performTraversals();
                if (!this.mProfile) return;
                Debug.stopMethodTracing();
                this.mProfile = false;
                return;
            }
            case 1010: {
                int n = message.arg1;
                boolean bl = message.arg2 != 0;
                this.handleFinishedEvent(n, bl);
                return;
            }
            case 1005: {
                KeyEvent keyEvent = (KeyEvent)message.obj;
                boolean bl = message.arg1 != 0;
                this.deliverKeyEvent(keyEvent, bl);
                return;
            }
            case 1006: {
                MotionEvent motionEvent = (MotionEvent)message.obj;
                try {
                    this.deliverPointerEvent(motionEvent);
                    return;
                }
                finally {
                    motionEvent.recycle();
                    if (message.arg1 == 0) return;
                    this.finishInputEvent();
                }
            }
            case 1007: {
                MotionEvent motionEvent = (MotionEvent)message.obj;
                try {
                    this.deliverTrackballEvent(motionEvent);
                    return;
                }
                finally {
                    motionEvent.recycle();
                    if (message.arg1 == 0) return;
                    this.finishInputEvent();
                }
            }
            case 1008: {
                boolean bl = message.arg1 != 0;
                this.handleAppVisibility(bl);
                return;
            }
            case 1009: {
                this.handleGetNewSurface();
                return;
            }
            case 1002: {
                ResizedInfo resizedInfo = (ResizedInfo)message.obj;
                if (this.mWinFrame.width() == message.arg1 && this.mWinFrame.height() == message.arg2 && this.mPendingContentInsets.equals(resizedInfo.coveredInsets) && this.mPendingVisibleInsets.equals(resizedInfo.visibleInsets)) {
                    if (((ResizedInfo)message.obj).newConfig == null) return;
                }
            }
            case 1003: {
                if (!this.mAdded) return;
                Configuration configuration = ((ResizedInfo)message.obj).newConfig;
                if (configuration != null) {
                    this.updateConfiguration(configuration, false);
                }
                this.mWinFrame.left = 0;
                this.mWinFrame.right = message.arg1;
                this.mWinFrame.top = 0;
                this.mWinFrame.bottom = message.arg2;
                this.mPendingContentInsets.set(((ResizedInfo)message.obj).coveredInsets);
                this.mPendingVisibleInsets.set(((ResizedInfo)message.obj).visibleInsets);
                if (message.what == 1003) {
                    this.mReportNextDraw = true;
                }
                if (this.mView != null) {
                    ViewRoot.forceLayout(this.mView);
                }
                this.requestLayout();
                return;
            }
            case 1004: {
                if (!this.mAdded) return;
                boolean bl = message.arg1 != 0;
                this.mAttachInfo.mHasWindowFocus = bl;
                if (bl) {
                    boolean bl2 = message.arg2 != 0;
                    this.ensureTouchModeLocally(bl2);
                    if (this.mGlWanted) {
                        this.checkEglErrors();
                        if (this.mGlWanted && !this.mUseGL) {
                            this.initializeGL();
                            if (this.mGlCanvas != null) {
                                float f = this.mAttachInfo.mApplicationScale;
                                this.mGlCanvas.setViewport((int)(0.5f + f * (float)this.mWidth), (int)(0.5f + f * (float)this.mHeight));
                            }
                        }
                    }
                }
                this.mLastWasImTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags);
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (this.mView != null) {
                    if (bl && inputMethodManager != null && this.mLastWasImTarget) {
                        inputMethodManager.startGettingWindowFocus(this.mView);
                    }
                    this.mAttachInfo.mKeyDispatchState.reset();
                    this.mView.dispatchWindowFocusChanged(bl);
                }
                if (bl) {
                    if (inputMethodManager != null && this.mLastWasImTarget) {
                        View view = this.mView;
                        View view2 = this.mView.findFocus();
                        int n = this.mWindowAttributes.softInputMode;
                        boolean bl3 = !this.mHasHadWindowFocus;
                        inputMethodManager.onWindowFocus(view, view2, n, bl3, this.mWindowAttributes.flags);
                    }
                    WindowManager.LayoutParams layoutParams = this.mWindowAttributes;
                    layoutParams.softInputMode = 0xFFFFFEFF & layoutParams.softInputMode;
                    WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)this.mView.getLayoutParams();
                    layoutParams2.softInputMode = 0xFFFFFEFF & layoutParams2.softInputMode;
                    this.mHasHadWindowFocus = true;
                }
                if (!bl) return;
                if (this.mView == null) return;
                this.sendAccessibilityEvents();
                return;
            }
            case 1001: {
                this.doDie();
                return;
            }
            case 1011: {
                KeyEvent keyEvent = (KeyEvent)message.obj;
                if ((8 & keyEvent.getFlags()) != 0) {
                    KeyEvent.changeFlags(keyEvent, 0xFFFFFFF7 & keyEvent.getFlags());
                }
                this.deliverKeyEventToViewHierarchy((KeyEvent)message.obj, false);
                return;
            }
            case 1012: {
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager == null) return;
                inputMethodManager.reportFinishInputConnection((InputConnection)message.obj);
                return;
            }
            case 1013: {
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager == null) return;
                inputMethodManager.checkFocus();
                return;
            }
            case 1014: 
        }
        if (this.mView == null) return;
        this.mView.onCloseSystemDialogs((String)message.obj);
    }

    @Override
    public void invalidateChild(View view, Rect rect) {
        this.checkThread();
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(rect);
            rect = this.mTempRect;
            if (this.mCurScrollY != 0) {
                rect.offset(0, -this.mCurScrollY);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(rect);
            }
            if (this.mAttachInfo.mScalingRequired) {
                rect.inset(-1, -1);
            }
        }
        this.mDirty.union(rect);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    @Override
    public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
        this.invalidateChild(null, rect);
        return null;
    }

    @Override
    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    @Override
    public boolean performHapticFeedback(int n, boolean bl) {
        try {
            boolean bl2 = sWindowSession.performHapticFeedback(this.mWindow, n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void playSoundEffect(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 119->154)] java.lang.IllegalStateException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void profile() {
        this.mProfile = true;
    }

    @Override
    public void recomputeViewAttributes(View view) {
        this.checkThread();
        if (this.mView == view) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        this.checkThread();
        if (this.mFocusedView != view2) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(this.mFocusedView, view2);
            this.scheduleTraversals();
        }
        this.mRealFocusedView = view2;
        this.mFocusedView = view2;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return this.scrollToRectOrFocus(rect, bl);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
    }

    @Override
    public void requestLayout() {
        this.checkThread();
        this.mLayoutRequested = true;
        this.scheduleTraversals();
    }

    @Override
    public void requestTransparentRegion(View view) {
        this.checkThread();
        if (this.mView == view) {
            View view2 = this.mView;
            view2.mPrivateFlags = 0x200 | view2.mPrivateFlags;
            this.mWindowAttributesChanged = true;
            this.requestLayout();
        }
    }

    Object retrievePendingEvent(int n) {
        Object object;
        if (n < 0) {
            n = -n;
        }
        if ((object = this.mPendingEvents.get(n)) != null) {
            this.mPendingEvents.remove(n);
        }
        return object;
    }

    public void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.sendEmptyMessage(1000);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean scrollToRectOrFocus(Rect rect, boolean bl) {
        int n;
        boolean bl2;
        block20: {
            View view;
            Rect rect2;
            block21: {
                block19: {
                    View.AttachInfo attachInfo = this.mAttachInfo;
                    Rect rect3 = attachInfo.mContentInsets;
                    rect2 = attachInfo.mVisibleInsets;
                    if (rect2.left > rect3.left || rect2.top > rect3.top || rect2.right > rect3.right) break block19;
                    int n2 = rect2.bottom;
                    int n3 = rect3.bottom;
                    bl2 = false;
                    n = 0;
                    if (n2 <= n3) break block20;
                }
                n = this.mScrollY;
                view = this.mRealFocusedView;
                if (view == null || view.mAttachInfo != this.mAttachInfo) {
                    this.mRealFocusedView = null;
                    return false;
                }
                if (view != this.mLastScrolledFocus) {
                    rect = null;
                }
                if (view != this.mLastScrolledFocus || this.mScrollMayChange) break block21;
                bl2 = false;
                if (rect == null) break block20;
            }
            bl2 = false;
            if (view != null) {
                this.mLastScrolledFocus = view;
                this.mScrollMayChange = false;
                boolean bl3 = view.getGlobalVisibleRect(this.mVisRect, null);
                bl2 = false;
                if (bl3) {
                    if (rect == null) {
                        view.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(view, this.mTempRect);
                        }
                    } else {
                        this.mTempRect.set(rect);
                    }
                    boolean bl4 = this.mTempRect.intersect(this.mVisRect);
                    bl2 = false;
                    if (bl4) {
                        if (this.mTempRect.height() <= this.mView.getHeight() - rect2.top - rect2.bottom) {
                            if (this.mTempRect.top - n < rect2.top) {
                                n -= rect2.top - (this.mTempRect.top - n);
                            } else if (this.mTempRect.bottom - n > this.mView.getHeight() - rect2.bottom) {
                                n += this.mTempRect.bottom - n - (this.mView.getHeight() - rect2.bottom);
                            }
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (n != this.mScrollY) {
            if (!bl) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, n - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = n;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLayoutParams(WindowManager.LayoutParams layoutParams, boolean bl) {
        synchronized (this) {
            int n = this.mWindowAttributes.softInputMode;
            int n2 = 0x20000000 & this.mWindowAttributes.flags;
            this.mWindowAttributes.copyFrom(layoutParams);
            WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
            layoutParams2.flags = n2 | layoutParams2.flags;
            if (bl) {
                this.mSoftInputMode = layoutParams.softInputMode;
                this.requestLayout();
            }
            if ((0xF0 & layoutParams.softInputMode) == 0) {
                this.mWindowAttributes.softInputMode = 0xFFFFFF0F & this.mWindowAttributes.softInputMode | n & 0xF0;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setView(View view, WindowManager.LayoutParams layoutParams, View view2) {
        synchronized (this) {
            if (this.mView == null) {
                int n;
                block32: {
                    this.mView = view;
                    this.mWindowAttributes.copyFrom(layoutParams);
                    WindowManager.LayoutParams layoutParams2 = this.mWindowAttributes;
                    if (view instanceof RootViewSurfaceTaker) {
                        this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                        if (this.mSurfaceHolderCallback != null) {
                            this.mSurfaceHolder = new TakenSurfaceHolder();
                            this.mSurfaceHolder.setFormat(0);
                        }
                    }
                    Resources resources = this.mView.getContext().getResources();
                    CompatibilityInfo compatibilityInfo = resources.getCompatibilityInfo();
                    this.mTranslator = compatibilityInfo.getTranslator();
                    if (this.mTranslator != null || !compatibilityInfo.supportsScreen()) {
                        this.mSurface.setCompatibleDisplayMetrics(resources.getDisplayMetrics(), this.mTranslator);
                    }
                    CompatibilityInfo.Translator translator = this.mTranslator;
                    boolean bl = false;
                    if (translator != null) {
                        bl = true;
                        layoutParams2.backup();
                        this.mTranslator.translateWindowLayout(layoutParams2);
                    }
                    if (!compatibilityInfo.supportsScreen()) {
                        layoutParams2.flags = 0x20000000 | layoutParams2.flags;
                    }
                    this.mSoftInputMode = layoutParams2.softInputMode;
                    this.mWindowAttributesChanged = true;
                    this.mAttachInfo.mRootView = view;
                    View.AttachInfo attachInfo = this.mAttachInfo;
                    boolean bl2 = this.mTranslator != null;
                    attachInfo.mScalingRequired = bl2;
                    View.AttachInfo attachInfo2 = this.mAttachInfo;
                    float f = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                    attachInfo2.mApplicationScale = f;
                    if (view2 != null) {
                        this.mAttachInfo.mPanelParentWindowToken = view2.getApplicationWindowToken();
                    }
                    this.mAdded = true;
                    this.requestLayout();
                    this.mInputChannel = new InputChannel();
                    n = sWindowSession.add(this.mWindow, this.mWindowAttributes, this.getHostVisibility(), this.mAttachInfo.mContentInsets, this.mInputChannel);
                    if (this.mTranslator != null) {
                        this.mTranslator.translateRectInScreenToAppWindow(this.mAttachInfo.mContentInsets);
                    }
                    this.mPendingContentInsets.set(this.mAttachInfo.mContentInsets);
                    this.mPendingVisibleInsets.set(0, 0, 0, 0);
                    if (n >= 0) break block32;
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.unscheduleTraversals();
                    switch (n) {
                        default: {
                            throw new RuntimeException("Unable to add window -- unknown error code " + n);
                        }
                        catch (RemoteException remoteException) {
                            this.mAdded = false;
                            this.mView = null;
                            this.mAttachInfo.mRootView = null;
                            this.mInputChannel = null;
                            this.unscheduleTraversals();
                            throw new RuntimeException("Adding window failed", remoteException);
                        }
                        finally {
                            if (bl) {
                                layoutParams2.restore();
                            }
                        }
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + layoutParams2.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + layoutParams2.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + layoutParams2.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of this type already exists");
                        }
                        case -8: 
                    }
                    throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for this window type");
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputQueueCallback != null) {
                    this.mInputQueue = new InputQueue(this.mInputChannel);
                    this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                } else {
                    InputQueue.registerInputChannel((InputChannel)this.mInputChannel, (InputHandler)this.mInputHandler, (MessageQueue)Looper.myQueue());
                }
                view.assignParent(this);
                boolean bl = (n & 1) != 0;
                this.mAddedTouchMode = bl;
                boolean bl3 = (n & 2) != 0;
                this.mAppVisible = bl3;
            }
            return;
        }
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return false;
    }

    public void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.removeMessages(1000);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateConfiguration(Configuration configuration, boolean bl) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        // MONITORENTER : arrayList
        for (int i = sConfigCallbacks.size() - 1; i >= 0; --i) {
            sConfigCallbacks.get(i).onConfigurationChanged(configuration);
        }
        // MONITOREXIT : arrayList
        if (this.mView == null) return;
        if (this.mView != null) {
            configuration = this.mView.getResources().getConfiguration();
        }
        if (!bl) {
            if (this.mLastConfiguration.diff(configuration) == 0) return;
        }
        this.mLastConfiguration.setTo(configuration);
        this.mView.dispatchConfigurationChanged(configuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void windowFocusChanged(boolean bl, boolean bl2) {
        Message message = Message.obtain();
        message.what = 1004;
        int n = bl ? 1 : 0;
        message.arg1 = n;
        int n2 = bl2 ? 1 : 0;
        message.arg2 = n2;
        this.sendMessage(message);
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String string2) {
            super(string2);
        }
    }

    static class InputMethodCallback
    extends IInputMethodCallback.Stub {
        private WeakReference<ViewRoot> mViewRoot;

        public InputMethodCallback(ViewRoot viewRoot) {
            this.mViewRoot = new WeakReference<ViewRoot>(viewRoot);
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchFinishedEvent(n, bl);
            }
        }

        @Override
        public void sessionCreated(IInputMethodSession iInputMethodSession) throws RemoteException {
        }
    }

    class ResizedInfo {
        Rect coveredInsets;
        Configuration newConfig;
        Rect visibleInsets;

        ResizedInfo() {
        }
    }

    static final class RunQueue {
        private final ArrayList<HandlerAction> mActions = new ArrayList();

        RunQueue() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                int n = arrayList2.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        arrayList2.clear();
                        return;
                    }
                    HandlerAction handlerAction = arrayList2.get(n2);
                    handler.postDelayed(handlerAction.action, handlerAction.delay);
                    ++n2;
                }
            }
        }

        void post(Runnable runnable) {
            this.postDelayed(runnable, 0L);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void postDelayed(Runnable runnable, long l) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            handlerAction.delay = l;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                this.mActions.add(handlerAction);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeCallbacks(Runnable runnable) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = runnable;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> arrayList2 = this.mActions;
                while (arrayList2.remove(handlerAction)) {
                }
                return;
            }
        }

        private static class HandlerAction {
            Runnable action;
            long delay;

            private HandlerAction() {
            }

            /*
             * Enabled aggressive block sorting
             */
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                HandlerAction handlerAction = (HandlerAction)object;
                return !(this.action != null ? !this.action.equals(handlerAction.action) : handlerAction.action != null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int hashCode() {
                int n;
                if (this.action != null) {
                    n = this.action.hashCode();
                    return n * 31 + (int)(this.delay ^ this.delay >>> 32);
                }
                n = 0;
                return n * 31 + (int)(this.delay ^ this.delay >>> 32);
            }
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        @Override
        public boolean isCreating() {
            return ViewRoot.this.mIsCreating;
        }

        @Override
        public boolean onAllowLockCanvas() {
            return ViewRoot.this.mDrawingAllowed;
        }

        @Override
        public void onRelayoutContainer() {
        }

        @Override
        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        @Override
        public void setFixedSize(int n, int n2) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        @Override
        public void setFormat(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceFormat(n);
        }

        @Override
        public void setKeepScreenOn(boolean bl) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceKeepScreenOn(bl);
        }

        @Override
        public void setType(int n) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceType(n);
        }
    }

    static final class TrackballAxis {
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        static final long FAST_MOVE_TIME = 150L;
        static final float MAX_ACCELERATION = 20.0f;
        float absPosition;
        float acceleration = 1.0f;
        int dir;
        long lastMoveTime = 0L;
        int nonAccelMovement;
        float position;
        int step;

        TrackballAxis() {
        }

        /*
         * Enabled aggressive block sorting
         */
        float collect(float f, long l, String string2) {
            float f2;
            long l2;
            if (f > 0.0f) {
                l2 = (long)(150.0f * f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (f < 0.0f) {
                l2 = (long)(150.0f * -f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                l2 = 0L;
            }
            if (l2 > 0L) {
                long l3 = l - this.lastMoveTime;
                this.lastMoveTime = l;
                float f3 = this.acceleration;
                if (l3 < l2) {
                    float f4 = 0.025f * (float)(l2 - l3);
                    if (f4 > 1.0f) {
                        f3 *= f4;
                    }
                    float f5 = f3 < 20.0f ? f3 : 20.0f;
                    this.acceleration = f5;
                } else {
                    float f6 = 0.025f * (float)(l3 - l2);
                    if (f6 > 1.0f) {
                        f3 /= f6;
                    }
                    float f7 = f3 > 1.0f ? f3 : 1.0f;
                    this.acceleration = f7;
                }
            }
            this.position = f + this.position;
            this.absPosition = f2 = Math.abs(this.position);
            return f2;
        }

        /*
         * Enabled aggressive block sorting
         */
        int generate(float f) {
            int n = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int n2;
                block6: {
                    block7: {
                        n2 = this.position >= 0.0f ? 1 : -1;
                        switch (this.step) {
                            default: {
                                if (this.absPosition < 1.0f) {
                                    return n;
                                }
                                break block6;
                            }
                            case 0: {
                                if (this.absPosition < f) return n;
                                n += n2;
                                this.nonAccelMovement = n2 + this.nonAccelMovement;
                                this.step = 1;
                                continue block4;
                            }
                            case 1: {
                                if (!(this.absPosition < 2.0f)) break block7;
                            }
                        }
                        return n;
                    }
                    n += n2;
                    this.nonAccelMovement = n2 + this.nonAccelMovement;
                    float f2 = this.position;
                    float f3 = n2 > 0 ? -2.0f : 2.0f;
                    this.position = f2 + f3;
                    this.absPosition = Math.abs(this.position);
                    this.step = 2;
                    continue;
                }
                n += n2;
                float f4 = this.position;
                float f5 = n2 >= 0 ? -1.0f : 1.0f;
                this.position = f4 + f5;
                this.absPosition = Math.abs(this.position);
                float f6 = 1.1f * this.acceleration;
                float f7 = f6 < 20.0f ? f6 : this.acceleration;
                this.acceleration = f7;
            }
        }

        void reset(int n) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = n;
            this.dir = 0;
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRoot> mViewRoot;

        public W(ViewRoot viewRoot, Context context) {
            this.mViewRoot = new WeakReference<ViewRoot>(viewRoot);
        }

        private static int checkCallingPermission(String string2) {
            if (!Process.supportsProcesses()) {
                return 0;
            }
            try {
                int n = ActivityManagerNative.getDefault().checkPermission(string2, Binder.getCallingPid(), Binder.getCallingUid());
                return n;
            }
            catch (RemoteException remoteException) {
                return -1;
            }
        }

        @Override
        public void closeSystemDialogs(String string2) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchCloseSystemDialogs(string2);
            }
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchAppVisibility(bl);
            }
        }

        @Override
        public void dispatchGetNewSurface() {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchGetNewSurface();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            if (!bl) return;
            try {
                sWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
            if (!bl) return;
            try {
                sWindowSession.wallpaperOffsetsComplete(this.asBinder());
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void executeCommand(String var1_1, String var2_2, ParcelFileDescriptor var3_3) {
            var4_4 = (ViewRoot)this.mViewRoot.get();
            if (var4_4 == null || (var5_5 = var4_4.mView) == null) ** GOTO lbl13
            if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
            var6_6 = null;
            var7_7 = new ParcelFileDescriptor.AutoCloseOutputStream(var3_3);
            ViewDebug.dispatchCommand((View)var5_5, (String)var1_1, (String)var2_2, (OutputStream)var7_7);
            if (var7_7 == null) ** GOTO lbl13
            var7_7.close();
lbl13:
            // 4 sources

            return;
            catch (IOException var13_8) {
                var9_9 = var13_8;
lbl17:
                // 2 sources

                while (true) {
                    var9_9.printStackTrace();
                    if (var6_6 == null) ** continue;
                    try {
                        var6_6.close();
                        return;
                    }
                    catch (IOException var12_10) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var12_11.printStackTrace();
                            return;
                        }
                    }
                    catch (Throwable var10_13) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var6_6 != null) {
                                var6_6.close();
                            }
lbl33:
                            // 4 sources

                            throw var10_14;
                            catch (IOException var11_16) {
                                var11_16.printStackTrace();
                                ** continue;
                            }
                            break;
                        }
                    }
                    break;
                }
            }
            catch (IOException var12_12) {
                ** continue;
            }
            catch (Throwable var10_15) {
                var6_6 = var7_7;
                ** continue;
            }
            catch (IOException var8_17) {
                var9_9 = var8_17;
                var6_6 = var7_7;
                ** continue;
            }
        }

        @Override
        public void resized(int n, int n2, Rect rect, Rect rect2, boolean bl, Configuration configuration) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchResized(n, n2, rect, rect2, bl, configuration);
            }
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.windowFocusChanged(bl, bl2);
            }
        }
    }
}

