/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.RingtoneManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class VolumePanel
extends Handler {
    private static final int ALARM_VOLUME_TEXT = 17040141;
    private static final int BEEP_DURATION = 150;
    private static final int BLUETOOTH_INCALL_VOLUME_TEXT = 17040140;
    private static final int FREE_DELAY = 10000;
    private static final int INCALL_VOLUME_TEXT = 17040139;
    private static boolean LOGD = false;
    private static final int MAX_VOLUME = 100;
    private static final int MSG_FREE_RESOURCES = 1;
    private static final int MSG_PLAY_SOUND = 2;
    private static final int MSG_STOP_SOUNDS = 3;
    private static final int MSG_VIBRATE = 4;
    private static final int MSG_VOLUME_CHANGED = 0;
    private static final int MUSIC_VOLUME_TEXT = 17040136;
    private static final int NOTIFICATION_VOLUME_TEXT = 17040142;
    public static final int PLAY_SOUND_DELAY = 300;
    private static final int RINGTONE_VOLUME_TEXT = 17040135;
    private static final String TAG = "VolumePanel";
    private static final int UNKNOWN_VOLUME_TEXT = 17040143;
    public static final int VIBRATE_DELAY = 300;
    private static final int VIBRATE_DURATION = 300;
    private final TextView mAdditionalMessage;
    private AudioManager mAudioManager;
    protected AudioService mAudioService;
    protected Context mContext;
    private final ImageView mLargeStreamIcon;
    private final ProgressBar mLevel;
    private final TextView mMessage;
    private boolean mRingIsSilent;
    private final ImageView mSmallStreamIcon;
    private final Toast mToast;
    private ToneGenerator[] mToneGenerators;
    private Vibrator mVibrator;
    private final View mView;

    static {
        LOGD = false;
    }

    public VolumePanel(Context context, AudioService audioService) {
        View view;
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = audioService;
        this.mToast = new Toast(context);
        this.mView = view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367147, null);
        this.mMessage = (TextView)view.findViewById(16908299);
        this.mAdditionalMessage = (TextView)view.findViewById(16908842);
        this.mSmallStreamIcon = (ImageView)view.findViewById(16908841);
        this.mLargeStreamIcon = (ImageView)view.findViewById(16908843);
        this.mLevel = (ProgressBar)view.findViewById(16908844);
        this.mToneGenerators = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mVibrator = new Vibrator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ToneGenerator getOrCreateToneGenerator(int n) {
        synchronized (this) {
            ToneGenerator toneGenerator;
            if (this.mToneGenerators[n] != null) return this.mToneGenerators[n];
            ToneGenerator[] toneGeneratorArray = this.mToneGenerators;
            toneGeneratorArray[n] = toneGenerator = new ToneGenerator(n, 100);
            return toneGenerator;
        }
    }

    private void setLargeIcon(int n) {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        this.mLargeStreamIcon.setImageResource(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRingerIcon() {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        int n = this.mAudioService.getRingerMode();
        if (LOGD) {
            Log.d(TAG, "setRingerIcon(), ringerMode: " + n);
        }
        int n2 = n == 0 ? 17301968 : (n == 1 ? 17301963 : 17301965);
        this.mLargeStreamIcon.setImageResource(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSmallIcon(int n) {
        this.mLargeStreamIcon.setVisibility(8);
        this.mSmallStreamIcon.setVisibility(0);
        ImageView imageView = this.mSmallStreamIcon;
        int n2 = n == 0 ? 17301969 : 17301970;
        imageView.setImageResource(n2);
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 0: {
                this.onVolumeChanged(message.arg1, message.arg2);
                return;
            }
            case 1: {
                this.onFreeResources();
                return;
            }
            case 3: {
                this.onStopSounds();
                return;
            }
            case 2: {
                this.onPlaySound(message.arg1, message.arg2);
                return;
            }
            case 4: 
        }
        this.onVibrate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onFreeResources() {
        this.mSmallStreamIcon.setImageDrawable(null);
        this.mLargeStreamIcon.setImageDrawable(null);
        synchronized (this) {
            int n = this.mToneGenerators.length - 1;
            while (n >= 0) {
                if (this.mToneGenerators[n] != null) {
                    this.mToneGenerators[n].release();
                }
                this.mToneGenerators[n] = null;
                --n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onPlaySound(int n, int n2) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        synchronized (this) {
            this.getOrCreateToneGenerator(n).startTone(24);
        }
        this.sendMessageDelayed(this.obtainMessage(3), 150L);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onShowVolumeChanged(int n, int n2) {
        int n3 = this.mAudioService.getStreamVolume(n);
        int n4 = 17040143;
        this.mRingIsSilent = false;
        if (LOGD) {
            Log.d(TAG, "onShowVolumeChanged(streamType: " + n + ", flags: " + n2 + "), index: " + n3);
        }
        int n5 = this.mAudioService.getStreamMaxVolume(n);
        int n6 = 0;
        switch (n) {
            case 2: {
                this.setRingerIcon();
                n4 = 17040135;
                Uri uri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 1);
                n6 = 0;
                if (uri != null) break;
                n6 = 17040138;
                this.mRingIsSilent = true;
                break;
            }
            case 3: {
                n4 = 17040136;
                if (this.mAudioManager.isBluetoothA2dpOn()) {
                    n6 = 17040137;
                    this.setLargeIcon(17301966);
                    break;
                }
                this.setSmallIcon(n3);
                n6 = 0;
                break;
            }
            case 0: {
                ++n5;
                n4 = 17040139;
                this.setSmallIcon(++n3);
                n6 = 0;
                break;
            }
            case 4: {
                n4 = 17040141;
                this.setSmallIcon(n3);
                n6 = 0;
                break;
            }
            case 5: {
                n4 = 17040142;
                this.setSmallIcon(n3);
                Uri uri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 2);
                n6 = 0;
                if (uri != null) break;
                n6 = 17040138;
                this.mRingIsSilent = true;
                break;
            }
            case 6: {
                ++n3;
                ++n5;
                n4 = 17040140;
                this.setLargeIcon(17301967);
                n6 = 0;
            }
        }
        String string2 = Resources.getSystem().getString(n4);
        if (!this.mMessage.getText().equals(string2)) {
            this.mMessage.setText(string2);
        }
        if (n6 == 0) {
            this.mAdditionalMessage.setVisibility(8);
        } else {
            this.mAdditionalMessage.setVisibility(0);
            this.mAdditionalMessage.setText(Resources.getSystem().getString(n6));
        }
        if (n5 != this.mLevel.getMax()) {
            this.mLevel.setMax(n5);
        }
        this.mLevel.setProgress(n3);
        this.mToast.setView(this.mView);
        this.mToast.setDuration(0);
        this.mToast.setGravity(48, 0, 0);
        this.mToast.show();
        if ((n2 & 0x10) != 0 && this.mAudioService.isStreamAffectedByRingerMode(n) && this.mAudioService.getRingerMode() == 1 && this.mAudioService.shouldVibrate(0)) {
            this.sendMessageDelayed(this.obtainMessage(4), 300L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onStopSounds() {
        synchronized (this) {
            int n = AudioSystem.getNumStreamTypes() - 1;
            while (n >= 0) {
                ToneGenerator toneGenerator = this.mToneGenerators[n];
                if (toneGenerator != null) {
                    toneGenerator.stopTone();
                }
                --n;
            }
            return;
        }
    }

    protected void onVibrate() {
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    protected void onVolumeChanged(int n, int n2) {
        if (LOGD) {
            Log.d(TAG, "onVolumeChanged(streamType: " + n + ", flags: " + n2 + ")");
        }
        if ((n2 & 1) != 0) {
            this.onShowVolumeChanged(n, n2);
        }
        if ((n2 & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, n, n2), 300L);
        }
        if ((n2 & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
    }

    public void postVolumeChanged(int n, int n2) {
        if (this.hasMessages(0)) {
            return;
        }
        this.removeMessages(1);
        this.obtainMessage(0, n, n2).sendToTarget();
    }
}

