/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

public class WindowManagerImpl
implements WindowManager {
    public static final int ADD_APP_EXITING = -4;
    public static final int ADD_BAD_APP_TOKEN = -1;
    public static final int ADD_BAD_SUBWINDOW_TOKEN = -2;
    public static final int ADD_DUPLICATE_ADD = -5;
    public static final int ADD_FLAG_APP_VISIBLE = 2;
    public static final int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static final int ADD_MULTIPLE_SINGLETON = -7;
    public static final int ADD_NOT_APP_TOKEN = -3;
    public static final int ADD_OKAY = 0;
    public static final int ADD_PERMISSION_DENIED = -8;
    public static final int ADD_STARTING_NOT_NEEDED = -6;
    public static final int RELAYOUT_FIRST_TIME = 2;
    public static final int RELAYOUT_IN_TOUCH_MODE = 1;
    private static WindowManagerImpl mWindowManager = new WindowManagerImpl();
    private WindowManager.LayoutParams[] mParams;
    private ViewRoot[] mRoots;
    private View[] mViews;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addView(View view, ViewGroup.LayoutParams layoutParams, boolean bl) {
        ViewRoot viewRoot;
        View view2;
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        synchronized (this) {
            int n;
            int n2 = this.findViewLocked(view, false);
            if (n2 >= 0) {
                if (!bl) {
                    throw new IllegalStateException("View " + view + " has already been added to the window manager.");
                }
                ViewRoot viewRoot2 = this.mRoots[n2];
                viewRoot2.mAddNesting = 1 + viewRoot2.mAddNesting;
                view.setLayoutParams(layoutParams2);
                viewRoot2.setLayoutParams(layoutParams2, true);
                return;
            }
            int n3 = layoutParams2.type;
            view2 = null;
            if (n3 >= 1000) {
                int n4 = layoutParams2.type;
                view2 = null;
                if (n4 <= 1999) {
                    int n5 = this.mViews != null ? this.mViews.length : 0;
                    view2 = null;
                    for (int i = 0; i < n5; ++i) {
                        if (this.mRoots[i].mWindow.asBinder() != layoutParams2.token) continue;
                        view2 = this.mViews[i];
                    }
                }
            }
            viewRoot = new ViewRoot(view.getContext());
            viewRoot.mAddNesting = 1;
            view.setLayoutParams(layoutParams2);
            if (this.mViews == null) {
                n = 1;
                this.mViews = new View[1];
                this.mRoots = new ViewRoot[1];
                this.mParams = new WindowManager.LayoutParams[1];
            } else {
                n = 1 + this.mViews.length;
                View[] viewArray = this.mViews;
                this.mViews = new View[n];
                System.arraycopy(viewArray, 0, this.mViews, 0, n - 1);
                ViewRoot[] viewRootArray = this.mRoots;
                this.mRoots = new ViewRoot[n];
                System.arraycopy(viewRootArray, 0, this.mRoots, 0, n - 1);
                WindowManager.LayoutParams[] layoutParamsArray = this.mParams;
                this.mParams = new WindowManager.LayoutParams[n];
                System.arraycopy(layoutParamsArray, 0, this.mParams, 0, n - 1);
            }
            int n6 = n - 1;
            this.mViews[n6] = view;
            this.mRoots[n6] = viewRoot;
            this.mParams[n6] = layoutParams2;
        }
        viewRoot.setView(view, layoutParams2, view2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findViewLocked(View view, boolean bl) {
        synchronized (this) {
            int n = this.mViews != null ? this.mViews.length : 0;
            int n2 = 0;
            while (true) {
                if (n2 < n) {
                    if (this.mViews[n2] == view) {
                        return n2;
                    }
                } else {
                    if (bl) {
                        throw new IllegalArgumentException("View not attached to window manager");
                    }
                    return -1;
                }
                ++n2;
            }
        }
    }

    public static WindowManagerImpl getDefault() {
        return mWindowManager;
    }

    private static void removeItem(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray.length > 0) {
            if (n > 0) {
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
            }
            if (n < objectArray.length) {
                System.arraycopy(objectArray2, n + 1, objectArray, n, objectArray2.length - n - 1);
            }
        }
    }

    public void addView(View view) {
        this.addView(view, new WindowManager.LayoutParams(2, 0, -1));
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.addView(view, layoutParams, false);
    }

    public void addViewNesting(View view, ViewGroup.LayoutParams layoutParams) {
        this.addView(view, layoutParams, false);
    }

    public void closeAll() {
        this.closeAll(null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeAll(IBinder iBinder, String string2, String string3) {
        synchronized (this) {
            if (this.mViews == null) {
                return;
            }
            int n = this.mViews.length;
            int n2 = 0;
            while (n2 < n) {
                if (iBinder == null || this.mParams[n2].token == iBinder) {
                    ViewRoot viewRoot = this.mRoots[n2];
                    viewRoot.mAddNesting = 1;
                    if (string2 != null) {
                        WindowLeaked windowLeaked = new WindowLeaked(string3 + " " + string2 + " has leaked window " + viewRoot.getView() + " that was originally added here");
                        windowLeaked.setStackTrace(viewRoot.getLocation().getStackTrace());
                        Log.e("WindowManager", windowLeaked.getMessage(), windowLeaked);
                    }
                    this.removeViewLocked(n2);
                    --n2;
                    --n;
                }
                ++n2;
            }
            return;
        }
    }

    void finishRemoveViewLocked(View view, int n) {
        int n2 = this.mViews.length;
        Object[] objectArray = new View[n2 - 1];
        WindowManagerImpl.removeItem(objectArray, this.mViews, n);
        this.mViews = objectArray;
        Object[] objectArray2 = new ViewRoot[n2 - 1];
        WindowManagerImpl.removeItem(objectArray2, this.mRoots, n);
        this.mRoots = objectArray2;
        Object[] objectArray3 = new WindowManager.LayoutParams[n2 - 1];
        WindowManagerImpl.removeItem(objectArray3, this.mParams, n);
        this.mParams = objectArray3;
        view.assignParent(null);
    }

    @Override
    public Display getDefaultDisplay() {
        return new Display(0);
    }

    public WindowManager.LayoutParams getRootViewLayoutParameter(View view) {
        ViewParent viewParent;
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof ViewRoot); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return null;
        }
        ViewRoot viewRoot = (ViewRoot)viewParent;
        int n = this.mRoots.length;
        for (int i = 0; i < n; ++i) {
            if (this.mRoots[i] != viewRoot) continue;
            return this.mParams[i];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeView(View view) {
        synchronized (this) {
            View view2 = this.removeViewLocked(this.findViewLocked(view, true));
            if (view2 == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewRoot is attached to " + view2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeViewImmediate(View view) {
        synchronized (this) {
            int n = this.findViewLocked(view, true);
            ViewRoot viewRoot = this.mRoots[n];
            View view2 = viewRoot.getView();
            viewRoot.mAddNesting = 0;
            viewRoot.die(true);
            this.finishRemoveViewLocked(view2, n);
            if (view2 == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewRoot is attached to " + view2);
        }
    }

    View removeViewLocked(int n) {
        ViewRoot viewRoot = this.mRoots[n];
        View view = viewRoot.getView();
        --viewRoot.mAddNesting;
        if (viewRoot.mAddNesting > 0) {
            return view;
        }
        InputMethodManager inputMethodManager = InputMethodManager.getInstance((Context)view.getContext());
        if (inputMethodManager != null) {
            inputMethodManager.windowDismissed(this.mViews[n].getWindowToken());
        }
        viewRoot.die(false);
        this.finishRemoveViewLocked(view, n);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
        view.setLayoutParams(layoutParams2);
        synchronized (this) {
            int n = this.findViewLocked(view, true);
            ViewRoot viewRoot = this.mRoots[n];
            this.mParams[n] = layoutParams2;
            viewRoot.setLayoutParams(layoutParams2, false);
            return;
        }
    }
}

