/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;

public abstract class WindowOrientationListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "WindowOrientationListener";
    private static final boolean localLOGV;
    private boolean mEnabled = false;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListenerImpl mSensorEventListener;
    private SensorManager mSensorManager;

    public WindowOrientationListener(Context context) {
        this(context, 3);
    }

    private WindowOrientationListener(Context context, int n) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = n;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        } else {
            if (!this.mEnabled) return;
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        } else {
            if (this.mEnabled) return;
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
            return;
        }
    }

    public int getCurrentRotation(int n) {
        if (this.mEnabled) {
            return this.mSensorEventListener.getCurrentRotation(n);
        }
        return n;
    }

    public abstract void onOrientationChanged(int var1);

    public void setAllow180Rotation(boolean bl) {
        if (this.mSensorEventListener != null) {
            this.mSensorEventListener.setAllow180Rotation(bl);
        }
    }

    static class SensorEventListenerImpl
    implements SensorEventListener {
        private static final float ACCELERATING_LOWPASS_ALPHA = 0.0f;
        private static final int ACCELERATING_TIME_CONSTANT_MS = 2000;
        private static final float DEFAULT_LOWPASS_ALPHA = 0.0f;
        private static final int DEFAULT_TIME_CONSTANT_MS = 100;
        private static final int[] INTERNAL_TO_SURFACE_ROTATION = new int[]{0, 1, 3, 2};
        private static final float MAX_DEVIATION_FROM_GRAVITY = 1.5f;
        private static final int MAX_TILT = 75;
        private static final int[] MAX_TRANSITION_TILT;
        private static final float MIN_ABS_ACCELERATION = 1.5f;
        private static final int PARTIAL_TILT = 50;
        private static final float RADIANS_TO_DEGREES = 57.29578f;
        private static final int[][] ROTATE_TO;
        private static final int[][] ROTATE_TO_WITH_180;
        private static final int ROTATION_0 = 0;
        private static final int ROTATION_180 = 3;
        private static final int ROTATION_270 = 2;
        private static final int ROTATION_90 = 1;
        private static final int SAMPLING_PERIOD_MS = 200;
        private static final int[] SURFACE_TO_INTERNAL_ROTATION;
        private static final int[][][] THRESHOLDS;
        private static final int[][][] THRESHOLDS_WITH_180;
        private static final float TILTED_LOWPASS_ALPHA = 0.0f;
        private static final int TILTED_TIME_CONSTANT_MS = 500;
        private static final int _DATA_X = 0;
        private static final int _DATA_Y = 1;
        private static final int _DATA_Z = 2;
        private int mAccelerationDistrust = 0;
        private boolean mAllow180Rotation = false;
        private float mOrientationAngle = 0.0f;
        private WindowOrientationListener mOrientationListener;
        private int mRotation = 0;
        private float mTiltAngle = 0.0f;
        private int mTiltDistrust = 0;

        static {
            SURFACE_TO_INTERNAL_ROTATION = new int[]{0, 1, 3, 2};
            THRESHOLDS = new int[][][]{new int[][]{{60, 180}, {180, 300}}, new int[][]{{0, 30}, {195, 315}, {315, 360}}, new int[][]{{0, 45}, {45, 165}, {330, 360}}, new int[][]{{0, 45}, {45, 135}, {135, 225}, {225, 315}, {315, 360}}};
            ROTATE_TO = new int[][]{{1, 2}, {0, 2, 0}, {0, 1, 0}, {0, 1, 0, 2, 0}};
            THRESHOLDS_WITH_180 = new int[][][]{new int[][]{{60, 165}, {165, 195}, {195, 300}}, new int[][]{{0, 30}, {165, 195}, {195, 315}, {315, 360}}, new int[][]{{0, 45}, {45, 165}, {165, 195}, {330, 360}}, new int[][]{{0, 45}, {45, 135}, {225, 315}, {315, 360}}};
            ROTATE_TO_WITH_180 = new int[][]{{1, 3, 2}, {0, 3, 1, 0}, {0, 2, 3, 0}, {0, 1, 2, 0}};
            MAX_TRANSITION_TILT = new int[]{75, 65, 65, 40};
            DEFAULT_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(100);
            TILTED_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(500);
            ACCELERATING_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(2000);
        }

        public SensorEventListenerImpl(WindowOrientationListener windowOrientationListener) {
            this.mOrientationListener = windowOrientationListener;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void calculateNewRotation(float f, float f2) {
            boolean bl = this.mAllow180Rotation;
            int[][] nArray = bl ? THRESHOLDS_WITH_180[this.mRotation] : THRESHOLDS[this.mRotation];
            int n = -1;
            int n2 = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n2 >= nArray.length) break block5;
                        if (!(f >= (float)nArray[n2][0]) || !(f < (float)nArray[n2][1])) break block6;
                        n = n2;
                    }
                    if (n != -1) break;
                    return;
                }
                ++n2;
            }
            int n3 = bl ? ROTATE_TO_WITH_180[this.mRotation][n] : ROTATE_TO[this.mRotation][n];
            if (f2 > (float)MAX_TRANSITION_TILT[n3]) {
                return;
            }
            this.mRotation = n3;
            this.mOrientationListener.onOrientationChanged(INTERNAL_TO_SURFACE_ROTATION[this.mRotation]);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkFullyTilted(float f) {
            if (f > 75.0f) {
                this.mOrientationAngle = this.mRotation == 0 ? 0.0f : (this.mRotation == 1 ? 90.0f : 270.0f);
                if (this.mTiltDistrust >= 3) return;
                this.mTiltDistrust = 3;
                return;
            }
            if (this.mTiltDistrust <= 0) return;
            --this.mTiltDistrust;
        }

        private static float computeLowpassAlpha(int n) {
            return 200.0f / (float)(n + 200);
        }

        private float computeNewOrientation(float f, float f2) {
            float f3 = 57.29578f * (float)(-Math.atan2(-f, f2));
            if (f3 < 0.0f) {
                f3 += 360.0f;
            }
            return f3;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void filterOrientation(float f, float f2) {
            float f3;
            float f4 = DEFAULT_LOWPASS_ALPHA;
            if (this.mAccelerationDistrust > 1) {
                f4 = ACCELERATING_LOWPASS_ALPHA;
            } else if (f > 50.0f || this.mAccelerationDistrust == 1) {
                f4 = TILTED_LOWPASS_ALPHA;
            }
            if ((f3 = f2 - this.mOrientationAngle) > 180.0f) {
                f2 -= 360.0f;
            } else if (f3 < -180.0f) {
                f2 += 360.0f;
            }
            this.mOrientationAngle = this.lowpassFilter(f2, this.mOrientationAngle, f4);
            if (this.mOrientationAngle > 360.0f) {
                this.mOrientationAngle -= 360.0f;
                return;
            } else {
                if (!(this.mOrientationAngle < 0.0f)) return;
                this.mOrientationAngle = 360.0f + this.mOrientationAngle;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleAccelerationDistrust(float f) {
            if (f > 1.5f) {
                if (this.mAccelerationDistrust >= 5) return;
                this.mAccelerationDistrust = 1 + this.mAccelerationDistrust;
                return;
            }
            if (this.mAccelerationDistrust <= 0) return;
            --this.mAccelerationDistrust;
        }

        private float lowpassFilter(float f, float f2, float f3) {
            return f3 * f + f2 * (1.0f - f3);
        }

        private float tiltAngle(float f, float f2) {
            return 57.29578f * (float)Math.asin(f / f2);
        }

        private float vectorMagnitude(float f, float f2, float f3) {
            return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        }

        int getCurrentRotation(int n) {
            if (this.mTiltDistrust > 0) {
                this.mRotation = SURFACE_TO_INTERNAL_ROTATION[n];
            }
            return INTERNAL_TO_SURFACE_ROTATION[this.mRotation];
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            float f;
            float f2;
            float f3;
            block5: {
                block4: {
                    f3 = sensorEvent.values[0];
                    f2 = sensorEvent.values[1];
                    float f4 = sensorEvent.values[2];
                    float f5 = this.vectorMagnitude(f3, f2, f4);
                    this.handleAccelerationDistrust(Math.abs(f5 - 9.80665f));
                    if (f5 < 1.5f) break block4;
                    float f6 = 1.0f;
                    if (this.mAccelerationDistrust > 0) {
                        f6 = ACCELERATING_LOWPASS_ALPHA;
                    }
                    this.mTiltAngle = this.lowpassFilter(this.tiltAngle(f4, f5), this.mTiltAngle, f6);
                    f = Math.abs(this.mTiltAngle);
                    this.checkFullyTilted(f);
                    if (this.mTiltDistrust <= 0) break block5;
                }
                return;
            }
            this.filterOrientation(f, this.computeNewOrientation(f3, f2));
            this.calculateNewRotation(this.mOrientationAngle, f);
        }

        void setAllow180Rotation(boolean bl) {
            this.mAllow180Rotation = bl;
        }
    }
}

