/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.net.http.SslCertificate;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.TypedValue;
import android.view.ViewRoot;
import android.view.WindowManager;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieSyncManager;
import android.webkit.FrameLoader;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.LoadListener;
import android.webkit.PerfChecker;
import android.webkit.PluginManager;
import android.webkit.URLUtil;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewWorker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class BrowserFrame
extends Handler {
    private static final int DRAWABLEDIR = 3;
    private static final int FILE_UPLOAD_LABEL = 4;
    static final int FRAME_COMPLETED = 1001;
    static final int FRAME_LOADTYPE_BACK = 1;
    static final int FRAME_LOADTYPE_FORWARD = 2;
    static final int FRAME_LOADTYPE_INDEXEDBACKFORWARD = 3;
    static final int FRAME_LOADTYPE_REDIRECT = 7;
    static final int FRAME_LOADTYPE_RELOAD = 4;
    static final int FRAME_LOADTYPE_RELOADALLOWINGSTALEDATA = 5;
    static final int FRAME_LOADTYPE_REPLACE = 8;
    static final int FRAME_LOADTYPE_SAME = 6;
    static final int FRAME_LOADTYPE_STANDARD = 0;
    private static final int LOADERROR = 2;
    private static final String LOGTAG = "webkit";
    private static final int MAX_OUTSTANDING_REQUESTS = 300;
    private static final int NODOMAIN = 1;
    static final int ORIENTATION_CHANGED = 1002;
    static final int POLICY_FUNCTION = 1003;
    static final int POLICY_IGNORE = 2;
    static final int POLICY_USE = 0;
    private static final int RESET_LABEL = 5;
    private static final int SUBMIT_LABEL = 6;
    private static final int TRANSITION_SWITCH_THRESHOLD = 75;
    static ConfigCallback sConfigCallback;
    static JWebCoreJavaBridge sJavaBridge;
    private boolean mBlockMessages = false;
    private final CallbackProxy mCallbackProxy;
    private boolean mCommitted = true;
    private final Context mContext;
    private final WebViewDatabase mDatabase;
    private boolean mFirstLayoutDone = true;
    private boolean mIsMainFrame;
    private Map<String, Object> mJSInterfaceMap;
    boolean mLoadInitFromJava;
    private int mLoadType;
    int mNativeFrame;
    private int mOrientation = -1;
    private final WebSettings mSettings;
    private final WebViewCore mWebViewCore;

    /*
     * Enabled aggressive block sorting
     */
    public BrowserFrame(Context context, WebViewCore webViewCore, CallbackProxy callbackProxy, WebSettings webSettings, Map<String, Object> map) {
        Context context2 = context.getApplicationContext();
        if (sJavaBridge == null) {
            sJavaBridge = new JWebCoreJavaBridge();
            if (((ActivityManager)context.getSystemService("activity")).getMemoryClass() > 16) {
                sJavaBridge.setCacheSize(0x800000);
            } else {
                sJavaBridge.setCacheSize(0x400000);
            }
            CacheManager.init((Context)context2);
            CookieSyncManager.createInstance(context2);
            PluginManager.getInstance(context2);
        }
        if (sConfigCallback == null) {
            sConfigCallback = new ConfigCallback((WindowManager)context.getSystemService("window"));
            ViewRoot.addConfigCallback(sConfigCallback);
        }
        sConfigCallback.addHandler(this);
        this.mJSInterfaceMap = map;
        this.mSettings = webSettings;
        this.mContext = context;
        this.mCallbackProxy = callbackProxy;
        this.mDatabase = WebViewDatabase.getInstance(context2);
        this.mWebViewCore = webViewCore;
        this.nativeCreateFrame(webViewCore, context.getAssets(), callbackProxy.getBackForwardList());
    }

    private void closeWindow(WebViewCore webViewCore) {
        this.mCallbackProxy.onCloseWindow(webViewCore.getWebView());
    }

    private BrowserFrame createWindow(boolean bl, boolean bl2) {
        return this.mCallbackProxy.createWindow(bl, bl2);
    }

    private void decidePolicyForFormResubmission(int n) {
        Message message = this.obtainMessage(1003, n, 2);
        Message message2 = this.obtainMessage(1003, n, 0);
        this.mCallbackProxy.onFormResubmission(message, message2);
    }

    private float density() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    private void didReceiveIcon(Bitmap bitmap) {
        this.mCallbackProxy.onReceivedIcon(bitmap);
    }

    private void didReceiveTouchIconUrl(String string2, boolean bl) {
        this.mCallbackProxy.onReceivedTouchIconUrl(string2, bl);
    }

    private native String documentAsText();

    private native String externalRepresentation();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getFile(String string2, byte[] byArray, int n, int n2) {
        try {
            InputStream inputStream = this.mContext.getContentResolver().openInputStream(Uri.parse(string2));
            int n3 = inputStream.available();
            if (n3 <= n2 && byArray != null && byArray.length - n >= n3) {
                inputStream.read(byArray, n, n3);
            } else {
                n3 = 0;
            }
            inputStream.close();
            return n3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e(LOGTAG, "FileNotFoundException:" + fileNotFoundException);
            return 0;
        }
        catch (IOException iOException) {
            Log.e(LOGTAG, "IOException: " + iOException);
            return 0;
        }
    }

    private int getFileSize(String string2) {
        int n = 0;
        try {
            InputStream inputStream = this.mContext.getContentResolver().openInputStream(Uri.parse(string2));
            n = inputStream.available();
            inputStream.close();
            return n;
        }
        catch (Exception exception) {
            return n;
        }
    }

    private native HashMap getFormTextData();

    private native String[] getUsernamePassword();

    private native boolean hasPasswordField();

    private void loadFinished(String string2, int n, boolean bl) {
        if ((bl || n == 0) && bl) {
            this.resetLoadingStates();
            this.mCallbackProxy.switchOutDrawHistory();
            this.mCallbackProxy.onPageFinished(string2);
        }
    }

    private void loadStarted(String string2, Bitmap bitmap, int n, boolean bl) {
        this.mIsMainFrame = bl;
        if (bl || n == 0) {
            String string3;
            WebHistoryItem webHistoryItem;
            this.mLoadType = n;
            if (bl) {
                this.mCallbackProxy.onPageStarted(string2, bitmap);
                this.mFirstLayoutDone = false;
                this.mCommitted = false;
                this.mWebViewCore.removeMessages(130);
            }
            if (n == 0 && this.mSettings.getSaveFormData() && (webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem()) != null && (string3 = webHistoryItem.getUrl()) != null) {
                this.mDatabase.setFormData(string3, this.getFormTextData());
            }
        }
    }

    private native void nativeAddJavascriptInterface(int var1, Object var2, String var3);

    private native void nativeCallPolicyFunction(int var1, int var2);

    private native void nativeCreateFrame(WebViewCore var1, AssetManager var2, WebBackForwardList var3);

    private native void nativeGoBackOrForward(int var1);

    private native void nativeLoadData(String var1, String var2, String var3, String var4, String var5);

    private native void nativeLoadUrl(String var1, Map<String, String> var2);

    private native void nativeOrientationChanged(int var1);

    private native void nativePostUrl(String var1, byte[] var2);

    private native void nativeStopLoading();

    private void reportError(int n, String string2, String string3) {
        this.resetLoadingStates();
        this.mCallbackProxy.onReceivedError(n, string2, string3);
    }

    private void requestFocus() {
        this.mCallbackProxy.onRequestFocus();
    }

    private void resetLoadingStates() {
        this.mCommitted = true;
        this.mFirstLayoutDone = true;
    }

    private native void setCacheDisabled(boolean var1);

    private void setProgress(int n) {
        this.mCallbackProxy.onProgressChanged(n);
        if (n == 100) {
            this.sendMessageDelayed(this.obtainMessage(1001), 100L);
        }
        if (this.mFirstLayoutDone && n > 75) {
            this.mCallbackProxy.switchOutDrawHistory();
        }
    }

    private void setTitle(String string2) {
        this.mCallbackProxy.onReceivedTitle(string2);
    }

    private native void setUsernamePassword(String var1, String var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LoadListener startLoadingResource(int n, String string2, String string3, HashMap hashMap, byte[] byArray, long l, int n2, boolean bl, boolean bl2, boolean bl3, String string4, String string5) {
        PerfChecker perfChecker;
        block12: {
            perfChecker = new PerfChecker();
            if (this.mSettings.getCacheMode() != -1) {
                n2 = this.mSettings.getCacheMode();
            }
            if (string3.equals("POST")) {
                if (n2 == 0) {
                    n2 = 2;
                }
                if (this.mSettings.getSavePassword() && this.hasPasswordField()) {
                    try {
                        String string6;
                        WebAddress webAddress = new WebAddress(this.mCallbackProxy.getBackForwardList().getCurrentItem().getUrl());
                        String string7 = webAddress.mScheme + webAddress.mHost;
                        String[] stringArray = this.getUsernamePassword();
                        if (stringArray == null || byArray == null || stringArray[0].length() <= 0 || stringArray[1].length() <= 0 || !(string6 = new String(byArray)).contains(URLEncoder.encode(stringArray[0])) || !string6.contains(URLEncoder.encode(stringArray[1]))) break block12;
                        String[] stringArray2 = this.mDatabase.getUsernamePassword(string7);
                        if (stringArray2 != null) {
                            if (stringArray2[0] != null) {
                                this.mDatabase.setUsernamePassword(string7, stringArray[0], stringArray[1]);
                            }
                            break block12;
                        }
                        this.mCallbackProxy.onSavePassword(string7, stringArray[0], stringArray[1], null);
                    }
                    catch (ParseException parseException) {}
                }
            }
        }
        boolean bl4 = this.mIsMainFrame;
        LoadListener loadListener = LoadListener.getLoadListener(this.mContext, this, string2, n, bl3, bl4, bl, bl2, l, string4, string5);
        this.mCallbackProxy.onLoadResource(string2);
        if (LoadListener.getNativeLoaderCount() > 300) {
            loadListener.error(-1, this.mContext.getString(17039623));
            return loadListener;
        }
        FrameLoader frameLoader = new FrameLoader(loadListener, this.mSettings, string3);
        frameLoader.setHeaders(hashMap);
        frameLoader.setPostData(byArray);
        int n3 = hashMap.containsKey("If-Modified-Since") || hashMap.containsKey("If-None-Match") ? 2 : n2;
        frameLoader.setCacheMode(n3);
        if (!frameLoader.executeLoad()) {
            perfChecker.responseAlert("startLoadingResource fail");
        }
        perfChecker.responseAlert("startLoadingResource succeed");
        if (!bl3) {
            return loadListener;
        }
        return null;
    }

    private void transitionToCommitted(int n, boolean bl) {
        if (bl) {
            this.mCommitted = true;
            this.mWebViewCore.getWebView().mViewManager.postResetStateAll();
        }
    }

    private void updateVisitedHistory(String string2, boolean bl) {
        this.mCallbackProxy.doUpdateVisitedHistory(string2, bl);
    }

    private void windowObjectCleared(int n) {
        if (this.mJSInterfaceMap != null) {
            for (String string2 : this.mJSInterfaceMap.keySet()) {
                this.nativeAddJavascriptInterface(n, this.mJSInterfaceMap.get(string2), string2);
            }
        }
    }

    public void addJavascriptInterface(Object object, String string2) {
        if (this.mJSInterfaceMap == null) {
            this.mJSInterfaceMap = new HashMap<String, Object>();
        }
        if (this.mJSInterfaceMap.containsKey(string2)) {
            this.mJSInterfaceMap.remove(string2);
        }
        this.mJSInterfaceMap.put(string2, object);
    }

    public native boolean cacheDisabled();

    void certificate(SslCertificate sslCertificate) {
        if (this.mIsMainFrame) {
            this.mCallbackProxy.onReceivedCertificate(sslCertificate);
        }
    }

    public native void clearCache();

    boolean committed() {
        return this.mCommitted;
    }

    public void destroy() {
        this.nativeDestroyFrame();
        this.mBlockMessages = true;
        this.removeCallbacksAndMessages(null);
    }

    void didFirstLayout() {
        if (!this.mFirstLayoutDone) {
            this.mFirstLayoutDone = true;
            this.mWebViewCore.contentDraw();
        }
    }

    public void documentAsText(Message message) {
        message.obj = this.documentAsText();
        message.sendToTarget();
    }

    public native boolean documentHasImages();

    public void externalRepresentation(Message message) {
        message.obj = this.externalRepresentation();
        message.sendToTarget();
    }

    boolean firstLayoutDone() {
        return this.mFirstLayoutDone;
    }

    CallbackProxy getCallbackProxy() {
        return this.mCallbackProxy;
    }

    /*
     * Unable to fully structure code
     */
    String getRawResFilename(int var1_1) {
        block10: {
            block0 : switch (var1_1) {
                default: {
                    Log.e("webkit", "getRawResFilename got incompatible resource ID");
                    return "";
                }
                case 1: {
                    var2_2 = 17563650;
lbl8:
                    // 3 sources

                    while (true) {
                        var3_3 = new TypedValue();
                        this.mContext.getResources().getValue(var2_2, var3_3, true);
                        if (var1_1 == 3) {
                            var4_4 = var3_3.string.toString();
                            var5_5 = var4_4.lastIndexOf(47);
                            if (var5_5 >= 0) break block0;
                            Log.e("webkit", "Can't find drawable directory.");
                            return "";
                        }
                        break block10;
                        break;
                    }
                }
                case 2: {
                    var2_2 = 0x10C0001;
                    ** GOTO lbl8
                }
                case 3: {
                    var2_2 = 17301688;
                    ** continue;
                }
                case 4: {
                    return this.mContext.getResources().getString(17040235);
                }
                case 5: {
                    return this.mContext.getResources().getString(17040236);
                }
                case 6: {
                    return this.mContext.getResources().getString(17040237);
                }
            }
            return var4_4.substring(0, var5_5 + 1);
        }
        return var3_3.string.toString();
    }

    String getUserAgentString() {
        return this.mSettings.getUserAgentString();
    }

    public void goBackOrForward(int n) {
        this.mLoadInitFromJava = true;
        this.nativeGoBackOrForward(n);
        this.mLoadInitFromJava = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        block11: {
            block10: {
                if (this.mBlockMessages) break block10;
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1001: {
                        WebHistoryItem webHistoryItem;
                        if (this.mSettings.getSavePassword() && this.hasPasswordField() && (webHistoryItem = this.mCallbackProxy.getBackForwardList().getCurrentItem()) != null) {
                            WebAddress webAddress = new WebAddress(webHistoryItem.getUrl());
                            String string2 = webAddress.mScheme + webAddress.mHost;
                            String[] stringArray = this.mDatabase.getUsernamePassword(string2);
                            if (stringArray != null && stringArray[0] != null) {
                                this.setUsernamePassword(stringArray[0], stringArray[1]);
                            }
                        }
                        WebViewWorker.getHandler().sendEmptyMessage(108);
                        return;
                    }
                    case 1003: {
                        this.nativeCallPolicyFunction(message.arg1, message.arg2);
                        return;
                    }
                    case 1002: 
                }
                if (this.mOrientation != message.arg1) break block11;
            }
            return;
        }
        this.mOrientation = message.arg1;
        this.nativeOrientationChanged(message.arg1);
    }

    public boolean handleUrl(String string2) {
        if (this.mLoadInitFromJava) {
            return false;
        }
        if (this.mCallbackProxy.shouldOverrideUrlLoading(string2)) {
            this.didFirstLayout();
            return true;
        }
        return false;
    }

    public void loadData(String string2, String string3, String string4, String string5, String string6) {
        this.mLoadInitFromJava = true;
        if (string6 == null || string6.length() == 0) {
            string6 = "about:blank";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "about:blank";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "text/html";
        }
        this.nativeLoadData(string2, string3, string4, string5, string6);
        this.mLoadInitFromJava = false;
    }

    int loadType() {
        return this.mLoadType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadUrl(String string2, Map<String, String> map) {
        this.mLoadInitFromJava = true;
        if (URLUtil.isJavaScriptUrl(string2)) {
            this.stringByEvaluatingJavaScriptFromString(string2.substring("javascript:".length()));
        } else {
            this.nativeLoadUrl(string2, map);
        }
        this.mLoadInitFromJava = false;
    }

    public native void nativeDestroyFrame();

    public void postUrl(String string2, byte[] byArray) {
        this.mLoadInitFromJava = true;
        this.nativePostUrl(string2, byArray);
        this.mLoadInitFromJava = false;
    }

    public native void reload(boolean var1);

    public void stopLoading() {
        if (this.mIsMainFrame) {
            this.resetLoadingStates();
        }
        this.nativeStopLoading();
    }

    public native String stringByEvaluatingJavaScriptFromString(String var1);

    private static class ConfigCallback
    implements ComponentCallbacks {
        private final ArrayList<WeakReference<Handler>> mHandlers = new ArrayList();
        private final WindowManager mWindowManager;

        ConfigCallback(WindowManager windowManager) {
            this.mWindowManager = windowManager;
        }

        public void addHandler(Handler handler) {
            synchronized (this) {
                this.mHandlers.add(new WeakReference<Handler>(handler));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onConfigurationChanged(Configuration configuration) {
            if (this.mHandlers.size() == 0) {
                return;
            }
            int n = this.mWindowManager.getDefaultDisplay().getOrientation();
            switch (n) {
                case 1: {
                    n = 90;
                    break;
                }
                case 2: {
                    n = 180;
                    break;
                }
                case 3: {
                    n = -90;
                    break;
                }
                case 0: {
                    n = 0;
                }
            }
            synchronized (this) {
                ArrayList<WeakReference<Handler>> arrayList = new ArrayList<WeakReference<Handler>>(this.mHandlers.size());
                for (WeakReference<Handler> weakReference : this.mHandlers) {
                    Handler handler = (Handler)weakReference.get();
                    if (handler != null) {
                        handler.sendMessage(handler.obtainMessage(1002, n, 0));
                        continue;
                    }
                    arrayList.add(weakReference);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    this.mHandlers.remove(weakReference);
                }
                return;
            }
        }

        @Override
        public void onLowMemory() {
        }
    }
}

