/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.ListIterator;

class ByteArrayBuilder {
    private static final int DEFAULT_CAPACITY = 8192;
    private static final LinkedList<SoftReference<Chunk>> sPool = new LinkedList();
    private static final ReferenceQueue<Chunk> sQueue = new ReferenceQueue();
    private LinkedList<Chunk> mChunks = new LinkedList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk obtainChunk(int n) {
        if (n < 8192) {
            n = 8192;
        }
        LinkedList<SoftReference<Chunk>> linkedList = sPool;
        synchronized (linkedList) {
            this.processPoolLocked();
            if (sPool.isEmpty()) return new Chunk(n);
            Chunk chunk = (Chunk)sPool.removeFirst().get();
            if (chunk == null) return new Chunk(n);
            return chunk;
        }
    }

    private void processPoolLocked() {
        SoftReference softReference;
        while ((softReference = (SoftReference)sQueue.poll()) != null) {
            sPool.remove(softReference);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(byte[] byArray, int n, int n2) {
        synchronized (this) {
            while (n2 > 0) {
                Chunk chunk;
                if (this.mChunks.isEmpty()) {
                    chunk = this.obtainChunk(n2);
                    this.mChunks.addLast(chunk);
                } else {
                    chunk = this.mChunks.getLast();
                    if (chunk.mLength == chunk.mArray.length) {
                        chunk = this.obtainChunk(n2);
                        this.mChunks.addLast(chunk);
                    }
                }
                int n3 = Math.min(n2, chunk.mArray.length - chunk.mLength);
                System.arraycopy(byArray, n, chunk.mArray, chunk.mLength, n3);
                chunk.mLength = n3 + chunk.mLength;
                n2 -= n3;
                n += n3;
            }
            return;
        }
    }

    public void clear() {
        synchronized (this) {
            Chunk chunk = this.getFirstChunk();
            while (chunk != null) {
                Chunk chunk2;
                chunk.release();
                chunk = chunk2 = this.getFirstChunk();
            }
            return;
        }
    }

    public int getByteSize() {
        synchronized (this) {
            int n = 0;
            ListIterator<Chunk> listIterator = this.mChunks.listIterator(0);
            while (listIterator.hasNext()) {
                int n2 = listIterator.next().mLength;
                n += n2;
            }
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chunk getFirstChunk() {
        synchronized (this) {
            block6: {
                boolean bl = this.mChunks.isEmpty();
                if (!bl) break block6;
                return null;
            }
            Chunk chunk = this.mChunks.removeFirst();
            return chunk;
        }
    }

    public boolean isEmpty() {
        synchronized (this) {
            boolean bl = this.mChunks.isEmpty();
            return bl;
        }
    }

    public static class Chunk {
        public byte[] mArray;
        public int mLength;

        public Chunk(int n) {
            this.mArray = new byte[n];
            this.mLength = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            this.mLength = 0;
            LinkedList linkedList = sPool;
            synchronized (linkedList) {
                sPool.offer(new SoftReference<Chunk>(this, sQueue));
                sPool.notifyAll();
                return;
            }
        }
    }
}

