/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.widget.EditText;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

class CallbackProxy
extends Handler {
    private static final int ADD_HISTORY_ITEM = 135;
    private static final int ADD_MESSAGE_TO_CONSOLE = 129;
    private static final int ASYNC_KEYEVENTS = 116;
    private static final int AUTH_CREDENTIALS = 137;
    private static final int AUTH_REQUEST = 104;
    private static final int CLOSE_WINDOW = 110;
    private static final int CREATE_WINDOW = 109;
    private static final int DOWNLOAD_FILE = 118;
    private static final int EXCEEDED_DATABASE_QUOTA = 126;
    private static final int GEOLOCATION_PERMISSIONS_HIDE_PROMPT = 131;
    private static final int GEOLOCATION_PERMISSIONS_SHOW_PROMPT = 130;
    private static final int GET_VISITED_HISTORY = 133;
    private static final int HISTORY_INDEX_CHANGED = 136;
    private static final int JS_ALERT = 112;
    private static final int JS_CONFIRM = 113;
    private static final int JS_PROMPT = 114;
    private static final int JS_TIMEOUT = 128;
    private static final int JS_UNLOAD = 115;
    private static final int LOAD_RESOURCE = 108;
    private static final String LOGTAG = "CallbackProxy";
    private static final int NOTIFY = 200;
    private static final int OPEN_FILE_CHOOSER = 134;
    private static final int OVERRIDE_URL = 103;
    private static final int PAGE_FINISHED = 121;
    private static final int PAGE_STARTED = 100;
    private static final boolean PERF_PROBE = false;
    private static final int PROGRESS = 106;
    private static final int REACHED_APPCACHE_MAXSIZE = 127;
    private static final int RECEIVED_CERTIFICATE = 124;
    private static final int RECEIVED_ICON = 101;
    private static final int RECEIVED_TITLE = 102;
    private static final int RECEIVED_TOUCH_ICON_URL = 132;
    private static final int REPORT_ERROR = 119;
    private static final int REQUEST_FOCUS = 122;
    private static final int RESEND_POST_DATA = 120;
    private static final int SAVE_PASSWORD = 111;
    private static final int SCALE_CHANGED = 123;
    private static final int SSL_ERROR = 105;
    private static final int SWITCH_OUT_HISTORY = 125;
    private static final int UPDATE_VISITED = 107;
    private final WebBackForwardList mBackForwardList;
    private final Context mContext;
    private volatile DownloadListener mDownloadListener;
    private volatile int mLatestProgress = 100;
    private boolean mProgressUpdatePending;
    private volatile WebBackForwardListClient mWebBackForwardListClient;
    private volatile WebChromeClient mWebChromeClient;
    private long mWebCoreIdleTime;
    private long mWebCoreThreadTime;
    private final WebView mWebView;
    private volatile WebViewClient mWebViewClient;

    public CallbackProxy(Context context, WebView webView) {
        this.mContext = context;
        this.mWebView = webView;
        this.mBackForwardList = new WebBackForwardList(this);
    }

    private String getJsDialogTitle(String string2) {
        if (URLUtil.isDataUrl(string2)) {
            return this.mContext.getString(17040048);
        }
        try {
            URL uRL = new URL(string2);
            Context context = this.mContext;
            Object[] objectArray = new Object[]{uRL.getProtocol() + "://" + uRL.getHost()};
            String string3 = context.getString(17040047, objectArray);
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            return string2;
        }
    }

    public void addMessageToConsole(String string2, int n, String string3, int n2) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message message = this.obtainMessage(129);
        message.getData().putString("message", string2);
        message.getData().putString("sourceID", string3);
        message.getData().putInt("lineNumber", n);
        message.getData().putInt("msgLevel", n2);
        this.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BrowserFrame createWindow(boolean bl, boolean bl2) {
        WebViewCore webViewCore;
        if (this.mWebChromeClient == null) {
            return null;
        }
        WebView webView = this.mWebView;
        webView.getClass();
        WebView.WebViewTransport webViewTransport = webView.new WebView.WebViewTransport();
        Message message = this.obtainMessage(200);
        message.obj = webViewTransport;
        synchronized (this) {
            int n = bl ? 1 : 0;
            int n2 = 0;
            if (bl2) {
                n2 = 1;
            }
            this.sendMessage(this.obtainMessage(109, n, n2, message));
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for createWindow");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
        }
        WebView webView2 = webViewTransport.getWebView();
        if (webView2 != null && (webViewCore = webView2.getWebViewCore()) != null) {
            webViewCore.initializeSubwindow();
            return webViewCore.getBrowserFrame();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doUpdateVisitedHistory(String string2, boolean bl) {
        if (this.mWebViewClient == null) {
            return;
        }
        int n = bl ? 1 : 0;
        this.sendMessage(this.obtainMessage(107, n, 0, string2));
    }

    public WebBackForwardList getBackForwardList() {
        return this.mBackForwardList;
    }

    public int getProgress() {
        return this.mLatestProgress;
    }

    public void getVisitedHistory(ValueCallback<String[]> valueCallback) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message message = this.obtainMessage(133);
        message.obj = valueCallback;
        this.sendMessage(message);
    }

    WebBackForwardListClient getWebBackForwardListClient() {
        return this.mWebBackForwardListClient;
    }

    public WebChromeClient getWebChromeClient() {
        return this.mWebChromeClient;
    }

    public WebViewClient getWebViewClient() {
        return this.mWebViewClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: {
                this.mWebView.setCertificate(null);
                if (this.mWebViewClient == null) return;
                this.mWebViewClient.onPageStarted(this.mWebView, message.getData().getString("url"), (Bitmap)message.obj);
                return;
            }
            case 121: {
                String string2 = (String)message.obj;
                this.mWebView.onPageFinished(string2);
                if (this.mWebViewClient == null) return;
                this.mWebViewClient.onPageFinished(this.mWebView, string2);
                return;
            }
            case 101: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.onReceivedIcon(this.mWebView, (Bitmap)message.obj);
                return;
            }
            case 132: {
                if (this.mWebChromeClient == null) return;
                WebChromeClient webChromeClient = this.mWebChromeClient;
                WebView webView = this.mWebView;
                String string3 = (String)message.obj;
                boolean bl = message.arg1 == 1;
                webChromeClient.onReceivedTouchIconUrl(webView, string3, bl);
                return;
            }
            case 102: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.onReceivedTitle(this.mWebView, (String)message.obj);
                return;
            }
            case 119: {
                if (this.mWebViewClient == null) return;
                int n = message.arg1;
                String string4 = message.getData().getString("description");
                String string5 = message.getData().getString("failingUrl");
                this.mWebViewClient.onReceivedError(this.mWebView, n, string4, string5);
                return;
            }
            case 120: {
                Message message2 = (Message)message.getData().getParcelable("resend");
                Message message3 = (Message)message.getData().getParcelable("dontResend");
                if (this.mWebViewClient != null) {
                    this.mWebViewClient.onFormResubmission(this.mWebView, message3, message2);
                    return;
                }
                message3.sendToTarget();
                return;
            }
            case 103: {
                boolean bl = this.uiOverrideUrlLoading(message.getData().getString("url"));
                ResultTransport resultTransport = (ResultTransport)message.obj;
                // MONITORENTER : this
                resultTransport.setResult(bl);
                this.notify();
                // MONITOREXIT : this
                return;
            }
            case 104: {
                if (this.mWebViewClient == null) return;
                HttpAuthHandler httpAuthHandler = (HttpAuthHandler)message.obj;
                String string6 = message.getData().getString("host");
                String string7 = message.getData().getString("realm");
                this.mWebViewClient.onReceivedHttpAuthRequest(this.mWebView, httpAuthHandler, string6, string7);
                return;
            }
            case 105: {
                if (this.mWebViewClient == null) return;
                HashMap hashMap = (HashMap)message.obj;
                this.mWebViewClient.onReceivedSslError(this.mWebView, (SslErrorHandler)hashMap.get("handler"), (SslError)hashMap.get("error"));
                return;
            }
            case 106: {
                // MONITORENTER : this
                if (this.mWebChromeClient != null) {
                    this.mWebChromeClient.onProgressChanged(this.mWebView, this.mLatestProgress);
                }
                this.mProgressUpdatePending = false;
                // MONITOREXIT : this
                return;
            }
            case 107: {
                if (this.mWebViewClient == null) return;
                WebViewClient webViewClient = this.mWebViewClient;
                WebView webView = this.mWebView;
                String string8 = (String)message.obj;
                boolean bl = message.arg1 != 0;
                webViewClient.doUpdateVisitedHistory(webView, string8, bl);
                return;
            }
            case 108: {
                if (this.mWebViewClient == null) return;
                this.mWebViewClient.onLoadResource(this.mWebView, (String)message.obj);
                return;
            }
            case 118: {
                if (this.mDownloadListener == null) return;
                String string9 = message.getData().getString("url");
                String string10 = message.getData().getString("userAgent");
                String string11 = message.getData().getString("contentDisposition");
                String string12 = message.getData().getString("mimetype");
                Long l = message.getData().getLong("contentLength");
                this.mDownloadListener.onDownloadStart(string9, string10, string11, string12, l);
                return;
            }
            case 109: {
                if (this.mWebChromeClient == null) return;
                WebChromeClient webChromeClient = this.mWebChromeClient;
                WebView webView = this.mWebView;
                boolean bl = message.arg1 == 1;
                boolean bl2 = message.arg2 == 1;
                Message message4 = (Message)message.obj;
                if (!webChromeClient.onCreateWindow(webView, bl, bl2, message4)) {
                    // MONITORENTER : this
                    this.notify();
                    // MONITOREXIT : this
                }
                this.mWebView.dismissZoomControl();
                return;
            }
            case 122: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.onRequestFocus(this.mWebView);
                return;
            }
            case 110: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.onCloseWindow((WebView)message.obj);
                return;
            }
            case 111: {
                String string13;
                String string14;
                Bundle bundle = message.getData();
                String string15 = bundle.getString("host");
                if (this.mWebView.onSavePassword(string15, string14 = bundle.getString("username"), string13 = bundle.getString("password"), (Message)message.obj)) return;
                // MONITORENTER : this
                this.notify();
                // MONITOREXIT : this
                return;
            }
            case 116: {
                if (this.mWebViewClient == null) return;
                this.mWebViewClient.onUnhandledKeyEvent(this.mWebView, (KeyEvent)message.obj);
                return;
            }
            case 126: {
                if (this.mWebChromeClient == null) return;
                HashMap hashMap = (HashMap)message.obj;
                String string16 = (String)hashMap.get("databaseIdentifier");
                String string17 = (String)hashMap.get("url");
                long l = (Long)hashMap.get("currentQuota");
                long l2 = (Long)hashMap.get("totalUsedQuota");
                long l3 = (Long)hashMap.get("estimatedSize");
                WebStorage.QuotaUpdater quotaUpdater = (WebStorage.QuotaUpdater)hashMap.get("quotaUpdater");
                this.mWebChromeClient.onExceededDatabaseQuota(string17, string16, l, l3, l2, quotaUpdater);
                return;
            }
            case 127: {
                if (this.mWebChromeClient == null) return;
                HashMap hashMap = (HashMap)message.obj;
                long l = (Long)hashMap.get("spaceNeeded");
                long l4 = (Long)hashMap.get("totalUsedQuota");
                WebStorage.QuotaUpdater quotaUpdater = (WebStorage.QuotaUpdater)hashMap.get("quotaUpdater");
                this.mWebChromeClient.onReachedMaxAppCacheSize(l, l4, quotaUpdater);
                return;
            }
            case 130: {
                if (this.mWebChromeClient == null) return;
                HashMap hashMap = (HashMap)message.obj;
                String string18 = (String)hashMap.get("origin");
                GeolocationPermissions.Callback callback = (GeolocationPermissions.Callback)hashMap.get("callback");
                this.mWebChromeClient.onGeolocationPermissionsShowPrompt(string18, callback);
                return;
            }
            case 131: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.onGeolocationPermissionsHidePrompt();
                return;
            }
            case 112: {
                if (this.mWebChromeClient == null) return;
                final JsResult jsResult = (JsResult)message.obj;
                String string19 = message.getData().getString("message");
                String string20 = message.getData().getString("url");
                if (!this.mWebChromeClient.onJsAlert(this.mWebView, string20, string19, jsResult)) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(string20)).setMessage(string19);
                    DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsResult.confirm();
                        }
                    };
                    builder.setPositiveButton(17039370, onClickListener).setCancelable(false).show();
                }
                jsResult.setReady();
                return;
            }
            case 113: {
                if (this.mWebChromeClient == null) return;
                final JsResult jsResult = (JsResult)message.obj;
                String string21 = message.getData().getString("message");
                String string22 = message.getData().getString("url");
                if (!this.mWebChromeClient.onJsConfirm(this.mWebView, string22, string21, jsResult)) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(string22)).setMessage(string21);
                    DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsResult.confirm();
                        }
                    };
                    AlertDialog.Builder builder2 = builder.setPositiveButton(17039370, onClickListener);
                    DialogInterface.OnClickListener onClickListener2 = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsResult.cancel();
                        }
                    };
                    AlertDialog.Builder builder3 = builder2.setNegativeButton(0x1040000, onClickListener2);
                    DialogInterface.OnCancelListener onCancelListener = new DialogInterface.OnCancelListener(){

                        @Override
                        public void onCancel(DialogInterface dialogInterface) {
                            jsResult.cancel();
                        }
                    };
                    builder3.setOnCancelListener(onCancelListener).show();
                }
                jsResult.setReady();
                return;
            }
            case 114: {
                if (this.mWebChromeClient == null) return;
                final JsPromptResult jsPromptResult = (JsPromptResult)message.obj;
                String string23 = message.getData().getString("message");
                String string24 = message.getData().getString("default");
                String string25 = message.getData().getString("url");
                if (!this.mWebChromeClient.onJsPrompt(this.mWebView, string25, string23, string24, jsPromptResult)) {
                    View view = LayoutInflater.from(this.mContext).inflate(17367084, null);
                    final EditText editText = (EditText)view.findViewById(16908730);
                    editText.setText(string24);
                    ((TextView)view.findViewById(16908299)).setText(string23);
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(string25)).setView(view);
                    DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsPromptResult.confirm(editText.getText().toString());
                        }
                    };
                    AlertDialog.Builder builder4 = builder.setPositiveButton(17039370, onClickListener);
                    DialogInterface.OnClickListener onClickListener3 = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsPromptResult.cancel();
                        }
                    };
                    AlertDialog.Builder builder5 = builder4.setNegativeButton(0x1040000, onClickListener3);
                    DialogInterface.OnCancelListener onCancelListener = new DialogInterface.OnCancelListener(){

                        @Override
                        public void onCancel(DialogInterface dialogInterface) {
                            jsPromptResult.cancel();
                        }
                    };
                    builder5.setOnCancelListener(onCancelListener).show();
                }
                jsPromptResult.setReady();
                return;
            }
            case 115: {
                if (this.mWebChromeClient == null) return;
                final JsResult jsResult = (JsResult)message.obj;
                String string26 = message.getData().getString("message");
                String string27 = message.getData().getString("url");
                if (!this.mWebChromeClient.onJsBeforeUnload(this.mWebView, string27, string26, jsResult)) {
                    String string28 = this.mContext.getString(17040049, string26);
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setMessage(string28);
                    DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsResult.confirm();
                        }
                    };
                    AlertDialog.Builder builder6 = builder.setPositiveButton(17039370, onClickListener);
                    DialogInterface.OnClickListener onClickListener4 = new DialogInterface.OnClickListener(){

                        @Override
                        public void onClick(DialogInterface dialogInterface, int n) {
                            jsResult.cancel();
                        }
                    };
                    builder6.setNegativeButton(0x1040000, onClickListener4).show();
                }
                jsResult.setReady();
                return;
            }
            case 128: {
                if (this.mWebChromeClient == null) return;
                JsResult jsResult = (JsResult)message.obj;
                if (this.mWebChromeClient.onJsTimeout()) {
                    jsResult.confirm();
                } else {
                    jsResult.cancel();
                }
                jsResult.setReady();
                return;
            }
            case 124: {
                this.mWebView.setCertificate((SslCertificate)message.obj);
                return;
            }
            case 200: {
                // MONITORENTER : this
                this.notify();
                // MONITOREXIT : this
                return;
            }
            case 123: {
                if (this.mWebViewClient == null) return;
                this.mWebViewClient.onScaleChanged(this.mWebView, message.getData().getFloat("old"), message.getData().getFloat("new"));
                return;
            }
            case 125: {
                this.mWebView.switchOutDrawHistory();
                return;
            }
            case 129: {
                ConsoleMessage.MessageLevel messageLevel;
                ConsoleMessage consoleMessage;
                WebChromeClient webChromeClient;
                String string29 = message.getData().getString("message");
                String string30 = message.getData().getString("sourceID");
                int n = message.getData().getInt("lineNumber");
                int n2 = message.getData().getInt("msgLevel");
                int n3 = ConsoleMessage.MessageLevel.values().length;
                if (n2 < 0 || n2 >= n3) {
                    n2 = 0;
                }
                if ((webChromeClient = this.mWebChromeClient).onConsoleMessage(consoleMessage = new ConsoleMessage(string29, string30, n, messageLevel = ConsoleMessage.MessageLevel.values()[n2]))) return;
                String string31 = string29 + " at " + string30 + ":" + n;
                switch (10.$SwitchMap$android$webkit$ConsoleMessage$MessageLevel[messageLevel.ordinal()]) {
                    default: {
                        return;
                    }
                    case 1: {
                        Log.v("Web Console", string31);
                        return;
                    }
                    case 2: {
                        Log.i("Web Console", string31);
                        return;
                    }
                    case 3: {
                        Log.w("Web Console", string31);
                        return;
                    }
                    case 4: {
                        Log.e("Web Console", string31);
                        return;
                    }
                    case 5: 
                }
                Log.d("Web Console", string31);
                return;
            }
            case 133: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.getVisitedHistory((ValueCallback)message.obj);
                return;
            }
            case 134: {
                if (this.mWebChromeClient == null) return;
                this.mWebChromeClient.openFileChooser((UploadFile)message.obj);
                return;
            }
            case 135: {
                if (this.mWebBackForwardListClient == null) return;
                this.mWebBackForwardListClient.onNewHistoryItem((WebHistoryItem)message.obj);
                return;
            }
            case 136: {
                if (this.mWebBackForwardListClient == null) return;
                this.mWebBackForwardListClient.onIndexChanged((WebHistoryItem)message.obj, message.arg1);
                return;
            }
            case 137: 
        }
        String string32 = message.getData().getString("host");
        String string33 = message.getData().getString("realm");
        String string34 = message.getData().getString("username");
        String string35 = message.getData().getString("password");
        this.mWebView.setHttpAuthUsernamePassword(string32, string33, string34, string35);
    }

    public void onCloseWindow(WebView webView) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(110, webView));
    }

    public boolean onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        if (this.mDownloadListener == null) {
            return false;
        }
        Message message = this.obtainMessage(118);
        Bundle bundle = message.getData();
        bundle.putString("url", string2);
        bundle.putString("userAgent", string3);
        bundle.putString("mimetype", string5);
        bundle.putLong("contentLength", l);
        bundle.putString("contentDisposition", string4);
        this.sendMessage(message);
        return true;
    }

    public void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.mWebChromeClient == null) {
            quotaUpdater.updateQuota(l);
            return;
        }
        Message message = this.obtainMessage(126);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("databaseIdentifier", string3);
        hashMap.put("url", string2);
        hashMap.put("currentQuota", l);
        hashMap.put("estimatedSize", l2);
        hashMap.put("totalUsedQuota", l3);
        hashMap.put("quotaUpdater", quotaUpdater);
        message.obj = hashMap;
        this.sendMessage(message);
    }

    public void onFormResubmission(Message message, Message message2) {
        if (this.mWebViewClient == null) {
            message.sendToTarget();
            return;
        }
        Message message3 = this.obtainMessage(120);
        Bundle bundle = message3.getData();
        bundle.putParcelable("resend", message2);
        bundle.putParcelable("dontResend", message);
        this.sendMessage(message3);
    }

    public void onGeolocationPermissionsHidePrompt() {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(131));
    }

    public void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message message = this.obtainMessage(130);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("origin", string2);
        hashMap.put("callback", callback);
        message.obj = hashMap;
        this.sendMessage(message);
    }

    void onIndexChanged(WebHistoryItem webHistoryItem, int n) {
        if (this.mWebBackForwardListClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(136, n, 0, webHistoryItem));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onJsAlert(String string2, String string3) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message message = this.obtainMessage(112, new JsResult(this, false));
        message.getData().putString("message", string3);
        message.getData().putString("url", string2);
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for jsAlert");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onJsBeforeUnload(String string2, String string3) {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult jsResult = new JsResult(this, true);
        Message message = this.obtainMessage(115, jsResult);
        message.getData().putString("message", string3);
        message.getData().putString("url", string2);
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return jsResult.getResult();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onJsConfirm(String string2, String string3) {
        if (this.mWebChromeClient == null) {
            return false;
        }
        JsResult jsResult = new JsResult(this, false);
        Message message = this.obtainMessage(113, jsResult);
        message.getData().putString("message", string3);
        message.getData().putString("url", string2);
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for jsConfirm");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return jsResult.getResult();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String onJsPrompt(String string2, String string3, String string4) {
        if (this.mWebChromeClient == null) {
            return null;
        }
        JsPromptResult jsPromptResult = new JsPromptResult(this);
        Message message = this.obtainMessage(114, jsPromptResult);
        message.getData().putString("message", string3);
        message.getData().putString("default", string4);
        message.getData().putString("url", string2);
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for jsPrompt");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return jsPromptResult.getStringResult();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onJsTimeout() {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult jsResult = new JsResult(this, true);
        Message message = this.obtainMessage(128, jsResult);
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return jsResult.getResult();
        }
    }

    public void onLoadResource(String string2) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(108, string2));
    }

    void onNewHistoryItem(WebHistoryItem webHistoryItem) {
        if (this.mWebBackForwardListClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(135, webHistoryItem));
    }

    public void onPageFinished(String string2) {
        this.sendMessage(this.obtainMessage(121, string2));
    }

    public void onPageStarted(String string2, Bitmap bitmap) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message message = this.obtainMessage(100);
        message.obj = bitmap;
        message.getData().putString("url", string2);
        this.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onProgressChanged(int n) {
        synchronized (this) {
            if (this.mWebChromeClient == null || this.mLatestProgress == n) {
                return;
            }
            this.mLatestProgress = n;
            if (!this.mProgressUpdatePending) {
                this.sendEmptyMessage(106);
                this.mProgressUpdatePending = true;
            }
            return;
        }
    }

    public void onReachedMaxAppCacheSize(long l, long l2, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.mWebChromeClient == null) {
            quotaUpdater.updateQuota(0L);
            return;
        }
        Message message = this.obtainMessage(127);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("spaceNeeded", l);
        hashMap.put("totalUsedQuota", l2);
        hashMap.put("quotaUpdater", quotaUpdater);
        message.obj = hashMap;
        this.sendMessage(message);
    }

    public void onReceivedCertificate(SslCertificate sslCertificate) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(124, sslCertificate));
    }

    public void onReceivedError(int n, String string2, String string3) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message message = this.obtainMessage(119);
        message.arg1 = n;
        message.getData().putString("description", string2);
        message.getData().putString("failingUrl", string3);
        this.sendMessage(message);
    }

    public void onReceivedHttpAuthCredentials(String string2, String string3, String string4, String string5) {
        Message message = this.obtainMessage(137);
        message.getData().putString("host", string2);
        message.getData().putString("realm", string3);
        message.getData().putString("username", string4);
        message.getData().putString("password", string5);
        this.sendMessage(message);
    }

    public void onReceivedHttpAuthRequest(HttpAuthHandler httpAuthHandler, String string2, String string3) {
        if (this.mWebViewClient == null) {
            httpAuthHandler.cancel();
            return;
        }
        Message message = this.obtainMessage(104, httpAuthHandler);
        message.getData().putString("host", string2);
        message.getData().putString("realm", string3);
        this.sendMessage(message);
    }

    public void onReceivedIcon(Bitmap bitmap) {
        WebHistoryItem webHistoryItem = this.mBackForwardList.getCurrentItem();
        if (webHistoryItem != null) {
            webHistoryItem.setFavicon(bitmap);
        }
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(101, bitmap));
    }

    public void onReceivedSslError(SslErrorHandler sslErrorHandler, SslError sslError) {
        if (this.mWebViewClient == null) {
            sslErrorHandler.cancel();
            return;
        }
        Message message = this.obtainMessage(105);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("handler", sslErrorHandler);
        hashMap.put("error", sslError);
        message.obj = hashMap;
        this.sendMessage(message);
    }

    public void onReceivedTitle(String string2) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(102, string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    void onReceivedTouchIconUrl(String string2, boolean bl) {
        WebHistoryItem webHistoryItem = this.mBackForwardList.getCurrentItem();
        if (webHistoryItem != null && (bl || webHistoryItem.getTouchIconUrl() == null)) {
            webHistoryItem.setTouchIconUrl(string2);
        }
        if (this.mWebChromeClient == null) {
            return;
        }
        int n = bl ? 1 : 0;
        this.sendMessage(this.obtainMessage(132, n, 0, string2));
    }

    public void onRequestFocus() {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendEmptyMessage(122);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onSavePassword(String string2, String string3, String string4, Message message) {
        Message message2 = this.obtainMessage(111, this.obtainMessage(200));
        Bundle bundle = message2.getData();
        bundle.putString("host", string2);
        bundle.putString("username", string3);
        bundle.putString("password", string4);
        synchronized (this) {
            this.sendMessage(message2);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for onSavePassword");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return false;
        }
    }

    public void onScaleChanged(float f, float f2) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message message = this.obtainMessage(123);
        Bundle bundle = message.getData();
        bundle.putFloat("old", f);
        bundle.putFloat("new", f2);
        this.sendMessage(message);
    }

    public void onTooManyRedirects(Message message, Message message2) {
    }

    public void onUnhandledKeyEvent(KeyEvent keyEvent) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(116, keyEvent));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Uri openFileChooser() {
        if (this.mWebChromeClient == null) {
            return null;
        }
        Message message = this.obtainMessage(134);
        UploadFile uploadFile = new UploadFile();
        message.obj = uploadFile;
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for openFileChooser");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return uploadFile.getResult();
        }
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
    }

    void setWebBackForwardListClient(WebBackForwardListClient webBackForwardListClient) {
        this.mWebBackForwardListClient = webBackForwardListClient;
    }

    public void setWebChromeClient(WebChromeClient webChromeClient) {
        this.mWebChromeClient = webChromeClient;
    }

    public void setWebViewClient(WebViewClient webViewClient) {
        this.mWebViewClient = webViewClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldOverrideUrlLoading(String string2) {
        ResultTransport<Boolean> resultTransport = new ResultTransport<Boolean>(false);
        Message message = this.obtainMessage(103);
        message.getData().putString("url", string2);
        message.obj = resultTransport;
        synchronized (this) {
            this.sendMessage(message);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.e(LOGTAG, "Caught exception while waiting for overrideUrl");
                Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
            }
            return resultTransport.getResult();
        }
    }

    void switchOutDrawHistory() {
        this.sendMessage(this.obtainMessage(125));
    }

    public boolean uiOverrideKeyEvent(KeyEvent keyEvent) {
        if (this.mWebViewClient != null) {
            return this.mWebViewClient.shouldOverrideKeyEvent(this.mWebView, keyEvent);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean uiOverrideUrlLoading(String string2) {
        if (string2 == null) return false;
        if (string2.length() == 0) {
            return false;
        }
        if (this.mWebViewClient != null) {
            return this.mWebViewClient.shouldOverrideUrlLoading(this.mWebView, string2);
        }
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(string2));
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
        try {
            this.mContext.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    private static class ResultTransport<E> {
        private E mResult;

        public ResultTransport(E e) {
            this.mResult = e;
        }

        public E getResult() {
            synchronized (this) {
                E e = this.mResult;
                return e;
            }
        }

        public void setResult(E e) {
            synchronized (this) {
                this.mResult = e;
                return;
            }
        }
    }

    private class UploadFile
    implements ValueCallback<Uri> {
        private Uri mValue;

        private UploadFile() {
        }

        public Uri getResult() {
            return this.mValue;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceiveValue(Uri uri) {
            this.mValue = uri;
            CallbackProxy callbackProxy = CallbackProxy.this;
            synchronized (callbackProxy) {
                CallbackProxy.this.notify();
                return;
            }
        }
    }
}

