/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.security.Credentials;
import android.util.Log;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.util.encoders.Base64;

class CertTool {
    static final String CERT = "CERT";
    private static final String LOGTAG = "CertTool";
    private static final AlgorithmIdentifier MD5_WITH_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption);
    static final String PKCS12 = "PKCS12";

    private CertTool() {
    }

    static void addCertificate(Context context, String string2, byte[] byArray) {
        Credentials.getInstance().install(context, string2, byArray);
    }

    static String[] getKeyStrengthList() {
        return new String[]{"High Grade", "Medium Grade"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSignedPublicKey(Context context, int n, String string2) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            int n2 = n == 0 ? 2048 : 1024;
            keyPairGenerator.initialize(n2);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            NetscapeCertRequest netscapeCertRequest = new NetscapeCertRequest(string2, MD5_WITH_RSA, keyPair.getPublic());
            netscapeCertRequest.sign(keyPair.getPrivate());
            byte[] byArray = netscapeCertRequest.toASN1Object().getDEREncoded();
            Credentials.getInstance().install(context, keyPair);
            return new String(Base64.encode((byte[])byArray));
        }
        catch (Exception exception) {
            Log.w(LOGTAG, exception);
            return null;
        }
    }
}

