/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.Uri;
import android.net.http.Headers;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.FileNotFoundException;

class ContentLoader
extends StreamLoader {
    private String mContentType;
    private String mUrl;

    ContentLoader(String string2, LoadListener loadListener) {
        super(loadListener);
        int n = string2.lastIndexOf(63);
        if (n != -1) {
            this.mUrl = string2.substring(0, n);
            this.mContentType = string2.substring(n + 1);
            return;
        }
        this.mUrl = string2;
    }

    private String errString(Exception exception) {
        String string2 = exception.getMessage();
        String string3 = this.mContext.getString(17039622);
        if (string2 != null) {
            string3 = string3 + " " + string2;
        }
        return string3;
    }

    @Override
    protected void buildHeaders(Headers headers) {
        if (this.mContentType != null) {
            headers.setContentType("text/html");
        }
        headers.setCacheControl("no-store, no-cache");
    }

    @Override
    protected boolean setupStreamAndSendStatus() {
        Uri uri = Uri.parse(this.mUrl);
        if (uri == null) {
            this.mLoadListener.error(-14, this.mContext.getString(17039367) + " " + this.mUrl);
            return false;
        }
        try {
            this.mDataStream = this.mContext.getContentResolver().openInputStream(uri);
            this.mLoadListener.status(1, 1, 200, "OK");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mLoadListener.error(-14, this.errString(fileNotFoundException));
            return false;
        }
        catch (RuntimeException runtimeException) {
            this.mLoadListener.error(-13, this.errString(runtimeException));
            return false;
        }
    }
}

