/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.http.EventHandler;
import android.net.http.RequestHandle;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.ContentLoader;
import android.webkit.CookieManager;
import android.webkit.DataLoader;
import android.webkit.FileLoader;
import android.webkit.LoadListener;
import android.webkit.Network;
import android.webkit.URLUtil;
import android.webkit.WebSettings;
import android.webkit.WebViewWorker;
import java.util.HashMap;
import java.util.Map;

class FrameLoader {
    private static final String CONTENT_TYPE = "content-type";
    static final String HEADER_STR = "text/xml, text/html, application/xhtml+xml, image/png, text/plain, */*;q=0.8";
    private static final String LOGTAG = "webkit";
    private static final int URI_PROTOCOL = 256;
    private static final String mAboutBlank = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EB\"><html><head><title>about:blank</title></head><body></body></html>";
    private int mCacheMode;
    private String mContentType;
    private Map<String, String> mHeaders;
    private final LoadListener mListener;
    private final String mMethod;
    private Network mNetwork;
    private byte[] mPostData;
    private String mReferrer;
    private final WebSettings mSettings;

    FrameLoader(LoadListener loadListener, WebSettings webSettings, String string2) {
        this.mListener = loadListener;
        this.mHeaders = null;
        this.mMethod = string2;
        this.mCacheMode = 0;
        this.mSettings = webSettings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCache() {
        switch (this.mCacheMode) {
            default: {
                return this.mListener.checkCache(this.mHeaders);
            }
            case 3: {
                CacheManager.CacheResult cacheResult = CacheManager.getCacheFile((String)this.mListener.url(), (long)this.mListener.postIdentifier(), null);
                if (cacheResult != null) {
                    this.startCacheLoad(cacheResult);
                    return true;
                }
                this.mListener.error(-14, ((Object)this.mListener.getContext().getText(EventHandler.errorStringResources[Math.abs(-14)])).toString());
                return true;
            }
            case 1: {
                CacheManager.CacheResult cacheResult = CacheManager.getCacheFile((String)this.mListener.url(), (long)this.mListener.postIdentifier(), null);
                if (cacheResult == null) return false;
                this.startCacheLoad(cacheResult);
                return true;
            }
            case 2: 
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean handleLocalFile(String string2, LoadListener loadListener, WebSettings webSettings) {
        String string3;
        block14: {
            try {
                string3 = new String(URLUtil.decode(string2.getBytes()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                loadListener.error(-12, loadListener.getContext().getString(17039367));
                return true;
            }
            if (!URLUtil.isAssetUrl(string3)) break block14;
            if (loadListener.isSynchronous()) {
                new FileLoader(string3, loadListener, 1, true).load();
                return true;
            }
            WebViewWorker.getHandler().obtainMessage(101, new FileLoader(string3, loadListener, 1, true)).sendToTarget();
            return true;
        }
        if (URLUtil.isResourceUrl((String)string3)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(string3, loadListener, 2, true).load();
                return true;
            }
            WebViewWorker.getHandler().obtainMessage(101, new FileLoader(string3, loadListener, 2, true)).sendToTarget();
            return true;
        }
        if (URLUtil.isFileUrl(string3)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(string3, loadListener, 3, webSettings.getAllowFileAccess()).load();
                return true;
            }
            WebViewWorker.getHandler().obtainMessage(101, new FileLoader(string3, loadListener, 3, webSettings.getAllowFileAccess())).sendToTarget();
            return true;
        }
        if (URLUtil.isContentUrl(string3)) {
            if (loadListener.isSynchronous()) {
                new ContentLoader(loadListener.url(), loadListener).load();
                return true;
            }
            WebViewWorker.getHandler().obtainMessage(101, new ContentLoader(loadListener.url(), loadListener)).sendToTarget();
            return true;
        }
        if (URLUtil.isDataUrl(string3)) {
            new DataLoader(string3, loadListener).load();
            return true;
        }
        if (!URLUtil.isAboutUrl(string3)) return false;
        loadListener.data(mAboutBlank.getBytes(), mAboutBlank.length());
        loadListener.endData();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void populateHeaders() {
        String string2;
        if (this.mReferrer != null) {
            this.mHeaders.put("Referer", this.mReferrer);
        }
        if (this.mContentType != null) {
            this.mHeaders.put(CONTENT_TYPE, this.mContentType);
        }
        if (this.mNetwork.isValidProxySet()) {
            Network network = this.mNetwork;
            // MONITORENTER : network
            String string3 = this.mNetwork.getProxyUsername();
            String string4 = this.mNetwork.getProxyPassword();
            // MONITOREXIT : network
            if (string3 != null && string4 != null) {
                String string5 = RequestHandle.authorizationHeader(true);
                this.mHeaders.put(string5, "Basic " + RequestHandle.computeBasicAuthResponse(string3, string4));
            }
        }
        if ((string2 = CookieManager.getInstance().getCookie(this.mListener.getWebAddress())) == null) return;
        if (string2.length() <= 0) return;
        this.mHeaders.put("Cookie", string2);
    }

    private void populateStaticHeaders() {
        String string2 = this.mHeaders.get("Accept");
        if (string2 == null || string2.length() == 0) {
            this.mHeaders.put("Accept", HEADER_STR);
        }
        this.mHeaders.put("Accept-Charset", "utf-8, iso-8859-1, utf-16, *;q=0.7");
        String string3 = this.mSettings.getAcceptLanguage();
        if (string3.length() > 0) {
            this.mHeaders.put("Accept-Language", string3);
        }
        this.mHeaders.put("User-Agent", this.mSettings.getUserAgentString());
    }

    private void startCacheLoad(CacheManager.CacheResult cacheResult) {
        CacheLoader cacheLoader = new CacheLoader(this.mListener, cacheResult);
        this.mListener.setCacheLoader(cacheLoader);
        if (this.mListener.isSynchronous()) {
            cacheLoader.load();
            return;
        }
        WebViewWorker.getHandler().obtainMessage(101, cacheLoader).sendToTarget();
    }

    public boolean executeLoad() {
        String string2 = this.mListener.url();
        if (URLUtil.isNetworkUrl(string2)) {
            if (this.mSettings.getBlockNetworkLoads()) {
                this.mListener.error(-12, this.mListener.getContext().getString(17039367));
                return false;
            }
            if (!URLUtil.verifyURLEncoding((String)this.mListener.host())) {
                this.mListener.error(-12, this.mListener.getContext().getString(17039367));
                return false;
            }
            this.mNetwork = Network.getInstance(this.mListener.getContext());
            if (this.mListener.isSynchronous()) {
                return this.handleHTTPLoad();
            }
            WebViewWorker.getHandler().obtainMessage(102, this).sendToTarget();
            return true;
        }
        if (FrameLoader.handleLocalFile(string2, this.mListener, this.mSettings)) {
            return true;
        }
        this.mListener.error(-10, ((Object)this.mListener.getContext().getText(17039368)).toString());
        return false;
    }

    public LoadListener getLoadListener() {
        return this.mListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean handleHTTPLoad() {
        boolean bl;
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.populateStaticHeaders();
        this.populateHeaders();
        if (this.handleCache()) {
            this.mListener.setRequestData(this.mMethod, this.mHeaders, this.mPostData);
            return true;
        }
        int n = -10;
        try {
            boolean bl2;
            bl = bl2 = this.mNetwork.requestURL(this.mMethod, this.mHeaders, this.mPostData, this.mListener);
        }
        catch (ParseException parseException) {
            n = -12;
            bl = false;
        }
        catch (RuntimeException runtimeException) {
            n = -12;
            bl = false;
        }
        if (!bl) {
            this.mListener.error(n, ((Object)this.mListener.getContext().getText(EventHandler.errorStringResources[Math.abs(n)])).toString());
            return false;
        }
        return true;
    }

    public void setCacheMode(int n) {
        this.mCacheMode = n;
    }

    public void setContentTypeForPost(String string2) {
        this.mContentType = string2;
    }

    public void setHeaders(HashMap hashMap) {
        this.mHeaders = hashMap;
    }

    public void setPostData(byte[] byArray) {
        this.mPostData = byArray;
    }

    public void setReferrer(String string2) {
        if (URLUtil.isNetworkUrl(string2)) {
            this.mReferrer = string2;
        }
    }
}

