/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityThread;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;

final class GeolocationService
implements LocationListener {
    private static final String TAG = "geolocationService";
    private boolean mIsGpsEnabled;
    private boolean mIsGpsProviderAvailable;
    private boolean mIsNetworkProviderAvailable;
    private boolean mIsRunning;
    private LocationManager mLocationManager;
    private long mNativeObject;

    public GeolocationService(long l) {
        this.mNativeObject = l;
        this.mLocationManager = (LocationManager)((Context)ActivityThread.systemMain().getApplication()).getSystemService("location");
        if (this.mLocationManager == null) {
            Log.e(TAG, "Could not get location manager.");
        }
    }

    private void maybeReportError(String string2) {
        if (this.mIsRunning && !this.mIsNetworkProviderAvailable && !this.mIsGpsProviderAvailable) {
            GeolocationService.nativeNewErrorAvailable(this.mNativeObject, string2);
        }
    }

    private static native void nativeNewErrorAvailable(long var0, String var2);

    private static native void nativeNewLocationAvailable(long var0, Location var2);

    private void registerForLocationUpdates() {
        try {
            this.mLocationManager.requestLocationUpdates("network", 0L, 0.0f, this);
            this.mIsNetworkProviderAvailable = true;
            if (this.mIsGpsEnabled) {
                this.mLocationManager.requestLocationUpdates("gps", 0L, 0.0f, this);
                this.mIsGpsProviderAvailable = true;
            }
            return;
        }
        catch (SecurityException securityException) {
            Log.e(TAG, "Caught security exception registering for location updates from system. This should only happen in DumpRenderTree.");
            return;
        }
    }

    private void unregisterFromLocationUpdates() {
        this.mLocationManager.removeUpdates(this);
    }

    @Override
    public void onLocationChanged(Location location) {
        if (this.mIsRunning) {
            GeolocationService.nativeNewLocationAvailable(this.mNativeObject, location);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onProviderDisabled(String string2) {
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = false;
        } else if ("gps".equals(string2)) {
            this.mIsGpsProviderAvailable = false;
        }
        this.maybeReportError("The last location provider was disabled");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onProviderEnabled(String string2) {
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = true;
            return;
        } else {
            if (!"gps".equals(string2)) return;
            this.mIsGpsProviderAvailable = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onStatusChanged(String string2, int n, Bundle bundle) {
        boolean bl = n == 2;
        if ("network".equals(string2)) {
            this.mIsNetworkProviderAvailable = bl;
        } else if ("gps".equals(string2)) {
            this.mIsGpsProviderAvailable = bl;
        }
        this.maybeReportError("The last location provider is no longer available");
    }

    public void setEnableGps(boolean bl) {
        if (this.mIsGpsEnabled != bl) {
            this.mIsGpsEnabled = bl;
            if (this.mIsRunning) {
                this.unregisterFromLocationUpdates();
                this.registerForLocationUpdates();
            }
        }
    }

    public void start() {
        this.registerForLocationUpdates();
        this.mIsRunning = true;
    }

    public void stop() {
        this.unregisterFromLocationUpdates();
        this.mIsRunning = false;
    }
}

