/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

class HTML5Audio
extends Handler
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnSeekCompleteListener {
    private static int COMPLETE = 0;
    private static int ERROR = 0;
    private static int IDLE = 0;
    private static int INITIALIZED = 0;
    private static final String LOGTAG = "HTML5Audio";
    private static int PAUSED = 0;
    private static int PREPARED = 0;
    private static int STARTED = 0;
    private static int STOPPED = 0;
    private static final int TIMEUPDATE = 100;
    private static final int TIMEUPDATE_PERIOD = 250;
    private boolean mAskToPlay = false;
    private MediaPlayer mMediaPlayer;
    private int mNativePointer;
    private int mState = IDLE;
    private Timer mTimer;
    private String mUrl;

    static {
        IDLE = 0;
        INITIALIZED = 1;
        PREPARED = 2;
        STARTED = 4;
        COMPLETE = 5;
        PAUSED = 6;
        STOPPED = -2;
        ERROR = -1;
    }

    public HTML5Audio(int n) {
        this.mNativePointer = n;
        this.resetMediaPlayer();
    }

    private float getMaxTimeSeekable() {
        return (float)this.mMediaPlayer.getDuration() / 1000.0f;
    }

    private native void nativeOnBuffering(int var1, int var2);

    private native void nativeOnEnded(int var1);

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnTimeupdate(int var1, int var2);

    private void pause() {
        if (this.mState == STARTED) {
            if (this.mTimer != null) {
                this.mTimer.purge();
            }
            this.mMediaPlayer.pause();
            this.mState = PAUSED;
        }
    }

    private void play() {
        if ((this.mState == ERROR || this.mState == IDLE) && this.mUrl != null) {
            this.resetMediaPlayer();
            this.setDataSource(this.mUrl);
            this.mAskToPlay = true;
        }
        if (this.mState >= PREPARED) {
            this.mMediaPlayer.start();
            this.mState = STARTED;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resetMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
        } else {
            this.mMediaPlayer.reset();
        }
        this.mMediaPlayer.setOnBufferingUpdateListener(this);
        this.mMediaPlayer.setOnCompletionListener(this);
        this.mMediaPlayer.setOnErrorListener(this);
        this.mMediaPlayer.setOnPreparedListener(this);
        this.mMediaPlayer.setOnSeekCompleteListener(this);
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mState = IDLE;
    }

    private void seek(int n) {
        if (this.mState >= PREPARED) {
            this.mMediaPlayer.seekTo(n);
        }
    }

    private void setDataSource(String string2) {
        this.mUrl = string2;
        try {
            if (this.mState != IDLE) {
                this.resetMediaPlayer();
            }
            this.mMediaPlayer.setDataSource(string2);
            this.mState = INITIALIZED;
            this.mMediaPlayer.prepareAsync();
            return;
        }
        catch (IOException iOException) {
            Log.e(LOGTAG, "couldn't load the resource: " + string2 + " exc: " + iOException);
            this.resetMediaPlayer();
            return;
        }
    }

    private void teardown() {
        this.mMediaPlayer.release();
        this.mState = ERROR;
        this.mNativePointer = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 100: {
                try {
                    if (this.mState == ERROR || !this.mMediaPlayer.isPlaying()) return;
                    this.nativeOnTimeupdate(this.mMediaPlayer.getCurrentPosition(), this.mNativePointer);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    this.mState = ERROR;
                    return;
                }
            }
        }
    }

    @Override
    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.nativeOnBuffering(n, this.mNativePointer);
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        this.resetMediaPlayer();
        this.mState = IDLE;
        this.nativeOnEnded(this.mNativePointer);
    }

    @Override
    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        this.mState = ERROR;
        this.resetMediaPlayer();
        this.mState = IDLE;
        return false;
    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        this.mState = PREPARED;
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new TimeupdateTask(), 250L, 250L);
        }
        this.nativeOnPrepared(mediaPlayer.getDuration(), 0, 0, this.mNativePointer);
        if (this.mAskToPlay) {
            this.mAskToPlay = false;
            this.play();
        }
    }

    @Override
    public void onSeekComplete(MediaPlayer mediaPlayer) {
        this.nativeOnTimeupdate(mediaPlayer.getCurrentPosition(), this.mNativePointer);
    }

    private final class TimeupdateTask
    extends TimerTask {
        private TimeupdateTask() {
        }

        @Override
        public void run() {
            HTML5Audio.this.obtainMessage(100).sendToTarget();
        }
    }
}

