/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.VideoView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class HTML5VideoViewProxy
extends Handler
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static final String COOKIE = "Cookie";
    private static final int ENDED = 201;
    private static final int ERROR = 103;
    private static final int LOAD_DEFAULT_POSTER = 104;
    private static final String LOGTAG = "HTML5VideoViewProxy";
    private static final int PAUSE = 102;
    private static final int PAUSED = 203;
    private static final int PLAY = 100;
    private static final int POSTER_FETCHED = 202;
    private static final int PREPARED = 200;
    private static final int SEEK = 101;
    private static final int TIMEUPDATE = 300;
    int mNativePointer;
    private Bitmap mPoster;
    private PosterDownloader mPosterDownloader;
    private int mSeekPosition;
    private Handler mWebCoreHandler;
    private WebView mWebView;

    private HTML5VideoViewProxy(WebView webView, int n) {
        super(Looper.getMainLooper());
        this.mWebView = webView;
        this.mNativePointer = n;
        this.createWebCoreHandler();
    }

    private void createWebCoreHandler() {
        this.mWebCoreHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 200: {
                        Map map = (Map)message.obj;
                        Integer n = (Integer)map.get("dur");
                        Integer n2 = (Integer)map.get("width");
                        Integer n3 = (Integer)map.get("height");
                        HTML5VideoViewProxy.this.nativeOnPrepared(n, n2, n3, HTML5VideoViewProxy.this.mNativePointer);
                        return;
                    }
                    case 201: {
                        HTML5VideoViewProxy.this.nativeOnEnded(HTML5VideoViewProxy.this.mNativePointer);
                        return;
                    }
                    case 203: {
                        HTML5VideoViewProxy.this.nativeOnPaused(HTML5VideoViewProxy.this.mNativePointer);
                        return;
                    }
                    case 202: {
                        Bitmap bitmap = (Bitmap)message.obj;
                        HTML5VideoViewProxy.this.nativeOnPosterFetched(bitmap, HTML5VideoViewProxy.this.mNativePointer);
                        return;
                    }
                    case 300: 
                }
                HTML5VideoViewProxy.this.nativeOnTimeupdate(message.arg1, HTML5VideoViewProxy.this.mNativePointer);
            }
        };
    }

    private void doSetPoster(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.mPoster = bitmap;
        Message message = Message.obtain(this.mWebCoreHandler, 202);
        message.obj = bitmap;
        this.mWebCoreHandler.sendMessage(message);
    }

    public static HTML5VideoViewProxy getInstance(WebViewCore webViewCore, int n) {
        return new HTML5VideoViewProxy(webViewCore.getWebView(), n);
    }

    private native void nativeOnEnded(int var1);

    private native void nativeOnPaused(int var1);

    private native void nativeOnPosterFetched(Bitmap var1, int var2);

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnTimeupdate(int var1, int var2);

    private void sendTimeupdate() {
        Message message = Message.obtain(this.mWebCoreHandler, 300);
        message.arg1 = VideoPlayer.getCurrentPosition();
        this.mWebCoreHandler.sendMessage(message);
    }

    public void dispatchOnEnded() {
        Message message = Message.obtain(this.mWebCoreHandler, 201);
        this.mWebCoreHandler.sendMessage(message);
    }

    public void dispatchOnPaused() {
        Message message = Message.obtain(this.mWebCoreHandler, 203);
        this.mWebCoreHandler.sendMessage(message);
    }

    public Context getContext() {
        return this.mWebView.getContext();
    }

    WebView getWebView() {
        return this.mWebView;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 100: {
                String string2 = (String)message.obj;
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) return;
                VideoPlayer.play(string2, this.mSeekPosition, this, webChromeClient);
                return;
            }
            case 101: {
                this.mSeekPosition = (Integer)message.obj;
                VideoPlayer.seek(this.mSeekPosition, this);
                return;
            }
            case 102: {
                VideoPlayer.pause(this);
                return;
            }
            case 201: {
                if (message.arg1 == 1) {
                    VideoPlayer.isVideoSelfEnded = true;
                }
            }
            case 103: {
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) return;
                webChromeClient.onHideCustomView();
                return;
            }
            case 104: {
                WebChromeClient webChromeClient = this.mWebView.getWebChromeClient();
                if (webChromeClient == null) return;
                this.doSetPoster(webChromeClient.getDefaultVideoPoster());
                return;
            }
            default: {
                return;
            }
            case 300: 
        }
        if (!VideoPlayer.isPlaying(this)) return;
        this.sendTimeupdate();
    }

    public void loadPoster(String string2) {
        if (string2 == null) {
            this.sendMessage(this.obtainMessage(104));
            return;
        }
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mPosterDownloader = new PosterDownloader(string2, this);
        this.mPosterDownloader.start();
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        this.sendMessage(this.obtainMessage(201, 1, 0));
    }

    @Override
    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        this.sendMessage(this.obtainMessage(103));
        return false;
    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        VideoPlayer.onPrepared();
        Message message = Message.obtain(this.mWebCoreHandler, 200);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("dur", new Integer(mediaPlayer.getDuration()));
        hashMap.put("width", new Integer(mediaPlayer.getVideoWidth()));
        hashMap.put("height", new Integer(mediaPlayer.getVideoHeight()));
        message.obj = hashMap;
        this.mWebCoreHandler.sendMessage(message);
    }

    public void onTimeupdate() {
        this.sendMessage(this.obtainMessage(300));
    }

    public void pause() {
        this.sendMessage(this.obtainMessage(102));
    }

    public void play(String string2) {
        if (string2 == null) {
            return;
        }
        Message message = this.obtainMessage(100);
        message.obj = string2;
        this.sendMessage(message);
    }

    public void seek(int n) {
        Message message = this.obtainMessage(101);
        message.obj = new Integer(n);
        this.sendMessage(message);
    }

    public void teardown() {
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mNativePointer = 0;
    }

    private static final class PosterDownloader
    implements EventHandler {
        private static int mQueueRefCount = 0;
        private static RequestQueue mRequestQueue;
        private Handler mHandler;
        private Headers mHeaders;
        private ByteArrayOutputStream mPosterBytes;
        private final HTML5VideoViewProxy mProxy;
        private RequestHandle mRequestHandle;
        private int mStatusCode;
        private String mUrl;

        public PosterDownloader(String string2, HTML5VideoViewProxy hTML5VideoViewProxy) {
            this.mUrl = string2;
            this.mProxy = hTML5VideoViewProxy;
            this.mHandler = new Handler();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void cleanup() {
            if (this.mPosterBytes == null) return;
            try {
                this.mPosterBytes.close();
lbl4:
                // 2 sources

                while (true) {
                    this.mPosterBytes = null;
                    return;
                }
            }
            catch (Throwable var2_1) {
                this.mPosterBytes = null;
                throw var2_1;
            }
            catch (IOException var1_2) {
                ** continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void releaseQueue() {
            block3: {
                block2: {
                    int n;
                    if (mQueueRefCount == 0) break block2;
                    mQueueRefCount = n = mQueueRefCount - 1;
                    if (n == 0) break block3;
                }
                return;
            }
            mRequestQueue.shutdown();
            mRequestQueue = null;
        }

        private void retainQueue() {
            if (mRequestQueue == null) {
                mRequestQueue = new RequestQueue(this.mProxy.getContext());
            }
            mQueueRefCount = 1 + mQueueRefCount;
        }

        public void cancelAndReleaseQueue() {
            if (this.mRequestHandle != null) {
                this.mRequestHandle.cancel();
                this.mRequestHandle = null;
            }
            this.releaseQueue();
        }

        @Override
        public void certificate(SslCertificate sslCertificate) {
        }

        @Override
        public void data(byte[] byArray, int n) {
            if (this.mPosterBytes == null) {
                this.mPosterBytes = new ByteArrayOutputStream();
            }
            this.mPosterBytes.write(byArray, 0, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void endData() {
            if (this.mStatusCode == 200) {
                if (this.mPosterBytes.size() > 0) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray(this.mPosterBytes.toByteArray(), 0, this.mPosterBytes.size());
                    this.mProxy.doSetPoster(bitmap);
                }
                this.cleanup();
                return;
            } else {
                if (this.mStatusCode < 300 || this.mStatusCode >= 400) return;
                this.mUrl = this.mHeaders.getLocation();
                if (this.mUrl == null) return;
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PosterDownloader.this.mRequestHandle != null) {
                            PosterDownloader.this.mRequestHandle.setupRedirect(PosterDownloader.this.mUrl, PosterDownloader.this.mStatusCode, new HashMap<String, String>());
                        }
                    }
                });
                return;
            }
        }

        @Override
        public void error(int n, String string2) {
            this.cleanup();
        }

        @Override
        public boolean handleSslErrorRequest(SslError sslError) {
            return false;
        }

        @Override
        public void headers(Headers headers) {
            this.mHeaders = headers;
        }

        public void start() {
            this.retainQueue();
            this.mRequestHandle = mRequestQueue.queueRequest(this.mUrl, "GET", null, this, null, 0);
        }

        @Override
        public void status(int n, int n2, int n3, String string2) {
            this.mStatusCode = n3;
        }
    }

    private static final class VideoPlayer {
        private static final int TIMEUPDATE_PERIOD = 250;
        static boolean isVideoSelfEnded = false;
        private static final WebChromeClient.CustomViewCallback mCallback = new WebChromeClient.CustomViewCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onCustomViewHidden() {
                mTimer.cancel();
                VideoPlayer.access$002(null);
                if (mVideoView.isPlaying()) {
                    mVideoView.stopPlayback();
                }
                if (isVideoSelfEnded) {
                    mCurrentProxy.dispatchOnEnded();
                } else {
                    mCurrentProxy.dispatchOnPaused();
                }
                mCurrentProxy.getWebView().getViewManager().showAll();
                isVideoSelfEnded = false;
                VideoPlayer.access$202(null);
                mLayout.removeView(mVideoView);
                VideoPlayer.access$102(null);
                if (mProgressView != null) {
                    mLayout.removeView(mProgressView);
                    VideoPlayer.access$402(null);
                }
                VideoPlayer.access$302(null);
            }
        };
        private static HTML5VideoViewProxy mCurrentProxy;
        private static FrameLayout mLayout;
        private static View mProgressView;
        private static Timer mTimer;
        private static VideoView mVideoView;

        private VideoPlayer() {
        }

        static /* synthetic */ Timer access$002(Timer timer) {
            mTimer = timer;
            return timer;
        }

        static /* synthetic */ VideoView access$102(VideoView videoView) {
            mVideoView = videoView;
            return videoView;
        }

        static /* synthetic */ HTML5VideoViewProxy access$202(HTML5VideoViewProxy hTML5VideoViewProxy) {
            mCurrentProxy = hTML5VideoViewProxy;
            return hTML5VideoViewProxy;
        }

        static /* synthetic */ FrameLayout access$302(FrameLayout frameLayout) {
            mLayout = frameLayout;
            return frameLayout;
        }

        static /* synthetic */ View access$402(View view) {
            mProgressView = view;
            return view;
        }

        public static int getCurrentPosition() {
            VideoView videoView = mVideoView;
            int n = 0;
            if (videoView != null) {
                n = mVideoView.getCurrentPosition();
            }
            return n;
        }

        public static boolean isPlaying(HTML5VideoViewProxy hTML5VideoViewProxy) {
            return mCurrentProxy == hTML5VideoViewProxy && mVideoView != null && mVideoView.isPlaying();
        }

        public static void onPrepared() {
            if (mProgressView == null || mLayout == null) {
                return;
            }
            mTimer.schedule((TimerTask)new TimeupdateTask(mCurrentProxy), 250L, 250L);
            mProgressView.setVisibility(8);
            mLayout.removeView(mProgressView);
            mProgressView = null;
        }

        public static void pause(HTML5VideoViewProxy hTML5VideoViewProxy) {
            if (mCurrentProxy == hTML5VideoViewProxy && mVideoView != null) {
                mVideoView.pause();
                mTimer.purge();
            }
        }

        public static void play(String string2, int n, HTML5VideoViewProxy hTML5VideoViewProxy, WebChromeClient webChromeClient) {
            if (mCurrentProxy == hTML5VideoViewProxy) {
                if (!mVideoView.isPlaying()) {
                    mVideoView.start();
                }
                return;
            }
            if (mCurrentProxy != null) {
                hTML5VideoViewProxy.dispatchOnEnded();
                return;
            }
            mCurrentProxy = hTML5VideoViewProxy;
            mLayout = new FrameLayout(hTML5VideoViewProxy.getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            mVideoView = new VideoView(hTML5VideoViewProxy.getContext());
            mVideoView.setWillNotDraw(false);
            mVideoView.setMediaController(new MediaController(hTML5VideoViewProxy.getContext()));
            String string3 = CookieManager.getInstance().getCookie(string2);
            HashMap<String, String> hashMap = null;
            if (string3 != null) {
                hashMap = new HashMap<String, String>();
                hashMap.put(HTML5VideoViewProxy.COOKIE, string3);
            }
            mVideoView.setVideoURI(Uri.parse(string2), hashMap);
            mVideoView.setOnCompletionListener(hTML5VideoViewProxy);
            mVideoView.setOnPreparedListener(hTML5VideoViewProxy);
            mVideoView.setOnErrorListener(hTML5VideoViewProxy);
            mVideoView.seekTo(n);
            mLayout.addView((View)mVideoView, layoutParams);
            mProgressView = webChromeClient.getVideoLoadingProgressView();
            if (mProgressView != null) {
                mLayout.addView(mProgressView, layoutParams);
                mProgressView.setVisibility(0);
            }
            mLayout.setVisibility(0);
            mTimer = new Timer();
            mVideoView.start();
            webChromeClient.onShowCustomView(mLayout, mCallback);
            mCurrentProxy.getWebView().getViewManager().hideAll();
        }

        public static void seek(int n, HTML5VideoViewProxy hTML5VideoViewProxy) {
            if (mCurrentProxy == hTML5VideoViewProxy && n >= 0 && mVideoView != null) {
                mVideoView.seekTo(n);
            }
        }

        private static final class TimeupdateTask
        extends TimerTask {
            private HTML5VideoViewProxy mProxy;

            public TimeupdateTask(HTML5VideoViewProxy hTML5VideoViewProxy) {
                this.mProxy = hTML5VideoViewProxy;
            }

            @Override
            public void run() {
                this.mProxy.onTimeupdate();
            }
        }
    }
}

