/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.CertTool;
import android.webkit.CookieManager;
import android.webkit.PerfChecker;
import android.webkit.PluginManager;
import android.webkit.WebView;
import java.lang.ref.WeakReference;
import java.util.Set;

final class JWebCoreJavaBridge
extends Handler {
    private static final int FUNCPTR_MESSAGE = 2;
    private static final String LOGTAG = "webkit-timers";
    static final int REFRESH_PLUGINS = 100;
    private static final int TIMER_MESSAGE = 1;
    private static WeakReference<WebView> sCurrentMainWebView = new WeakReference<Object>(null);
    private boolean mHasDeferredTimers;
    private boolean mHasInstantTimer;
    private int mNativeBridge;
    private int mPauseTimerRefCount;
    private boolean mTimerPaused;

    public JWebCoreJavaBridge() {
        this.nativeConstructor();
    }

    private String cookies(String string2) {
        return CookieManager.getInstance().getCookie(string2);
    }

    private boolean cookiesEnabled() {
        return CookieManager.getInstance().acceptCookie();
    }

    private void fireSharedTimer() {
        PerfChecker perfChecker = new PerfChecker();
        this.mHasInstantTimer = false;
        this.sharedTimerFired();
        perfChecker.responseAlert("sharedTimer");
    }

    private String[] getKeyStrengthList() {
        return CertTool.getKeyStrengthList();
    }

    private String[] getPluginDirectories() {
        return PluginManager.getInstance(null).getPluginDirectories();
    }

    private String getPluginSharedDataDirectory() {
        return PluginManager.getInstance(null).getPluginSharedDataDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSignedPublicKey(int n, String string2, String string3) {
        synchronized (this) {
            block5: {
                WebView webView = (WebView)sCurrentMainWebView.get();
                if (webView == null) break block5;
                String string4 = CertTool.getSignedPublicKey(webView.getContext(), n, string2);
                return string4;
            }
            Log.e(LOGTAG, "There is no active WebView for getSignedPublicKey");
            return "";
        }
    }

    private native void nativeConstructor();

    private native void nativeFinalize();

    private native void nativeServiceFuncPtrQueue();

    private native void nativeUpdatePluginDirectories(String[] var1, boolean var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeActiveWebView(WebView webView) {
        synchronized (JWebCoreJavaBridge.class) {
            block6: {
                Object t = sCurrentMainWebView.get();
                if (t == webView) break block6;
                return;
            }
            sCurrentMainWebView.clear();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setActiveWebView(WebView webView) {
        synchronized (JWebCoreJavaBridge.class) {
            block6: {
                Object t = sCurrentMainWebView.get();
                if (t == null) break block6;
                return;
            }
            sCurrentMainWebView = new WeakReference<WebView>(webView);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCookies(String string2, String string3) {
        if (string3.contains("\r") || string3.contains("\n")) {
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = 0;
            while (n2 != -1 && n2 < n) {
                int n3 = string3.indexOf(13, n2);
                int n4 = string3.indexOf(10, n2);
                int n5 = n3 == -1 ? n4 : (n4 == -1 ? n3 : (n3 < n4 ? n3 : n4));
                if (n5 > n2) {
                    stringBuilder.append(string3.subSequence(n2, n5));
                } else if (n5 == -1) {
                    stringBuilder.append(string3.subSequence(n2, n));
                    break;
                }
                n2 = n5 + 1;
            }
            string3 = stringBuilder.toString();
        }
        CookieManager.getInstance().setCookie(string2, string3);
    }

    private void setSharedTimer(long l) {
        if (l <= 0L) {
            if (this.mHasInstantTimer) {
                return;
            }
            this.mHasInstantTimer = true;
            this.sendMessageDelayed(this.obtainMessage(1), l);
            return;
        }
        this.sendMessageDelayed(this.obtainMessage(1), l);
    }

    private native void sharedTimerFired();

    private void signalServiceFuncPtrQueue() {
        this.sendMessage(this.obtainMessage(2));
    }

    private void stopSharedTimer() {
        this.removeMessages(1);
        this.mHasInstantTimer = false;
        this.mHasDeferredTimers = false;
    }

    public native void addPackageName(String var1);

    public native void addPackageNames(Set<String> var1);

    protected void finalize() {
        this.nativeFinalize();
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                return;
            }
            case 1: {
                if (this.mTimerPaused) {
                    this.mHasDeferredTimers = true;
                    return;
                }
                this.fireSharedTimer();
                return;
            }
            case 2: {
                this.nativeServiceFuncPtrQueue();
                return;
            }
            case 100: 
        }
        this.nativeUpdatePluginDirectories(PluginManager.getInstance(null).getPluginDirectories(), (Boolean)message.obj);
    }

    public void pause() {
        int n;
        this.mPauseTimerRefCount = n = this.mPauseTimerRefCount - 1;
        if (n == 0) {
            this.mTimerPaused = true;
            this.mHasDeferredTimers = false;
        }
    }

    public native void removePackageName(String var1);

    public void resume() {
        int n;
        this.mPauseTimerRefCount = n = 1 + this.mPauseTimerRefCount;
        if (n == 1) {
            this.mTimerPaused = false;
            if (this.mHasDeferredTimers) {
                this.mHasDeferredTimers = false;
                this.fireSharedTimer();
            }
        }
    }

    public native void setCacheSize(int var1);

    public native void setNetworkOnLine(boolean var1);

    public native void setNetworkType(String var1, String var2);
}

