/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.HttpAuthHeader;
import android.net.http.RequestHandle;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.BrowserFrame;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.CertTool;
import android.webkit.CookieManager;
import android.webkit.HttpAuthHandler;
import android.webkit.MimeTypeMap;
import android.webkit.Network;
import android.webkit.PerfChecker;
import android.webkit.URLUtil;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LoadListener
extends Handler
implements EventHandler {
    private static final Pattern CONTENT_TYPE_PATTERN;
    private static final int HTTP_AUTH = 401;
    private static final int HTTP_FOUND = 302;
    private static final int HTTP_MOVED_PERMANENTLY = 301;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_NOT_MODIFIED = 304;
    private static final int HTTP_OK = 200;
    private static final int HTTP_PARTIAL_CONTENT = 206;
    private static final int HTTP_PROXY_AUTH = 407;
    private static final int HTTP_SEE_OTHER = 303;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String LOGTAG = "webkit";
    private static final int MSG_CONTENT_DATA = 110;
    private static final int MSG_CONTENT_ERROR = 130;
    private static final int MSG_CONTENT_FINISHED = 120;
    private static final int MSG_CONTENT_HEADERS = 100;
    private static final int MSG_LOCATION_CHANGED = 140;
    private static final int MSG_LOCATION_CHANGED_REQUEST = 150;
    private static final int MSG_SSL_CERTIFICATE = 170;
    private static final int MSG_SSL_ERROR = 180;
    private static final int MSG_STATUS = 160;
    private static final String XML_MIME_TYPE = "^[\\w_\\-+~!$\\^{}|.%'`#&*]+/[\\w_\\-+~!$\\^{}|.%'`#&*]+\\+xml$";
    private static HashMap<String, String> sCertificateTypeMap;
    private static int sNativeLoaderCount;
    private boolean mAuthFailed;
    private HttpAuthHeader mAuthHeader;
    private BrowserFrame mBrowserFrame;
    private CacheLoader mCacheLoader;
    private int mCacheRedirectCount;
    private boolean mCancelled;
    public long mContentLength;
    private Context mContext;
    private final ByteArrayBuilder mDataBuilder = new ByteArrayBuilder();
    private String mEncoding;
    private String mErrorDescription;
    private int mErrorID = 0;
    private boolean mFromCache = false;
    private Headers mHeaders;
    private boolean mIsMainPageLoader;
    private final boolean mIsMainResourceLoader;
    private Vector<Message> mMessageQueue;
    private String mMethod;
    private String mMimeType;
    private int mNativeLoader;
    private String mOriginalUrl;
    private final String mPassword;
    private boolean mPermanent;
    private byte[] mPostData;
    private long mPostIdentifier;
    private RequestHandle mRequestHandle;
    private Map<String, String> mRequestHeaders;
    private SslError mSslError;
    private RequestHandle mSslErrorRequestHandle;
    private int mStatusCode;
    private String mStatusText;
    private boolean mSynchronous;
    private String mTransferEncoding;
    private WebAddress mUri;
    private String mUrl;
    private final boolean mUserGesture;
    private final String mUsername;

    static {
        sCertificateTypeMap = new HashMap();
        sCertificateTypeMap.put("application/x-x509-ca-cert", "CERT");
        sCertificateTypeMap.put("application/x-x509-user-cert", "CERT");
        sCertificateTypeMap.put("application/x-pkcs12", "PKCS12");
        CONTENT_TYPE_PATTERN = Pattern.compile("^((?:[xX]-)?[a-zA-Z\\*]+/[\\w\\+\\*-]+[\\.[\\w\\+-]+]*)$");
    }

    LoadListener(Context context, BrowserFrame browserFrame, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, String string3, String string4) {
        this.mContext = context;
        this.mBrowserFrame = browserFrame;
        this.setUrl(string2);
        this.mNativeLoader = n;
        this.mSynchronous = bl;
        if (bl) {
            this.mMessageQueue = new Vector();
        }
        this.mIsMainPageLoader = bl2;
        this.mIsMainResourceLoader = bl3;
        this.mUserGesture = bl4;
        this.mPostIdentifier = l;
        this.mUsername = string3;
        this.mPassword = string4;
    }

    private void clearNativeLoader() {
        --sNativeLoaderCount;
        this.mNativeLoader = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void commitHeaders() {
        if (this.mIsMainPageLoader && sCertificateTypeMap.containsKey(this.mMimeType) || this.mAuthHeader != null) {
            return;
        }
        this.nativeReceivedResponse(this.createNativeResponse());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void commitHeadersCheckRedirect() {
        if (this.mCancelled || this.mStatusCode >= 301 && this.mStatusCode <= 303 || this.mStatusCode == 307 || this.mStatusCode == 304 && this.mCacheLoader != null) {
            return;
        }
        this.commitHeaders();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitLoad() {
        if (!this.mCancelled) {
            ByteArrayBuilder.Chunk chunk;
            PerfChecker perfChecker;
            String string2;
            if (!this.mIsMainPageLoader || (string2 = sCertificateTypeMap.get(this.mMimeType)) == null) {
                perfChecker = new PerfChecker();
            } else {
                ByteArrayBuilder byteArrayBuilder = this.mDataBuilder;
                synchronized (byteArrayBuilder) {
                    byte[] byArray = new byte[this.mDataBuilder.getByteSize()];
                    int n = 0;
                    while (true) {
                        ByteArrayBuilder.Chunk chunk2;
                        if ((chunk2 = this.mDataBuilder.getFirstChunk()) == null) {
                            CertTool.addCertificate(this.mContext, string2, byArray);
                            this.mBrowserFrame.stopLoading();
                            return;
                        }
                        if (chunk2.mLength != 0) {
                            System.arraycopy(chunk2.mArray, 0, byArray, n, chunk2.mLength);
                            n += chunk2.mLength;
                        }
                        chunk2.release();
                    }
                }
            }
            while ((chunk = this.mDataBuilder.getFirstChunk()) != null) {
                if (chunk.mLength != 0) {
                    this.nativeAddData(chunk.mArray, chunk.mLength);
                    WebViewWorker.CacheData cacheData = new WebViewWorker.CacheData();
                    cacheData.mListener = this;
                    cacheData.mChunk = chunk;
                    WebViewWorker.getHandler().obtainMessage(105, cacheData).sendToTarget();
                } else {
                    chunk.release();
                }
                perfChecker.responseAlert("res nativeAddData");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int createNativeResponse() {
        int n = this.mStatusCode == 304 && this.mCacheLoader != null ? 200 : this.mStatusCode;
        final int n2 = this.nativeCreateResponse(this.originalUrl(), n, this.mStatusText, this.mMimeType, this.mContentLength, this.mEncoding);
        if (this.mHeaders != null) {
            this.mHeaders.getHeaders(new Headers.HeaderCallback(){

                @Override
                public void header(String string2, String string3) {
                    LoadListener.this.nativeSetResponseHeader(n2, string2, string3);
                }
            });
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRedirect() {
        if (this.mCancelled) return;
        if (this.mCacheRedirectCount >= 16) {
            this.handleError(-9, this.mContext.getString(17039619));
            return;
        }
        String string2 = this.mHeaders.getLocation();
        if (string2 == null) {
            this.commitHeaders();
            this.commitLoad();
            this.tearDown();
            return;
        }
        int n = this.createNativeResponse();
        String string3 = this.nativeRedirectedToUrl(this.mUrl, string2, n);
        if (this.mCancelled) return;
        if (string3 == null) {
            Log.d(LOGTAG, "Redirection failed for " + this.mHeaders.getLocation());
            this.cancel();
            return;
        }
        if (!URLUtil.isNetworkUrl(string3)) {
            String string4 = this.mContext.getString(17040064) + "\n" + string3;
            this.nativeAddData(string4.getBytes(), string4.length());
            this.nativeFinished();
            this.clearNativeLoader();
            return;
        }
        if (this.getErrorID() == 0) {
            WebViewWorker.CacheSaveData cacheSaveData = new WebViewWorker.CacheSaveData();
            cacheSaveData.mListener = this;
            cacheSaveData.mUrl = this.mUrl;
            cacheSaveData.mPostId = this.mPostIdentifier;
            WebViewWorker.getHandler().obtainMessage(106, cacheSaveData).sendToTarget();
        } else {
            WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        }
        this.mOriginalUrl = string3;
        this.setUrl(string3);
        if (this.mRequestHeaders == null) {
            this.mRequestHeaders = new HashMap<String, String>();
        }
        CacheLoader cacheLoader = this.mCacheLoader;
        boolean bl = false;
        if (cacheLoader != null) {
            this.mCacheRedirectCount = 1 + this.mCacheRedirectCount;
            bl = true;
        }
        if (!this.checkCache(this.mRequestHeaders)) {
            if (this.mRequestHandle != null) {
                try {
                    this.mRequestHandle.setupRedirect(this.mUrl, this.mStatusCode, this.mRequestHeaders);
                }
                catch (RuntimeException runtimeException) {
                    Log.e(LOGTAG, runtimeException.getMessage());
                    this.handleError(-12, this.mContext.getString(17039367));
                    return;
                }
            } else if (!Network.getInstance(this.getContext()).requestURL(this.mMethod, this.mRequestHeaders, this.mPostData, this)) {
                this.handleError(-12, this.mContext.getString(17039367));
                return;
            }
            if (!bl) return;
            this.mRequestHandle.setRedirectCount(this.mCacheRedirectCount);
            return;
        }
        if (bl) {
            return;
        }
        this.mCacheRedirectCount = 1 + this.mRequestHandle.getRedirectCount();
    }

    private String getErrorDescription() {
        return this.mErrorDescription;
    }

    private int getErrorID() {
        return this.mErrorID;
    }

    public static LoadListener getLoadListener(Context context, BrowserFrame browserFrame, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, String string3, String string4) {
        sNativeLoaderCount = 1 + sNativeLoaderCount;
        return new LoadListener(context, browserFrame, string2, n, bl, bl2, bl3, bl4, l, string3, string4);
    }

    public static int getNativeLoaderCount() {
        return sNativeLoaderCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void guessMimeType() {
        if (URLUtil.isDataUrl(this.mUrl) && this.mMimeType.length() != 0) {
            this.cancel();
            this.handleError(-12, this.mContext.getString(17039367));
            return;
        } else {
            this.mMimeType = "text/html";
            String string2 = this.guessMimeTypeFromExtension(this.mUrl);
            if (string2 == null) return;
            this.mMimeType = string2;
            return;
        }
    }

    private String guessMimeTypeFromExtension(String string2) {
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(string2));
    }

    private void handleCertificate(SslCertificate sslCertificate) {
        if (this.mIsMainPageLoader && this.mIsMainResourceLoader) {
            this.mBrowserFrame.certificate(sslCertificate);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleEndData() {
        if (this.mCancelled) {
            return;
        }
        switch (this.mStatusCode) lbl-1000:
        // 2 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    this.detachRequestHandle();
                    this.tearDown();
                    return;
                }
            }
            case 301: {
                this.mPermanent = true;
            }
            case 302: 
            case 303: 
            case 307: {
                if (this.mStatusCode == 307) {
                    if (this.mRequestHandle != null && this.mRequestHandle.getMethod().equals("POST")) {
                        this.sendMessageInternal(this.obtainMessage(150));
                        return;
                    }
                    if (this.mMethod != null && this.mMethod.equals("POST")) {
                        this.sendMessageInternal(this.obtainMessage(150));
                        return;
                    }
                    this.sendMessageInternal(this.obtainMessage(140));
                    return;
                }
                this.sendMessageInternal(this.obtainMessage(140));
                return;
            }
            case 401: 
            case 407: {
                if (this.mAuthHeader == null || !Network.getInstance(this.mContext).isValidProxySet() && this.mAuthHeader.isProxy()) ** GOTO lbl-1000
                if (!this.mAuthFailed && this.mUsername != null && this.mPassword != null) {
                    if (this.mAuthHeader.isProxy()) {
                        var1_1 = Network.getInstance(this.mContext).getProxyHostname();
lbl28:
                        // 2 sources

                        while (true) {
                            HttpAuthHandler.onReceivedCredentials((LoadListener)this, (String)var1_1, (String)this.mAuthHeader.getRealm(), (String)this.mUsername, (String)this.mPassword);
                            this.makeAuthResponse(this.mUsername, this.mPassword);
                            return;
                        }
                    }
                    var1_1 = this.mUri.mHost;
                    ** continue;
                }
                Network.getInstance(this.mContext).handleAuthRequest(this);
                return;
            }
            case 304: 
        }
        ** while (this.mCacheLoader == null)
lbl38:
        // 1 sources

        if (this.isSynchronous()) {
            this.mCacheLoader.load();
lbl40:
            // 2 sources

            while (true) {
                this.mFromCache = true;
                return;
            }
        }
        WebViewWorker.getHandler().obtainMessage(101, this.mCacheLoader).sendToTarget();
        ** while (true)
    }

    private void handleError(int n, String string2) {
        this.mErrorID = n;
        this.mErrorDescription = string2;
        this.detachRequestHandle();
        this.notifyError();
        this.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleHeaders(Headers headers) {
        block25: {
            block23: {
                block24: {
                    String string2;
                    if (this.mCancelled) {
                        return;
                    }
                    if (this.mStatusCode == 206) {
                        WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
                        return;
                    }
                    this.mHeaders = headers;
                    long l = headers.getContentLength();
                    this.mContentLength = l != -1L ? l : 0L;
                    String string3 = headers.getContentType();
                    if (string3 == null) break block23;
                    this.parseContentTypeHeader(string3);
                    if (!this.mMimeType.equals("text/plain") && !this.mMimeType.equals("application/octet-stream")) break block24;
                    String string4 = headers.getContentDisposition();
                    String string5 = null;
                    if (string4 != null) {
                        string5 = URLUtil.parseContentDisposition((String)string4);
                    }
                    if (string5 == null) {
                        string5 = this.mUrl;
                    }
                    if ((string2 = this.guessMimeTypeFromExtension(string5)) != null) {
                        this.mMimeType = string2;
                    }
                    break block25;
                }
                if (this.mMimeType.equals("text/vnd.wap.wml")) {
                    this.mMimeType = "text/plain";
                    break block25;
                } else if (this.mMimeType.equals("application/vnd.wap.xhtml+xml")) {
                    this.mMimeType = "application/xhtml+xml";
                }
                break block25;
            }
            this.guessMimeType();
        }
        if (this.mIsMainPageLoader && this.mIsMainResourceLoader && this.mUserGesture && Pattern.matches(XML_MIME_TYPE, this.mMimeType) && !this.mMimeType.equalsIgnoreCase("application/xhtml+xml")) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse(this.url()), this.mMimeType);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 65536);
            if (resolveInfo != null && !this.mContext.getPackageName().equals(resolveInfo.activityInfo.packageName)) {
                try {
                    this.mContext.startActivity(intent);
                    this.mBrowserFrame.stopLoading();
                    return;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        }
        boolean bl = this.mStatusCode == 401 || this.mStatusCode == 407;
        boolean bl2 = this.mStatusCode == 407;
        this.mAuthFailed = false;
        if (this.mAuthHeader != null) {
            Network network;
            boolean bl3;
            boolean bl4 = bl && bl2 == (bl3 = this.mAuthHeader.isProxy());
            this.mAuthFailed = bl4;
            if (!this.mAuthFailed && this.mAuthHeader.isProxy() && (network = Network.getInstance(this.mContext)).isValidProxySet()) {
                synchronized (network) {
                    network.setProxyUsername(this.mAuthHeader.getUsername());
                    network.setProxyPassword(this.mAuthHeader.getPassword());
                }
            }
        }
        this.mAuthHeader = null;
        if (bl) {
            if (this.mStatusCode == 401) {
                this.mAuthHeader = this.parseAuthHeader(headers.getWwwAuthenticate());
            } else {
                this.mAuthHeader = this.parseAuthHeader(headers.getProxyAuthenticate());
                if (this.mAuthHeader != null) {
                    this.mAuthHeader.setProxy();
                }
            }
        }
        if ((this.mStatusCode == 200 || this.mStatusCode == 302 || this.mStatusCode == 301 || this.mStatusCode == 307) && this.mNativeLoader != 0) {
            if (!(this.mFromCache || this.mRequestHandle == null || this.mRequestHandle.getMethod().equals("POST") && this.mPostIdentifier == 0L)) {
                WebViewWorker.CacheCreateData cacheCreateData = new WebViewWorker.CacheCreateData();
                cacheCreateData.mListener = this;
                cacheCreateData.mUrl = this.mUrl;
                cacheCreateData.mMimeType = this.mMimeType;
                cacheCreateData.mStatusCode = this.mStatusCode;
                cacheCreateData.mPostId = this.mPostIdentifier;
                cacheCreateData.mHeaders = headers;
                WebViewWorker.getHandler().obtainMessage(103, cacheCreateData).sendToTarget();
            }
            WebViewWorker.CacheEncoding cacheEncoding = new WebViewWorker.CacheEncoding();
            cacheEncoding.mEncoding = this.mEncoding;
            cacheEncoding.mListener = this;
            WebViewWorker.getHandler().obtainMessage(104, cacheEncoding).sendToTarget();
        }
        this.commitHeadersCheckRedirect();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleSslError(SslError sslError) {
        if (!this.mCancelled) {
            this.mSslError = sslError;
            Network.getInstance(this.mContext).handleSslErrorRequest(this);
        } else if (this.mSslErrorRequestHandle != null) {
            this.mSslErrorRequestHandle.handleSslErrorResponse(true);
        }
        this.mSslErrorRequestHandle = null;
    }

    private void handleStatus(int n, int n2, int n3, String string2) {
        if (this.mCancelled) {
            return;
        }
        this.mStatusCode = n3;
        this.mStatusText = string2;
        this.mPermanent = false;
    }

    private boolean ignoreCallbacks() {
        return this.mCancelled || this.mAuthHeader != null || this.mStatusCode > 300 && this.mStatusCode < 400 && this.mStatusCode != 305;
    }

    private native void nativeAddData(byte[] var1, int var2);

    private native int nativeCreateResponse(String var1, int var2, String var3, String var4, long var5, String var7);

    private native void nativeError(int var1, String var2, String var3);

    private native void nativeFinished();

    private native void nativeReceivedResponse(int var1);

    private native String nativeRedirectedToUrl(String var1, String var2, int var3);

    private native void nativeSetResponseHeader(int var1, String var2, String var3);

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private HttpAuthHeader parseAuthHeader(String string2) {
        if (string2 == null) return null;
        int[] nArray = new int[256];
        int n = string2.length();
        int n2 = 0;
        boolean bl = true;
        while (true) {
            int n3;
            int n4;
            int n5;
            block8: {
                block9: {
                    block5: {
                        block6: {
                            block10: {
                                boolean bl2;
                                block7: {
                                    block4: {
                                        if (!bl || (bl = false)) break block4;
                                        if (n <= 0) break block5;
                                        bl2 = false;
                                        n5 = 0;
                                        n4 = 0;
                                    }
                                    if (n5 >= n || n4 >= 256) break block6;
                                    if (string2.charAt(n5) != '\"') break block7;
                                    bl2 = !bl2;
                                    n3 = n4;
                                    break block8;
                                }
                                if (bl2) break block9;
                                if (!string2.regionMatches(true, n5, "Basic", 0, "Basic".length())) break block10;
                                n3 = n4 + 1;
                                nArray[n4] = n5;
                                break block8;
                            }
                            if (!string2.regionMatches(true, n5, "Digest", 0, "Digest".length())) break block9;
                            n3 = n4 + 1;
                            nArray[n4] = n5;
                            break block8;
                        }
                        n2 = n4;
                    }
                    if (n2 <= 0) return null;
                    break;
                }
                n3 = n4;
            }
            ++n5;
            n4 = n3;
        }
        for (int i = 0; i < n2; ++i) {
            int n6;
            int n7;
            HttpAuthHeader httpAuthHeader;
            if (!string2.regionMatches(true, nArray[i], "Digest", 0, "Digest".length()) || !(httpAuthHeader = new HttpAuthHeader(string2.substring(n7 = nArray[i], n6 = i + 1 < n2 ? nArray[i + 1] : n))).isSupportedScheme()) continue;
            return httpAuthHeader;
        }
        for (int i = 0; i < n2; ++i) {
            int n8;
            int n9;
            HttpAuthHeader httpAuthHeader;
            if (!string2.regionMatches(true, nArray[i], "Basic", 0, "Basic".length()) || !(httpAuthHeader = new HttpAuthHeader(string2.substring(n9 = nArray[i], n8 = i + 1 < n2 ? nArray[i + 1] : n))).isSupportedScheme()) continue;
            return httpAuthHeader;
        }
        return null;
    }

    private void sendMessageInternal(Message message) {
        if (this.mSynchronous) {
            this.mMessageQueue.add(message);
            return;
        }
        this.sendMessage(message);
    }

    static boolean willLoadFromCache(String string2, long l) {
        return CacheManager.getCacheFile((String)string2, (long)l, null) != null;
    }

    void attachRequestHandle(RequestHandle requestHandle) {
        this.mRequestHandle = requestHandle;
    }

    boolean authCredentialsInvalid() {
        return this.mAuthFailed && (!this.mAuthHeader.isDigest() || !this.mAuthHeader.getStale());
    }

    public void cancel() {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.cancel();
            this.mRequestHandle = null;
        }
        WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        this.mCancelled = true;
        this.clearNativeLoader();
    }

    public boolean cancelled() {
        return this.mCancelled;
    }

    @Override
    public void certificate(SslCertificate sslCertificate) {
        this.sendMessageInternal(this.obtainMessage(170, sslCertificate));
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean checkCache(Map<String, String> map) {
        CacheManager.CacheResult cacheResult = CacheManager.getCacheFile((String)this.url(), (long)this.mPostIdentifier, map);
        this.mCacheLoader = null;
        this.mFromCache = false;
        if (cacheResult != null) {
            this.mCacheLoader = new CacheLoader(this, cacheResult);
            if (!map.containsKey("if-none-match") && !map.containsKey("if-modified-since")) {
                if (this.isSynchronous()) {
                    this.mCacheLoader.load();
                } else {
                    WebViewWorker.getHandler().obtainMessage(101, this.mCacheLoader).sendToTarget();
                }
                this.mFromCache = true;
                return true;
            }
        }
        return false;
    }

    long contentLength() {
        return this.mContentLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void data(byte[] byArray, int n) {
        ByteArrayBuilder byteArrayBuilder = this.mDataBuilder;
        // MONITORENTER : byteArrayBuilder
        boolean bl = this.mDataBuilder.isEmpty();
        this.mDataBuilder.append(byArray, 0, n);
        // MONITOREXIT : byteArrayBuilder
        if (!bl) return;
        this.sendMessageInternal(this.obtainMessage(110));
    }

    void detachRequestHandle() {
        this.mRequestHandle = null;
    }

    void downloadFile() {
        WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        this.mBrowserFrame.getCallbackProxy().onDownloadStart(this.url(), this.mBrowserFrame.getUserAgentString(), this.mHeaders.getContentDisposition(), this.mMimeType, this.mContentLength);
        this.cancel();
    }

    @Override
    public void endData() {
        this.sendMessageInternal(this.obtainMessage(120));
    }

    @Override
    public void error(int n, String string2) {
        this.sendMessageInternal(this.obtainMessage(130, n, 0, string2));
    }

    Context getContext() {
        return this.mContext;
    }

    BrowserFrame getFrame() {
        return this.mBrowserFrame;
    }

    WebAddress getWebAddress() {
        return this.mUri;
    }

    void handleAuthResponse(String string2, String string3) {
        if (string2 != null && string3 != null) {
            this.makeAuthResponse(string2, string3);
            return;
        }
        this.commitLoad();
        this.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 100: {
                this.handleHeaders((Headers)message.obj);
                return;
            }
            case 110: {
                if (this.mNativeLoader != 0 && !this.ignoreCallbacks()) {
                    this.commitLoad();
                    return;
                }
            }
            default: {
                return;
            }
            case 120: {
                this.handleEndData();
                return;
            }
            case 130: {
                this.handleError(message.arg1, (String)message.obj);
                return;
            }
            case 140: {
                this.doRedirect();
                return;
            }
            case 150: {
                Message message2 = this.obtainMessage(140);
                Message message3 = this.obtainMessage(120);
                this.mBrowserFrame.getCallbackProxy().onFormResubmission(message3, message2);
                return;
            }
            case 160: {
                HashMap hashMap = (HashMap)message.obj;
                this.handleStatus((Integer)hashMap.get("major"), (Integer)hashMap.get("minor"), (Integer)hashMap.get("code"), (String)hashMap.get("reason"));
                return;
            }
            case 170: {
                this.handleCertificate((SslCertificate)message.obj);
                return;
            }
            case 180: 
        }
        this.handleSslError((SslError)message.obj);
    }

    @Override
    public boolean handleSslErrorRequest(SslError sslError) {
        if (Network.getInstance(this.mContext).checkSslPrefTable(this, sslError)) {
            return true;
        }
        if (this.isSynchronous()) {
            this.mRequestHandle.handleSslErrorResponse(false);
            return true;
        }
        this.sendMessageInternal(this.obtainMessage(180, sslError));
        if (!this.mCancelled) {
            this.mSslErrorRequestHandle = this.mRequestHandle;
        }
        return !this.mCancelled;
    }

    void handleSslErrorResponse(boolean bl) {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.handleSslErrorResponse(bl);
        }
        if (!bl) {
            this.commitLoad();
            this.tearDown();
        }
    }

    @Override
    public void headers(Headers headers) {
        if (this.mCancelled) {
            return;
        }
        ArrayList<String> arrayList = headers.getSetCookie();
        for (int i = 0; i < arrayList.size(); ++i) {
            CookieManager.getInstance().setCookie(this.mUri, arrayList.get(i));
        }
        this.sendMessageInternal(this.obtainMessage(100, headers));
    }

    String host() {
        if (this.mUri != null) {
            return this.mUri.mHost;
        }
        return null;
    }

    boolean isSynchronous() {
        return this.mSynchronous;
    }

    void loadSynchronousMessages() {
        while (!this.mMessageQueue.isEmpty()) {
            this.handleMessage(this.mMessageQueue.remove(0));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeAuthResponse(String string2, String string3) {
        block5: {
            block4: {
                if (this.mAuthHeader == null || this.mRequestHandle == null) break block4;
                this.mAuthHeader.setUsername(string2);
                this.mAuthHeader.setPassword(string3);
                int n = this.mAuthHeader.getScheme();
                if (n == 1) {
                    boolean bl = this.mAuthHeader.isProxy();
                    this.mRequestHandle.setupBasicAuthResponse(bl, string2, string3);
                    return;
                }
                if (n == 2) break block5;
            }
            return;
        }
        boolean bl = this.mAuthHeader.isProxy();
        String string4 = this.mAuthHeader.getRealm();
        String string5 = this.mAuthHeader.getNonce();
        String string6 = this.mAuthHeader.getQop();
        String string7 = this.mAuthHeader.getAlgorithm();
        String string8 = this.mAuthHeader.getOpaque();
        this.mRequestHandle.setupDigestAuthResponse(bl, string2, string3, string4, string5, string6, string7, string8);
    }

    String mimeType() {
        return this.mMimeType;
    }

    void notifyError() {
        if (this.mNativeLoader != 0) {
            String string2 = this.getErrorDescription();
            if (string2 == null) {
                string2 = "";
            }
            this.nativeError(this.getErrorID(), string2, this.url());
            this.clearNativeLoader();
        }
    }

    String originalUrl() {
        if (this.mOriginalUrl != null) {
            return this.mOriginalUrl;
        }
        return this.mUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseContentTypeHeader(String string2) {
        if (string2 != null) {
            int n = string2.indexOf(59);
            if (n >= 0) {
                this.mMimeType = string2.substring(0, n);
                int n2 = string2.indexOf(61, n);
                if (n2 > 0) {
                    n = string2.indexOf(59, n2);
                    if (n < n2) {
                        n = string2.length();
                    }
                    this.mEncoding = string2.substring(n2 + 1, n);
                } else {
                    this.mEncoding = string2.substring(n + 1);
                }
                this.mEncoding = this.mEncoding.trim().toLowerCase();
                if (n < string2.length() - 1) {
                    this.mTransferEncoding = string2.substring(n + 1).trim().toLowerCase();
                }
            } else {
                this.mMimeType = string2;
            }
            this.mMimeType = this.mMimeType.trim();
            try {
                Matcher matcher = CONTENT_TYPE_PATTERN.matcher(this.mMimeType);
                if (matcher.find()) {
                    this.mMimeType = matcher.group(1);
                } else {
                    this.guessMimeType();
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.guessMimeType();
            }
        }
        this.mMimeType = this.mMimeType.toLowerCase();
    }

    void pauseLoad(boolean bl) {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.pauseRequest(bl);
        }
    }

    long postIdentifier() {
        return this.mPostIdentifier;
    }

    boolean proxyAuthenticate() {
        if (this.mAuthHeader != null) {
            return this.mAuthHeader.isProxy();
        }
        return false;
    }

    String realm() {
        if (this.mAuthHeader == null) {
            return null;
        }
        return this.mAuthHeader.getRealm();
    }

    void resetCancel() {
        this.mCancelled = false;
    }

    void setCacheLoader(CacheLoader cacheLoader) {
        this.mCacheLoader = cacheLoader;
        this.mFromCache = true;
    }

    void setRequestData(String string2, Map<String, String> map, byte[] byArray) {
        this.mMethod = string2;
        this.mRequestHeaders = map;
        this.mPostData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setUrl(String string2) {
        if (string2 == null) return;
        this.mUri = null;
        if (URLUtil.isNetworkUrl(string2)) {
            this.mUrl = URLUtil.stripAnchor(string2);
            try {
                this.mUri = new WebAddress(this.mUrl);
                return;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
        this.mUrl = string2;
    }

    SslError sslError() {
        return this.mSslError;
    }

    @Override
    public void status(int n, int n2, int n3, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("major", n);
        hashMap.put("minor", n2);
        hashMap.put("code", n3);
        hashMap.put("reason", string2);
        this.mDataBuilder.clear();
        this.mMimeType = "";
        this.mEncoding = "";
        this.mTransferEncoding = "";
        this.sendMessageInternal(this.obtainMessage(160, hashMap));
    }

    /*
     * Enabled aggressive block sorting
     */
    void tearDown() {
        if (this.getErrorID() == 0) {
            WebViewWorker.CacheSaveData cacheSaveData = new WebViewWorker.CacheSaveData();
            cacheSaveData.mListener = this;
            cacheSaveData.mUrl = this.mUrl;
            cacheSaveData.mPostId = this.mPostIdentifier;
            WebViewWorker.getHandler().obtainMessage(106, cacheSaveData).sendToTarget();
        } else {
            WebViewWorker.getHandler().obtainMessage(107, this).sendToTarget();
        }
        if (this.mNativeLoader != 0) {
            PerfChecker perfChecker = new PerfChecker();
            this.nativeFinished();
            perfChecker.responseAlert("res nativeFinished");
            this.clearNativeLoader();
        }
    }

    String transferEncoding() {
        return this.mTransferEncoding;
    }

    String url() {
        return this.mUrl;
    }
}

