/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslError;
import android.os.Bundle;
import android.webkit.HttpAuthHandler;
import android.webkit.LoadListener;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import java.io.ByteArrayInputStream;
import java.util.Map;

class Network {
    private static final String LOGTAG = "network";
    private static Network sNetwork;
    private static int sPlatformNotificationEnableRefCount;
    private static boolean sPlatformNotifications;
    private HttpAuthHandler mHttpAuthHandler;
    private String mProxyPassword;
    private String mProxyUsername;
    private RequestQueue mRequestQueue;
    private SslErrorHandler mSslErrorHandler = new SslErrorHandler();

    private Network(Context context) {
        this.mHttpAuthHandler = new HttpAuthHandler(this);
        this.mRequestQueue = new RequestQueue(context);
    }

    public static void disablePlatformNotifications() {
        block3: {
            block2: {
                int n;
                sPlatformNotificationEnableRefCount = n = sPlatformNotificationEnableRefCount - 1;
                if (n != 0) break block2;
                if (sNetwork == null) break block3;
                Network.sNetwork.mRequestQueue.disablePlatformNotifications();
            }
            return;
        }
        sPlatformNotifications = false;
    }

    public static void enablePlatformNotifications() {
        block3: {
            block2: {
                int n;
                sPlatformNotificationEnableRefCount = n = 1 + sPlatformNotificationEnableRefCount;
                if (n != 1) break block2;
                if (sNetwork == null) break block3;
                Network.sNetwork.mRequestQueue.enablePlatformNotifications();
            }
            return;
        }
        sPlatformNotifications = true;
    }

    public static Network getInstance(Context context) {
        synchronized (Network.class) {
            if (sNetwork == null) {
                sNetwork = new Network(context.getApplicationContext());
                if (sPlatformNotifications) {
                    --sPlatformNotificationEnableRefCount;
                    Network.enablePlatformNotifications();
                }
            }
            Network network = sNetwork;
            return network;
        }
    }

    boolean checkSslPrefTable(LoadListener loadListener, SslError sslError) {
        if (loadListener != null && sslError != null) {
            return this.mSslErrorHandler.checkSslPrefTable(loadListener, sslError);
        }
        return false;
    }

    public void clearUserSslPrefTable() {
        this.mSslErrorHandler.clear();
    }

    public String getProxyHostname() {
        return this.mRequestQueue.getProxyHost().getHostName();
    }

    public String getProxyPassword() {
        synchronized (this) {
            String string2 = this.mProxyPassword;
            return string2;
        }
    }

    public String getProxyUsername() {
        synchronized (this) {
            String string2 = this.mProxyUsername;
            return string2;
        }
    }

    public void handleAuthRequest(LoadListener loadListener) {
        if (loadListener != null) {
            this.mHttpAuthHandler.handleAuthRequest(loadListener);
        }
    }

    public void handleSslErrorRequest(LoadListener loadListener) {
        if (loadListener != null) {
            this.mSslErrorHandler.handleSslErrorRequest(loadListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidProxySet() {
        RequestQueue requestQueue = this.mRequestQueue;
        synchronized (requestQueue) {
            if (this.mRequestQueue.getProxyHost() == null) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestURL(String string2, Map<String, String> map, byte[] byArray, LoadListener loadListener) {
        String string3 = loadListener.url();
        if (!URLUtil.isValidUrl(string3)) {
            return false;
        }
        if (URLUtil.isAssetUrl(string3) || URLUtil.isResourceUrl((String)string3) || URLUtil.isFileUrl(string3) || URLUtil.isDataUrl(string3)) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        RequestQueue requestQueue = this.mRequestQueue;
        if (loadListener.isSynchronous()) {
            RequestHandle requestHandle = requestQueue.queueSynchronousRequest(string3, loadListener.getWebAddress(), string2, map, loadListener, byteArrayInputStream, n);
            loadListener.attachRequestHandle(requestHandle);
            requestHandle.processRequest();
            loadListener.loadSynchronousMessages();
            return true;
        }
        loadListener.attachRequestHandle(requestQueue.queueRequest(string3, loadListener.getWebAddress(), string2, map, loadListener, byteArrayInputStream, n));
        return true;
    }

    public boolean restoreState(Bundle bundle) {
        return this.mSslErrorHandler.restoreState(bundle);
    }

    public boolean saveState(Bundle bundle) {
        return this.mSslErrorHandler.saveState(bundle);
    }

    public void setProxyPassword(String string2) {
        synchronized (this) {
            this.mProxyPassword = string2;
            return;
        }
    }

    public void setProxyUsername(String string2) {
        synchronized (this) {
            this.mProxyUsername = string2;
            return;
        }
    }

    public void startTiming() {
        this.mRequestQueue.startTiming();
    }

    public void stopTiming() {
        this.mRequestQueue.stopTiming();
    }
}

