/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Dialog;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;

class PluginFullScreenHolder
extends Dialog {
    private View mContentView;
    private final int mNpp;
    private final WebView mWebView;

    PluginFullScreenHolder(WebView webView, int n) {
        super(webView.getContext(), 16973831);
        this.mWebView = webView;
        this.mNpp = n;
    }

    @Override
    public void onBackPressed() {
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (keyEvent.isSystem()) {
            return super.onKeyDown(n, keyEvent);
        }
        this.mWebView.onKeyDown(n, keyEvent);
        return true;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (keyEvent.isSystem()) {
            return super.onKeyUp(n, keyEvent);
        }
        this.mWebView.onKeyUp(n, keyEvent);
        return true;
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mContentView != null && this.mContentView.getParent() != null) {
            ((ViewGroup)this.mContentView.getParent()).removeView(this.mContentView);
        }
        this.mWebView.getWebViewCore().sendMessage(182, this.mNpp, 0);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        this.mWebView.onTrackballEvent(motionEvent);
        return true;
    }

    @Override
    public void setContentView(View view) {
        SurfaceView surfaceView;
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        if (view instanceof SurfaceView && (surfaceView = (SurfaceView)view).isFixedSize()) {
            surfaceView.getHolder().setSizeFromLayout();
        }
        super.setContentView(view);
        this.mContentView = view;
    }
}

