/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.SystemProperties;
import android.util.Log;
import android.webkit.BrowserFrame;
import java.util.ArrayList;
import java.util.Iterator;

public class PluginManager {
    private static final String LOGTAG = "PluginManager";
    public static final String PLUGIN_ACTION = "android.webkit.PLUGIN";
    public static final String PLUGIN_PERMISSION = "android.webkit.permission.PLUGIN";
    private static final String PLUGIN_SYSTEM_LIB = "/system/lib/plugins/";
    private static final String PLUGIN_TYPE = "type";
    private static final Signature[] SIGNATURES;
    private static final String SIGNATURE_1 = "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";
    private static final String TYPE_NATIVE = "native";
    private static PluginManager mInstance;
    private final Context mContext;
    private ArrayList<PackageInfo> mPackageInfoCache;

    static {
        mInstance = null;
        Signature[] signatureArray = new Signature[]{new Signature(SIGNATURE_1)};
        SIGNATURES = signatureArray;
    }

    private PluginManager(Context context) {
        this.mContext = context;
        this.mPackageInfoCache = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginManager getInstance(Context context) {
        synchronized (PluginManager.class) {
            if (mInstance != null) return mInstance;
            if (context == null) {
                throw new IllegalStateException("First call to PluginManager need a valid context.");
            }
            mInstance = new PluginManager(context.getApplicationContext());
            return mInstance;
        }
    }

    Class<?> getPluginClass(String string2, String string3) throws PackageManager.NameNotFoundException, ClassNotFoundException {
        return this.mContext.createPackageContext(string2, 3).getClassLoader().loadClass(string3);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] getPluginDirectories() {
        var1_1 = new ArrayList<String>();
        var2_2 = this.mContext.getPackageManager();
        var3_3 = var2_2.queryIntentServices(new Intent("android.webkit.PLUGIN"), 132);
        var4_4 = this.mPackageInfoCache;
        synchronized (var4_4) {
            this.mPackageInfoCache.clear();
            var6_5 = var3_3.iterator();
            block8: while (true) {
                block20: {
                    if (!var6_5.hasNext()) {
                        return var1_1.toArray(new String[var1_1.size()]);
                    }
                    var7_6 = var6_5.next().serviceInfo;
                    if (var7_6 == null) {
                        Log.w("PluginManager", "Ignore bad plugin");
                        continue;
                    }
                    try {
                        var11_8 = var2_2.getPackageInfo(var7_6.packageName, 4160);
                        if (var11_8 == null) continue;
                        var12_9 = var11_8.applicationInfo.dataDir + "/lib";
                        if ((129 & var11_8.applicationInfo.flags) == 1) {
                            var12_9 = "/system/lib/plugins/" + var11_8.packageName;
                        }
                        if ((var13_10 = var11_8.requestedPermissions) == null) continue;
                    }
                    catch (PackageManager.NameNotFoundException var9_7) {
                        Log.w("PluginManager", "Can't find plugin: " + var7_6.packageName);
                        continue;
                    }
                    var14_11 = var13_10.length;
                    var15_12 = 0;
                    block9: while (true) {
                        block22: {
                            block19: {
                                block21: {
                                    var16_13 = false;
                                    if (var15_12 >= var14_11) break block21;
                                    if (!"android.webkit.permission.PLUGIN".equals(var13_10[var15_12])) break block22;
                                    var16_13 = true;
                                }
                                if (!var16_13 || (var17_14 = var11_8.signatures) == null) continue block8;
                                if (SystemProperties.getBoolean("ro.secure", false)) {
                                    var18_15 = false;
                                    var19_16 = var17_14.length;
                                    var20_17 = 0;
lbl41:
                                    // 2 sources

                                    while (var20_17 < var19_16) {
                                        var21_18 = var17_14[var20_17];
                                        var22_19 = 0;
lbl44:
                                        // 2 sources

                                        while (true) {
                                            var23_20 = PluginManager.SIGNATURES.length;
                                            if (var22_19 >= var23_20) break block19;
                                            if (!PluginManager.SIGNATURES[var22_19].equals(var21_18)) break block9;
                                            var18_15 = true;
                                            break block19;
                                            break;
                                        }
                                    }
                                    break block20;
                                }
lbl51:
                                // 3 sources

                                while (true) {
                                    if (var7_6.metaData == null) {
                                        Log.e("PluginManager", "The plugin '" + var7_6.name + "' has no type defined");
                                        continue block8;
                                    }
                                    var24_21 = var7_6.metaData.getString("type");
                                    if (!"native".equals(var24_21)) {
                                        Log.e("PluginManager", "Unrecognized plugin type: " + var24_21);
                                        continue block8;
                                    }
                                    try {
                                        this.getPluginClass(var7_6.packageName, var7_6.name);
                                    }
                                    catch (PackageManager.NameNotFoundException var27_23) {
                                        Log.e("PluginManager", "Can't find plugin: " + var7_6.packageName);
                                        continue block8;
                                    }
                                    catch (ClassNotFoundException var25_22) {
                                        Log.e("PluginManager", "Can't find plugin's class: " + var7_6.name);
                                        continue block8;
                                    }
                                    this.mPackageInfoCache.add(var11_8);
                                    var1_1.add(var12_9);
                                    continue block8;
                                    break;
                                }
                            }
                            ++var20_17;
                            ** GOTO lbl41
                        }
                        ++var15_12;
                    }
                    ++var22_19;
                    ** continue;
                }
                if (var18_15) break;
            }
            ** continue;
        }
    }

    String getPluginSharedDataDirectory() {
        return this.mContext.getDir("plugins", 0).getPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getPluginsAPKName(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) {
            return null;
        }
        ArrayList<PackageInfo> arrayList = this.mPackageInfoCache;
        synchronized (arrayList) {
            PackageInfo packageInfo;
            Iterator<PackageInfo> iterator = this.mPackageInfoCache.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                packageInfo = iterator.next();
            } while (!string2.contains(packageInfo.packageName));
            return packageInfo.packageName;
        }
    }

    public void refreshPlugins(boolean bl) {
        BrowserFrame.sJavaBridge.obtainMessage(100, bl).sendToTarget();
    }
}

