/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import java.util.ArrayList;
import java.util.Iterator;

class ViewManager {
    private static final int MAX_SURFACE_DIMENSION = 2048;
    private final int MAX_SURFACE_AREA;
    private final ArrayList<ChildView> mChildren = new ArrayList();
    private boolean mHidden;
    private boolean mReadyToDraw;
    private final WebView mWebView;
    private boolean mZoomInProgress = false;

    ViewManager(WebView webView) {
        this.mWebView = webView;
        this.MAX_SURFACE_AREA = (int)(2.75 * (double)(webView.getResources().getDisplayMetrics().widthPixels * webView.getResources().getDisplayMetrics().heightPixels));
    }

    static /* synthetic */ boolean access$402(ViewManager viewManager, boolean bl) {
        viewManager.mReadyToDraw = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestLayout(ChildView childView) {
        SurfaceView surfaceView;
        block15: {
            block14: {
                AbsoluteLayout.LayoutParams layoutParams;
                int n = this.mWebView.contentToViewDimension(childView.width);
                int n2 = this.mWebView.contentToViewDimension(childView.height);
                int n3 = this.mWebView.contentToViewX(childView.x);
                int n4 = this.mWebView.contentToViewY(childView.y);
                ViewGroup.LayoutParams layoutParams2 = childView.mView.getLayoutParams();
                if (layoutParams2 instanceof AbsoluteLayout.LayoutParams) {
                    layoutParams = (AbsoluteLayout.LayoutParams)layoutParams2;
                    layoutParams.width = n;
                    layoutParams.height = n2;
                    layoutParams.x = n3;
                    layoutParams.y = n4;
                } else {
                    layoutParams = new AbsoluteLayout.LayoutParams(n, n2, n3, n4);
                }
                childView.mView.setLayoutParams(layoutParams);
                if (!(childView.mView instanceof SurfaceView) || (surfaceView = (SurfaceView)childView.mView).isFixedSize() && this.mZoomInProgress) break block14;
                int n5 = n;
                int n6 = n2;
                if (n5 > 2048 || n6 > 2048) {
                    if (childView.width > childView.height) {
                        n5 = 2048;
                        n6 = 2048 * childView.height / childView.width;
                    } else {
                        n6 = 2048;
                        n5 = 2048 * childView.width / childView.height;
                    }
                }
                if (n5 * n6 > this.MAX_SURFACE_AREA) {
                    float f = this.MAX_SURFACE_AREA;
                    if (childView.width > childView.height) {
                        n5 = (int)Math.sqrt(f * (float)childView.width / (float)childView.height);
                        n6 = n5 * childView.height / childView.width;
                    } else {
                        n6 = (int)Math.sqrt(f * (float)childView.height / (float)childView.width);
                        n5 = n6 * childView.width / childView.height;
                    }
                }
                if (n5 != n || n6 != n2) {
                    surfaceView.getHolder().setFixedSize(n5, n6);
                    return;
                }
                if (!surfaceView.isFixedSize() && this.mZoomInProgress) {
                    surfaceView.getHolder().setFixedSize(surfaceView.getWidth(), surfaceView.getHeight());
                    return;
                }
                if (surfaceView.isFixedSize() && !this.mZoomInProgress) break block15;
            }
            return;
        }
        if (surfaceView.getVisibility() == 0) {
            surfaceView.setVisibility(4);
            surfaceView.getHolder().setSizeFromLayout();
            this.mWebView.mPrivateHandler.post(new Runnable(){

                @Override
                public void run() {
                    surfaceView.setVisibility(0);
                }
            });
            return;
        }
        surfaceView.getHolder().setSizeFromLayout();
    }

    ChildView createView() {
        return new ChildView();
    }

    void endZoom() {
        this.mZoomInProgress = false;
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            this.requestLayout(iterator.next());
        }
    }

    void hideAll() {
        if (this.mHidden) {
            return;
        }
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            iterator.next().mView.setVisibility(8);
        }
        this.mHidden = true;
    }

    ChildView hitTest(int n, int n2) {
        if (this.mHidden) {
            return null;
        }
        for (ChildView childView : this.mChildren) {
            if (childView.mView.getVisibility() != 0 || n < childView.x || n >= childView.x + childView.width || n2 < childView.y || n2 >= childView.y + childView.height) continue;
            return childView;
        }
        return null;
    }

    void postReadyToDrawAll() {
        this.mWebView.mPrivateHandler.post(new Runnable(){

            @Override
            public void run() {
                ViewManager.access$402(ViewManager.this, true);
                Iterator iterator = ViewManager.this.mChildren.iterator();
                while (iterator.hasNext()) {
                    ((ChildView)iterator.next()).mView.setVisibility(0);
                }
            }
        });
    }

    void postResetStateAll() {
        this.mWebView.mPrivateHandler.post(new Runnable(){

            @Override
            public void run() {
                ViewManager.access$402(ViewManager.this, false);
            }
        });
    }

    void scaleAll() {
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            this.requestLayout(iterator.next());
        }
    }

    void showAll() {
        if (!this.mHidden) {
            return;
        }
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            iterator.next().mView.setVisibility(0);
        }
        this.mHidden = false;
    }

    void startZoom() {
        this.mZoomInProgress = true;
        Iterator<ChildView> iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            this.requestLayout(iterator.next());
        }
    }

    class ChildView {
        int height;
        View mView;
        int width;
        int x;
        int y;

        ChildView() {
        }

        private void attachViewOnUIThread() {
            ViewManager.this.mWebView.addView(this.mView);
            ViewManager.this.mChildren.add(this);
            if (!ViewManager.this.mReadyToDraw) {
                this.mView.setVisibility(8);
            }
        }

        private void removeViewOnUIThread() {
            ViewManager.this.mWebView.removeView(this.mView);
            ViewManager.this.mChildren.remove(this);
        }

        void attachView(int n, int n2, int n3, int n4) {
            if (this.mView == null) {
                return;
            }
            this.setBounds(n, n2, n3, n4);
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                @Override
                public void run() {
                    ViewManager.this.requestLayout(ChildView.this);
                    if (ChildView.this.mView.getParent() == null) {
                        ChildView.this.attachViewOnUIThread();
                    }
                }
            });
        }

        void removeView() {
            if (this.mView == null) {
                return;
            }
            ((ViewManager)ViewManager.this).mWebView.mPrivateHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChildView.this.removeViewOnUIThread();
                }
            });
        }

        void setBounds(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }
}

