/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import com.android.internal.widget.EditableInputConnection;
import java.util.ArrayList;

class WebTextView
extends AutoCompleteTextView {
    static final String LOGTAG = "webtextview";
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private Drawable mBackground;
    private char[] mCharacter = new char[1];
    private boolean mDragSent;
    private long mDragStartTime;
    private float mDragStartX;
    private float mDragStartY;
    private boolean mFromFocusChange;
    private boolean mFromSetInputType;
    private boolean mFromWebKit;
    private boolean mGotEnterDown;
    private boolean mGotTouchDown;
    private boolean mHasPerformedLongClick;
    private int mHeightSpec;
    private boolean mInSetTextAndKeepSelection;
    private int mMaxLength;
    private int mNodePointer;
    private String mPreChange;
    private boolean mScrolled;
    private boolean mSingle;
    private WebView mWebView;
    private int mWidthSpec;

    WebTextView(Context context, WebView webView) {
        super(context, null, 16843449);
        this.mWebView = webView;
        this.mMaxLength = -1;
    }

    private void createBackground() {
        if (this.mBackground != null) {
            return;
        }
        this.mBackground = new OutlineDrawable();
        this.setGravity(16);
        TextPaint textPaint = this.getPaint();
        textPaint.setFlags(1 | (0x80 | textPaint.getFlags()));
        this.setTextColor(-16777216);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lineUpScroll() {
        Layout layout2 = this.getLayout();
        if (this.mWebView != null && layout2 != null) {
            float f = Touch.getMaxScrollX((TextView)this, (Layout)layout2, (int)this.mScrollY);
            WebView webView = this.mWebView;
            float f2 = f > 0.0f ? (float)this.mScrollX / f : 0.0f;
            webView.scrollFocusedTextInput(f2, this.mScrollY);
        }
    }

    private void sendDomEvent(KeyEvent keyEvent) {
        this.mWebView.passToJavaScript(this.getText().toString(), keyEvent);
    }

    private void setMaxLength(int n) {
        this.mMaxLength = n;
        if (-1 == n) {
            this.setFilters(NO_FILTERS);
            return;
        }
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(n)};
        this.setFilters(inputFilterArray);
    }

    void bringIntoView() {
        if (this.getLayout() != null) {
            this.bringPointIntoView(Selection.getSelectionEnd(this.getText()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isSystem()) {
            return super.dispatchKeyEvent(keyEvent);
        }
        boolean bl = keyEvent.getAction() != 1;
        int n = keyEvent.getKeyCode();
        boolean bl2 = false;
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (!this.mWebView.nativeCursorMatchesFocus()) {
                    if (bl) {
                        return this.mWebView.onKeyDown(n, keyEvent);
                    }
                    return this.mWebView.onKeyUp(n, keyEvent);
                }
                bl2 = true;
            }
        }
        if (61 == n) {
            if (bl) {
                this.onEditorAction(5);
            }
            return true;
        }
        Editable editable = this.getText();
        int n2 = editable.length();
        if (67 == n && n2 == 0) {
            this.sendDomEvent(keyEvent);
            return true;
        }
        if (this.mSingle && 66 == n) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (!bl) {
                InputMethodManager.getInstance((Context)this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, n));
                this.sendDomEvent(keyEvent);
            }
            return super.dispatchKeyEvent(keyEvent);
        }
        if (23 == n) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (!this.mWebView.nativeCursorMatchesFocus()) {
                if (bl) {
                    return this.mWebView.onKeyDown(n, keyEvent);
                }
                return this.mWebView.onKeyUp(n, keyEvent);
            }
            if (!bl) {
                this.mWebView.centerKeyPressOnTextField();
            }
            return super.dispatchKeyEvent(keyEvent);
        }
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        int n3 = Selection.getSelectionStart(editable);
        int n4 = Selection.getSelectionEnd(editable);
        boolean bl3 = this.mMaxLength != -1 && n2 == this.mMaxLength;
        String string2 = bl3 && n4 != n3 ? editable.toString() : "";
        if (super.dispatchKeyEvent(keyEvent)) {
            if (66 == n) {
                this.mGotEnterDown = true;
            }
            if (bl3 && !bl2 && n != 67) {
                if (n4 == n3) {
                    return true;
                }
                if (!string2.equals(this.getText().toString())) {
                    Editable editable2 = this.getText();
                    int n5 = Selection.getSelectionStart(editable2);
                    int n6 = Selection.getSelectionEnd(editable2);
                    this.mWebView.replaceTextfieldText(0, n2, editable2.toString(), n5, n6);
                    return true;
                }
            }
            return true;
        }
        if (this.mGotEnterDown && !bl) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        this.mWebView.resetTrackballTime();
        if (bl) {
            return this.mWebView.onKeyDown(n, keyEvent);
        }
        return this.mWebView.onKeyUp(n, keyEvent);
    }

    boolean isSameTextField(int n) {
        return n == this.mNodePointer;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
        if (this.mWebView != null) {
            editorInfo.fieldName = this.mWebView.nativeFocusCandidateName() + "\\" + this.mWebView.getUrl();
        }
        return inputConnection;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mWebView == null || !this.mWebView.nativeFocusCandidateIsPassword() || !this.isSameTextField(this.mWebView.nativeFocusCandidatePointer())) {
            this.setInPassword(false);
            return;
        }
        super.onDraw(canvas);
    }

    public void onDrawSubstitute() {
        this.updateCursorControllerPositions();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onEditorAction(int n) {
        switch (n) {
            case 5: {
                if (this.mWebView.nativeMoveCursorToNextTextInput()) {
                    this.mWebView.setFocusControllerInactive();
                    this.mWebView.rebuildWebTextView();
                    this.setDefaultSelection();
                    this.mWebView.invalidate();
                    return;
                }
            }
            default: {
                return;
            }
            case 6: {
                super.onEditorAction(n);
                return;
            }
            case 2: 
            case 3: 
        }
        InputMethodManager.getInstance((Context)this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
        this.sendDomEvent(new KeyEvent(0, 66));
        this.sendDomEvent(new KeyEvent(1, 66));
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        this.mFromFocusChange = true;
        super.onFocusChanged(bl, n, rect);
        this.mFromFocusChange = false;
    }

    @Override
    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        super.onScrollChanged(n, n2, n3, n4);
        this.lineUpScroll();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSelectionChanged(int n, int n2) {
        block5: {
            block4: {
                if (this.mInSetTextAndKeepSelection) break block4;
                InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
                if (inputMethodManager != null && inputMethodManager.isActive(this)) {
                    Editable editable = this.getText();
                    inputMethodManager.updateSelection(this, n, n2, EditableInputConnection.getComposingSpanStart(editable), EditableInputConnection.getComposingSpanEnd(editable));
                }
                if (!this.mFromWebKit && !this.mFromFocusChange && !this.mFromSetInputType && this.mWebView != null) break block5;
            }
            return;
        }
        this.mWebView.setSelection(n, n2);
        this.lineUpScroll();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        block9: {
            block10: {
                block8: {
                    super.onTextChanged(charSequence, n, n2, n3);
                    String string2 = ((Object)charSequence).toString();
                    if (this.mPreChange == null || this.mPreChange.equals(string2) || this.mMaxLength > -1 && this.mPreChange.length() > this.mMaxLength && this.mPreChange.substring(0, this.mMaxLength).equals(string2)) break block8;
                    this.mPreChange = string2;
                    if (n3 != 0) break block9;
                    if (n2 > 0) break block10;
                }
                return;
            }
            this.mWebView.deleteSelection(n, n + n2);
            this.updateCachedTextfield();
            return;
        }
        TextUtils.getChars(charSequence, n + n3 - 1, n + n3, this.mCharacter, 0);
        KeyEvent[] keyEventArray = KeyCharacterMap.load(0).getEvents(this.mCharacter);
        boolean bl = keyEventArray == null;
        int n4 = bl ? 0 : 1;
        if (n3 > 1 || bl) {
            String string3 = ((Object)charSequence.subSequence(n, n + n3 - n4)).toString();
            this.mWebView.replaceTextfieldText(n, n + n2, string3, n + n3 - n4, n + n3 - n4);
        } else if (!this.mInSetTextAndKeepSelection) {
            this.mWebView.setSelection(n, n + n2);
        }
        if (!bl) {
            int n5 = keyEventArray.length;
            for (int i = 0; i < n5; ++i) {
                if (KeyEvent.isModifierKey(keyEventArray[i].getKeyCode())) continue;
                this.sendDomEvent(keyEventArray[i]);
            }
        }
        this.updateCachedTextfield();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                super.onTouchEvent(motionEvent);
                this.mDragStartX = motionEvent.getX();
                this.mDragStartY = motionEvent.getY();
                this.mDragStartTime = motionEvent.getEventTime();
                this.mDragSent = false;
                this.mScrolled = false;
                this.mGotTouchDown = true;
                this.mHasPerformedLongClick = false;
            }
            default: {
                return true;
            }
            case 2: {
                if (this.mHasPerformedLongClick) {
                    this.mGotTouchDown = false;
                    return false;
                }
                int n = ViewConfiguration.get(this.mContext).getScaledTouchSlop();
                Editable editable = this.getText();
                int n2 = Touch.getInitialScrollX(this, editable);
                int n3 = Touch.getInitialScrollY(this, editable);
                super.onTouchEvent(motionEvent);
                int n4 = Math.abs(this.mScrollX - n2);
                int n5 = Math.abs(this.mScrollY - n3);
                int n6 = n / 2;
                if (n4 > n6 || n5 > n6) {
                    this.mScrolled = true;
                    this.cancelLongPress();
                    return true;
                }
                if (Math.abs((float)((int)motionEvent.getX()) - this.mDragStartX) < (float)n && Math.abs((float)((int)motionEvent.getY()) - this.mDragStartY) < (float)n) {
                    return true;
                }
                if (this.mWebView == null) return false;
                if (!this.mDragSent) {
                    this.mWebView.initiateTextFieldDrag(this.mDragStartX, this.mDragStartY, this.mDragStartTime);
                    this.mDragSent = true;
                }
                if (!this.mWebView.textFieldDrag(motionEvent)) return false;
                this.mScrolled = true;
                this.cancelLongPress();
                return true;
            }
            case 1: 
            case 3: 
        }
        super.onTouchEvent(motionEvent);
        if (this.mHasPerformedLongClick) {
            this.mGotTouchDown = false;
            return false;
        }
        if (!this.mScrolled) {
            this.cancelLongPress();
            if (this.mGotTouchDown && this.mWebView != null) {
                this.mWebView.touchUpOnTextField(motionEvent);
            }
        }
        if (this.mWebView != null && this.mDragSent) {
            this.mWebView.onTouchEvent(motionEvent);
        }
        this.mGotTouchDown = false;
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(motionEvent);
        }
        if (motionEvent.getAction() != 2) {
            return false;
        }
        if (!this.mWebView.nativeCursorMatchesFocus()) {
            return this.mWebView.onTrackballEvent(motionEvent);
        }
        Editable editable = this.getText();
        MovementMethod movementMethod = this.getMovementMethod();
        return movementMethod != null && this.getLayout() != null && movementMethod.onTrackballEvent(this, editable, motionEvent);
    }

    @Override
    public boolean performLongClick() {
        this.mHasPerformedLongClick = true;
        return super.performLongClick();
    }

    void remove() {
        InputMethodManager.getInstance((Context)this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
        this.mWebView.removeView(this);
        this.mWebView.requestFocus();
    }

    @Override
    public boolean requestRectangleOnScreen(Rect rect) {
        if (!this.mWebView.inAnimateZoom()) {
            return super.requestRectangleOnScreen(rect);
        }
        return false;
    }

    public void setAdapterCustom(AutoCompleteAdapter autoCompleteAdapter) {
        if (autoCompleteAdapter != null) {
            this.setInputType(0x10000 | this.getInputType());
            autoCompleteAdapter.setTextView(this);
        }
        super.setAdapter(autoCompleteAdapter);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setDefaultSelection() {
        Editable editable = this.getText();
        int n = this.mSingle ? editable.length() : 0;
        if (Selection.getSelectionStart(editable) == n && Selection.getSelectionEnd(editable) == n) {
            if (this.mWebView != null) {
                this.mWebView.setSelection(n, n);
            }
            return;
        }
        Selection.setSelection(editable, n, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setInPassword(boolean bl) {
        if (bl) {
            this.setInputType(129);
            this.createBackground();
        }
        boolean bl2 = !bl;
        this.setWillNotDraw(bl2);
        Drawable drawable2 = bl ? this.mBackground : null;
        this.setBackgroundDrawable(drawable2);
    }

    @Override
    public void setInputType(int n) {
        this.mFromSetInputType = true;
        super.setInputType(n);
        this.mFromSetInputType = false;
    }

    void setNodePointer(int n) {
        this.mNodePointer = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setRect(int n, int n2, int n3, int n4) {
        AbsoluteLayout.LayoutParams layoutParams = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new AbsoluteLayout.LayoutParams(n3, n4, n, n2);
        } else {
            layoutParams.x = n;
            layoutParams.y = n2;
            layoutParams.width = n3;
            layoutParams.height = n4;
        }
        if (this.getParent() == null) {
            this.mWebView.addView((View)this, layoutParams);
        } else {
            this.setLayoutParams(layoutParams);
        }
        this.mWidthSpec = View.MeasureSpec.makeMeasureSpec(n3, 0x40000000);
        this.mHeightSpec = View.MeasureSpec.makeMeasureSpec(n4, 0x40000000);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setSelectionFromWebKit(int n, int n2) {
        Editable editable;
        int n3;
        if (n < 0 || n2 < 0 || n > (n3 = (editable = this.getText()).length()) || n2 > n3) {
            return;
        }
        this.mFromWebKit = true;
        Selection.setSelection(editable, n, n2);
        this.mFromWebKit = false;
    }

    void setTextAndKeepSelection(String string2) {
        this.mPreChange = string2.toString();
        Editable editable = this.getText();
        int n = Selection.getSelectionStart(editable);
        int n2 = Selection.getSelectionEnd(editable);
        this.mInSetTextAndKeepSelection = true;
        editable.replace(0, editable.length(), string2);
        int n3 = editable.length();
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        Selection.setSelection(editable, n, n2);
        this.mInSetTextAndKeepSelection = false;
        this.updateCachedTextfield();
    }

    /*
     * Enabled aggressive block sorting
     */
    void setType(int n) {
        int n2;
        if (this.mWebView == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        int n3 = -1;
        int n4 = 1;
        if (this.mWebView.nativeFocusCandidateHasNextTextfield()) {
            n4 |= 0xA0;
        }
        switch (n) {
            default: {
                n2 = 0x90000000 | 2;
                break;
            }
            case 0: {
                n2 = 0x90000000 | 2;
                bl2 = false;
                break;
            }
            case 1: {
                n4 = 180225;
                n2 = 0x90000000 | 1;
                bl2 = false;
                bl = false;
                break;
            }
            case 2: {
                bl2 = true;
                n2 = 0x90000000 | 2;
                break;
            }
            case 3: {
                n2 = 0x90000000 | 3;
                bl2 = false;
                break;
            }
            case 4: {
                n2 = 0x90000000 | 2;
                bl2 = false;
                break;
            }
            case 5: {
                n4 |= 2;
                n2 = 0x90000000 | 5;
                bl2 = false;
                break;
            }
            case 6: {
                n4 |= 3;
                n2 = 0x90000000 | 5;
                bl2 = false;
                break;
            }
            case 7: {
                n2 = 0x90000000 | 2;
                bl2 = false;
            }
        }
        this.setHint(null);
        if (bl) {
            String string2;
            this.mWebView.requestLabel(this.mWebView.nativeFocusCandidateFramePointer(), this.mNodePointer);
            n3 = this.mWebView.nativeFocusCandidateMaxLength();
            if (n != 2 && (string2 = this.mWebView.nativeFocusCandidateName()) != null && string2.length() > 0) {
                this.mWebView.requestFormData(string2, this.mNodePointer);
            }
        }
        this.mSingle = bl;
        this.setMaxLength(n3);
        this.setHorizontallyScrolling(bl);
        this.setInputType(n4);
        this.setImeOptions(n2);
        this.setInPassword(bl2);
        this.setAdapterCustom(null);
    }

    void updateCachedTextfield() {
        this.mWebView.updateCachedTextfield(this.getText().toString());
    }

    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        private TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> arrayList) {
            super(context, 17367131, arrayList);
        }

        private void setTextView(TextView textView) {
            this.mTextView = textView;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            TextView textView = (TextView)super.getView(n, view, viewGroup);
            if (textView != null && this.mTextView != null) {
                textView.setTextSize(this.mTextView.getTextSize());
            }
            return textView;
        }
    }

    private static class OutlineDrawable
    extends Drawable {
        private OutlineDrawable() {
        }

        @Override
        public void draw(Canvas canvas) {
            Rect rect = this.getBounds();
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-1);
            canvas.drawRect(rect, paint);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16777216);
            canvas.drawRect(rect, paint);
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setAlpha(int n) {
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
        }
    }
}

