/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.MediaFile;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.GeolocationPermissions;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.Network;
import android.webkit.PluginManager;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebIconDatabase;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

final class WebViewCore {
    static final int ACTION_DOUBLETAP = 512;
    static final int ACTION_LONGPRESS = 256;
    static final String[] HandlerDebugString;
    private static final String LOGTAG = "webcore";
    static final int SCROLL_BITS = 6;
    static final String THREAD_NAME = "WebViewCoreThread";
    static final int ZOOM_BITS = 134;
    private static boolean mRepaintScheduled;
    private static Handler sWebCoreHandler;
    private BrowserFrame mBrowserFrame;
    private final CallbackProxy mCallbackProxy;
    private final Context mContext;
    private int mCurrentViewHeight = 0;
    private float mCurrentViewScale = 1.0f;
    private int mCurrentViewWidth = 0;
    private boolean mDrawIsPaused;
    private boolean mDrawIsScheduled;
    private final EventHub mEventHub;
    private Map<String, Object> mJavascriptInterfaces;
    private int mNativeClass;
    private RestoreState mRestoreState = null;
    private int mRestoredScale = 0;
    private int mRestoredScreenWidthScale = 0;
    private int mRestoredX = 0;
    private int mRestoredY = 0;
    final DrawFilter mScrollFilter;
    private final WebSettings mSettings;
    private boolean mSplitPictureIsScheduled;
    private int mViewportDensityDpi = -1;
    private int mViewportHeight = -1;
    private int mViewportInitialScale = 0;
    private int mViewportMaximumScale = 0;
    private int mViewportMinimumScale = 0;
    private boolean mViewportUserScalable = true;
    private int mViewportWidth = -1;
    private WebView mWebView;
    private int mWebkitScrollX = 0;
    private int mWebkitScrollY = 0;
    final DrawFilter mZoomFilter = new PaintFlagsDrawFilter(134, 64);

    static {
        System.loadLibrary(LOGTAG);
        HandlerDebugString = new String[]{"REQUEST_LABEL", "UPDATE_FRAME_CACHE_IF_LOADING", "SCROLL_TEXT_INPUT", "LOAD_URL", "STOP_LOADING", "RELOAD", "KEY_DOWN", "KEY_UP", "VIEW_SIZE_CHANGED", "GO_BACK_FORWARD", "SET_SCROLL_OFFSET", "RESTORE_STATE", "PAUSE_TIMERS", "RESUME_TIMERS", "CLEAR_CACHE", "CLEAR_HISTORY", "SET_SELECTION", "REPLACE_TEXT", "PASS_TO_JS", "SET_GLOBAL_BOUNDS", "UPDATE_CACHE_AND_TEXT_ENTRY", "CLICK", "SET_NETWORK_STATE", "DOC_HAS_IMAGES", "121", "DELETE_SELECTION", "LISTBOX_CHOICES", "SINGLE_LISTBOX_CHOICE", "MESSAGE_RELAY", "SET_BACKGROUND_COLOR", "SET_MOVE_FOCUS", "SAVE_DOCUMENT_STATE", "129", "WEBKIT_DRAW", "SYNC_SCROLL", "POST_URL", "SPLIT_PICTURE_SET", "CLEAR_CONTENT", "SET_MOVE_MOUSE", "SET_MOVE_MOUSE_IF_LATEST", "REQUEST_CURSOR_HREF", "ADD_JS_INTERFACE", "LOAD_DATA", "TOUCH_UP", "TOUCH_EVENT", "SET_ACTIVE", "ON_PAUSE", "ON_RESUME", "FREE_MEMORY", "VALID_NODE_BOUNDS"};
        mRepaintScheduled = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebViewCore(Context context, WebView webView, CallbackProxy callbackProxy, Map<String, Object> map) {
        this.mScrollFilter = new PaintFlagsDrawFilter(6, 0);
        this.mCallbackProxy = callbackProxy;
        this.mWebView = webView;
        this.mJavascriptInterfaces = map;
        this.mContext = context;
        synchronized (WebViewCore.class) {
            if (sWebCoreHandler == null) {
                Thread thread = new Thread(new WebCoreThread());
                thread.setName(THREAD_NAME);
                thread.start();
                try {
                    WebViewCore.class.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(LOGTAG, "Caught exception while waiting for thread creation.");
                    Log.e(LOGTAG, Log.getStackTraceString(interruptedException));
                }
            }
        }
        this.mEventHub = new EventHub();
        this.mSettings = new WebSettings(this.mContext, this.mWebView);
        WebIconDatabase.getInstance();
        WebStorage.getInstance().createUIHandler();
        GeolocationPermissions.getInstance().createUIHandler();
        Message message = sWebCoreHandler.obtainMessage(0, this);
        sWebCoreHandler.sendMessage(message);
    }

    static /* synthetic */ WebView access$1002(WebViewCore webViewCore, WebView webView) {
        webViewCore.mWebView = webView;
        return webView;
    }

    static /* synthetic */ Handler access$402(Handler handler) {
        sWebCoreHandler = handler;
        return handler;
    }

    static /* synthetic */ int access$5402(WebViewCore webViewCore, int n) {
        webViewCore.mWebkitScrollX = n;
        return n;
    }

    static /* synthetic */ int access$5502(WebViewCore webViewCore, int n) {
        webViewCore.mWebkitScrollY = n;
        return n;
    }

    static /* synthetic */ boolean access$5702(WebViewCore webViewCore, boolean bl) {
        webViewCore.mSplitPictureIsScheduled = bl;
        return bl;
    }

    static /* synthetic */ boolean access$6202(WebViewCore webViewCore, boolean bl) {
        webViewCore.mDrawIsScheduled = bl;
        return bl;
    }

    static /* synthetic */ BrowserFrame access$702(WebViewCore webViewCore, BrowserFrame browserFrame) {
        webViewCore.mBrowserFrame = browserFrame;
        return browserFrame;
    }

    static /* synthetic */ int access$902(WebViewCore webViewCore, int n) {
        webViewCore.mNativeClass = n;
        return n;
    }

    private ViewManager.ChildView addSurface(View view, int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return null;
        }
        if (view == null) {
            Log.e(LOGTAG, "Attempted to add an empty plugin view to the view hierarchy");
            return null;
        }
        view.setWillNotDraw(false);
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).setZOrderOnTop(true);
        }
        ViewManager.ChildView childView = this.mWebView.mViewManager.createView();
        childView.mView = view;
        childView.attachView(n, n2, n3, n4);
        return childView;
    }

    private void centerFitRect(int n, int n2, int n3, int n4) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(127, new Rect(n, n2, n + n3, n2 + n4)).sendToTarget();
    }

    private void clearCache(boolean bl) {
        this.mBrowserFrame.clearCache();
        if (bl) {
            CacheManager.removeAllCacheFiles();
        }
    }

    private void clearTextEntry() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 111).sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void contentScrollBy(int n, int n2, boolean bl) {
        if (!this.mBrowserFrame.firstLayoutDone() || this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 102, n, n2, new Boolean(bl));
        if (this.mDrawIsScheduled) {
            this.mEventHub.sendMessage(Message.obtain(null, 125, message));
            return;
        }
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void contentScrollTo(int n, int n2) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = n;
            this.mRestoredY = n2;
            return;
        }
        if (this.mWebView == null) return;
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 101, n, n2);
        if (this.mDrawIsScheduled) {
            this.mEventHub.sendMessage(Message.obtain(null, 125, message));
            return;
        }
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void contentSpawnScrollTo(int n, int n2) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = n;
            this.mRestoredY = n2;
            return;
        }
        if (this.mWebView == null) return;
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 103, n, n2);
        if (this.mDrawIsScheduled) {
            this.mEventHub.sendMessage(Message.obtain(null, 125, message));
            return;
        }
        message.sendToTarget();
    }

    private void destroySurface(ViewManager.ChildView childView) {
        childView.removeView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void didFirstLayout(boolean bl) {
        this.mBrowserFrame.didFirstLayout();
        if (this.mWebView == null) {
            return;
        }
        boolean bl2 = bl || this.mRestoredScale > 0;
        this.setupViewport(bl2);
        if (!bl2) {
            this.mWebView.mViewManager.postReadyToDrawAll();
        }
        this.mRestoredScreenWidthScale = 0;
        this.mRestoredScale = 0;
        this.mRestoredY = 0;
        this.mRestoredX = 0;
        this.mWebkitScrollY = 0;
        this.mWebkitScrollX = 0;
    }

    private Context getContext() {
        return this.mContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> getPluginClass(String string2, String string3) {
        if (this.mWebView == null) {
            return null;
        }
        PluginManager pluginManager = PluginManager.getInstance(null);
        String string4 = pluginManager.getPluginsAPKName(string2);
        if (string4 == null) {
            Log.w(LOGTAG, "Unable to resolve " + string2 + " to a plugin APK");
            return null;
        }
        try {
            return pluginManager.getPluginClass(string4, string3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(LOGTAG, "Unable to find plugin classloader for the apk (" + string4 + ")");
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e(LOGTAG, "Unable to find plugin class (" + string3 + ") in the apk (" + string4 + ")");
            return null;
        }
    }

    private long getUsedQuota() {
        Collection collection = WebStorage.getInstance().getOriginsSync();
        if (collection == null) {
            return 0L;
        }
        long l = 0L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            l += ((WebStorage.Origin)iterator.next()).getQuota();
        }
        return l;
    }

    private void hideFullScreenPlugin() {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    private void initialize() {
        this.mBrowserFrame = new BrowserFrame(this.mContext, this, this.mCallbackProxy, this.mSettings, this.mJavascriptInterfaces);
        this.mJavascriptInterfaces = null;
        this.mSettings.syncSettingsAndCreateHandler(this.mBrowserFrame);
        WebIconDatabase.getInstance().createHandler();
        WebStorage.getInstance().createHandler();
        GeolocationPermissions.getInstance().createHandler();
        this.mEventHub.transferMessages();
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 107, this.mNativeClass, 0).sendToTarget();
        }
    }

    private void key(KeyEvent keyEvent, boolean bl) {
        block6: {
            block5: {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getUnicodeChar();
                if (n == 0 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() > 0) {
                    n2 = keyEvent.getCharacters().codePointAt(0);
                }
                if (this.nativeKey(n, n2, keyEvent.getRepeatCount(), keyEvent.isShiftPressed(), keyEvent.isAltPressed(), keyEvent.isSymPressed(), bl) || n == 66) break block5;
                if (n < 19 || n > 22) break block6;
                if (this.mWebView != null && keyEvent.isDown()) {
                    Message.obtain(this.mWebView.mPrivateHandler, 110, n).sendToTarget();
                }
            }
            return;
        }
        this.mCallbackProxy.onUnhandledKeyEvent(keyEvent);
    }

    private void loadUrl(String string2, Map<String, String> map) {
        this.mBrowserFrame.loadUrl(string2, map);
    }

    private native void nativeClearContent();

    private native void nativeClick(int var1, int var2);

    private native void nativeCopyContentToPicture(Picture var1);

    private native void nativeDeleteSelection(int var1, int var2, int var3);

    private native boolean nativeDrawContent(Canvas var1, int var2);

    private native void nativeDumpDomTree(boolean var1);

    private native void nativeDumpNavTree();

    private native void nativeDumpRenderTree(boolean var1);

    private native void nativeDumpV8Counters();

    static native String nativeFindAddress(String var0, boolean var1);

    private native boolean nativeFocusBoundsChanged();

    private native void nativeFreeMemory();

    private native void nativeFullScreenPluginHidden(int var1);

    private native void nativeGeolocationPermissionsProvide(String var1, boolean var2, boolean var3);

    private native int nativeGetContentMinPrefWidth();

    private native boolean nativeHandleTouchEvent(int var1, int var2, int var3, int var4);

    private native boolean nativeKey(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7);

    private native void nativeMoveFocus(int var1, int var2);

    private native void nativeMoveMouse(int var1, int var2, int var3);

    private native void nativeMoveMouseIfLatest(int var1, int var2, int var3, int var4);

    private native void nativePause();

    private native boolean nativePictureReady();

    private native void nativeProvideVisitedHistory(String[] var1);

    private native boolean nativeRecordContent(Region var1, Point var2);

    private native void nativeRegisterURLSchemeAsLocal(String var1);

    private native void nativeReplaceTextfieldText(int var1, int var2, String var3, int var4, int var5, int var6);

    private native String nativeRequestLabel(int var1, int var2);

    private native void nativeResume();

    private native String nativeRetrieveAnchorText(int var1, int var2);

    private native String nativeRetrieveHref(int var1, int var2);

    private native void nativeSaveDocumentState(int var1);

    private native void nativeScrollFocusedTextInput(float var1, int var2);

    private native void nativeSendListBoxChoice(int var1);

    private native void nativeSendListBoxChoices(boolean[] var1, int var2);

    private native void nativeSetBackgroundColor(int var1);

    private native void nativeSetFocusControllerActive(boolean var1);

    private native void nativeSetGlobalBounds(int var1, int var2, int var3, int var4);

    private native void nativeSetJsFlags(String var1);

    private native void nativeSetNewStorageLimit(long var1);

    private native void nativeSetScrollOffset(int var1, int var2, int var3);

    private native void nativeSetSelection(int var1, int var2);

    private native void nativeSetSize(int var1, int var2, int var3, float var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void nativeSplitContent();

    private native void nativeTouchUp(int var1, int var2, int var3, int var4, int var5);

    private native void nativeUpdateFrameCache();

    private native void nativeUpdateFrameCacheIfLoading();

    private native boolean nativeValidNodeAndBounds(int var1, int var2, Rect var3);

    /*
     * Enabled aggressive block sorting
     */
    private void needTouchEvents(boolean bl) {
        if (this.mWebView != null) {
            Handler handler = this.mWebView.mPrivateHandler;
            int n = bl ? 1 : 0;
            Message.obtain(handler, 116, n, 0).sendToTarget();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String openFileChooser() {
        Uri uri = this.mCallbackProxy.openFileChooser();
        if (uri == null) {
            return "";
        }
        Cursor cursor = this.mContext.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);
        String string2 = "";
        if (cursor == null) return uri.toString() + "/" + string2;
        try {
            if (cursor.moveToNext()) {
                String string3;
                string2 = string3 = cursor.getString(0);
            }
            cursor.close();
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
        return uri.toString() + "/" + string2;
    }

    private native void passToJs(int var1, String var2, int var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public static void pauseTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.pause();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void pauseUpdatePicture(WebViewCore webViewCore) {
        if (webViewCore == null) {
            return;
        }
        synchronized (webViewCore) {
            webViewCore.mDrawIsPaused = true;
            if (webViewCore.mDrawIsScheduled) {
                webViewCore.mEventHub.removeMessages(130);
            }
            return;
        }
    }

    static void reducePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(1));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestKeyboard(boolean bl) {
        if (this.mWebView != null) {
            Handler handler = this.mWebView.mPrivateHandler;
            int n = bl ? 1 : 0;
            Message.obtain(handler, 118, n, 0).sendToTarget();
        }
    }

    private void requestKeyboardWithSelection(int n, int n2, int n3, int n4) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 128, n, n4, new TextSelectionData(n2, n3)).sendToTarget();
        }
    }

    private void requestListBox(String[] stringArray, int[] nArray, int n) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(stringArray, nArray, n);
        }
    }

    private void requestListBox(String[] stringArray, int[] nArray, int[] nArray2) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(stringArray, nArray, nArray2);
        }
    }

    private void restoreScale(int n) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredScale = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void restoreScreenWidthScale(int n) {
        if (!this.mSettings.getUseWideViewPort() || this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        this.mRestoredScreenWidthScale = n;
    }

    private void restoreState(int n) {
        WebBackForwardList webBackForwardList = this.mCallbackProxy.getBackForwardList();
        int n2 = webBackForwardList.getSize();
        for (int i = 0; i < n2; ++i) {
            webBackForwardList.getItemAtIndex(i).inflate(this.mBrowserFrame.mNativeFrame);
        }
        this.mBrowserFrame.mLoadInitFromJava = true;
        WebBackForwardList.restoreIndex((int)this.mBrowserFrame.mNativeFrame, (int)n);
        this.mBrowserFrame.mLoadInitFromJava = false;
    }

    static void resumePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(2));
    }

    public static void resumeTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.resume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void resumeUpdatePicture(WebViewCore webViewCore) {
        if (webViewCore == null) {
            return;
        }
        synchronized (webViewCore) {
            webViewCore.mDrawIsPaused = false;
            if (webViewCore.mDrawIsScheduled) {
                webViewCore.mDrawIsScheduled = false;
                webViewCore.contentDraw();
            }
            return;
        }
    }

    private void sendFindAgain() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 126).sendToTarget();
    }

    private void sendImmediateRepaint() {
        if (this.mWebView != null && !mRepaintScheduled) {
            mRepaintScheduled = true;
            Message.obtain(this.mWebView.mPrivateHandler, 123).sendToTarget();
        }
    }

    private void sendNotifyProgressFinished() {
        this.sendUpdateTextEntry();
        WebViewWorker.getHandler().removeMessages(110);
        WebViewWorker.getHandler().sendEmptyMessage(110);
        this.contentDraw();
    }

    private void sendUpdateTextEntry() {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 106).sendToTarget();
        }
    }

    private void sendViewInvalidate(int n, int n2, int n3, int n4) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 117, new Rect(n, n2, n3, n4)).sendToTarget();
        }
    }

    private void setRootLayer(int n) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 124, n, 0).sendToTarget();
        }
    }

    private void setScrollbarModes(int n, int n2) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(129, n, n2).sendToTarget();
    }

    private native void setViewportSettingsFromNative();

    /*
     * Enabled aggressive block sorting
     */
    private void setupViewport(boolean bl) {
        int n;
        this.setViewportSettingsFromNative();
        float f = 1.0f;
        if (this.mViewportDensityDpi == -1) {
            if (WebView.DEFAULT_SCALE_PERCENT != 100) {
                f = (float)WebView.DEFAULT_SCALE_PERCENT / 100.0f;
            }
        } else if (this.mViewportDensityDpi > 0) {
            f = (float)this.mContext.getResources().getDisplayMetrics().densityDpi / (float)this.mViewportDensityDpi;
        }
        int n2 = (int)(100.0f * f);
        if (this.mViewportInitialScale > 0) {
            this.mViewportInitialScale = (int)(f * (float)this.mViewportInitialScale);
        }
        if (this.mViewportMinimumScale > 0) {
            this.mViewportMinimumScale = (int)(f * (float)this.mViewportMinimumScale);
        }
        if (this.mViewportMaximumScale > 0) {
            this.mViewportMaximumScale = (int)(f * (float)this.mViewportMaximumScale);
        }
        if (this.mViewportWidth == 0 && this.mViewportInitialScale == 0) {
            this.mViewportInitialScale = n2;
        }
        if (!this.mViewportUserScalable) {
            this.mViewportInitialScale = n2;
            this.mViewportMinimumScale = n2;
            this.mViewportMaximumScale = n2;
        }
        if (this.mViewportMinimumScale > this.mViewportInitialScale && this.mViewportInitialScale != 0) {
            this.mViewportMinimumScale = this.mViewportInitialScale;
        }
        if (this.mViewportMaximumScale > 0 && this.mViewportMaximumScale < this.mViewportInitialScale) {
            this.mViewportMaximumScale = this.mViewportInitialScale;
        }
        if (this.mViewportWidth < 0 && this.mViewportInitialScale == n2) {
            this.mViewportWidth = 0;
        }
        if (this.mViewportWidth != 0 && !bl) {
            RestoreState restoreState = new RestoreState();
            restoreState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
            restoreState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
            restoreState.mDefaultScale = f;
            restoreState.mMobileSite = false;
            restoreState.mScrollX = 0;
            Message.obtain(this.mWebView.mPrivateHandler, 109, restoreState).sendToTarget();
            return;
        }
        int n3 = this.mCurrentViewWidth;
        if (n3 == 0) {
            n = this.mWebView.getViewWidth();
            n3 = (int)((float)n / f);
            if (n3 == 0) {
                Log.w(LOGTAG, "Can't get the viewWidth after the first layout");
            }
        } else {
            n = Math.round((float)n3 * this.mCurrentViewScale);
        }
        this.mRestoreState = new RestoreState();
        this.mRestoreState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
        this.mRestoreState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
        this.mRestoreState.mDefaultScale = f;
        this.mRestoreState.mScrollX = this.mRestoredX;
        this.mRestoreState.mScrollY = this.mRestoredY;
        RestoreState restoreState = this.mRestoreState;
        boolean bl2 = this.mViewportWidth == 0;
        restoreState.mMobileSite = bl2;
        if (this.mRestoredScale > 0) {
            this.mRestoreState.mViewScale = (float)this.mRestoredScale / 100.0f;
            this.mRestoreState.mTextWrapScale = this.mRestoredScreenWidthScale > 0 ? (float)this.mRestoredScreenWidthScale / 100.0f : this.mRestoreState.mViewScale;
        } else if (this.mViewportInitialScale > 0) {
            float f2;
            RestoreState restoreState2 = this.mRestoreState;
            RestoreState restoreState3 = this.mRestoreState;
            restoreState3.mTextWrapScale = f2 = (float)this.mViewportInitialScale / 100.0f;
            restoreState2.mViewScale = f2;
        } else if (this.mViewportWidth > 0 && this.mViewportWidth < n) {
            float f3;
            RestoreState restoreState4 = this.mRestoreState;
            RestoreState restoreState5 = this.mRestoreState;
            restoreState5.mTextWrapScale = f3 = (float)n / (float)this.mViewportWidth;
            restoreState4.mViewScale = f3;
        } else {
            this.mRestoreState.mTextWrapScale = f;
            this.mRestoreState.mViewScale = 0.0f;
        }
        if (this.mWebView.mHeightCanMeasure) {
            this.mWebView.mLastHeightSent = 0;
            WebView.ViewSizeData viewSizeData = new WebView.ViewSizeData();
            viewSizeData.mWidth = this.mWebView.mLastWidthSent;
            viewSizeData.mHeight = 0;
            viewSizeData.mTextWrapWidth = viewSizeData.mWidth;
            viewSizeData.mScale = -1.0f;
            viewSizeData.mIgnoreHeight = false;
            viewSizeData.mAnchorY = 0;
            viewSizeData.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 105, viewSizeData));
            return;
        }
        if (!this.mSettings.getUseWideViewPort()) return;
        if (n3 == 0) {
            this.mWebView.mLastWidthSent = 0;
            return;
        }
        WebView.ViewSizeData viewSizeData = new WebView.ViewSizeData();
        float f4 = this.mRestoreState.mViewScale == 0.0f ? (this.mRestoredScale > 0 ? (float)this.mRestoredScale / 100.0f : this.mRestoreState.mTextWrapScale) : this.mRestoreState.mViewScale;
        viewSizeData.mScale = f4;
        viewSizeData.mWidth = Math.round((float)n / viewSizeData.mScale);
        int n4 = this.mCurrentViewHeight == 0 ? Math.round((float)this.mWebView.getViewHeight() / viewSizeData.mScale) : this.mCurrentViewHeight * viewSizeData.mWidth / n3;
        viewSizeData.mHeight = n4;
        viewSizeData.mTextWrapWidth = Math.round((float)n / this.mRestoreState.mTextWrapScale);
        viewSizeData.mIgnoreHeight = false;
        viewSizeData.mAnchorY = 0;
        viewSizeData.mAnchorX = 0;
        this.mEventHub.removeMessages(105);
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 105, viewSizeData));
    }

    private void showFullScreenPlugin(ViewManager.ChildView childView, int n) {
        if (this.mWebView == null) {
            return;
        }
        Message message = this.mWebView.mPrivateHandler.obtainMessage(120);
        message.obj = childView.mView;
        message.arg1 = n;
        message.sendToTarget();
    }

    private void showRect(int n, int n2, int n3, int n4, int n5, int n6, float f, float f2, float f3, float f4) {
        if (this.mWebView != null) {
            ShowRectData showRectData = new ShowRectData();
            showRectData.mLeft = n;
            showRectData.mTop = n2;
            showRectData.mWidth = n3;
            showRectData.mHeight = n4;
            showRectData.mContentWidth = n5;
            showRectData.mContentHeight = n6;
            showRectData.mXPercentInDoc = f;
            showRectData.mXPercentInView = f2;
            showRectData.mYPercentInDoc = f3;
            showRectData.mYPercentInView = f4;
            Message.obtain(this.mWebView.mPrivateHandler, 113, showRectData).sendToTarget();
        }
    }

    static boolean supportsMimeType(String string2) {
        return MediaFile.getFileTypeForMimeType(string2) > 0;
    }

    private void updateSurface(ViewManager.ChildView childView, int n, int n2, int n3, int n4) {
        childView.attachView(n, n2, n3, n4);
    }

    private void updateTextSelection(int n, int n2, int n3, int n4) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 112, n, n4, new TextSelectionData(n2, n3)).sendToTarget();
        }
    }

    private void updateTextfield(int n, boolean bl, String string2, int n2) {
        if (this.mWebView != null) {
            Message message = Message.obtain(this.mWebView.mPrivateHandler, 108, n, n2, string2);
            message.getData().putBoolean("password", bl);
            message.sendToTarget();
        }
    }

    private void updateViewport() {
        if (this.mBrowserFrame.firstLayoutDone()) {
            this.setupViewport(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void viewSizeChanged(int n, int n2, int n3, float f, int n4, int n5, boolean bl) {
        if (n == 0) {
            Log.w(LOGTAG, "skip viewSizeChanged as w is 0");
            return;
        }
        int n6 = n;
        if (this.mSettings.getUseWideViewPort()) {
            n6 = this.mViewportWidth == -1 ? (this.mSettings.getLayoutAlgorithm() == WebSettings.LayoutAlgorithm.NORMAL ? 800 : Math.min(WebView.sMaxViewportWidth, Math.max(n, Math.max(800, this.nativeGetContentMinPrefWidth())))) : (this.mViewportWidth > 0 ? Math.max(n, this.mViewportWidth) : n3);
        }
        int n7 = n6 == n ? n2 : Math.round((float)n6 * (float)n2 / (float)n);
        this.nativeSetSize(n6, n7, n3, f, n, n2, n4, n5, bl);
        boolean bl2 = this.mCurrentViewWidth == 0;
        this.mCurrentViewWidth = n;
        this.mCurrentViewHeight = n2;
        this.mCurrentViewScale = f;
        if (bl2) {
            this.contentDraw();
        }
        this.mEventHub.sendMessage(Message.obtain(null, 117));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void webkitDraw() {
        block6: {
            block5: {
                this.mDrawIsScheduled = false;
                DrawData drawData = new DrawData();
                if (!this.nativeRecordContent(drawData.mInvalRegion, drawData.mWidthHeight) || this.mWebView == null) break block5;
                drawData.mFocusSizeChanged = this.nativeFocusBoundsChanged();
                drawData.mViewPoint = new Point(this.mCurrentViewWidth, this.mCurrentViewHeight);
                if (this.mSettings.getUseWideViewPort()) {
                    int n = this.mViewportWidth == -1 ? 800 : (this.mViewportWidth == 0 ? this.mCurrentViewWidth : this.mViewportWidth);
                    drawData.mMinPrefWidth = Math.max(n, this.nativeGetContentMinPrefWidth());
                }
                if (this.mRestoreState != null) {
                    drawData.mRestoreState = this.mRestoreState;
                    this.mRestoreState = null;
                }
                Message.obtain(this.mWebView.mPrivateHandler, 105, drawData).sendToTarget();
                if (this.mWebkitScrollX != 0 || this.mWebkitScrollY != 0) break block6;
            }
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 104, this.mWebkitScrollX, this.mWebkitScrollY).sendToTarget();
        this.mWebkitScrollY = 0;
        this.mWebkitScrollX = 0;
    }

    protected void addMessageToConsole(String string2, int n, String string3, int n2) {
        this.mCallbackProxy.addMessageToConsole(string2, n, string3, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void contentDraw() {
        if (this.mCurrentViewWidth == 0 || !this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        synchronized (this) {
            if (this.mDrawIsScheduled) {
                return;
            }
            this.mDrawIsScheduled = true;
            if (this.mDrawIsPaused) {
                return;
            }
            this.mEventHub.sendMessage(Message.obtain(null, 130));
            return;
        }
    }

    Picture copyContentPicture() {
        synchronized (this) {
            Picture picture = new Picture();
            if (this.mNativeClass != 0) {
                this.nativeCopyContentToPicture(picture);
            }
            return picture;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void destroy() {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            boolean bl = this.mEventHub.hasMessages(110);
            boolean bl2 = this.mEventHub.hasMessages(109);
            this.mEventHub.removeMessages();
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 200));
            if (bl2) {
                this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 109));
            }
            if (bl) {
                this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 110));
            }
            this.mEventHub.blockMessages();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawContentPicture(Canvas canvas, int n, boolean bl, boolean bl2) {
        DrawFilter drawFilter;
        if (bl) {
            drawFilter = this.mZoomFilter;
        } else {
            drawFilter = null;
            if (bl2) {
                drawFilter = this.mScrollFilter;
            }
        }
        canvas.setDrawFilter(drawFilter);
        boolean bl3 = this.nativeDrawContent(canvas, n);
        canvas.setDrawFilter(null);
        if (bl3 && !this.mSplitPictureIsScheduled) {
            this.mSplitPictureIsScheduled = true;
            this.sendMessage(133);
        }
    }

    protected void exceededDatabaseQuota(String string2, String string3, long l, long l2) {
        this.mCallbackProxy.onExceededDatabaseQuota(string2, string3, l, l2, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            @Override
            public void updateQuota(long l) {
                WebViewCore.this.nativeSetNewStorageLimit(l);
            }
        });
    }

    protected void geolocationPermissionsHidePrompt() {
        this.mCallbackProxy.onGeolocationPermissionsHidePrompt();
    }

    protected void geolocationPermissionsShowPrompt(String string2) {
        this.mCallbackProxy.onGeolocationPermissionsShowPrompt(string2, new GeolocationPermissions.Callback(){

            @Override
            public void invoke(String string2, boolean bl, boolean bl2) {
                GeolocationPermissionsData geolocationPermissionsData = new GeolocationPermissionsData();
                geolocationPermissionsData.mOrigin = string2;
                geolocationPermissionsData.mAllow = bl;
                geolocationPermissionsData.mRemember = bl2;
                WebViewCore.this.sendMessage(180, geolocationPermissionsData);
            }
        });
    }

    BrowserFrame getBrowserFrame() {
        return this.mBrowserFrame;
    }

    public WebSettings getSettings() {
        return this.mSettings;
    }

    WebView getWebView() {
        return this.mWebView;
    }

    void initializeSubwindow() {
        this.initialize();
        sWebCoreHandler.removeMessages(0, this);
    }

    protected void jsAlert(String string2, String string3) {
        this.mCallbackProxy.onJsAlert(string2, string3);
    }

    protected boolean jsConfirm(String string2, String string3) {
        return this.mCallbackProxy.onJsConfirm(string2, string3);
    }

    protected boolean jsInterrupt() {
        return this.mCallbackProxy.onJsTimeout();
    }

    protected String jsPrompt(String string2, String string3, String string4) {
        return this.mCallbackProxy.onJsPrompt(string2, string3, string4);
    }

    protected boolean jsUnload(String string2, String string3) {
        return this.mCallbackProxy.onJsBeforeUnload(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pictureReady() {
        synchronized (this) {
            if (this.mNativeClass == 0) return false;
            boolean bl = this.nativePictureReady();
            return bl;
        }
    }

    protected void populateVisitedLinks() {
        ValueCallback<String[]> valueCallback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(String[] stringArray) {
                WebViewCore.this.sendMessage(181, stringArray);
            }
        };
        this.mCallbackProxy.getVisitedHistory(valueCallback);
    }

    protected void reachedMaxAppCacheSize(long l) {
        this.mCallbackProxy.onReachedMaxAppCacheSize(l, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            @Override
            public void updateQuota(long l) {
                WebViewCore.this.nativeSetNewStorageLimit(l);
            }
        });
    }

    void removeMessages() {
        this.mEventHub.removeMessages();
    }

    void removeMessages(int n) {
        this.mEventHub.removeMessages(n);
    }

    void sendMessage(int n) {
        this.mEventHub.sendMessage(Message.obtain(null, n));
    }

    void sendMessage(int n, int n2) {
        this.mEventHub.sendMessage(Message.obtain(null, n, n2, 0));
    }

    void sendMessage(int n, int n2, int n3) {
        this.mEventHub.sendMessage(Message.obtain(null, n, n2, n3));
    }

    void sendMessage(int n, int n2, int n3, Object object) {
        this.mEventHub.sendMessage(Message.obtain(null, n, n2, n3, object));
    }

    void sendMessage(int n, int n2, Object object) {
        this.mEventHub.sendMessage(Message.obtain(null, n, n2, 0, object));
    }

    void sendMessage(int n, Object object) {
        this.mEventHub.sendMessage(Message.obtain(null, n, object));
    }

    void sendMessage(Message message) {
        this.mEventHub.sendMessage(message);
    }

    void sendMessageAtFrontOfQueue(int n, Object object) {
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, n, object));
    }

    void sendMessageDelayed(int n, Object object, long l) {
        this.mEventHub.sendMessageDelayed(Message.obtain(null, n, object), l);
    }

    void signalRepaintDone() {
        mRepaintScheduled = false;
    }

    void stopLoading() {
        if (this.mBrowserFrame != null) {
            this.mBrowserFrame.stopLoading();
        }
    }

    static class BaseUrlData {
        String mBaseUrl;
        String mData;
        String mEncoding;
        String mHistoryUrl;
        String mMimeType;

        BaseUrlData() {
        }
    }

    static class CursorData {
        int mFrame;
        int mMoveGeneration;
        int mNode;
        int mX;
        int mY;

        CursorData() {
        }

        CursorData(int n, int n2, int n3, int n4) {
            this.mFrame = n;
            this.mNode = n2;
            this.mX = n3;
            this.mY = n4;
        }
    }

    static class DrawData {
        boolean mFocusSizeChanged;
        Region mInvalRegion = new Region();
        int mMinPrefWidth;
        RestoreState mRestoreState;
        Point mViewPoint;
        Point mWidthHeight = new Point();

        DrawData() {
        }
    }

    class EventHub {
        static final int ADD_JS_INTERFACE = 138;
        static final int ADD_PACKAGE_NAME = 185;
        static final int ADD_PACKAGE_NAMES = 184;
        static final int CLEAR_CACHE = 111;
        static final int CLEAR_CONTENT = 134;
        static final int CLEAR_HISTORY = 112;
        static final int CLEAR_SSL_PREF_TABLE = 150;
        static final int CLICK = 118;
        static final int DELETE_SELECTION = 122;
        private static final int DESTROY = 200;
        static final int DOC_HAS_IMAGES = 120;
        static final int DUMP_DOMTREE = 170;
        static final int DUMP_NAVTREE = 172;
        static final int DUMP_RENDERTREE = 171;
        static final int DUMP_V8COUNTERS = 173;
        static final int FREE_MEMORY = 145;
        static final int GEOLOCATION_PERMISSIONS_PROVIDE = 180;
        static final int GO_BACK_FORWARD = 106;
        static final int HIDE_FULLSCREEN = 182;
        static final int KEY_DOWN = 103;
        static final int KEY_UP = 104;
        static final int LISTBOX_CHOICES = 123;
        static final int LOAD_DATA = 139;
        static final int LOAD_URL = 100;
        static final int MESSAGE_RELAY = 125;
        static final int ON_PAUSE = 143;
        static final int ON_RESUME = 144;
        static final int PASS_TO_JS = 115;
        static final int PAUSE_TIMERS = 109;
        static final int POPULATE_VISITED_LINKS = 181;
        static final int POST_URL = 132;
        static final int RELOAD = 102;
        static final int REMOVE_PACKAGE_NAME = 186;
        static final int REPLACE_TEXT = 114;
        static final int REQUEST_CURSOR_HREF = 137;
        static final int REQUEST_DOC_AS_TEXT = 161;
        static final int REQUEST_EXT_REPRESENTATION = 160;
        static final int REQUEST_LABEL = 97;
        static final int RESTORE_STATE = 108;
        static final int RESUME_TIMERS = 110;
        static final int SAVE_DOCUMENT_STATE = 128;
        static final int SCROLL_TEXT_INPUT = 99;
        static final int SET_ACTIVE = 142;
        static final int SET_BACKGROUND_COLOR = 126;
        static final int SET_GLOBAL_BOUNDS = 116;
        static final int SET_JS_FLAGS = 174;
        static final int SET_MOVE_FOCUS = 127;
        static final int SET_MOVE_MOUSE = 135;
        static final int SET_MOVE_MOUSE_IF_LATEST = 136;
        static final int SET_NETWORK_STATE = 119;
        static final int SET_NETWORK_TYPE = 183;
        static final int SET_SCROLL_OFFSET = 107;
        static final int SET_SELECTION = 113;
        static final int SINGLE_LISTBOX_CHOICE = 124;
        static final int SPLIT_PICTURE_SET = 133;
        static final int STOP_LOADING = 101;
        static final int SYNC_SCROLL = 131;
        static final int TOUCH_EVENT = 141;
        static final int TOUCH_UP = 140;
        static final int UPDATE_CACHE_AND_TEXT_ENTRY = 117;
        static final int UPDATE_FRAME_CACHE_IF_LOADING = 98;
        static final int VALID_NODE_BOUNDS = 146;
        static final int VIEW_SIZE_CHANGED = 105;
        static final int WEBKIT_DRAW = 130;
        private boolean mBlockMessages;
        private Handler mHandler;
        private ArrayList<Message> mMessages = new ArrayList();
        private int mSavedPriority;
        private int mTid;

        private EventHub() {
        }

        static /* synthetic */ int access$2202(EventHub eventHub, int n) {
            eventHub.mSavedPriority = n;
            return n;
        }

        private void blockMessages() {
            synchronized (this) {
                this.mBlockMessages = true;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasMessages(int n) {
            synchronized (this) {
                block6: {
                    block5: {
                        boolean bl = this.mBlockMessages;
                        if (!bl) break block5;
                        return false;
                    }
                    if (this.mMessages == null) break block6;
                    Log.w(WebViewCore.LOGTAG, "hasMessages() is not supported in this case.");
                    return false;
                }
                boolean bl = this.mHandler.hasMessages(n);
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeMessages() {
            synchronized (this) {
                WebViewCore.access$6202(WebViewCore.this, false);
                WebViewCore.access$5702(WebViewCore.this, false);
                if (this.mMessages != null) {
                    this.mMessages.clear();
                } else {
                    this.mHandler.removeCallbacksAndMessages(null);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeMessages(int n) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (n == 130) {
                        WebViewCore.access$6202(WebViewCore.this, false);
                    }
                    if (this.mMessages != null) {
                        Log.w(WebViewCore.LOGTAG, "Not supported in this case.");
                    } else {
                        this.mHandler.removeMessages(n);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendMessage(Message message) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (this.mMessages != null) {
                        this.mMessages.add(message);
                    } else {
                        this.mHandler.sendMessage(message);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendMessageAtFrontOfQueue(Message message) {
            synchronized (this) {
                boolean bl = this.mBlockMessages;
                if (!bl) {
                    if (this.mMessages != null) {
                        this.mMessages.add(0, message);
                    } else {
                        this.mHandler.sendMessageAtFrontOfQueue(message);
                    }
                }
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendMessageDelayed(Message message, long l) {
            synchronized (this) {
                block6: {
                    boolean bl = this.mBlockMessages;
                    if (!bl) break block6;
                    return;
                }
                this.mHandler.sendMessageDelayed(message, l);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void transferMessages() {
            this.mTid = Process.myTid();
            this.mSavedPriority = Process.getThreadPriority(this.mTid);
            this.mHandler = new Handler(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void handleMessage(Message message) {
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 130: {
                            WebViewCore.this.webkitDraw();
                            return;
                        }
                        case 200: {
                            WebViewCore webViewCore = WebViewCore.this;
                            // MONITORENTER : webViewCore
                            WebViewCore.this.mBrowserFrame.destroy();
                            WebViewCore.access$702(WebViewCore.this, null);
                            WebViewCore.this.mSettings.onDestroyed();
                            WebViewCore.access$902(WebViewCore.this, 0);
                            WebViewCore.access$1002(WebViewCore.this, null);
                            // MONITOREXIT : webViewCore
                            return;
                        }
                        case 97: {
                            if (WebViewCore.this.mWebView == null) return;
                            int n = message.arg2;
                            String string2 = WebViewCore.this.nativeRequestLabel(message.arg1, n);
                            if (string2 == null) return;
                            if (string2.length() <= 0) return;
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler, 125, n, 0, string2).sendToTarget();
                            return;
                        }
                        case 98: {
                            WebViewCore.this.nativeUpdateFrameCacheIfLoading();
                            return;
                        }
                        case 99: {
                            WebViewCore.this.nativeScrollFocusedTextInput(((Float)message.obj).floatValue(), message.arg1);
                            return;
                        }
                        case 100: {
                            GetUrlData getUrlData = (GetUrlData)message.obj;
                            WebViewCore.this.loadUrl(getUrlData.mUrl, getUrlData.mExtraHeaders);
                            return;
                        }
                        case 132: {
                            PostUrlData postUrlData = (PostUrlData)message.obj;
                            WebViewCore.this.mBrowserFrame.postUrl(postUrlData.mUrl, postUrlData.mPostData);
                            return;
                        }
                        case 139: {
                            String string3;
                            int n;
                            BaseUrlData baseUrlData = (BaseUrlData)message.obj;
                            String string4 = baseUrlData.mBaseUrl;
                            if (!(string4 == null || (n = string4.indexOf(58)) <= 0 || (string3 = string4.substring(0, n)).startsWith("http") || string3.startsWith("ftp") || string3.startsWith("about") || string3.startsWith("javascript"))) {
                                WebViewCore.this.nativeRegisterURLSchemeAsLocal(string3);
                            }
                            WebViewCore.this.mBrowserFrame.loadData(string4, baseUrlData.mData, baseUrlData.mMimeType, baseUrlData.mEncoding, baseUrlData.mHistoryUrl);
                            return;
                        }
                        case 101: {
                            if (WebViewCore.this.mBrowserFrame.committed() && !WebViewCore.this.mBrowserFrame.firstLayoutDone()) {
                                WebViewCore.this.mBrowserFrame.didFirstLayout();
                            }
                            WebViewCore.this.stopLoading();
                            return;
                        }
                        case 102: {
                            WebViewCore.this.mBrowserFrame.reload(false);
                            return;
                        }
                        case 103: {
                            WebViewCore.this.key((KeyEvent)message.obj, true);
                            return;
                        }
                        case 104: {
                            WebViewCore.this.key((KeyEvent)message.obj, false);
                            return;
                        }
                        case 118: {
                            WebViewCore.this.nativeClick(message.arg1, message.arg2);
                            return;
                        }
                        case 105: {
                            WebView.ViewSizeData viewSizeData = (WebView.ViewSizeData)message.obj;
                            WebViewCore.this.viewSizeChanged(viewSizeData.mWidth, viewSizeData.mHeight, viewSizeData.mTextWrapWidth, viewSizeData.mScale, viewSizeData.mAnchorX, viewSizeData.mAnchorY, viewSizeData.mIgnoreHeight);
                            return;
                        }
                        case 107: {
                            Point point = (Point)message.obj;
                            WebViewCore.this.nativeSetScrollOffset(message.arg1, point.x, point.y);
                            return;
                        }
                        case 116: {
                            Rect rect = (Rect)message.obj;
                            WebViewCore.this.nativeSetGlobalBounds(rect.left, rect.top, rect.width(), rect.height());
                            return;
                        }
                        case 106: {
                            if (!WebViewCore.this.mBrowserFrame.committed() && message.arg1 == -1 && WebViewCore.this.mBrowserFrame.loadType() == 0) {
                                WebViewCore.this.mBrowserFrame.reload(true);
                                return;
                            }
                            WebViewCore.this.mBrowserFrame.goBackOrForward(message.arg1);
                            return;
                        }
                        case 108: {
                            WebViewCore.this.stopLoading();
                            WebViewCore.this.restoreState(message.arg1);
                            return;
                        }
                        case 109: {
                            EventHub.access$2202(EventHub.this, Process.getThreadPriority(EventHub.this.mTid));
                            Process.setThreadPriority(EventHub.this.mTid, 10);
                            WebViewCore.pauseTimers();
                            WebViewWorker.getHandler().sendEmptyMessage(111);
                            return;
                        }
                        case 110: {
                            Process.setThreadPriority(EventHub.this.mTid, EventHub.this.mSavedPriority);
                            WebViewCore.resumeTimers();
                            WebViewWorker.getHandler().sendEmptyMessage(112);
                            return;
                        }
                        case 143: {
                            WebViewCore.this.nativePause();
                            return;
                        }
                        case 144: {
                            WebViewCore.this.nativeResume();
                            return;
                        }
                        case 145: {
                            WebViewCore.this.clearCache(false);
                            WebViewCore.this.nativeFreeMemory();
                            return;
                        }
                        case 119: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            JWebCoreJavaBridge jWebCoreJavaBridge = BrowserFrame.sJavaBridge;
                            boolean bl = message.arg1 == 1;
                            jWebCoreJavaBridge.setNetworkOnLine(bl);
                            return;
                        }
                        case 183: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            Map map = (Map)message.obj;
                            BrowserFrame.sJavaBridge.setNetworkType((String)map.get("type"), (String)map.get("subtype"));
                            return;
                        }
                        case 111: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.clearCache(bl);
                            return;
                        }
                        case 112: {
                            WebViewCore.this.mCallbackProxy.getBackForwardList().close(((WebViewCore)WebViewCore.this).mBrowserFrame.mNativeFrame);
                            return;
                        }
                        case 114: {
                            ReplaceTextData replaceTextData = (ReplaceTextData)message.obj;
                            WebViewCore.this.nativeReplaceTextfieldText(message.arg1, message.arg2, replaceTextData.mReplace, replaceTextData.mNewStart, replaceTextData.mNewEnd, replaceTextData.mTextGeneration);
                            return;
                        }
                        case 115: {
                            JSKeyData jSKeyData = (JSKeyData)message.obj;
                            KeyEvent keyEvent = jSKeyData.mEvent;
                            int n = keyEvent.getKeyCode();
                            int n2 = keyEvent.getUnicodeChar();
                            int n3 = message.arg1;
                            WebViewCore.this.passToJs(n3, jSKeyData.mCurrentText, n, n2, keyEvent.isDown(), keyEvent.isShiftPressed(), keyEvent.isAltPressed(), keyEvent.isSymPressed());
                            return;
                        }
                        case 128: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore.this.nativeSaveDocumentState(cursorData.mFrame);
                            return;
                        }
                        case 150: {
                            Network.getInstance(WebViewCore.this.mContext).clearUserSslPrefTable();
                            return;
                        }
                        case 140: {
                            TouchUpData touchUpData = (TouchUpData)message.obj;
                            WebViewCore.this.nativeTouchUp(touchUpData.mMoveGeneration, touchUpData.mFrame, touchUpData.mNode, touchUpData.mX, touchUpData.mY);
                            return;
                        }
                        case 141: {
                            TouchEventData touchEventData = (TouchEventData)message.obj;
                            Handler handler = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler;
                            int n = touchEventData.mAction;
                            int n4 = WebViewCore.this.nativeHandleTouchEvent(touchEventData.mAction, touchEventData.mX, touchEventData.mY, touchEventData.mMetaState) ? 1 : 0;
                            TouchEventData touchEventData2 = touchEventData.mReprocess ? touchEventData : null;
                            Message.obtain(handler, 115, n, n4, touchEventData2).sendToTarget();
                            return;
                        }
                        case 142: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeSetFocusControllerActive(bl);
                            return;
                        }
                        case 138: {
                            JSInterfaceData jSInterfaceData = (JSInterfaceData)message.obj;
                            WebViewCore.this.mBrowserFrame.addJavascriptInterface(jSInterfaceData.mObject, jSInterfaceData.mInterfaceName);
                            return;
                        }
                        case 160: {
                            WebViewCore.this.mBrowserFrame.externalRepresentation((Message)message.obj);
                            return;
                        }
                        case 161: {
                            WebViewCore.this.mBrowserFrame.documentAsText((Message)message.obj);
                            return;
                        }
                        case 127: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore.this.nativeMoveFocus(cursorData.mFrame, cursorData.mNode);
                            return;
                        }
                        case 135: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore.this.nativeMoveMouse(cursorData.mFrame, cursorData.mX, cursorData.mY);
                            return;
                        }
                        case 136: {
                            CursorData cursorData = (CursorData)message.obj;
                            WebViewCore.this.nativeMoveMouseIfLatest(cursorData.mMoveGeneration, cursorData.mFrame, cursorData.mX, cursorData.mY);
                            return;
                        }
                        case 137: {
                            Message message2 = (Message)message.obj;
                            message2.getData().putString("url", WebViewCore.this.nativeRetrieveHref(message.arg1, message.arg2));
                            message2.getData().putString("title", WebViewCore.this.nativeRetrieveAnchorText(message.arg1, message.arg2));
                            message2.sendToTarget();
                            return;
                        }
                        case 117: {
                            WebViewCore.this.nativeUpdateFrameCache();
                            if (WebViewCore.this.mWebView != null) {
                                WebViewCore.this.mWebView.postInvalidate();
                            }
                            WebViewCore.this.sendUpdateTextEntry();
                            return;
                        }
                        case 120: {
                            Message message3 = (Message)message.obj;
                            int n = WebViewCore.this.mBrowserFrame.documentHasImages() ? 1 : 0;
                            message3.arg1 = n;
                            message3.sendToTarget();
                            return;
                        }
                        case 122: {
                            TextSelectionData textSelectionData = (TextSelectionData)message.obj;
                            WebViewCore.this.nativeDeleteSelection(textSelectionData.mStart, textSelectionData.mEnd, message.arg1);
                            return;
                        }
                        case 113: {
                            WebViewCore.this.nativeSetSelection(message.arg1, message.arg2);
                            return;
                        }
                        case 123: {
                            SparseBooleanArray sparseBooleanArray = (SparseBooleanArray)message.obj;
                            int n = message.arg1;
                            boolean[] blArray = new boolean[n];
                            int n5 = 0;
                            while (true) {
                                if (n5 >= n) {
                                    WebViewCore.this.nativeSendListBoxChoices(blArray, n);
                                    return;
                                }
                                blArray[n5] = sparseBooleanArray.get(n5);
                                ++n5;
                            }
                        }
                        case 124: {
                            WebViewCore.this.nativeSendListBoxChoice(message.arg1);
                            return;
                        }
                        case 126: {
                            WebViewCore.this.nativeSetBackgroundColor(message.arg1);
                            return;
                        }
                        case 170: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeDumpDomTree(bl);
                            return;
                        }
                        case 171: {
                            WebViewCore webViewCore = WebViewCore.this;
                            boolean bl = message.arg1 == 1;
                            webViewCore.nativeDumpRenderTree(bl);
                            return;
                        }
                        case 172: {
                            WebViewCore.this.nativeDumpNavTree();
                            return;
                        }
                        case 173: {
                            WebViewCore.this.nativeDumpV8Counters();
                            return;
                        }
                        case 174: {
                            WebViewCore.this.nativeSetJsFlags((String)message.obj);
                            return;
                        }
                        case 180: {
                            GeolocationPermissionsData geolocationPermissionsData = (GeolocationPermissionsData)message.obj;
                            WebViewCore.this.nativeGeolocationPermissionsProvide(geolocationPermissionsData.mOrigin, geolocationPermissionsData.mAllow, geolocationPermissionsData.mRemember);
                            return;
                        }
                        case 131: {
                            WebViewCore.access$5402(WebViewCore.this, message.arg1);
                            WebViewCore.access$5502(WebViewCore.this, message.arg2);
                            return;
                        }
                        case 133: {
                            WebViewCore.this.nativeSplitContent();
                            WebViewCore.access$5702(WebViewCore.this, false);
                            return;
                        }
                        case 134: {
                            WebViewCore.this.nativeClearContent();
                            return;
                        }
                        case 125: {
                            if (!(message.obj instanceof Message)) return;
                            ((Message)message.obj).sendToTarget();
                            return;
                        }
                        case 181: {
                            WebViewCore.this.nativeProvideVisitedHistory((String[])message.obj);
                            return;
                        }
                        case 146: {
                            MotionUpData motionUpData = (MotionUpData)message.obj;
                            if (!WebViewCore.this.nativeValidNodeAndBounds(motionUpData.mFrame, motionUpData.mNode, motionUpData.mBounds)) {
                                WebViewCore.this.nativeUpdateFrameCache();
                            }
                            Message message4 = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(119, motionUpData.mX, motionUpData.mY);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.sendMessageAtFrontOfQueue(message4);
                            return;
                        }
                        case 182: {
                            WebViewCore.this.nativeFullScreenPluginHidden(message.arg1);
                            return;
                        }
                        case 184: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.addPackageNames((Set)message.obj);
                            return;
                        }
                        case 185: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.addPackageName((String)message.obj);
                            return;
                        }
                        case 186: 
                    }
                    if (BrowserFrame.sJavaBridge == null) {
                        throw new IllegalStateException("No WebView has been created in this process!");
                    }
                    BrowserFrame.sJavaBridge.removePackageName((String)message.obj);
                }
            };
            synchronized (this) {
                int n = this.mMessages.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this.mMessages = null;
                        return;
                    }
                    this.mHandler.sendMessage(this.mMessages.get(n2));
                    ++n2;
                }
            }
        }
    }

    static class GeolocationPermissionsData {
        boolean mAllow;
        String mOrigin;
        boolean mRemember;

        GeolocationPermissionsData() {
        }
    }

    static class GetUrlData {
        Map<String, String> mExtraHeaders;
        String mUrl;

        GetUrlData() {
        }
    }

    static class JSInterfaceData {
        String mInterfaceName;
        Object mObject;

        JSInterfaceData() {
        }
    }

    static class JSKeyData {
        String mCurrentText;
        KeyEvent mEvent;

        JSKeyData() {
        }
    }

    static class MotionUpData {
        Rect mBounds;
        int mFrame;
        int mNode;
        int mX;
        int mY;

        MotionUpData() {
        }
    }

    static class PostUrlData {
        byte[] mPostData;
        String mUrl;

        PostUrlData() {
        }
    }

    static class ReplaceTextData {
        int mNewEnd;
        int mNewStart;
        String mReplace;
        int mTextGeneration;

        ReplaceTextData() {
        }
    }

    static class RestoreState {
        float mDefaultScale;
        float mMaxScale;
        float mMinScale;
        boolean mMobileSite;
        int mScrollX;
        int mScrollY;
        float mTextWrapScale;
        float mViewScale;

        RestoreState() {
        }
    }

    static class ShowRectData {
        int mContentHeight;
        int mContentWidth;
        int mHeight;
        int mLeft;
        int mTop;
        int mWidth;
        float mXPercentInDoc;
        float mXPercentInView;
        float mYPercentInDoc;
        float mYPercentInView;

        ShowRectData() {
        }
    }

    static class TextSelectionData {
        int mEnd;
        int mStart;

        public TextSelectionData(int n, int n2) {
            this.mStart = n;
            this.mEnd = n2;
        }
    }

    static class TouchEventData {
        int mAction;
        int mMetaState;
        boolean mReprocess;
        float mViewX;
        float mViewY;
        int mX;
        int mY;

        TouchEventData() {
        }
    }

    static class TouchUpData {
        int mFrame;
        int mMoveGeneration;
        int mNode;
        int mX;
        int mY;

        TouchUpData() {
        }
    }

    private static class WebCoreThread
    implements Runnable {
        private static final int INITIALIZE = 0;
        private static final int REDUCE_PRIORITY = 1;
        private static final int RESUME_PRIORITY = 2;

        private WebCoreThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            Assert.assertNull(sWebCoreHandler);
            synchronized (WebViewCore.class) {
                WebViewCore.access$402(new Handler(){

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            default: {
                                return;
                            }
                            case 0: {
                                ((WebViewCore)message.obj).initialize();
                                return;
                            }
                            case 1: {
                                Process.setThreadPriority(3);
                                return;
                            }
                            case 2: 
                        }
                        Process.setThreadPriority(0);
                    }
                });
                WebViewCore.class.notify();
            }
            Looper.loop();
        }
    }
}

