/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheManager;
import android.webkit.FrameLoader;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class WebViewWorker
extends Handler {
    private static final int CACHE_TRANSACTION_TICKER_INTERVAL = 60000;
    static final int MSG_ADD_HTTPLOADER = 102;
    static final int MSG_ADD_STREAMLOADER = 101;
    static final int MSG_APPEND_CACHE = 105;
    static final int MSG_CACHE_TRANSACTION_TICKER = 110;
    static final int MSG_CLEAR_CACHE = 109;
    static final int MSG_CREATE_CACHE = 103;
    static final int MSG_PAUSE_CACHE_TRANSACTION = 111;
    static final int MSG_REMOVE_CACHE = 107;
    static final int MSG_RESUME_CACHE_TRANSACTION = 112;
    static final int MSG_SAVE_CACHE = 106;
    static final int MSG_TRIM_CACHE = 108;
    static final int MSG_UPDATE_CACHE_ENCODING = 104;
    private static final String THREAD_NAME = "WebViewWorkerThread";
    private static Map<LoadListener, CacheManager.CacheResult> mCacheResultMap = new HashMap<LoadListener, CacheManager.CacheResult>();
    private static boolean mCacheTickersBlocked = true;
    private static WebViewWorker sWorkerHandler;

    private WebViewWorker(Looper looper) {
        super(looper);
    }

    static WebViewWorker getHandler() {
        synchronized (WebViewWorker.class) {
            if (sWorkerHandler == null) {
                HandlerThread handlerThread = new HandlerThread(THREAD_NAME, 1);
                handlerThread.start();
                sWorkerHandler = new WebViewWorker(handlerThread.getLooper());
            }
            WebViewWorker webViewWorker = sWorkerHandler;
            return webViewWorker;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 101: {
                ((StreamLoader)message.obj).load();
                return;
            }
            case 102: {
                ((FrameLoader)message.obj).handleHTTPLoad();
                return;
            }
            case 103: {
                CacheCreateData cacheCreateData = (CacheCreateData)message.obj;
                CacheManager.CacheResult cacheResult = CacheManager.createCacheFile((String)cacheCreateData.mUrl, (int)cacheCreateData.mStatusCode, (Headers)cacheCreateData.mHeaders, (String)cacheCreateData.mMimeType, (long)cacheCreateData.mPostId, (boolean)false);
                if (cacheResult != null) {
                    mCacheResultMap.put(cacheCreateData.mListener, cacheResult);
                    return;
                }
                mCacheResultMap.remove(cacheCreateData.mListener);
                return;
            }
            case 104: {
                CacheEncoding cacheEncoding = (CacheEncoding)message.obj;
                CacheManager.CacheResult cacheResult = mCacheResultMap.get(cacheEncoding.mListener);
                if (cacheResult == null) return;
                cacheResult.encoding = cacheEncoding.mEncoding;
                return;
            }
            case 105: {
                CacheData cacheData = (CacheData)message.obj;
                CacheManager.CacheResult cacheResult = mCacheResultMap.get(cacheData.mListener);
                if (cacheResult != null) {
                    cacheResult.contentLength += (long)cacheData.mChunk.mLength;
                    if (cacheResult.contentLength > CacheManager.CACHE_MAX_SIZE) {
                        CacheManager.cleanupCacheFile((CacheManager.CacheResult)cacheResult);
                        mCacheResultMap.remove(cacheData.mListener);
                    } else {
                        try {
                            cacheResult.outStream.write(cacheData.mChunk.mArray, 0, cacheData.mChunk.mLength);
                        }
                        catch (IOException iOException) {
                            CacheManager.cleanupCacheFile((CacheManager.CacheResult)cacheResult);
                            mCacheResultMap.remove(cacheData.mListener);
                        }
                    }
                }
                cacheData.mChunk.release();
                return;
            }
            case 106: {
                CacheSaveData cacheSaveData = (CacheSaveData)message.obj;
                CacheManager.CacheResult cacheResult = mCacheResultMap.get(cacheSaveData.mListener);
                if (cacheResult == null) return;
                CacheManager.saveCacheFile((String)cacheSaveData.mUrl, (long)cacheSaveData.mPostId, (CacheManager.CacheResult)cacheResult);
                mCacheResultMap.remove(cacheSaveData.mListener);
                return;
            }
            case 107: {
                LoadListener loadListener = (LoadListener)message.obj;
                CacheManager.CacheResult cacheResult = mCacheResultMap.get(loadListener);
                if (cacheResult == null) return;
                CacheManager.cleanupCacheFile((CacheManager.CacheResult)cacheResult);
                mCacheResultMap.remove(loadListener);
                return;
            }
            case 108: {
                CacheManager.trimCacheIfNeeded();
                return;
            }
            case 109: {
                CacheManager.clearCache();
                return;
            }
            case 110: {
                if (mCacheTickersBlocked) return;
                CacheManager.endTransaction();
                CacheManager.startTransaction();
                this.sendEmptyMessageDelayed(110, 60000L);
                return;
            }
            case 111: {
                if (!CacheManager.disableTransaction()) return;
                mCacheTickersBlocked = true;
                this.removeMessages(110);
                return;
            }
            default: {
                return;
            }
            case 112: 
        }
        if (!CacheManager.enableTransaction()) return;
        mCacheTickersBlocked = false;
        this.sendEmptyMessageDelayed(110, 60000L);
    }

    static class CacheCreateData {
        Headers mHeaders;
        LoadListener mListener;
        String mMimeType;
        long mPostId;
        int mStatusCode;
        String mUrl;

        CacheCreateData() {
        }
    }

    static class CacheData {
        ByteArrayBuilder.Chunk mChunk;
        LoadListener mListener;

        CacheData() {
        }
    }

    static class CacheEncoding {
        String mEncoding;
        LoadListener mListener;

        CacheEncoding() {
        }
    }

    static class CacheSaveData {
        LoadListener mListener;
        long mPostId;
        String mUrl;

        CacheSaveData() {
        }
    }
}

