/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppSecurityPermissions
implements View.OnClickListener {
    private static final String TAG = "AppSecurityPermissions";
    private boolean localLOGV = false;
    private Context mContext;
    private State mCurrentState;
    private Drawable mDangerousIcon;
    private LinearLayout mDangerousList;
    private Map<String, String> mDangerousMap;
    private String mDefaultGrpLabel;
    private String mDefaultGrpName = "DefaultGrp";
    private boolean mExpanded;
    private HashMap<String, CharSequence> mGroupLabelCache;
    private LayoutInflater mInflater;
    private View mNoPermsView;
    private LinearLayout mNonDangerousList;
    private Drawable mNormalIcon;
    private Map<String, String> mNormalMap;
    private String mPermFormat;
    private List<PermissionInfo> mPermsList;
    private LinearLayout mPermsView;
    private PackageManager mPm;
    private Drawable mShowMaxIcon;
    private Drawable mShowMinIcon;
    private View mShowMore;
    private ImageView mShowMoreIcon;
    private TextView mShowMoreText;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppSecurityPermissions(Context context, PackageParser.Package package_) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = new ArrayList<PermissionInfo>();
        HashSet<PermissionInfo> hashSet = new HashSet<PermissionInfo>();
        if (package_ != null) {
            ArrayList<String> arrayList;
            int n;
            if (package_.requestedPermissions != null && (n = (arrayList = package_.requestedPermissions).size()) > 0) {
                this.extractPerms(arrayList.toArray(new String[n]), hashSet);
            }
            if (package_.mSharedUserId != null) {
                try {
                    this.getAllUsedPermissions(this.mPm.getUidForSharedUser(package_.mSharedUserId), hashSet);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w(TAG, "Could'nt retrieve shared user id for:" + package_.packageName);
                }
            }
            for (PermissionInfo permissionInfo : hashSet) {
                this.mPermsList.add(permissionInfo);
            }
        }
    }

    public AppSecurityPermissions(Context context, String string2) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = new ArrayList<PermissionInfo>();
        HashSet<PermissionInfo> hashSet = new HashSet<PermissionInfo>();
        try {
            PackageInfo packageInfo = this.mPm.getPackageInfo(string2, 4096);
            if (packageInfo.applicationInfo != null && packageInfo.applicationInfo.uid != -1) {
                this.getAllUsedPermissions(packageInfo.applicationInfo.uid, hashSet);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Could'nt retrieve permissions for package:" + string2);
        }
        for (PermissionInfo permissionInfo : hashSet) {
            this.mPermsList.add(permissionInfo);
        }
    }

    public AppSecurityPermissions(Context context, List<PermissionInfo> list) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void aggregateGroupDescs(Map<String, List<PermissionInfo>> map, Map<String, String> map2) {
        if (map != null && map2 != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = null;
                String string3 = iterator.next();
                List<PermissionInfo> list = map.get(string3);
                if (list == null) continue;
                Iterator<PermissionInfo> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    string2 = this.formatPermissions(string2, iterator2.next().loadLabel(this.mPm));
                }
                if (string2 == null) continue;
                if (this.localLOGV) {
                    Log.i(TAG, "Group:" + string3 + " description:" + string2.toString());
                }
                map2.put(string3, string2.toString());
            }
        }
    }

    private String canonicalizeGroupDesc(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        int n = string2.length();
        if (string2.charAt(n - 1) == '.') {
            string2 = string2.substring(0, n - 1);
        }
        return string2;
    }

    private void displayNoPermissions() {
        this.mNoPermsView.setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void displayPermissions(boolean bl) {
        Map<String, String> map = bl ? this.mDangerousMap : this.mNormalMap;
        LinearLayout linearLayout = bl ? this.mDangerousList : this.mNonDangerousList;
        linearLayout.removeAllViews();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            CharSequence charSequence = this.getGroupLabel(string2);
            if (this.localLOGV) {
                Log.i(TAG, "Adding view group:" + charSequence + ", desc:" + map.get(string2));
            }
            linearLayout.addView(this.getPermissionItemView(charSequence, map.get(string2), bl));
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractPerms(String[] stringArray, Set<PermissionInfo> set) {
        if (stringArray != null && stringArray.length != 0) {
            for (String string2 : stringArray) {
                try {
                    PermissionInfo permissionInfo = this.mPm.getPermissionInfo(string2, 0);
                    if (permissionInfo == null) continue;
                    set.add(permissionInfo);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.i(TAG, "Ignoring unknown permission:" + string2);
                }
            }
        }
    }

    private String formatPermissions(String string2, CharSequence charSequence) {
        if (string2 == null) {
            if (charSequence == null) {
                return null;
            }
            return ((Object)charSequence).toString();
        }
        String string3 = this.canonicalizeGroupDesc(string2);
        if (charSequence == null) {
            return string3;
        }
        String string4 = this.mPermFormat;
        Object[] objectArray = new Object[]{string3, ((Object)charSequence).toString()};
        return String.format(string4, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getAllUsedPermissions(int n, Set<PermissionInfo> set) {
        String[] stringArray = this.mPm.getPackagesForUid(n);
        if (stringArray != null && stringArray.length != 0) {
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                this.getPermissionsForPackage(stringArray[i], set);
            }
        }
    }

    private CharSequence getGroupLabel(String string2) {
        String string3;
        if (string2 == null) {
            return this.mDefaultGrpLabel;
        }
        CharSequence charSequence = this.mGroupLabelCache.get(string2);
        if (charSequence != null) {
            return charSequence;
        }
        try {
            PermissionGroupInfo permissionGroupInfo = this.mPm.getPermissionGroupInfo(string2, 0);
            string3 = ((Object)permissionGroupInfo.loadLabel(this.mPm)).toString();
            this.mGroupLabelCache.put(string2, string3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.i(TAG, "Invalid group name:" + string2);
            return null;
        }
        return string3;
    }

    private static View getPermissionItemView(Context context, LayoutInflater layoutInflater, CharSequence charSequence, CharSequence charSequence2, boolean bl, Drawable drawable2) {
        View view = layoutInflater.inflate(0x1090019, null);
        TextView textView = (TextView)view.findViewById(16908682);
        TextView textView2 = (TextView)view.findViewById(16908683);
        ((ImageView)view.findViewById(16908681)).setImageDrawable(drawable2);
        if (charSequence != null) {
            textView.setText(charSequence);
            textView2.setText(charSequence2);
            return view;
        }
        textView.setText(charSequence2);
        textView2.setVisibility(8);
        return view;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static View getPermissionItemView(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Resources resources = context.getResources();
        if (bl) {
            n = 17301904;
            return AppSecurityPermissions.getPermissionItemView(context, layoutInflater, charSequence, charSequence2, bl, resources.getDrawable(n));
        }
        n = 17301962;
        return AppSecurityPermissions.getPermissionItemView(context, layoutInflater, charSequence, charSequence2, bl, resources.getDrawable(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View getPermissionItemView(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        Drawable drawable2;
        Context context = this.mContext;
        LayoutInflater layoutInflater = this.mInflater;
        if (bl) {
            drawable2 = this.mDangerousIcon;
            return AppSecurityPermissions.getPermissionItemView(context, layoutInflater, charSequence, charSequence2, bl, drawable2);
        }
        drawable2 = this.mNormalIcon;
        return AppSecurityPermissions.getPermissionItemView(context, layoutInflater, charSequence, charSequence2, bl, drawable2);
    }

    private void getPermissionsForPackage(String string2, Set<PermissionInfo> set) {
        try {
            PackageInfo packageInfo = this.mPm.getPackageInfo(string2, 4096);
            if (packageInfo != null && packageInfo.requestedPermissions != null) {
                this.extractPerms(packageInfo.requestedPermissions, set);
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Could'nt retrieve permissions for package:" + string2);
            return;
        }
    }

    private boolean isDisplayablePermission(PermissionInfo permissionInfo) {
        return permissionInfo.protectionLevel == 1 || permissionInfo.protectionLevel == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setPermissions(List<PermissionInfo> list) {
        this.mGroupLabelCache = new HashMap();
        this.mGroupLabelCache.put(this.mDefaultGrpName, this.mDefaultGrpLabel);
        this.mDangerousMap = new HashMap<String, String>();
        this.mNormalMap = new HashMap<String, String>();
        HashMap<String, List<PermissionInfo>> hashMap = new HashMap<String, List<PermissionInfo>>();
        HashMap<String, List<PermissionInfo>> hashMap2 = new HashMap<String, List<PermissionInfo>>();
        PermissionInfoComparator permissionInfoComparator = new PermissionInfoComparator(this.mPm);
        if (list != null) {
            for (PermissionInfo permissionInfo : list) {
                List list2;
                if (this.localLOGV) {
                    Log.i(TAG, "Processing permission:" + permissionInfo.name);
                }
                if (!this.isDisplayablePermission(permissionInfo)) {
                    if (!this.localLOGV) continue;
                    Log.i(TAG, "Permission:" + permissionInfo.name + " is not displayable");
                    continue;
                }
                HashMap<String, List<PermissionInfo>> hashMap3 = permissionInfo.protectionLevel == 1 ? hashMap : hashMap2;
                String string2 = permissionInfo.group == null ? this.mDefaultGrpName : permissionInfo.group;
                if (this.localLOGV) {
                    Log.i(TAG, "Permission:" + permissionInfo.name + " belongs to group:" + string2);
                }
                if ((list2 = (List)hashMap3.get(string2)) == null) {
                    ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>();
                    hashMap3.put(string2, arrayList);
                    arrayList.add(permissionInfo);
                    continue;
                }
                int n = Collections.binarySearch(list2, permissionInfo, permissionInfoComparator);
                if (this.localLOGV) {
                    Log.i(TAG, "idx=" + n + ", list.size=" + list2.size());
                }
                if (n >= 0) continue;
                list2.add(-n - 1, permissionInfo);
            }
            this.aggregateGroupDescs(hashMap, this.mDangerousMap);
            this.aggregateGroupDescs(hashMap2, this.mNormalMap);
        }
        this.mCurrentState = State.NO_PERMS;
        if (this.mDangerousMap.size() > 0) {
            State state = this.mNormalMap.size() > 0 ? State.BOTH : State.DANGEROUS_ONLY;
            this.mCurrentState = state;
        } else if (this.mNormalMap.size() > 0) {
            this.mCurrentState = State.NORMAL_ONLY;
        }
        if (this.localLOGV) {
            Log.i(TAG, "mCurrentState=" + (Object)((Object)this.mCurrentState));
        }
        this.showPermissions();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPermissions() {
        switch (1.$SwitchMap$android$widget$AppSecurityPermissions$State[this.mCurrentState.ordinal()]) {
            default: {
                return;
            }
            case 1: {
                this.displayNoPermissions();
                return;
            }
            case 2: {
                this.displayPermissions(true);
                return;
            }
            case 3: {
                this.displayPermissions(false);
                return;
            }
            case 4: 
        }
        this.displayPermissions(true);
        if (this.mExpanded) {
            this.displayPermissions(false);
            this.mShowMoreIcon.setImageDrawable(this.mShowMaxIcon);
            this.mShowMoreText.setText(17040160);
            this.mNonDangerousList.setVisibility(0);
        } else {
            this.mShowMoreIcon.setImageDrawable(this.mShowMinIcon);
            this.mShowMoreText.setText(17040161);
            this.mNonDangerousList.setVisibility(8);
        }
        this.mShowMore.setVisibility(0);
    }

    public int getPermissionCount() {
        return this.mPermsList.size();
    }

    public View getPermissionsView() {
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPermsView = (LinearLayout)this.mInflater.inflate(17367066, null);
        this.mShowMore = this.mPermsView.findViewById(16908686);
        this.mShowMoreIcon = (ImageView)this.mShowMore.findViewById(16908688);
        this.mShowMoreText = (TextView)this.mShowMore.findViewById(16908687);
        this.mDangerousList = (LinearLayout)this.mPermsView.findViewById(16908685);
        this.mNonDangerousList = (LinearLayout)this.mPermsView.findViewById(16908689);
        this.mNoPermsView = this.mPermsView.findViewById(16908684);
        this.mShowMore.setClickable(true);
        this.mShowMore.setOnClickListener(this);
        this.mShowMore.setFocusable(true);
        this.mShowMore.setBackgroundResource(17301602);
        this.mDefaultGrpLabel = this.mContext.getString(17040157);
        this.mPermFormat = this.mContext.getString(17040158);
        this.mNormalIcon = this.mContext.getResources().getDrawable(17301962);
        this.mDangerousIcon = this.mContext.getResources().getDrawable(17301904);
        this.mShowMaxIcon = this.mContext.getResources().getDrawable(17301873);
        this.mShowMinIcon = this.mContext.getResources().getDrawable(17301874);
        this.setPermissions(this.mPermsList);
        return this.mPermsView;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        if (this.localLOGV) {
            Log.i(TAG, "mExpanded=" + this.mExpanded);
        }
        boolean bl = !this.mExpanded;
        this.mExpanded = bl;
        this.showPermissions();
    }

    private static class PermissionInfoComparator
    implements Comparator<PermissionInfo> {
        private PackageManager mPm;
        private final Collator sCollator = Collator.getInstance();

        PermissionInfoComparator(PackageManager packageManager) {
            this.mPm = packageManager;
        }

        @Override
        public final int compare(PermissionInfo permissionInfo, PermissionInfo permissionInfo2) {
            CharSequence charSequence = permissionInfo.loadLabel(this.mPm);
            CharSequence charSequence2 = permissionInfo2.loadLabel(this.mPm);
            return this.sCollator.compare(charSequence, charSequence2);
        }
    }

    private static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State BOTH;
        public static final /* enum */ State DANGEROUS_ONLY;
        public static final /* enum */ State NORMAL_ONLY;
        public static final /* enum */ State NO_PERMS;

        static {
            NO_PERMS = new State();
            DANGEROUS_ONLY = new State();
            NORMAL_ONLY = new State();
            BOTH = new State();
            State[] stateArray = new State[]{NO_PERMS, DANGEROUS_ONLY, NORMAL_ONLY, BOTH};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

