/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class EdgeGlow {
    private static final float EPSILON = 0.001f;
    private static final float HELD_EDGE_ALPHA = 0.7f;
    private static final float HELD_EDGE_SCALE_Y = 0.5f;
    private static final float HELD_GLOW_ALPHA = 0.5f;
    private static final float HELD_GLOW_SCALE_Y = 0.5f;
    private static final float MAX_ALPHA = 0.8f;
    private static final float MAX_GLOW_HEIGHT = 3.0f;
    private static final int MIN_VELOCITY = 100;
    private static final int PULL_DECAY_TIME = 1000;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final int PULL_DISTANCE_EDGE_FACTOR = 5;
    private static final int PULL_DISTANCE_GLOW_FACTOR = 5;
    private static final float PULL_EDGE_BEGIN = 0.6f;
    private static final float PULL_GLOW_BEGIN = 1.0f;
    private static final int PULL_TIME = 167;
    private static final int RECEDE_TIME = 1000;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_PULL_DECAY = 4;
    private static final int STATE_RECEDE = 3;
    private static final String TAG = "EdgeGlow";
    private static final int VELOCITY_EDGE_FACTOR = 8;
    private static final int VELOCITY_GLOW_FACTOR = 16;
    private float mDuration;
    private final Drawable mEdge;
    private float mEdgeAlpha;
    private float mEdgeAlphaFinish;
    private float mEdgeAlphaStart;
    private float mEdgeScaleY;
    private float mEdgeScaleYFinish;
    private float mEdgeScaleYStart;
    private final Drawable mGlow;
    private float mGlowAlpha;
    private float mGlowAlphaFinish;
    private float mGlowAlphaStart;
    private float mGlowScaleY;
    private float mGlowScaleYFinish;
    private float mGlowScaleYStart;
    private int mHeight;
    private final Interpolator mInterpolator;
    private float mPullDistance;
    private long mStartTime;
    private int mState = 0;
    private int mWidth;

    public EdgeGlow(Drawable drawable2, Drawable drawable3) {
        this.mEdge = drawable2;
        this.mGlow = drawable3;
        this.mInterpolator = new DecelerateInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void update() {
        float f = Math.min((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / this.mDuration, 1.0f);
        float f2 = this.mInterpolator.getInterpolation(f);
        this.mEdgeAlpha = this.mEdgeAlphaStart + f2 * (this.mEdgeAlphaFinish - this.mEdgeAlphaStart);
        this.mEdgeScaleY = this.mEdgeScaleYStart + f2 * (this.mEdgeScaleYFinish - this.mEdgeScaleYStart);
        this.mGlowAlpha = this.mGlowAlphaStart + f2 * (this.mGlowAlphaFinish - this.mGlowAlphaStart);
        this.mGlowScaleY = this.mGlowScaleYStart + f2 * (this.mGlowScaleYFinish - this.mGlowScaleYStart);
        if (!(f >= 0.999f)) return;
        switch (this.mState) {
            default: {
                return;
            }
            case 2: {
                this.mState = 3;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 1000.0f;
                this.mEdgeAlphaStart = this.mEdgeAlpha;
                this.mEdgeScaleYStart = this.mEdgeScaleY;
                this.mGlowAlphaStart = this.mGlowAlpha;
                this.mGlowScaleYStart = this.mGlowScaleY;
                this.mEdgeAlphaFinish = 0.0f;
                this.mEdgeScaleYFinish = 0.0f;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 1: {
                this.mState = 4;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 1000.0f;
                this.mEdgeAlphaStart = this.mEdgeAlpha;
                this.mEdgeScaleYStart = this.mEdgeScaleY;
                this.mGlowAlphaStart = this.mGlowAlpha;
                this.mGlowScaleYStart = this.mGlowScaleY;
                this.mEdgeAlphaFinish = 0.0f;
                this.mEdgeScaleYFinish = 0.0f;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 4: {
                float f3 = this.mGlowScaleYFinish != 0.0f ? 1.0f / (this.mGlowScaleYFinish * this.mGlowScaleYFinish) : Float.MAX_VALUE;
                this.mEdgeScaleY = this.mEdgeScaleYStart + f3 * (f2 * (this.mEdgeScaleYFinish - this.mEdgeScaleYStart));
                return;
            }
            case 3: 
        }
        this.mState = 0;
    }

    public boolean draw(Canvas canvas) {
        this.update();
        int n = this.mEdge.getIntrinsicHeight();
        int n2 = this.mGlow.getIntrinsicHeight();
        float f = (float)this.mHeight / (float)this.mWidth;
        this.mGlow.setAlpha((int)(255.0f * Math.max(0.0f, Math.min(this.mGlowAlpha, 1.0f))));
        this.mGlow.setBounds(-this.mWidth, 0, 2 * this.mWidth, (int)Math.min(0.6f * (f * ((float)n2 * this.mGlowScaleY)), 3.0f * (float)this.mHeight));
        this.mGlow.draw(canvas);
        this.mEdge.setAlpha((int)(255.0f * Math.max(0.0f, Math.min(this.mEdgeAlpha, 1.0f))));
        this.mEdge.setBounds(0, 0, this.mWidth, (int)((float)n * this.mEdgeScaleY));
        this.mEdge.draw(canvas);
        return this.mState != 0;
    }

    public void finish() {
        this.mState = 0;
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void onAbsorb(int n) {
        this.mState = 2;
        int n2 = Math.max(100, Math.abs(n));
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.1f + 0.03f * (float)n2;
        this.mEdgeAlphaStart = 0.0f;
        this.mEdgeScaleYStart = 0.0f;
        this.mEdgeScaleY = 0.0f;
        this.mGlowAlphaStart = 0.5f;
        this.mGlowScaleYStart = 0.0f;
        this.mEdgeAlphaFinish = Math.max(0, Math.min(n2 * 8, 1));
        this.mEdgeScaleYFinish = Math.max(0.5f, Math.min((float)(n2 * 8), 1.0f));
        this.mGlowScaleYFinish = Math.min(0.025f + 1.5E-4f * (float)(n2 * (n2 / 100)), 1.75f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min(1.0E-5f * (float)(n2 * 16), 0.8f));
    }

    public void onPull(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        long l = AnimationUtils.currentAnimationTimeMillis();
        if (this.mState == 4 && (float)(l - this.mStartTime) < this.mDuration) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = 1.0f;
        }
        this.mState = 1;
        this.mStartTime = l;
        this.mDuration = 167.0f;
        this.mPullDistance = f + this.mPullDistance;
        float f6 = Math.abs(this.mPullDistance);
        this.mEdgeAlphaStart = f5 = Math.max(0.6f, Math.min(f6, 0.8f));
        this.mEdgeAlpha = f5;
        this.mEdgeScaleYStart = f4 = Math.max(0.5f, Math.min(f6 * 5.0f, 1.0f));
        this.mEdgeScaleY = f4;
        this.mGlowAlphaStart = f3 = Math.min(0.8f, this.mGlowAlpha + 0.8f * Math.abs(f));
        this.mGlowAlpha = f3;
        float f7 = Math.abs(f);
        if (f > 0.0f && this.mPullDistance < 0.0f) {
            f7 = -f7;
        }
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleY = 0.0f;
        }
        this.mGlowScaleYStart = f2 = Math.min(3.0f, Math.max(0.0f, this.mGlowScaleY + f7 * 5.0f));
        this.mGlowScaleY = f2;
        this.mEdgeAlphaFinish = this.mEdgeAlpha;
        this.mEdgeScaleYFinish = this.mEdgeScaleY;
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mEdgeAlphaStart = this.mEdgeAlpha;
        this.mEdgeScaleYStart = this.mEdgeScaleY;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mEdgeAlphaFinish = 0.0f;
        this.mEdgeScaleYFinish = 0.0f;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 1000.0f;
    }

    public void setSize(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
    }
}

