/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.database.DataSetObserver;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListPosition;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.HeterogeneousExpandableList;
import java.util.ArrayList;
import java.util.Collections;

class ExpandableListConnector
extends BaseAdapter
implements Filterable {
    private final DataSetObserver mDataSetObserver;
    private ArrayList<GroupMetadata> mExpGroupMetadataList;
    private ExpandableListAdapter mExpandableListAdapter;
    private int mMaxExpGroupCount = Integer.MAX_VALUE;
    private int mTotalExpChildrenCount;

    public ExpandableListConnector(ExpandableListAdapter expandableListAdapter) {
        this.mDataSetObserver = new MyDataSetObserver();
        this.mExpGroupMetadataList = new ArrayList();
        this.setExpandableListAdapter(expandableListAdapter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshExpGroupMetadataList(boolean bl, boolean bl2) {
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n = arrayList.size();
        int n2 = 0;
        this.mTotalExpChildrenCount = 0;
        if (bl2) {
            boolean bl3 = false;
            for (int i = n - 1; i >= 0; --i) {
                GroupMetadata groupMetadata = arrayList.get(i);
                int n3 = this.findGroupPosition(groupMetadata.gId, groupMetadata.gPos);
                if (n3 == groupMetadata.gPos) continue;
                if (n3 == -1) {
                    arrayList.remove(i);
                    --n;
                }
                groupMetadata.gPos = n3;
                if (bl3) continue;
                bl3 = true;
            }
            if (bl3) {
                Collections.sort(arrayList);
            }
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            GroupMetadata groupMetadata = arrayList.get(n5);
            int n6 = groupMetadata.lastChildFlPos == -1 || bl ? this.mExpandableListAdapter.getChildrenCount(groupMetadata.gPos) : groupMetadata.lastChildFlPos - groupMetadata.flPos;
            this.mTotalExpChildrenCount = n6 + this.mTotalExpChildrenCount;
            int n7 = n2 + (groupMetadata.gPos - n4);
            n4 = groupMetadata.gPos;
            groupMetadata.flPos = n7;
            groupMetadata.lastChildFlPos = n2 = n7 + n6;
            ++n5;
        }
        return;
    }

    @Override
    public boolean areAllItemsEnabled() {
        return this.mExpandableListAdapter.areAllItemsEnabled();
    }

    boolean collapseGroup(int n) {
        PositionMetadata positionMetadata = this.getFlattenedPos(ExpandableListPosition.obtain(2, n, -1, -1));
        if (positionMetadata == null) {
            return false;
        }
        boolean bl = this.collapseGroup(positionMetadata);
        positionMetadata.recycle();
        return bl;
    }

    boolean collapseGroup(PositionMetadata positionMetadata) {
        if (positionMetadata.groupMetadata == null) {
            return false;
        }
        this.mExpGroupMetadataList.remove(positionMetadata.groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupCollapsed(positionMetadata.groupMetadata.gPos);
        return true;
    }

    boolean expandGroup(int n) {
        PositionMetadata positionMetadata = this.getFlattenedPos(ExpandableListPosition.obtain(2, n, -1, -1));
        boolean bl = this.expandGroup(positionMetadata);
        positionMetadata.recycle();
        return bl;
    }

    boolean expandGroup(PositionMetadata positionMetadata) {
        if (positionMetadata.position.groupPos < 0) {
            throw new RuntimeException("Need group");
        }
        if (this.mMaxExpGroupCount == 0) {
            return false;
        }
        if (positionMetadata.groupMetadata != null) {
            return false;
        }
        if (this.mExpGroupMetadataList.size() >= this.mMaxExpGroupCount) {
            GroupMetadata groupMetadata = this.mExpGroupMetadataList.get(0);
            int n = this.mExpGroupMetadataList.indexOf(groupMetadata);
            this.collapseGroup(groupMetadata.gPos);
            if (positionMetadata.groupInsertIndex > n) {
                --positionMetadata.groupInsertIndex;
            }
        }
        GroupMetadata groupMetadata = GroupMetadata.obtain(-1, -1, positionMetadata.position.groupPos, this.mExpandableListAdapter.getGroupId(positionMetadata.position.groupPos));
        this.mExpGroupMetadataList.add(positionMetadata.groupInsertIndex, groupMetadata);
        this.refreshExpGroupMetadataList(false, false);
        this.notifyDataSetChanged();
        this.mExpandableListAdapter.onGroupExpanded(groupMetadata.gPos);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    int findGroupPosition(long var1_1, int var3_2) {
        var4_3 = this.mExpandableListAdapter.getGroupCount();
        if (var4_3 == 0) {
            return -1;
        }
        if (var1_1 == -9223372036854775808L) {
            return -1;
        }
        var5_4 = Math.max(0, var3_2);
        var6_5 = Math.min(var4_3 - 1, var5_4);
        var7_6 = 100L + SystemClock.uptimeMillis();
        var9_7 = var6_5;
        var10_8 = var6_5;
        var11_9 = this.getAdapter();
        var12_10 = false;
        if (var11_9 != null) ** GOTO lbl18
        return -1;
        block0: while (var14_12 || var12_10 && !var13_11) {
            var6_5 = ++var10_8;
            var12_10 = false;
lbl18:
            // 4 sources

            while (true) {
                block8: {
                    block7: {
                        if (SystemClock.uptimeMillis() > var7_6) ** GOTO lbl-1000
                        if (var11_9.getGroupId(var6_5) == var1_1) {
                            return var6_5;
                        }
                        if (var10_8 != var4_3 - 1) break block7;
                        var13_11 = true;
lbl24:
                        // 2 sources

                        while (var9_7 == 0) {
                            var14_12 = true;
lbl26:
                            // 2 sources

                            while (var13_11 && var14_12) lbl-1000:
                            // 2 sources

                            {
                                return -1;
                            }
                            continue block0;
                        }
                        break block8;
                    }
                    var13_11 = false;
                    ** GOTO lbl24
                }
                var14_12 = false;
                ** GOTO lbl26
                break;
            }
        }
        if (!var13_11 && (var12_10 || var14_12)) ** GOTO lbl18
        var6_5 = --var9_7;
        var12_10 = true;
        ** while (true)
    }

    ExpandableListAdapter getAdapter() {
        return this.mExpandableListAdapter;
    }

    @Override
    public int getCount() {
        return this.mExpandableListAdapter.getGroupCount() + this.mTotalExpChildrenCount;
    }

    ArrayList<GroupMetadata> getExpandedGroupMetadataList() {
        return this.mExpGroupMetadataList;
    }

    @Override
    public Filter getFilter() {
        ExpandableListAdapter expandableListAdapter = this.getAdapter();
        if (expandableListAdapter instanceof Filterable) {
            return ((Filterable)((Object)expandableListAdapter)).getFilter();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    PositionMetadata getFlattenedPos(ExpandableListPosition expandableListPosition) {
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n = arrayList.size();
        int n2 = n - 1;
        if (n == 0) {
            return PositionMetadata.obtain(expandableListPosition.groupPos, expandableListPosition.type, expandableListPosition.groupPos, expandableListPosition.childPos, null, 0);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2) {
            n3 = n4 + (n2 - n4) / 2;
            GroupMetadata groupMetadata = arrayList.get(n3);
            if (expandableListPosition.groupPos > groupMetadata.gPos) {
                n4 = n3 + 1;
                continue;
            }
            if (expandableListPosition.groupPos < groupMetadata.gPos) {
                n2 = n3 - 1;
                continue;
            }
            if (expandableListPosition.groupPos != groupMetadata.gPos) continue;
            if (expandableListPosition.type == 2) {
                return PositionMetadata.obtain(groupMetadata.flPos, expandableListPosition.type, expandableListPosition.groupPos, expandableListPosition.childPos, groupMetadata, n3);
            }
            if (expandableListPosition.type == 1) {
                return PositionMetadata.obtain(1 + (groupMetadata.flPos + expandableListPosition.childPos), expandableListPosition.type, expandableListPosition.groupPos, expandableListPosition.childPos, groupMetadata, n3);
            }
            return null;
        }
        if (expandableListPosition.type != 2) {
            return null;
        }
        if (n4 > n3) {
            GroupMetadata groupMetadata = arrayList.get(n4 - 1);
            return PositionMetadata.obtain(groupMetadata.lastChildFlPos + (expandableListPosition.groupPos - groupMetadata.gPos), expandableListPosition.type, expandableListPosition.groupPos, expandableListPosition.childPos, null, n4);
        }
        if (n2 < n3) {
            int n5 = n2 + 1;
            GroupMetadata groupMetadata = arrayList.get(n5);
            return PositionMetadata.obtain(groupMetadata.flPos - (groupMetadata.gPos - expandableListPosition.groupPos), expandableListPosition.type, expandableListPosition.groupPos, expandableListPosition.childPos, null, n5);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object getItem(int n) {
        Object object;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        if (positionMetadata.position.type == 2) {
            object = this.mExpandableListAdapter.getGroup(positionMetadata.position.groupPos);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            object = this.mExpandableListAdapter.getChild(positionMetadata.position.groupPos, positionMetadata.position.childPos);
        }
        positionMetadata.recycle();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getItemId(int n) {
        long l;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        long l2 = this.mExpandableListAdapter.getGroupId(positionMetadata.position.groupPos);
        if (positionMetadata.position.type == 2) {
            l = this.mExpandableListAdapter.getCombinedGroupId(l2);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            long l3 = this.mExpandableListAdapter.getChildId(positionMetadata.position.groupPos, positionMetadata.position.childPos);
            l = this.mExpandableListAdapter.getCombinedChildId(l2, l3);
        }
        positionMetadata.recycle();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getItemViewType(int n) {
        int n2;
        ExpandableListPosition expandableListPosition = this.getUnflattenedPos((int)n).position;
        if (this.mExpandableListAdapter instanceof HeterogeneousExpandableList) {
            HeterogeneousExpandableList heterogeneousExpandableList = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
            n2 = expandableListPosition.type == 2 ? heterogeneousExpandableList.getGroupType(expandableListPosition.groupPos) : heterogeneousExpandableList.getChildType(expandableListPosition.groupPos, expandableListPosition.childPos) + heterogeneousExpandableList.getGroupTypeCount();
        } else {
            n2 = expandableListPosition.type == 2 ? 0 : 1;
        }
        expandableListPosition.recycle();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    PositionMetadata getUnflattenedPos(int n) {
        int n2;
        int n3;
        ArrayList<GroupMetadata> arrayList = this.mExpGroupMetadataList;
        int n4 = arrayList.size();
        int n5 = n4 - 1;
        if (n4 == 0) {
            return PositionMetadata.obtain(n, 2, n, -1, null, 0);
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 <= n5) {
            n6 = n7 + (n5 - n7) / 2;
            GroupMetadata groupMetadata = arrayList.get(n6);
            if (n > groupMetadata.lastChildFlPos) {
                n7 = n6 + 1;
                continue;
            }
            if (n < groupMetadata.flPos) {
                n5 = n6 - 1;
                continue;
            }
            if (n == groupMetadata.flPos) {
                return PositionMetadata.obtain(n, 2, groupMetadata.gPos, -1, groupMetadata, n6);
            }
            if (n > groupMetadata.lastChildFlPos) continue;
            int n8 = n - (1 + groupMetadata.flPos);
            return PositionMetadata.obtain(n, 1, groupMetadata.gPos, n8, groupMetadata, n6);
        }
        if (n7 > n6) {
            GroupMetadata groupMetadata = arrayList.get(n7 - 1);
            n3 = n7;
            n2 = n - groupMetadata.lastChildFlPos + groupMetadata.gPos;
            return PositionMetadata.obtain(n, 2, n2, -1, null, n3);
        }
        if (n5 >= n6) throw new RuntimeException("Unknown state");
        int n9 = n5 + 1;
        GroupMetadata groupMetadata = arrayList.get(n9);
        n3 = n9;
        n2 = groupMetadata.gPos - (groupMetadata.flPos - n);
        return PositionMetadata.obtain(n, 2, n2, -1, null, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        View view2;
        PositionMetadata positionMetadata = this.getUnflattenedPos(n);
        if (positionMetadata.position.type == 2) {
            view2 = this.mExpandableListAdapter.getGroupView(positionMetadata.position.groupPos, positionMetadata.isExpanded(), view, viewGroup);
        } else {
            if (positionMetadata.position.type != 1) {
                throw new RuntimeException("Flat list position is of unknown type");
            }
            boolean bl = positionMetadata.groupMetadata.lastChildFlPos == n;
            view2 = this.mExpandableListAdapter.getChildView(positionMetadata.position.groupPos, positionMetadata.position.childPos, bl, view, viewGroup);
        }
        positionMetadata.recycle();
        return view2;
    }

    @Override
    public int getViewTypeCount() {
        if (this.mExpandableListAdapter instanceof HeterogeneousExpandableList) {
            HeterogeneousExpandableList heterogeneousExpandableList = (HeterogeneousExpandableList)((Object)this.mExpandableListAdapter);
            return heterogeneousExpandableList.getGroupTypeCount() + heterogeneousExpandableList.getChildTypeCount();
        }
        return 2;
    }

    @Override
    public boolean hasStableIds() {
        return this.mExpandableListAdapter.hasStableIds();
    }

    @Override
    public boolean isEmpty() {
        ExpandableListAdapter expandableListAdapter = this.getAdapter();
        if (expandableListAdapter != null) {
            return expandableListAdapter.isEmpty();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isEnabled(int n) {
        ExpandableListPosition expandableListPosition = this.getUnflattenedPos((int)n).position;
        boolean bl = expandableListPosition.type == 1 ? this.mExpandableListAdapter.isChildSelectable(expandableListPosition.groupPos, expandableListPosition.childPos) : true;
        expandableListPosition.recycle();
        return bl;
    }

    public boolean isGroupExpanded(int n) {
        for (int i = this.mExpGroupMetadataList.size() - 1; i >= 0; --i) {
            if (this.mExpGroupMetadataList.get((int)i).gPos != n) continue;
            return true;
        }
        return false;
    }

    public void setExpandableListAdapter(ExpandableListAdapter expandableListAdapter) {
        if (this.mExpandableListAdapter != null) {
            this.mExpandableListAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mExpandableListAdapter = expandableListAdapter;
        expandableListAdapter.registerDataSetObserver(this.mDataSetObserver);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setExpandedGroupMetadataList(ArrayList<GroupMetadata> arrayList) {
        if (arrayList != null && this.mExpandableListAdapter != null) {
            int n = this.mExpandableListAdapter.getGroupCount();
            int n2 = arrayList.size() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mExpGroupMetadataList = arrayList;
                    this.refreshExpGroupMetadataList(true, false);
                    return;
                }
                if (arrayList.get((int)n2).gPos >= n) break;
                --n2;
            }
        }
    }

    public void setMaxExpGroupCount(int n) {
        this.mMaxExpGroupCount = n;
    }

    static class GroupMetadata
    implements Parcelable,
    Comparable<GroupMetadata> {
        public static final Parcelable.Creator<GroupMetadata> CREATOR = new Parcelable.Creator<GroupMetadata>(){

            @Override
            public GroupMetadata createFromParcel(Parcel parcel) {
                return GroupMetadata.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readLong());
            }

            public GroupMetadata[] newArray(int n) {
                return new GroupMetadata[n];
            }
        };
        static final int REFRESH = -1;
        int flPos;
        long gId;
        int gPos;
        int lastChildFlPos;

        private GroupMetadata() {
        }

        static GroupMetadata obtain(int n, int n2, int n3, long l) {
            GroupMetadata groupMetadata = new GroupMetadata();
            groupMetadata.flPos = n;
            groupMetadata.lastChildFlPos = n2;
            groupMetadata.gPos = n3;
            groupMetadata.gId = l;
            return groupMetadata;
        }

        @Override
        public int compareTo(GroupMetadata groupMetadata) {
            if (groupMetadata == null) {
                throw new IllegalArgumentException();
            }
            return this.gPos - groupMetadata.gPos;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.flPos);
            parcel.writeInt(this.lastChildFlPos);
            parcel.writeInt(this.gPos);
            parcel.writeLong(this.gId);
        }
    }

    protected class MyDataSetObserver
    extends DataSetObserver {
        protected MyDataSetObserver() {
        }

        @Override
        public void onChanged() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetChanged();
        }

        @Override
        public void onInvalidated() {
            ExpandableListConnector.this.refreshExpGroupMetadataList(true, true);
            ExpandableListConnector.this.notifyDataSetInvalidated();
        }
    }

    public static class PositionMetadata {
        private static final int MAX_POOL_SIZE = 5;
        private static ArrayList<PositionMetadata> sPool = new ArrayList(5);
        public int groupInsertIndex;
        public GroupMetadata groupMetadata;
        public ExpandableListPosition position;

        private PositionMetadata() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static PositionMetadata getRecycledOrCreate() {
            PositionMetadata positionMetadata;
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() <= 0) return new PositionMetadata();
                positionMetadata = sPool.remove(0);
            }
            positionMetadata.resetState();
            return positionMetadata;
        }

        static PositionMetadata obtain(int n, int n2, int n3, int n4, GroupMetadata groupMetadata, int n5) {
            PositionMetadata positionMetadata = PositionMetadata.getRecycledOrCreate();
            positionMetadata.position = ExpandableListPosition.obtain(n2, n3, n4, n);
            positionMetadata.groupMetadata = groupMetadata;
            positionMetadata.groupInsertIndex = n5;
            return positionMetadata;
        }

        private void resetState() {
            this.position = null;
            this.groupMetadata = null;
            this.groupInsertIndex = 0;
        }

        public boolean isExpanded() {
            return this.groupMetadata != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void recycle() {
            ArrayList<PositionMetadata> arrayList = sPool;
            synchronized (arrayList) {
                if (sPool.size() < 5) {
                    sPool.add(this);
                }
                return;
            }
        }
    }
}

