/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;

class FastScroller {
    private static int MIN_PAGES = 0;
    private static final int STATE_DRAGGING = 3;
    private static final int STATE_ENTER = 1;
    private static final int STATE_EXIT = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_VISIBLE = 2;
    private boolean mChangedBounds;
    private boolean mDrawOverlay;
    private Handler mHandler = new Handler();
    private int mItemCount = -1;
    private AbsListView mList;
    private BaseAdapter mListAdapter;
    private int mListOffset;
    private boolean mLongList;
    private Drawable mOverlayDrawable;
    private RectF mOverlayPos;
    private int mOverlaySize;
    private Paint mPaint;
    private boolean mScrollCompleted;
    private ScrollFade mScrollFade;
    private SectionIndexer mSectionIndexer;
    private String mSectionText;
    private Object[] mSections;
    private int mState;
    private Drawable mThumbDrawable;
    private int mThumbH;
    private int mThumbW;
    private int mThumbY;
    private int mVisibleItem;

    static {
        MIN_PAGES = 4;
    }

    public FastScroller(Context context, AbsListView absListView) {
        this.mList = absListView;
        this.init(context);
    }

    private void cancelFling() {
        MotionEvent motionEvent = MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0);
        this.mList.onTouchEvent(motionEvent);
        motionEvent.recycle();
    }

    private void getSectionsFromIndexer() {
        Object object = this.mList.getAdapter();
        this.mSectionIndexer = null;
        if (object instanceof HeaderViewListAdapter) {
            this.mListOffset = ((HeaderViewListAdapter)object).getHeadersCount();
            object = ((HeaderViewListAdapter)object).getWrappedAdapter();
        }
        if (object instanceof ExpandableListConnector) {
            ExpandableListAdapter expandableListAdapter = ((ExpandableListConnector)object).getAdapter();
            if (expandableListAdapter instanceof SectionIndexer) {
                this.mSectionIndexer = (SectionIndexer)((Object)expandableListAdapter);
                this.mListAdapter = (BaseAdapter)object;
                this.mSections = this.mSectionIndexer.getSections();
            }
            return;
        }
        if (object instanceof SectionIndexer) {
            this.mListAdapter = (BaseAdapter)object;
            this.mSectionIndexer = (SectionIndexer)object;
            this.mSections = this.mSectionIndexer.getSections();
            return;
        }
        this.mListAdapter = (BaseAdapter)object;
        this.mSections = new String[]{" "};
    }

    private void init(Context context) {
        Resources resources = context.getResources();
        this.useThumbDrawable(context, resources.getDrawable(17302131));
        this.mOverlayDrawable = resources.getDrawable(17302062);
        this.mScrollCompleted = true;
        this.getSectionsFromIndexer();
        this.mOverlaySize = context.getResources().getDimensionPixelSize(17104903);
        this.mOverlayPos = new RectF();
        this.mScrollFade = new ScrollFade();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTextSize(this.mOverlaySize / 2);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{16842806});
        int n = typedArray.getColorStateList(typedArray.getIndex(0)).getDefaultColor();
        this.mPaint.setColor(n);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mState = 0;
    }

    private void resetThumbPos() {
        int n = this.mList.getWidth();
        this.mThumbDrawable.setBounds(n - this.mThumbW, 0, n, this.mThumbH);
        this.mThumbDrawable.setAlpha(208);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollTo(float f) {
        int n;
        String string2;
        int n2;
        Object[] objectArray;
        block18: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            float f2;
            int n10;
            block16: {
                int n11;
                int n12;
                block17: {
                    block15: {
                        n10 = this.mList.getCount();
                        this.mScrollCompleted = false;
                        f2 = 1.0f / (float)n10 / 8.0f;
                        objectArray = this.mSections;
                        if (objectArray == null || objectArray.length <= 1) break block15;
                        n9 = objectArray.length;
                        n12 = (int)(f * (float)n9);
                        if (n12 >= n9) {
                            n12 = n9 - 1;
                        }
                        n8 = n12;
                        n2 = n12;
                        n11 = this.mSectionIndexer.getPositionForSection(n12);
                        n7 = n10;
                        n6 = n11;
                        n5 = n12;
                        n4 = n12 + 1;
                        int n13 = n9 - 1;
                        if (n12 < n13) {
                            n7 = this.mSectionIndexer.getPositionForSection(n12 + 1);
                        }
                        if (n7 != n11) break block16;
                        break block17;
                    }
                    int n14 = (int)(f * (float)n10);
                    if (this.mList instanceof ExpandableListView) {
                        ExpandableListView expandableListView = (ExpandableListView)this.mList;
                        expandableListView.setSelectionFromTop(expandableListView.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(n14 + this.mListOffset)), 0);
                    } else if (this.mList instanceof ListView) {
                        ((ListView)this.mList).setSelectionFromTop(n14 + this.mListOffset, 0);
                    } else {
                        this.mList.setSelection(n14 + this.mListOffset);
                    }
                    n2 = -1;
                    break block18;
                }
                while (n12 > 0) {
                    if ((n6 = this.mSectionIndexer.getPositionForSection(--n12)) != n11) {
                        n5 = n12;
                        n2 = n12;
                        break;
                    }
                    if (n12 != 0) continue;
                    n2 = 0;
                    break;
                }
            }
            for (int i = n4 + 1; i < n9 && this.mSectionIndexer.getPositionForSection(i) == n7; ++i, ++n4) {
            }
            float f3 = (float)n5 / (float)n9;
            float f4 = (float)n4 / (float)n9;
            int n15 = n5 == n8 && f - f3 < f2 ? n6 : n6 + (int)((float)(n7 - n6) * (f - f3) / (f4 - f3));
            if (n15 > (n3 = n10 - 1)) {
                n15 = n10 - 1;
            }
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expandableListView = (ExpandableListView)this.mList;
                expandableListView.setSelectionFromTop(expandableListView.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(n15 + this.mListOffset)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(n15 + this.mListOffset, 0);
            } else {
                this.mList.setSelection(n15 + this.mListOffset);
            }
        }
        if (n2 < 0) {
            this.mDrawOverlay = false;
            return;
        }
        this.mSectionText = string2 = objectArray[n2].toString();
        boolean bl = (string2.length() != 1 || string2.charAt(0) != ' ') && n2 < (n = objectArray.length);
        this.mDrawOverlay = bl;
    }

    private void useThumbDrawable(Context context, Drawable drawable2) {
        this.mThumbDrawable = drawable2;
        this.mThumbW = context.getResources().getDimensionPixelSize(17104904);
        this.mThumbH = context.getResources().getDimensionPixelSize(17104905);
        this.mChangedBounds = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        int n;
        int n2;
        int n3;
        block8: {
            block7: {
                if (this.mState == 0) break block7;
                n3 = this.mThumbY;
                n2 = this.mList.getWidth();
                ScrollFade scrollFade = this.mScrollFade;
                n = -1;
                if (this.mState == 4) {
                    n = scrollFade.getAlpha();
                    if (n < 104) {
                        this.mThumbDrawable.setAlpha(n * 2);
                    }
                    int n4 = n2 - n * this.mThumbW / 208;
                    this.mThumbDrawable.setBounds(n4, 0, n2, this.mThumbH);
                    this.mChangedBounds = true;
                }
                canvas.translate(0.0f, n3);
                this.mThumbDrawable.draw(canvas);
                canvas.translate(0.0f, -n3);
                if (this.mState == 3 && this.mDrawOverlay) {
                    this.mOverlayDrawable.draw(canvas);
                    Paint paint = this.mPaint;
                    float f = paint.descent();
                    RectF rectF = this.mOverlayPos;
                    canvas.drawText(this.mSectionText, (int)(rectF.left + rectF.right) / 2, (float)((int)(rectF.bottom + rectF.top) / 2 + this.mOverlaySize / 4) - f, paint);
                    return;
                }
                if (this.mState == 4) break block8;
            }
            return;
        }
        if (n == 0) {
            this.setState(0);
            return;
        }
        this.mList.invalidate(n2 - this.mThumbW, n3, n2, n3 + this.mThumbH);
    }

    SectionIndexer getSectionIndexer() {
        return this.mSectionIndexer;
    }

    Object[] getSections() {
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        return this.mSections;
    }

    public int getState() {
        return this.mState;
    }

    boolean isPointInside(float f, float f2) {
        return f > (float)(this.mList.getWidth() - this.mThumbW) && f2 >= (float)this.mThumbY && f2 <= (float)(this.mThumbY + this.mThumbH);
    }

    boolean isVisible() {
        return this.mState != 0;
    }

    boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mState > 0 && motionEvent.getAction() == 0 && this.isPointInside(motionEvent.getX(), motionEvent.getY())) {
            this.setState(3);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onScroll(AbsListView absListView, int n, int n2, int n3) {
        if (this.mItemCount != n3 && n2 > 0) {
            this.mItemCount = n3;
            boolean bl = this.mItemCount / n2 >= MIN_PAGES;
            this.mLongList = bl;
        }
        if (!this.mLongList) {
            if (this.mState == 0) return;
            this.setState(0);
            return;
        }
        if (n3 - n2 > 0 && this.mState != 3) {
            this.mThumbY = n * (this.mList.getHeight() - this.mThumbH) / (n3 - n2);
            if (this.mChangedBounds) {
                this.resetThumbPos();
                this.mChangedBounds = false;
            }
        }
        this.mScrollCompleted = true;
        if (n == this.mVisibleItem) return;
        this.mVisibleItem = n;
        if (this.mState == 3) return;
        this.setState(2);
        this.mHandler.postDelayed(this.mScrollFade, 1500L);
    }

    void onSizeChanged(int n, int n2, int n3, int n4) {
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setBounds(n - this.mThumbW, 0, n, this.mThumbH);
        }
        RectF rectF = this.mOverlayPos;
        rectF.left = (n - this.mOverlaySize) / 2;
        rectF.right = rectF.left + (float)this.mOverlaySize;
        rectF.top = n2 / 10;
        rectF.bottom = rectF.top + (float)this.mOverlaySize;
        if (this.mOverlayDrawable != null) {
            this.mOverlayDrawable.setBounds((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mState == 0) {
            return false;
        }
        int n = motionEvent.getAction();
        if (n == 0) {
            if (!this.isPointInside(motionEvent.getX(), motionEvent.getY())) return false;
            this.setState(3);
            if (this.mListAdapter == null && this.mList != null) {
                this.getSectionsFromIndexer();
            }
            if (this.mList != null) {
                this.mList.requestDisallowInterceptTouchEvent(true);
                this.mList.reportScrollStateChange(1);
            }
            this.cancelFling();
            return true;
        } else if (n == 1) {
            if (this.mState != 3) return false;
            if (this.mList != null) {
                this.mList.requestDisallowInterceptTouchEvent(false);
                this.mList.reportScrollStateChange(0);
            }
            this.setState(2);
            Handler handler = this.mHandler;
            handler.removeCallbacks(this.mScrollFade);
            handler.postDelayed(this.mScrollFade, 1000L);
            return true;
        } else {
            if (n != 2 || this.mState != 3) return false;
            int n2 = this.mList.getHeight();
            int n3 = 10 + ((int)motionEvent.getY() - this.mThumbH);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 + this.mThumbH > n2) {
                n3 = n2 - this.mThumbH;
            }
            if (Math.abs(this.mThumbY - n3) < 2) {
                return true;
            }
            this.mThumbY = n3;
            if (!this.mScrollCompleted) return true;
            this.scrollTo((float)this.mThumbY / (float)(n2 - this.mThumbH));
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setState(int var1_1) {
        switch (var1_1) lbl-1000:
        // 3 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    this.mState = var1_1;
                    return;
                }
            }
            case 0: {
                this.mHandler.removeCallbacks(this.mScrollFade);
                this.mList.invalidate();
                ** GOTO lbl-1000
            }
            case 2: {
                if (this.mState != 2) {
                    this.resetThumbPos();
                }
            }
            case 3: {
                this.mHandler.removeCallbacks(this.mScrollFade);
                ** GOTO lbl-1000
            }
            case 4: 
        }
        var2_2 = this.mList.getWidth();
        this.mList.invalidate(var2_2 - this.mThumbW, this.mThumbY, var2_2, this.mThumbY + this.mThumbH);
        ** while (true)
    }

    void stop() {
        this.setState(0);
    }

    public class ScrollFade
    implements Runnable {
        static final int ALPHA_MAX = 208;
        static final long FADE_DURATION = 200L;
        long mFadeDuration;
        long mStartTime;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getAlpha() {
            if (FastScroller.this.getState() != 4) {
                return 208;
            }
            long l = SystemClock.uptimeMillis();
            if (l <= this.mStartTime + this.mFadeDuration) return (int)(208L - 208L * (l - this.mStartTime) / this.mFadeDuration);
            return 0;
        }

        @Override
        public void run() {
            if (FastScroller.this.getState() != 4) {
                this.startFade();
                return;
            }
            if (this.getAlpha() > 0) {
                FastScroller.this.mList.invalidate();
                return;
            }
            FastScroller.this.setState(0);
        }

        void startFade() {
            this.mFadeDuration = 200L;
            this.mStartTime = SystemClock.uptimeMillis();
            FastScroller.this.setState(4);
        }
    }
}

