/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.NumberPickerButton;
import android.widget.TextView;

public class NumberPicker
extends LinearLayout {
    private static final char[] DIGIT_CHARACTERS;
    public static final Formatter TWO_DIGIT_FORMATTER;
    private int mCurrent;
    private boolean mDecrement;
    private NumberPickerButton mDecrementButton;
    private String[] mDisplayedValues;
    private int mEnd;
    private Formatter mFormatter;
    private final Handler mHandler;
    private boolean mIncrement;
    private NumberPickerButton mIncrementButton;
    private OnChangedListener mListener;
    private final InputFilter mNumberInputFilter;
    private int mPrevious;
    private final Runnable mRunnable = new Runnable(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (NumberPicker.this.mIncrement) {
                NumberPicker.this.changeCurrent(1 + NumberPicker.this.mCurrent);
                NumberPicker.this.mHandler.postDelayed(this, NumberPicker.this.mSpeed);
                return;
            } else {
                if (!NumberPicker.this.mDecrement) return;
                NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent - 1);
                NumberPicker.this.mHandler.postDelayed(this, NumberPicker.this.mSpeed);
                return;
            }
        }
    };
    private long mSpeed = 300L;
    private int mStart;
    private final EditText mText;

    static {
        TWO_DIGIT_FORMATTER = new Formatter(){
            final Object[] mArgs;
            final StringBuilder mBuilder = new StringBuilder();
            final java.util.Formatter mFmt = new java.util.Formatter(this.mBuilder);
            {
                this.mArgs = new Object[1];
            }

            @Override
            public String toString(int n) {
                this.mArgs[0] = n;
                this.mBuilder.delete(0, this.mBuilder.length());
                this.mFmt.format("%02d", this.mArgs);
                return this.mFmt.toString();
            }
        };
        DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(1);
        ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367107, (ViewGroup)this, true);
        this.mHandler = new Handler();
        View.OnClickListener onClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view) {
                NumberPicker.this.validateInput(NumberPicker.this.mText);
                if (!NumberPicker.this.mText.hasFocus()) {
                    NumberPicker.this.mText.requestFocus();
                }
                if (16908794 == view.getId()) {
                    NumberPicker.this.changeCurrent(1 + NumberPicker.this.mCurrent);
                    return;
                } else {
                    if (16908796 != view.getId()) return;
                    NumberPicker.this.changeCurrent(NumberPicker.this.mCurrent - 1);
                    return;
                }
            }
        };
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            @Override
            public void onFocusChange(View view, boolean bl) {
                if (!bl) {
                    NumberPicker.this.validateInput(view);
                }
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onLongClick(View view) {
                NumberPicker.this.mText.clearFocus();
                if (16908794 == view.getId()) {
                    NumberPicker.access$002(NumberPicker.this, true);
                    NumberPicker.this.mHandler.post(NumberPicker.this.mRunnable);
                    return true;
                } else {
                    if (16908796 != view.getId()) return true;
                    NumberPicker.access$402(NumberPicker.this, true);
                    NumberPicker.this.mHandler.post(NumberPicker.this.mRunnable);
                    return true;
                }
            }
        };
        NumberPickerInputFilter numberPickerInputFilter = new NumberPickerInputFilter();
        this.mNumberInputFilter = new NumberRangeKeyListener();
        this.mIncrementButton = (NumberPickerButton)this.findViewById(16908794);
        this.mIncrementButton.setOnClickListener(onClickListener);
        this.mIncrementButton.setOnLongClickListener(onLongClickListener);
        this.mIncrementButton.setNumberPicker(this);
        this.mDecrementButton = (NumberPickerButton)this.findViewById(16908796);
        this.mDecrementButton.setOnClickListener(onClickListener);
        this.mDecrementButton.setOnLongClickListener(onLongClickListener);
        this.mDecrementButton.setNumberPicker(this);
        this.mText = (EditText)this.findViewById(16908795);
        this.mText.setOnFocusChangeListener(onFocusChangeListener);
        this.mText.setFilters(new InputFilter[]{numberPickerInputFilter});
        this.mText.setRawInputType(2);
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    static /* synthetic */ boolean access$002(NumberPicker numberPicker, boolean bl) {
        numberPicker.mIncrement = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(NumberPicker numberPicker, boolean bl) {
        numberPicker.mDecrement = bl;
        return bl;
    }

    private String formatNumber(int n) {
        if (this.mFormatter != null) {
            return this.mFormatter.toString(n);
        }
        return String.valueOf(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getSelectedPos(String string2) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return this.mStart;
            }
        }
        for (int i = 0; i < this.mDisplayedValues.length; string2 = string2.toLowerCase(), ++i) {
            if (!this.mDisplayedValues[i].toLowerCase().startsWith(string2)) continue;
            return i + this.mStart;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return this.mStart;
        }
    }

    private void notifyChange() {
        if (this.mListener != null) {
            this.mListener.onChanged(this, this.mPrevious, this.mCurrent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateView() {
        if (this.mDisplayedValues == null) {
            this.mText.setText(this.formatNumber(this.mCurrent));
        } else {
            this.mText.setText(this.mDisplayedValues[this.mCurrent - this.mStart]);
        }
        this.mText.setSelection(this.mText.getText().length());
    }

    private void validateCurrentView(CharSequence charSequence) {
        int n = this.getSelectedPos(((Object)charSequence).toString());
        if (n >= this.mStart && n <= this.mEnd && this.mCurrent != n) {
            this.mPrevious = this.mCurrent;
            this.mCurrent = n;
            this.notifyChange();
        }
        this.updateView();
    }

    private void validateInput(View view) {
        String string2 = String.valueOf(((TextView)view).getText());
        if ("".equals(string2)) {
            this.updateView();
            return;
        }
        this.validateCurrentView(string2);
    }

    public void cancelDecrement() {
        this.mDecrement = false;
    }

    public void cancelIncrement() {
        this.mIncrement = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void changeCurrent(int n) {
        if (n > this.mEnd) {
            n = this.mStart;
        } else if (n < this.mStart) {
            n = this.mEnd;
        }
        this.mPrevious = this.mCurrent;
        this.mCurrent = n;
        this.notifyChange();
        this.updateView();
    }

    protected int getBeginRange() {
        return this.mStart;
    }

    public int getCurrent() {
        return this.mCurrent;
    }

    protected int getEndRange() {
        return this.mEnd;
    }

    public void setCurrent(int n) {
        if (n < this.mStart || n > this.mEnd) {
            throw new IllegalArgumentException("current should be >= start and <= end");
        }
        this.mCurrent = n;
        this.updateView();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mIncrementButton.setEnabled(bl);
        this.mDecrementButton.setEnabled(bl);
        this.mText.setEnabled(bl);
    }

    public void setFormatter(Formatter formatter) {
        this.mFormatter = formatter;
    }

    public void setOnChangeListener(OnChangedListener onChangedListener) {
        this.mListener = onChangedListener;
    }

    public void setRange(int n, int n2) {
        this.setRange(n, n2, null);
    }

    public void setRange(int n, int n2, String[] stringArray) {
        this.mDisplayedValues = stringArray;
        this.mStart = n;
        this.mEnd = n2;
        this.mCurrent = n;
        this.updateView();
        if (stringArray != null) {
            this.mText.setRawInputType(524289);
        }
    }

    public void setSpeed(long l) {
        this.mSpeed = l;
    }

    public static interface Formatter {
        public String toString(int var1);
    }

    private class NumberPickerInputFilter
    implements InputFilter {
        private NumberPickerInputFilter() {
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            if (NumberPicker.this.mDisplayedValues == null) {
                return NumberPicker.this.mNumberInputFilter.filter(charSequence, n, n2, spanned, n3, n4);
            }
            String string2 = String.valueOf(charSequence.subSequence(n, n2));
            String string3 = String.valueOf(String.valueOf(spanned.subSequence(0, n3)) + string2 + spanned.subSequence(n4, spanned.length())).toLowerCase();
            String[] stringArray = NumberPicker.this.mDisplayedValues;
            int n5 = stringArray.length;
            for (int i = 0; i < n5; ++i) {
                if (!stringArray[i].toLowerCase().startsWith(string3)) continue;
                return string2;
            }
            return "";
        }
    }

    private class NumberRangeKeyListener
    extends NumberKeyListener {
        private NumberRangeKeyListener() {
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            String string2;
            CharSequence charSequence2 = super.filter(charSequence, n, n2, spanned, n3, n4);
            if (charSequence2 == null) {
                charSequence2 = charSequence.subSequence(n, n2);
            }
            if ("".equals(string2 = String.valueOf(spanned.subSequence(0, n3)) + charSequence2 + spanned.subSequence(n4, spanned.length()))) {
                return string2;
            }
            if (NumberPicker.this.getSelectedPos(string2) > NumberPicker.this.mEnd) {
                return "";
            }
            return charSequence2;
        }

        @Override
        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        @Override
        public int getInputType() {
            return 2;
        }
    }

    public static interface OnChangedListener {
        public void onChanged(NumberPicker var1, int var2, int var3);
    }
}

