/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class ScrollBarDrawable
extends Drawable {
    private boolean mAlwaysDrawHorizontalTrack;
    private boolean mAlwaysDrawVerticalTrack;
    private boolean mChanged;
    private int mExtent;
    private Drawable mHorizontalThumb;
    private Drawable mHorizontalTrack;
    private int mOffset;
    private int mRange;
    private boolean mRangeChanged;
    private final Rect mTempBounds = new Rect();
    private boolean mVertical;
    private Drawable mVerticalThumb;
    private Drawable mVerticalTrack;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Rect rect;
        int n;
        int n2;
        boolean bl;
        block8: {
            block7: {
                bl = this.mVertical;
                n2 = this.mExtent;
                n = this.mRange;
                boolean bl2 = true;
                boolean bl3 = true;
                if (n2 <= 0 || n <= n2) {
                    bl2 = bl ? this.mAlwaysDrawVerticalTrack : this.mAlwaysDrawHorizontalTrack;
                    bl3 = false;
                }
                rect = this.getBounds();
                if (canvas.quickReject(rect.left, rect.top, rect.right, rect.bottom, Canvas.EdgeType.AA)) break block7;
                if (bl2) {
                    this.drawTrack(canvas, rect, bl);
                }
                if (bl3) break block8;
            }
            return;
        }
        int n3 = bl ? rect.height() : rect.width();
        int n4 = bl ? rect.width() : rect.height();
        int n5 = Math.round((float)n3 * (float)n2 / (float)n);
        int n6 = Math.round((float)(n3 - n5) * (float)this.mOffset / (float)(n - n2));
        int n7 = n4 * 2;
        if (n5 < n7) {
            n5 = n7;
        }
        if (n6 + n5 > n3) {
            n6 = n3 - n5;
        }
        this.drawThumb(canvas, rect, n6, n5, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawThumb(Canvas canvas, Rect rect, int n, int n2, boolean bl) {
        Rect rect2 = this.mTempBounds;
        boolean bl2 = this.mRangeChanged || this.mChanged;
        if (bl2) {
            if (bl) {
                rect2.set(rect.left, n + rect.top, rect.right, n2 + (n + rect.top));
            } else {
                rect2.set(n + rect.left, rect.top, n2 + (n + rect.left), rect.bottom);
            }
        }
        if (bl) {
            Drawable drawable2 = this.mVerticalThumb;
            if (bl2) {
                drawable2.setBounds(rect2);
            }
            drawable2.draw(canvas);
            return;
        }
        Drawable drawable3 = this.mHorizontalThumb;
        if (bl2) {
            drawable3.setBounds(rect2);
        }
        drawable3.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawTrack(Canvas canvas, Rect rect, boolean bl) {
        Drawable drawable2 = bl ? this.mVerticalTrack : this.mHorizontalTrack;
        if (drawable2 != null) {
            if (this.mChanged) {
                drawable2.setBounds(rect);
            }
            drawable2.draw(canvas);
        }
    }

    public boolean getAlwaysDrawHorizontalTrack() {
        return this.mAlwaysDrawHorizontalTrack;
    }

    public boolean getAlwaysDrawVerticalTrack() {
        return this.mAlwaysDrawVerticalTrack;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSize(boolean bl) {
        Drawable drawable2;
        if (bl) {
            Drawable drawable3;
            if (this.mVerticalTrack != null) {
                drawable3 = this.mVerticalTrack;
                return drawable3.getIntrinsicWidth();
            }
            drawable3 = this.mVerticalThumb;
            return drawable3.getIntrinsicWidth();
        }
        if (this.mHorizontalTrack != null) {
            drawable2 = this.mHorizontalTrack;
            return drawable2.getIntrinsicHeight();
        }
        drawable2 = this.mHorizontalThumb;
        return drawable2.getIntrinsicHeight();
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mChanged = true;
    }

    @Override
    public void setAlpha(int n) {
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setAlpha(n);
        }
        this.mVerticalThumb.setAlpha(n);
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setAlpha(n);
        }
        this.mHorizontalThumb.setAlpha(n);
    }

    public void setAlwaysDrawHorizontalTrack(boolean bl) {
        this.mAlwaysDrawHorizontalTrack = bl;
    }

    public void setAlwaysDrawVerticalTrack(boolean bl) {
        this.mAlwaysDrawVerticalTrack = bl;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setColorFilter(colorFilter);
        }
        this.mVerticalThumb.setColorFilter(colorFilter);
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setColorFilter(colorFilter);
        }
        this.mHorizontalThumb.setColorFilter(colorFilter);
    }

    public void setHorizontalThumbDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.mHorizontalThumb = drawable2;
        }
    }

    public void setHorizontalTrackDrawable(Drawable drawable2) {
        this.mHorizontalTrack = drawable2;
    }

    public void setParameters(int n, int n2, int n3, boolean bl) {
        if (this.mVertical != bl) {
            this.mChanged = true;
        }
        if (this.mRange != n || this.mOffset != n2 || this.mExtent != n3) {
            this.mRangeChanged = true;
        }
        this.mRange = n;
        this.mOffset = n2;
        this.mExtent = n3;
        this.mVertical = bl;
    }

    public void setVerticalThumbDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.mVerticalThumb = drawable2;
        }
    }

    public void setVerticalTrackDrawable(Drawable drawable2) {
        this.mVerticalTrack = drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("ScrollBarDrawable: range=").append(this.mRange).append(" offset=").append(this.mOffset).append(" extent=").append(this.mExtent);
        if (this.mVertical) {
            string2 = " V";
            return stringBuilder.append(string2).toString();
        }
        string2 = " H";
        return stringBuilder.append(string2).toString();
    }
}

