/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class AlertController {
    private ListAdapter mAdapter;
    View.OnClickListener mButtonHandler = new View.OnClickListener(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onClick(View view) {
            Message message;
            if (view == AlertController.this.mButtonPositive && AlertController.this.mButtonPositiveMessage != null) {
                message = Message.obtain(AlertController.this.mButtonPositiveMessage);
            } else if (view == AlertController.this.mButtonNegative && AlertController.this.mButtonNegativeMessage != null) {
                message = Message.obtain(AlertController.this.mButtonNegativeMessage);
            } else {
                Button button = AlertController.this.mButtonNeutral;
                message = null;
                if (view == button) {
                    Message message2 = AlertController.this.mButtonNeutralMessage;
                    message = null;
                    if (message2 != null) {
                        message = Message.obtain(AlertController.this.mButtonNeutralMessage);
                    }
                }
            }
            if (message != null) {
                message.sendToTarget();
            }
            AlertController.this.mHandler.obtainMessage(1, AlertController.this.mDialogInterface).sendToTarget();
        }
    };
    private Button mButtonNegative;
    private Message mButtonNegativeMessage;
    private CharSequence mButtonNegativeText;
    private Button mButtonNeutral;
    private Message mButtonNeutralMessage;
    private CharSequence mButtonNeutralText;
    private Button mButtonPositive;
    private Message mButtonPositiveMessage;
    private CharSequence mButtonPositiveText;
    private int mCheckedItem = -1;
    private final Context mContext;
    private View mCustomTitleView;
    private final DialogInterface mDialogInterface;
    private boolean mForceInverseBackground;
    private Handler mHandler;
    private Drawable mIcon;
    private int mIconId = -1;
    private ImageView mIconView;
    private ListView mListView;
    private CharSequence mMessage;
    private TextView mMessageView;
    private ScrollView mScrollView;
    private CharSequence mTitle;
    private TextView mTitleView;
    private View mView;
    private int mViewSpacingBottom;
    private int mViewSpacingLeft;
    private int mViewSpacingRight;
    private boolean mViewSpacingSpecified = false;
    private int mViewSpacingTop;
    private final Window mWindow;

    public AlertController(Context context, DialogInterface dialogInterface, Window window) {
        this.mContext = context;
        this.mDialogInterface = dialogInterface;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(dialogInterface);
    }

    static /* synthetic */ ListView access$1002(AlertController alertController, ListView listView) {
        alertController.mListView = listView;
        return listView;
    }

    static /* synthetic */ ListAdapter access$802(AlertController alertController, ListAdapter listAdapter) {
        alertController.mAdapter = listAdapter;
        return listAdapter;
    }

    static /* synthetic */ int access$902(AlertController alertController, int n) {
        alertController.mCheckedItem = n;
        return n;
    }

    static boolean canTextInput(View view) {
        if (view.onCheckIsTextEditor()) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        int n = viewGroup.getChildCount();
        while (n > 0) {
            if (!AlertController.canTextInput(viewGroup.getChildAt(--n))) continue;
            return true;
        }
        return false;
    }

    private void centerButton(Button button) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)button.getLayoutParams();
        layoutParams.gravity = 1;
        layoutParams.weight = 0.5f;
        button.setLayoutParams(layoutParams);
        this.mWindow.findViewById(16908675).setVisibility(0);
        this.mWindow.findViewById(16908676).setVisibility(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBackground(LinearLayout linearLayout, LinearLayout linearLayout2, View view, boolean bl, TypedArray typedArray, boolean bl2, View view2) {
        int n;
        int n2 = typedArray.getResourceId(0, 17302089);
        int n3 = typedArray.getResourceId(1, 17302093);
        int n4 = typedArray.getResourceId(2, 17302086);
        int n5 = typedArray.getResourceId(3, 17302083);
        int n6 = typedArray.getResourceId(4, 17302088);
        int n7 = typedArray.getResourceId(5, 17302092);
        int n8 = typedArray.getResourceId(6, 17302085);
        int n9 = typedArray.getResourceId(7, 17302082);
        int n10 = typedArray.getResourceId(8, 17302084);
        View[] viewArray = new View[4];
        boolean[] blArray = new boolean[4];
        View view3 = null;
        boolean bl3 = false;
        int n11 = 0;
        if (bl2) {
            viewArray[0] = linearLayout;
            blArray[0] = false;
            n11 = 0 + 1;
        }
        LinearLayout linearLayout3 = linearLayout2.getVisibility() == 8 ? null : linearLayout2;
        viewArray[n11] = linearLayout3;
        boolean bl4 = this.mListView != null;
        blArray[n11] = bl4;
        int n12 = n11 + 1;
        if (view != null) {
            viewArray[n12] = view;
            blArray[n12] = this.mForceInverseBackground;
            ++n12;
        }
        if (bl) {
            viewArray[n12] = view2;
            blArray[n12] = true;
        }
        boolean bl5 = false;
        for (int i = 0; i < (n = viewArray.length); ++i) {
            View view4 = viewArray[i];
            if (view4 == null) continue;
            if (view3 != null) {
                if (!bl5) {
                    int n13 = bl3 ? n7 : n3;
                    view3.setBackgroundResource(n13);
                } else {
                    int n14 = bl3 ? n8 : n4;
                    view3.setBackgroundResource(n14);
                }
                bl5 = true;
            }
            view3 = view4;
            bl3 = blArray[i];
        }
        if (view3 != null) {
            if (bl5) {
                int n15 = bl3 ? (bl ? n10 : n9) : n5;
                view3.setBackgroundResource(n15);
            } else {
                int n16 = bl3 ? n6 : n2;
                view3.setBackgroundResource(n16);
            }
        }
        if (this.mListView != null && this.mAdapter != null) {
            this.mListView.setAdapter(this.mAdapter);
            if (this.mCheckedItem > -1) {
                this.mListView.setItemChecked(this.mCheckedItem, true);
                this.mListView.setSelection(this.mCheckedItem);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupButtons() {
        int n = 0;
        this.mButtonPositive = (Button)this.mWindow.findViewById(16908313);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setVisibility(0);
            n = 0 | 1;
        }
        this.mButtonNegative = (Button)this.mWindow.findViewById(16908314);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setVisibility(0);
            n |= 2;
        }
        this.mButtonNeutral = (Button)this.mWindow.findViewById(16908315);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setVisibility(0);
            n |= 4;
        }
        if (n == 1) {
            this.centerButton(this.mButtonPositive);
            return n != 0;
        } else if (n == 2) {
            this.centerButton(this.mButtonNeutral);
            return n != 0;
        } else {
            if (n != 4) return n != 0;
            this.centerButton(this.mButtonNeutral);
        }
        return n != 0;
    }

    private void setupContent(LinearLayout linearLayout) {
        this.mScrollView = (ScrollView)this.mWindow.findViewById(16908672);
        this.mScrollView.setFocusable(false);
        this.mMessageView = (TextView)this.mWindow.findViewById(16908299);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
            return;
        }
        this.mMessageView.setVisibility(8);
        this.mScrollView.removeView(this.mMessageView);
        if (this.mListView != null) {
            linearLayout.removeView(this.mWindow.findViewById(16908672));
            linearLayout.addView((View)this.mListView, new LinearLayout.LayoutParams(-1, -1));
            linearLayout.setLayoutParams(new LinearLayout.LayoutParams(-1, 0, 1.0f));
            return;
        }
        linearLayout.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setupTitle(LinearLayout linearLayout) {
        if (this.mCustomTitleView != null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
            linearLayout.addView(this.mCustomTitleView, layoutParams);
            this.mWindow.findViewById(16908668).setVisibility(8);
            return true;
        } else {
            boolean bl = !TextUtils.isEmpty(this.mTitle);
            this.mIconView = (ImageView)this.mWindow.findViewById(16908294);
            if (!bl) {
                this.mWindow.findViewById(16908668).setVisibility(8);
                this.mIconView.setVisibility(8);
                return false;
            }
            this.mTitleView = (TextView)this.mWindow.findViewById(16908669);
            this.mTitleView.setText(this.mTitle);
            if (this.mIconId > 0) {
                this.mIconView.setImageResource(this.mIconId);
                return true;
            }
            if (this.mIcon != null) {
                this.mIconView.setImageDrawable(this.mIcon);
                return true;
            }
            if (this.mIconId != 0) return true;
            this.mTitleView.setPadding(this.mIconView.getPaddingLeft(), this.mIconView.getPaddingTop(), this.mIconView.getPaddingRight(), this.mIconView.getPaddingBottom());
            this.mIconView.setVisibility(8);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupView() {
        FrameLayout frameLayout;
        LinearLayout linearLayout = (LinearLayout)this.mWindow.findViewById(16908671);
        this.setupContent(linearLayout);
        boolean bl = this.setupButtons();
        LinearLayout linearLayout2 = (LinearLayout)this.mWindow.findViewById(16908667);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        boolean bl2 = this.setupTitle(linearLayout2);
        View view = this.mWindow.findViewById(16908674);
        if (!bl) {
            view.setVisibility(8);
        }
        if (this.mView != null) {
            frameLayout = (FrameLayout)this.mWindow.findViewById(16908673);
            FrameLayout frameLayout2 = (FrameLayout)this.mWindow.findViewById(16908331);
            frameLayout2.addView(this.mView, new ViewGroup.LayoutParams(-1, -1));
            if (this.mViewSpacingSpecified) {
                frameLayout2.setPadding(this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)frameLayout.getLayoutParams()).weight = 0.0f;
            }
        } else {
            this.mWindow.findViewById(16908673).setVisibility(8);
            frameLayout = null;
        }
        if (bl2 && (this.mMessage != null || this.mView != null)) {
            this.mWindow.findViewById(16908670).setVisibility(0);
        }
        this.setBackground(linearLayout2, linearLayout, frameLayout, bl, typedArray, bl2, view);
        typedArray.recycle();
    }

    public Button getButton(int n) {
        switch (n) {
            default: {
                return null;
            }
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: 
        }
        return this.mButtonNeutral;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void installContent() {
        this.mWindow.requestFeature(1);
        if (this.mView == null || !AlertController.canTextInput(this.mView)) {
            this.mWindow.setFlags(131072, 131072);
        }
        this.mWindow.setContentView(17367062);
        this.setupView();
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(keyEvent);
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message) {
        if (message == null && onClickListener != null) {
            message = this.mHandler.obtainMessage(n, onClickListener);
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
            case -1: {
                this.mButtonPositiveText = charSequence;
                this.mButtonPositiveMessage = message;
                return;
            }
            case -2: {
                this.mButtonNegativeText = charSequence;
                this.mButtonNegativeMessage = message;
                return;
            }
            case -3: 
        }
        this.mButtonNeutralText = charSequence;
        this.mButtonNeutralMessage = message;
    }

    public void setCustomTitle(View view) {
        this.mCustomTitleView = view;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIcon(int n) {
        this.mIconId = n;
        if (this.mIconView == null) return;
        if (n > 0) {
            this.mIconView.setImageResource(this.mIconId);
            return;
        } else {
            if (n != 0) return;
            this.mIconView.setVisibility(8);
            return;
        }
    }

    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (this.mIconView != null && this.mIcon != null) {
            this.mIconView.setImageDrawable(drawable2);
        }
    }

    public void setInverseBackgroundForced(boolean bl) {
        this.mForceInverseBackground = bl;
    }

    public void setMessage(CharSequence charSequence) {
        this.mMessage = charSequence;
        if (this.mMessageView != null) {
            this.mMessageView.setText(charSequence);
        }
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        if (this.mTitleView != null) {
            this.mTitleView.setText(charSequence);
        }
    }

    public void setView(View view) {
        this.mView = view;
        this.mViewSpacingSpecified = false;
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        this.mView = view;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = n;
        this.mViewSpacingTop = n2;
        this.mViewSpacingRight = n3;
        this.mViewSpacingBottom = n4;
    }

    public static class AlertParams {
        public ListAdapter mAdapter;
        public boolean mCancelable;
        public int mCheckedItem = -1;
        public boolean[] mCheckedItems;
        public final Context mContext;
        public Cursor mCursor;
        public View mCustomTitleView;
        public boolean mForceInverseBackground;
        public Drawable mIcon;
        public int mIconId = 0;
        public final LayoutInflater mInflater;
        public String mIsCheckedColumn;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public CharSequence[] mItems;
        public String mLabelColumn;
        public CharSequence mMessage;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public DialogInterface.OnClickListener mOnClickListener;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mPositiveButtonText;
        public boolean mRecycleOnMeasure = true;
        public CharSequence mTitle;
        public View mView;
        public int mViewSpacingBottom;
        public int mViewSpacingLeft;
        public int mViewSpacingRight;
        public boolean mViewSpacingSpecified = false;
        public int mViewSpacingTop;

        public AlertParams(Context context) {
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void createListView(final AlertController alertController) {
            void var7_4;
            final RecycleListView recycleListView = (RecycleListView)this.mInflater.inflate(17367134, null);
            if (this.mIsMultiChoice) {
                if (this.mCursor == null) {
                    ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(this.mContext, 17367059, 16908308, this.mItems){

                        @Override
                        public View getView(int n, View view, ViewGroup viewGroup) {
                            View view2 = super.getView(n, view, viewGroup);
                            if (AlertParams.this.mCheckedItems != null && AlertParams.this.mCheckedItems[n]) {
                                recycleListView.setItemChecked(n, true);
                            }
                            return view2;
                        }
                    };
                } else {
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    CursorAdapter cursorAdapter = new CursorAdapter(context, cursor, false){
                        private final int mIsCheckedIndex;
                        private final int mLabelIndex;
                        {
                            super(context, cursor, bl);
                            Cursor cursor2 = this.getCursor();
                            this.mLabelIndex = cursor2.getColumnIndexOrThrow(AlertParams.this.mLabelColumn);
                            this.mIsCheckedIndex = cursor2.getColumnIndexOrThrow(AlertParams.this.mIsCheckedColumn);
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        public void bindView(View view, Context context, Cursor cursor) {
                            ((CheckedTextView)view.findViewById(16908308)).setText(cursor.getString(this.mLabelIndex));
                            RecycleListView recycleListView2 = recycleListView;
                            int n = cursor.getPosition();
                            boolean bl = cursor.getInt(this.mIsCheckedIndex) == 1;
                            recycleListView2.setItemChecked(n, bl);
                        }

                        @Override
                        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                            return AlertParams.this.mInflater.inflate(17367059, viewGroup, false);
                        }
                    };
                }
            } else {
                int n = this.mIsSingleChoice ? 17367058 : 0x1090011;
                if (this.mCursor == null) {
                    if (this.mAdapter != null) {
                        ListAdapter listAdapter = this.mAdapter;
                    } else {
                        ArrayAdapter<CharSequence> arrayAdapter = new ArrayAdapter<CharSequence>(this.mContext, n, 16908308, this.mItems);
                    }
                } else {
                    Context context = this.mContext;
                    Cursor cursor = this.mCursor;
                    String[] stringArray = new String[]{this.mLabelColumn};
                    SimpleCursorAdapter simpleCursorAdapter = new SimpleCursorAdapter(context, n, cursor, stringArray, new int[]{16908308});
                }
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(recycleListView);
            }
            AlertController.access$802(alertController, (ListAdapter)var7_4);
            AlertController.access$902(alertController, this.mCheckedItem);
            if (this.mOnClickListener != null) {
                recycleListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                        AlertParams.this.mOnClickListener.onClick(alertController.mDialogInterface, n);
                        if (!AlertParams.this.mIsSingleChoice) {
                            alertController.mDialogInterface.dismiss();
                        }
                    }
                });
            } else if (this.mOnCheckboxClickListener != null) {
                recycleListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                        if (AlertParams.this.mCheckedItems != null) {
                            AlertParams.this.mCheckedItems[n] = recycleListView.isItemChecked(n);
                        }
                        AlertParams.this.mOnCheckboxClickListener.onClick(alertController.mDialogInterface, n, recycleListView.isItemChecked(n));
                    }
                });
            }
            if (this.mOnItemSelectedListener != null) {
                recycleListView.setOnItemSelectedListener(this.mOnItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                recycleListView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                recycleListView.setChoiceMode(2);
            }
            recycleListView.mRecycleOnMeasure = this.mRecycleOnMeasure;
            AlertController.access$1002(alertController, recycleListView);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void apply(AlertController alertController) {
            if (this.mCustomTitleView != null) {
                alertController.setCustomTitle(this.mCustomTitleView);
            } else {
                if (this.mTitle != null) {
                    alertController.setTitle(this.mTitle);
                }
                if (this.mIcon != null) {
                    alertController.setIcon(this.mIcon);
                }
                if (this.mIconId >= 0) {
                    alertController.setIcon(this.mIconId);
                }
            }
            if (this.mMessage != null) {
                alertController.setMessage(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                alertController.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
            }
            if (this.mNegativeButtonText != null) {
                alertController.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
            }
            if (this.mNeutralButtonText != null) {
                alertController.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
            }
            if (this.mForceInverseBackground) {
                alertController.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(alertController);
            }
            if (this.mView != null) {
                if (!this.mViewSpacingSpecified) {
                    alertController.setView(this.mView);
                    return;
                }
                alertController.setView(this.mView, this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
        }

        public static interface OnPrepareListViewListener {
            public void onPrepareListView(ListView var1);
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        public ButtonHandler(DialogInterface dialogInterface) {
            this.mDialog = new WeakReference<DialogInterface>(dialogInterface);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)message.obj).onClick((DialogInterface)this.mDialog.get(), message.what);
                    return;
                }
                case 1: 
            }
            ((DialogInterface)message.obj).dismiss();
        }
    }

    public static class RecycleListView
    extends ListView {
        boolean mRecycleOnMeasure = true;

        public RecycleListView(Context context) {
            super(context);
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        protected boolean recycleOnMeasure() {
            return this.mRecycleOnMeasure;
        }
    }
}

