/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import com.android.internal.os.storage.ExternalStorageFormatter;

public class ExternalMediaFormatActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final int POSITIVE_BUTTON = -1;
    private BroadcastReceiver mStorageReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            Log.d("ExternalMediaFormatActivity", "got action " + string2);
            if (string2 == "android.intent.action.MEDIA_REMOVED" || string2 == "android.intent.action.MEDIA_CHECKING" || string2 == "android.intent.action.MEDIA_MOUNTED" || string2 == "android.intent.action.MEDIA_SHARED") {
                ExternalMediaFormatActivity.this.finish();
            }
        }
    };

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        if (n == -1) {
            Intent intent = new Intent("com.android.internal.os.storage.FORMAT_ONLY");
            intent.setComponent(ExternalStorageFormatter.COMPONENT_NAME);
            this.startService(intent);
        }
        this.finish();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Log.d("ExternalMediaFormatActivity", "onCreate!");
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mIconId = 17301642;
        alertParams.mTitle = this.getString(17040179);
        alertParams.mMessage = this.getString(17040180);
        alertParams.mPositiveButtonText = this.getString(17040181);
        alertParams.mPositiveButtonListener = this;
        alertParams.mNegativeButtonText = this.getString(0x1040000);
        alertParams.mNegativeButtonListener = this;
        this.setupAlert();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.mStorageReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.MEDIA_REMOVED");
        intentFilter.addAction("android.intent.action.MEDIA_CHECKING");
        intentFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_SHARED");
        this.registerReceiver(this.mStorageReceiver, intentFilter);
    }
}

