/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class NetInitiatedActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    public static final String BUTTON_TEXT_ACCEPT = "Accept";
    public static final String BUTTON_TEXT_DENY = "Deny";
    private static final boolean DEBUG = true;
    private static final int NEGATIVE_BUTTON = -2;
    private static final int POSITIVE_BUTTON = -1;
    private static final String TAG = "NetInitiatedActivity";
    private static final boolean VERBOSE;
    private BroadcastReceiver mNetInitiatedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(NetInitiatedActivity.TAG, "NetInitiatedReceiver onReceive: " + intent.getAction());
            if (intent.getAction() == "android.intent.action.NETWORK_INITIATED_VERIFY") {
                NetInitiatedActivity.this.handleNIVerify(intent);
            }
        }
    };
    private int notificationId = -1;

    private void handleNIVerify(Intent intent) {
        this.notificationId = intent.getIntExtra("notif_id", -1);
        Log.d(TAG, "handleNIVerify action: " + intent.getAction());
    }

    private void sendUserResponse(int n) {
        Log.d(TAG, "sendUserResponse, response: " + n);
        ((LocationManager)this.getSystemService("location")).sendNiResponse(this.notificationId, n);
    }

    private void showNIError() {
        Toast.makeText((Context)this, "NI error", 1).show();
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        if (n == -1) {
            this.sendUserResponse(1);
        }
        if (n == -2) {
            this.sendUserResponse(2);
        }
        this.finish();
        this.notificationId = -1;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mIconId = 17301909;
        alertParams.mTitle = intent.getStringExtra("title");
        alertParams.mMessage = intent.getStringExtra("message");
        alertParams.mPositiveButtonText = BUTTON_TEXT_ACCEPT;
        alertParams.mPositiveButtonListener = this;
        alertParams.mNegativeButtonText = BUTTON_TEXT_DENY;
        alertParams.mNegativeButtonListener = this;
        this.notificationId = intent.getIntExtra("notif_id", -1);
        Log.d(TAG, "onCreate, notifId: " + this.notificationId);
        this.setupAlert();
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause");
        this.unregisterReceiver(this.mNetInitiatedReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume");
        this.registerReceiver(this.mNetInitiatedReceiver, new IntentFilter("android.intent.action.NETWORK_INITIATED_VERIFY"));
    }
}

