/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResolverActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private ResolveListAdapter mAdapter;
    private CheckBox mAlwaysCheck;
    private TextView mClearDefaultHint;
    private PackageManager mPm;

    @Override
    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
        if (this.mClearDefaultHint == null) {
            return;
        }
        if (bl) {
            this.mClearDefaultHint.setVisibility(0);
            return;
        }
        this.mClearDefaultHint.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        ResolveInfo resolveInfo = this.mAdapter.resolveInfoForPosition(n);
        Intent intent = this.mAdapter.intentForPosition(n);
        if (this.mAlwaysCheck != null && this.mAlwaysCheck.isChecked()) {
            String string2;
            Set<String> set;
            IntentFilter intentFilter = new IntentFilter();
            if (intent.getAction() != null) {
                String string3 = intent.getAction();
                intentFilter.addAction(string3);
            }
            if ((set = intent.getCategories()) != null) {
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    intentFilter.addCategory(iterator.next());
                }
            }
            intentFilter.addCategory("android.intent.category.DEFAULT");
            int n2 = 0xFFF0000 & resolveInfo.match;
            Uri uri = intent.getData();
            if (n2 == 0x600000 && (string2 = intent.resolveType(this)) != null) {
                try {
                    intentFilter.addDataType(string2);
                }
                catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                    Log.w("ResolverActivity", malformedMimeTypeException);
                    intentFilter = null;
                }
            }
            if (uri != null && uri.getScheme() != null && (n2 != 0x600000 || !"file".equals(uri.getScheme()) && !"content".equals(uri.getScheme()))) {
                Iterator<PatternMatcher> iterator;
                String string4 = uri.getScheme();
                intentFilter.addDataScheme(string4);
                Iterator<IntentFilter.AuthorityEntry> iterator2 = resolveInfo.filter.authoritiesIterator();
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        IntentFilter.AuthorityEntry authorityEntry = iterator2.next();
                        if (authorityEntry.match(uri) < 0) continue;
                        int n3 = authorityEntry.getPort();
                        String string5 = authorityEntry.getHost();
                        String string6 = n3 >= 0 ? Integer.toString(n3) : null;
                        intentFilter.addDataAuthority(string5, string6);
                        break;
                    }
                }
                if ((iterator = resolveInfo.filter.pathsIterator()) != null) {
                    String string7 = uri.getPath();
                    while (string7 != null && iterator.hasNext()) {
                        PatternMatcher patternMatcher = iterator.next();
                        if (!patternMatcher.match(string7)) continue;
                        String string8 = patternMatcher.getPath();
                        int n4 = patternMatcher.getType();
                        intentFilter.addDataPath(string8, n4);
                        break;
                    }
                }
            }
            if (intentFilter != null) {
                int n5 = this.mAdapter.mList.size();
                ComponentName[] componentNameArray = new ComponentName[n5];
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    ResolveInfo resolveInfo2 = ((DisplayResolveInfo)((ResolveListAdapter)this.mAdapter).mList.get((int)i)).ri;
                    componentNameArray[i] = new ComponentName(resolveInfo2.activityInfo.packageName, resolveInfo2.activityInfo.name);
                    if (resolveInfo2.match <= n6) continue;
                    n6 = resolveInfo2.match;
                }
                PackageManager packageManager = this.getPackageManager();
                ComponentName componentName = intent.getComponent();
                packageManager.addPreferredActivity(intentFilter, n6, componentNameArray, componentName);
            }
        }
        if (intent != null) {
            this.startActivity(intent);
        }
        this.finish();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        this.onCreate(bundle, new Intent(this.getIntent()), this.getResources().getText(17040105), null, null, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        super.onCreate(bundle);
        this.mPm = this.getPackageManager();
        intent.setComponent(null);
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mTitle = charSequence;
        alertParams.mOnClickListener = this;
        if (bl) {
            alertParams.mView = ((LayoutInflater)this.getSystemService("layout_inflater")).inflate(17367064, null);
            this.mAlwaysCheck = (CheckBox)alertParams.mView.findViewById(16908679);
            this.mAlwaysCheck.setText(17040106);
            this.mAlwaysCheck.setOnCheckedChangeListener(this);
            this.mClearDefaultHint = (TextView)alertParams.mView.findViewById(16908680);
            this.mClearDefaultHint.setVisibility(8);
        }
        this.mAdapter = new ResolveListAdapter(this, intent, intentArray, list);
        if (this.mAdapter.getCount() > 1) {
            alertParams.mAdapter = this.mAdapter;
        } else {
            if (this.mAdapter.getCount() == 1) {
                this.startActivity(this.mAdapter.intentForPosition(0));
                this.finish();
                return;
            }
            alertParams.mMessage = this.getResources().getText(17040109);
        }
        this.setupAlert();
    }

    private final class DisplayResolveInfo {
        Drawable displayIcon;
        CharSequence displayLabel;
        CharSequence extendedInfo;
        Intent origIntent;
        ResolveInfo ri;

        DisplayResolveInfo(ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent) {
            this.ri = resolveInfo;
            this.displayLabel = charSequence;
            this.extendedInfo = charSequence2;
            this.origIntent = intent;
        }
    }

    private final class ResolveListAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private final Intent mIntent;
        private List<DisplayResolveInfo> mList;

        /*
         * Enabled aggressive block sorting
         */
        public ResolveListAdapter(Context context, Intent intent, Intent[] intentArray, List<ResolveInfo> list) {
            int n;
            Intent intent2;
            this.mIntent = intent2 = new Intent(intent);
            this.mIntent.setComponent(null);
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            if (list == null) {
                PackageManager packageManager = ResolverActivity.this.mPm;
                int n2 = ResolverActivity.this.mAlwaysCheck != null ? 64 : 0;
                list = packageManager.queryIntentActivities(intent, 0x10000 | n2);
            }
            if (list != null && (n = list.size()) > 0) {
                ResolveInfo resolveInfo = list.get(0);
                for (int i = 1; i < n; ++i) {
                    ResolveInfo resolveInfo2 = list.get(i);
                    if (resolveInfo.priority == resolveInfo2.priority && resolveInfo.isDefault == resolveInfo2.isDefault) continue;
                    while (i < n) {
                        list.remove(i);
                        --n;
                    }
                }
                if (n > 1) {
                    ResolveInfo.DisplayNameComparator displayNameComparator = new ResolveInfo.DisplayNameComparator(ResolverActivity.this.mPm);
                    Collections.sort(list, displayNameComparator);
                }
                this.mList = new ArrayList<DisplayResolveInfo>();
                if (intentArray != null) {
                    int n3;
                    for (int i = 0; i < (n3 = intentArray.length); ++i) {
                        Intent intent3 = intentArray[i];
                        if (intent3 == null) continue;
                        ActivityInfo activityInfo = intent3.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (activityInfo == null) {
                            Log.w("ResolverActivity", "No activity found for " + intent3);
                            continue;
                        }
                        ResolveInfo resolveInfo3 = new ResolveInfo();
                        resolveInfo3.activityInfo = activityInfo;
                        if (intent3 instanceof LabeledIntent) {
                            LabeledIntent labeledIntent = (LabeledIntent)intent3;
                            resolveInfo3.resolvePackageName = labeledIntent.getSourcePackage();
                            resolveInfo3.labelRes = labeledIntent.getLabelResource();
                            resolveInfo3.nonLocalizedLabel = labeledIntent.getNonLocalizedLabel();
                            resolveInfo3.icon = labeledIntent.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(resolveInfo3, resolveInfo3.loadLabel(ResolverActivity.this.getPackageManager()), null, intent3));
                    }
                }
                ResolveInfo resolveInfo4 = list.get(0);
                int n4 = 0;
                CharSequence charSequence = resolveInfo4.loadLabel(ResolverActivity.this.mPm);
                for (int i = 1; i < n; ++i) {
                    ResolveInfo resolveInfo5;
                    CharSequence charSequence2;
                    if (charSequence == null) {
                        charSequence = resolveInfo4.activityInfo.packageName;
                    }
                    if ((charSequence2 = (resolveInfo5 = list.get(i)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        charSequence2 = resolveInfo5.activityInfo.packageName;
                    }
                    if (charSequence2.equals(charSequence)) continue;
                    int n5 = i - 1;
                    this.processGroup(list, n4, n5, resolveInfo4, charSequence);
                    resolveInfo4 = resolveInfo5;
                    charSequence = charSequence2;
                    n4 = i;
                }
                int n6 = n - 1;
                this.processGroup(list, n4, n6, resolveInfo4, charSequence);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void bindView(View view, DisplayResolveInfo displayResolveInfo) {
            TextView textView = (TextView)view.findViewById(16908308);
            TextView textView2 = (TextView)view.findViewById(16908309);
            ImageView imageView = (ImageView)view.findViewById(16908294);
            textView.setText(displayResolveInfo.displayLabel);
            if (displayResolveInfo.extendedInfo != null) {
                textView2.setVisibility(0);
                textView2.setText(displayResolveInfo.extendedInfo);
            } else {
                textView2.setVisibility(8);
            }
            if (displayResolveInfo.displayIcon == null) {
                displayResolveInfo.displayIcon = displayResolveInfo.ri.loadIcon(ResolverActivity.this.mPm);
            }
            imageView.setImageDrawable(displayResolveInfo.displayIcon);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private void processGroup(List<ResolveInfo> list, int n, int n2, ResolveInfo resolveInfo, CharSequence charSequence) {
            boolean bl;
            block9: {
                if (1 + (n2 - n) == 1) {
                    this.mList.add(new DisplayResolveInfo(resolveInfo, charSequence, null, null));
                    return;
                }
                CharSequence charSequence2 = resolveInfo.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                bl = false;
                if (charSequence2 == null) {
                    bl = true;
                }
                if (bl) break block9;
                HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
                hashSet.add(charSequence2);
                int n3 = n + 1;
                while (true) {
                    CharSequence charSequence3;
                    block11: {
                        block10: {
                            if (n3 > n2) break block10;
                            charSequence3 = list.get((int)n3).activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                            if (charSequence3 != null && !hashSet.contains(charSequence3)) break block11;
                            bl = true;
                        }
                        hashSet.clear();
                        break;
                    }
                    hashSet.add(charSequence3);
                    ++n3;
                }
            }
            int n4 = n;
            while (n4 <= n2) {
                ResolveInfo resolveInfo2 = list.get(n4);
                if (bl) {
                    this.mList.add(new DisplayResolveInfo(resolveInfo2, charSequence, resolveInfo2.activityInfo.packageName, null));
                } else {
                    this.mList.add(new DisplayResolveInfo(resolveInfo2, charSequence, resolveInfo2.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
                ++n4;
            }
        }

        @Override
        public int getCount() {
            if (this.mList != null) {
                return this.mList.size();
            }
            return 0;
        }

        @Override
        public Object getItem(int n) {
            return n;
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view == null ? this.mInflater.inflate(17367122, viewGroup, false) : view;
            this.bindView(view2, this.mList.get(n));
            return view2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Intent intentForPosition(int n) {
            if (this.mList == null) {
                return null;
            }
            DisplayResolveInfo displayResolveInfo = this.mList.get(n);
            Intent intent = displayResolveInfo.origIntent != null ? displayResolveInfo.origIntent : this.mIntent;
            Intent intent2 = new Intent(intent);
            intent2.addFlags(0x3000000);
            ActivityInfo activityInfo = displayResolveInfo.ri.activityInfo;
            intent2.setComponent(new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name));
            return intent2;
        }

        public ResolveInfo resolveInfoForPosition(int n) {
            if (this.mList == null) {
                return null;
            }
            return this.mList.get((int)n).ri;
        }
    }
}

