/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public final class RingtonePickerActivity
extends AlertActivity
implements AdapterView.OnItemSelectedListener,
Runnable,
DialogInterface.OnClickListener,
AlertController.AlertParams.OnPrepareListViewListener {
    private static final int DELAY_MS_SELECTION_PLAYED = 300;
    private static final String TAG = "RingtonePickerActivity";
    private int mClickedPos = -1;
    private Cursor mCursor;
    private Ringtone mDefaultRingtone;
    private int mDefaultRingtonePos = -1;
    private Uri mExistingUri;
    private Handler mHandler;
    private boolean mHasDefaultItem;
    private boolean mHasSilentItem;
    private DialogInterface.OnClickListener mRingtoneClickListener = new DialogInterface.OnClickListener(){

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            RingtonePickerActivity.access$002(RingtonePickerActivity.this, n);
            RingtonePickerActivity.this.playRingtone(n, 0);
        }
    };
    private RingtoneManager mRingtoneManager;
    private int mSampleRingtonePos = -1;
    private int mSilentPos = -1;
    private int mStaticItemCount;
    private Uri mUriForDefaultItem;

    static /* synthetic */ int access$002(RingtonePickerActivity ringtonePickerActivity, int n) {
        ringtonePickerActivity.mClickedPos = n;
        return n;
    }

    private int addDefaultRingtoneItem(ListView listView) {
        return this.addStaticItem(listView, 17040144);
    }

    private int addSilentItem(ListView listView) {
        return this.addStaticItem(listView, 17040146);
    }

    private int addStaticItem(ListView listView, int n) {
        TextView textView = (TextView)this.getLayoutInflater().inflate(17367058, (ViewGroup)listView, false);
        textView.setText(n);
        listView.addHeaderView(textView);
        this.mStaticItemCount = 1 + this.mStaticItemCount;
        return listView.getHeaderViewsCount() - 1;
    }

    private int getListPosition(int n) {
        if (n < 0) {
            return n;
        }
        return n + this.mStaticItemCount;
    }

    private int getRingtoneManagerPosition(int n) {
        return n - this.mStaticItemCount;
    }

    private void playRingtone(int n, int n2) {
        this.mHandler.removeCallbacks(this);
        this.mSampleRingtonePos = n;
        this.mHandler.postDelayed(this, n2);
    }

    private void stopAnyPlayingRingtone() {
        if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
            this.mDefaultRingtone.stop();
        }
        if (this.mRingtoneManager != null) {
            this.mRingtoneManager.stopPreviousRingtone();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        boolean bl = n == -1;
        this.mRingtoneManager.stopPreviousRingtone();
        if (bl) {
            Intent intent = new Intent();
            Object object = this.mClickedPos == this.mDefaultRingtonePos ? this.mUriForDefaultItem : (this.mClickedPos == this.mSilentPos ? null : this.mRingtoneManager.getRingtoneUri(this.getRingtoneManagerPosition(this.mClickedPos)));
            intent.putExtra("android.intent.extra.ringtone.PICKED_URI", (Parcelable)object);
            this.setResult(-1, intent);
        } else {
            this.setResult(0);
        }
        this.getWindow().getDecorView().post(new Runnable(){

            @Override
            public void run() {
                RingtonePickerActivity.this.mCursor.deactivate();
            }
        });
        this.finish();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mHandler = new Handler();
        Intent intent = this.getIntent();
        this.mHasDefaultItem = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_DEFAULT", true);
        this.mUriForDefaultItem = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.DEFAULT_URI");
        if (this.mUriForDefaultItem == null) {
            this.mUriForDefaultItem = Settings.System.DEFAULT_RINGTONE_URI;
        }
        this.mHasSilentItem = intent.getBooleanExtra("android.intent.extra.ringtone.SHOW_SILENT", true);
        this.mRingtoneManager = new RingtoneManager(this);
        boolean bl = intent.getBooleanExtra("android.intent.extra.ringtone.INCLUDE_DRM", true);
        this.mRingtoneManager.setIncludeDrm(bl);
        int n = intent.getIntExtra("android.intent.extra.ringtone.TYPE", -1);
        if (n != -1) {
            this.mRingtoneManager.setType(n);
        }
        this.mCursor = this.mRingtoneManager.getCursor();
        this.setVolumeControlStream(this.mRingtoneManager.inferStreamType());
        this.mExistingUri = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.EXISTING_URI");
        AlertController.AlertParams alertParams = this.mAlertParams;
        alertParams.mCursor = this.mCursor;
        alertParams.mOnClickListener = this.mRingtoneClickListener;
        alertParams.mLabelColumn = "title";
        alertParams.mIsSingleChoice = true;
        alertParams.mOnItemSelectedListener = this;
        alertParams.mPositiveButtonText = this.getString(17039370);
        alertParams.mPositiveButtonListener = this;
        alertParams.mNegativeButtonText = this.getString(0x1040000);
        alertParams.mPositiveButtonListener = this;
        alertParams.mOnPrepareListViewListener = this;
        alertParams.mTitle = intent.getCharSequenceExtra("android.intent.extra.ringtone.TITLE");
        if (alertParams.mTitle == null) {
            alertParams.mTitle = this.getString(17040147);
        }
        this.setupAlert();
    }

    public void onItemSelected(AdapterView adapterView, View view, int n, long l) {
        this.playRingtone(n, 300);
    }

    public void onNothingSelected(AdapterView adapterView) {
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.stopAnyPlayingRingtone();
    }

    @Override
    public void onPrepareListView(ListView listView) {
        if (this.mHasDefaultItem) {
            this.mDefaultRingtonePos = this.addDefaultRingtoneItem(listView);
            if (RingtoneManager.isDefault(this.mExistingUri)) {
                this.mClickedPos = this.mDefaultRingtonePos;
            }
        }
        if (this.mHasSilentItem) {
            this.mSilentPos = this.addSilentItem(listView);
            if (this.mExistingUri == null) {
                this.mClickedPos = this.mSilentPos;
            }
        }
        if (this.mClickedPos == -1) {
            this.mClickedPos = this.getListPosition(this.mRingtoneManager.getRingtonePosition(this.mExistingUri));
        }
        this.mAlertParams.mCheckedItem = this.mClickedPos;
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.stopAnyPlayingRingtone();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (this.mSampleRingtonePos == this.mSilentPos) {
            this.mRingtoneManager.stopPreviousRingtone();
            return;
        } else {
            Ringtone ringtone;
            if (this.mDefaultRingtone != null && this.mDefaultRingtone.isPlaying()) {
                this.mDefaultRingtone.stop();
                this.mDefaultRingtone = null;
            }
            if (this.mSampleRingtonePos == this.mDefaultRingtonePos) {
                if (this.mDefaultRingtone == null) {
                    this.mDefaultRingtone = RingtoneManager.getRingtone(this, this.mUriForDefaultItem);
                }
                ringtone = this.mDefaultRingtone;
                this.mRingtoneManager.stopPreviousRingtone();
            } else {
                ringtone = this.mRingtoneManager.getRingtone(this.getRingtoneManagerPosition(this.mSampleRingtonePos));
            }
            if (ringtone == null) return;
            ringtone.play();
            return;
        }
    }
}

