/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.backup;

import android.app.backup.BackupDataOutput;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.backup.IBackupTransport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.bouncycastle.util.encoders.Base64;

public class LocalTransport
extends IBackupTransport.Stub {
    private static final boolean DEBUG = true;
    private static final long RESTORE_TOKEN = 1L;
    private static final String TAG = "LocalTransport";
    private static final String TRANSPORT_DIR_NAME = "com.android.internal.backup.LocalTransport";
    private Context mContext;
    private File mDataDir = new File(Environment.getDownloadCacheDirectory(), "backup");
    private PackageManager mPackageManager;
    private int mRestorePackage = -1;
    private PackageInfo[] mRestorePackages = null;

    public LocalTransport(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
    }

    private void deleteContents(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.deleteContents(file2);
                }
                file2.delete();
            }
        }
    }

    @Override
    public int clearBackupData(PackageInfo packageInfo) {
        Log.v(TAG, "clearBackupData() pkg=" + packageInfo.packageName);
        File file = new File(this.mDataDir, packageInfo.packageName);
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            fileArray[i].delete();
        }
        file.delete();
        return 0;
    }

    @Override
    public int finishBackup() {
        Log.v(TAG, "finishBackup()");
        return 0;
    }

    @Override
    public void finishRestore() {
        Log.v(TAG, "finishRestore()");
    }

    @Override
    public RestoreSet[] getAvailableRestoreSets() throws RemoteException {
        return new RestoreSet[]{new RestoreSet("Local disk image", "flash", 1L)};
    }

    @Override
    public long getCurrentRestoreSet() {
        return 1L;
    }

    /*
     * Loose catch block
     */
    @Override
    public int getRestoreData(ParcelFileDescriptor parcelFileDescriptor) {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        if (this.mRestorePackage < 0) {
            throw new IllegalStateException("nextRestorePackage not called");
        }
        File file = new File(this.mDataDir, this.mRestorePackages[this.mRestorePackage].packageName);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Log.e(TAG, "Error listing directory: " + file);
            return 1;
        }
        Log.v(TAG, "  getRestoreData() found " + fileArray.length + " key files");
        BackupDataOutput backupDataOutput = new BackupDataOutput(parcelFileDescriptor.getFileDescriptor());
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray[i];
            FileInputStream fileInputStream = new FileInputStream(file2);
            {
                catch (IOException iOException) {
                    Log.e(TAG, "Unable to read backup records", iOException);
                    return 1;
                }
            }
            int n2 = (int)file2.length();
            byte[] byArray = new byte[n2];
            fileInputStream.read(byArray);
            String string2 = new String(Base64.decode((String)file2.getName()));
            Log.v(TAG, "    ... key=" + string2 + " size=" + n2);
            backupDataOutput.writeEntityHeader(string2, n2);
            backupDataOutput.writeEntityData(byArray, n2);
            fileInputStream.close();
            continue;
            catch (Throwable throwable) {
                fileInputStream.close();
                throw throwable;
            }
        }
        return 0;
    }

    @Override
    public int initializeDevice() {
        Log.v(TAG, "wiping all data");
        this.deleteContents(this.mDataDir);
        return 0;
    }

    @Override
    public String nextRestorePackage() {
        block2: {
            String string2;
            if (this.mRestorePackages == null) {
                throw new IllegalStateException("startRestore not called");
            }
            do {
                int n;
                this.mRestorePackage = n = 1 + this.mRestorePackage;
                if (n >= this.mRestorePackages.length) break block2;
            } while (!new File(this.mDataDir, string2 = this.mRestorePackages[this.mRestorePackage].packageName).isDirectory());
            Log.v(TAG, "  nextRestorePackage() = " + string2);
            return string2;
        }
        Log.v(TAG, "  no more packages to restore");
        return "";
    }

    /*
     * Exception decompiling
     */
    @Override
    public int performBackup(PackageInfo var1_1, ParcelFileDescriptor var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10 : 323->328)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long requestBackupTime() {
        return 0L;
    }

    @Override
    public int startRestore(long l, PackageInfo[] packageInfoArray) {
        Log.v(TAG, "start restore " + l);
        this.mRestorePackages = packageInfoArray;
        this.mRestorePackage = -1;
        return 0;
    }

    @Override
    public String transportDirName() {
        return TRANSPORT_DIR_NAME;
    }
}

