/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.Build;
import android.os.FileUtils;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NativeLibraryHelper {
    private static final String APK_LIB = "lib/";
    private static final int APK_LIB_LENGTH = 0;
    private static final boolean DEBUG_NATIVE = false;
    private static final String GDBSERVER = "gdbserver";
    private static final String LIB_PREFIX = "lib";
    private static final int LIB_PREFIX_LENGTH = 0;
    private static final String LIB_SUFFIX = ".so";
    private static final int LIB_SUFFIX_LENGTH = 0;
    private static final int MIN_ENTRY_LENGTH = 0;
    private static final int PACKAGE_INSTALL_NATIVE_ABI_MISMATCH = 2;
    private static final int PACKAGE_INSTALL_NATIVE_FOUND_LIBRARIES = 0;
    private static final int PACKAGE_INSTALL_NATIVE_NO_LIBRARIES = 1;
    private static final String TAG = "NativeHelper";

    static {
        APK_LIB_LENGTH = APK_LIB.length();
        LIB_PREFIX_LENGTH = LIB_PREFIX.length();
        LIB_SUFFIX_LENGTH = LIB_SUFFIX.length();
        MIN_ENTRY_LENGTH = 1 + (2 + APK_LIB_LENGTH + LIB_PREFIX_LENGTH) + LIB_SUFFIX_LENGTH;
    }

    public static int copyNativeBinariesLI(File file, File file2) {
        ZipFile zipFile = new ZipFile(file);
        LinkedList<Pair<ZipEntry, String>> linkedList = new LinkedList<Pair<ZipEntry, String>>();
        NativeLibraryHelper.listPackageNativeBinariesLI(zipFile, linkedList);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            try {
                Pair pair = (Pair)linkedList.get(i);
                File file3 = new File(file2, (String)pair.second);
                NativeLibraryHelper.copyNativeBinaryLI(zipFile, (ZipEntry)pair.first, file2, file3);
                continue;
            }
            catch (ZipException zipException) {
                Slog.w(TAG, "Failed to extract data from package file", zipException);
                return -2;
            }
            catch (IOException iOException) {
                Slog.w(TAG, "Failed to cache package shared libs", iOException);
                return -4;
            }
        }
        return 1;
    }

    private static void copyNativeBinaryLI(ZipFile zipFile, ZipEntry zipEntry, File file, File file2) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            File file3 = File.createTempFile("tmp", "tmp", file);
            String string2 = file3.getPath();
            if (!(FileUtils.copyToFile(inputStream, file3) && file3.setLastModified(zipEntry.getTime()) && FileUtils.setPermissions(string2, 493, -1, -1) == 0 && file3.renameTo(file2))) {
                file3.delete();
                throw new IOException("Couldn't create cached binary " + file2 + " in " + file);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static int listPackageGdbServerLI(ZipFile zipFile, String string2, List<Pair<ZipEntry, String>> list) throws IOException, ZipException {
        String string3 = APK_LIB + string2 + "/" + GDBSERVER;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().equals(string3)) continue;
            Log.d(TAG, "Found gdbserver: " + zipEntry.getName());
            list.add(Pair.create(zipEntry, GDBSERVER));
            return 0;
        }
        return 1;
    }

    public static int listPackageNativeBinariesLI(ZipFile zipFile, List<Pair<ZipEntry, String>> list) throws ZipException, IOException {
        String string2 = Build.CPU_ABI;
        int n = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, string2, list);
        if (n == 2) {
            String string3 = SystemProperties.get("ro.product.cpu.abi2", null);
            if (string3 != null) {
                n = NativeLibraryHelper.listPackageSharedLibsForAbiLI(zipFile, string3, list);
            }
            if (n == 2) {
                Slog.w(TAG, "Native ABI mismatch from package file");
                return -2;
            }
            if (n == 0) {
                string2 = string3;
            }
        }
        if (n == 0) {
            NativeLibraryHelper.listPackageGdbServerLI(zipFile, string2, list);
        }
        return 1;
    }

    private static int listPackageSharedLibsForAbiLI(ZipFile zipFile, String string2, List<Pair<ZipEntry, String>> list) throws IOException, ZipException {
        int n = string2.length();
        boolean bl = false;
        boolean bl2 = false;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n2;
            String string4;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || (string4 = zipEntry.getName()).length() < MIN_ENTRY_LENGTH || !string4.endsWith(LIB_SUFFIX) || !string4.startsWith(APK_LIB) || (n2 = string4.lastIndexOf(47)) < 0 || !string4.regionMatches(n2 + 1, LIB_PREFIX, 0, LIB_PREFIX_LENGTH)) continue;
            bl = true;
            if (n2 != n + APK_LIB_LENGTH || !string4.regionMatches(APK_LIB_LENGTH, string2, 0, n) || !FileUtils.isFilenameSafe(new File(string3 = string4.substring(n2 + 1)))) continue;
            bl2 = true;
            list.add(Pair.create(zipEntry, string3));
        }
        if (!bl) {
            return 1;
        }
        if (!bl2) {
            return 2;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean removeNativeBinariesFromDirLI(File file) {
        boolean bl = file.exists();
        boolean bl2 = false;
        if (bl) {
            File[] fileArray = file.listFiles();
            bl2 = false;
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].delete()) {
                        Slog.w(TAG, "Could not delete native binary: " + fileArray[i].getPath());
                        continue;
                    }
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public static boolean removeNativeBinariesLI(String string2) {
        return NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(string2));
    }
}

