/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.util.Log;

public class PackageHelper {
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_EXTERNAL = 2;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    private static final String TAG = "PackageHelper";
    private static final boolean localLOGV = true;

    public static String createSdDir(long l, String string2, String string3, int n) {
        IMountService iMountService;
        block4: {
            iMountService = PackageHelper.getMountService();
            int n2 = (int)(l >> 20);
            if (l - (long)(1024 * (n2 * 1024)) > 0L) {
                ++n2;
            }
            int n3 = n2 + 1;
            Log.i(TAG, "Size of container " + n3 + " MB " + l + " bytes");
            try {
                if (iMountService.createSecureContainer(string2, n3, "fat", string3, n) == 0) break block4;
                Log.e(TAG, "Failed to create secure container " + string2);
                return null;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return null;
            }
        }
        String string4 = iMountService.getSecureContainerPath(string2);
        Log.i(TAG, "Created secure container " + string2 + " at " + string4);
        return string4;
    }

    public static boolean destroySdDir(String string2) {
        try {
            Log.i(TAG, "Forcibly destroying container " + string2);
            if (PackageHelper.getMountService().destroySecureContainer(string2, true) != 0) {
                Log.i(TAG, "Failed to destroy container " + string2);
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to destroy container " + string2 + " with exception " + remoteException);
            return false;
        }
    }

    public static boolean finalizeSdDir(String string2) {
        try {
            if (PackageHelper.getMountService().finalizeSecureContainer(string2) != 0) {
                Log.i(TAG, "Failed to finalize container " + string2);
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to finalize container " + string2 + " with exception " + remoteException);
            return false;
        }
    }

    public static IMountService getMountService() {
        IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder != null) {
            return IMountService.Stub.asInterface(iBinder);
        }
        Log.e(TAG, "Can't get mount service");
        return null;
    }

    public static String getSdDir(String string2) {
        try {
            String string3 = PackageHelper.getMountService().getSecureContainerPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get container path for " + string2 + " with exception " + remoteException);
            return null;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            String[] stringArray = PackageHelper.getMountService().getSecureContainerList();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get secure container list with exception" + remoteException);
            return null;
        }
    }

    public static boolean isContainerMounted(String string2) {
        try {
            boolean bl = PackageHelper.getMountService().isSecureContainerMounted(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to find out if container " + string2 + " mounted");
            return false;
        }
    }

    public static String mountSdDir(String string2, String string3, int n) {
        block4: {
            int n2;
            try {
                n2 = PackageHelper.getMountService().mountSecureContainer(string2, string3, n);
                if (n2 == 0) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return null;
            }
            Log.i(TAG, "Failed to mount container " + string2 + " rc : " + n2);
            return null;
        }
        String string4 = PackageHelper.getMountService().getSecureContainerPath(string2);
        return string4;
    }

    public static boolean renameSdDir(String string2, String string3) {
        block3: {
            int n;
            try {
                n = PackageHelper.getMountService().renameSecureContainer(string2, string3);
                if (n == 0) break block3;
            }
            catch (RemoteException remoteException) {
                Log.i(TAG, "Failed ot rename  " + string2 + " to " + string3 + " with exception : " + remoteException);
                return false;
            }
            Log.e(TAG, "Failed to rename " + string2 + " to " + string3 + "with rc " + n);
            return false;
        }
        return true;
    }

    public static boolean unMountSdDir(String string2) {
        block3: {
            int n;
            try {
                n = PackageHelper.getMountService().unmountSecureContainer(string2, true);
                if (n == 0) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return false;
            }
            Log.e(TAG, "Failed to unmount " + string2 + " with rc " + n);
            return false;
        }
        return true;
    }
}

