/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import java.util.HashSet;

public abstract class PackageMonitor
extends BroadcastReceiver {
    public static final int PACKAGE_PERMANENT_CHANGE = 3;
    public static final int PACKAGE_TEMPORARY_CHANGE = 2;
    public static final int PACKAGE_UNCHANGED = 0;
    public static final int PACKAGE_UPDATING = 1;
    static final IntentFilter sExternalFilt;
    static final IntentFilter sNonDataFilt;
    static final IntentFilter sPackageFilt;
    String[] mAppearingPackages;
    int mChangeType;
    String[] mDisappearingPackages;
    String[] mModifiedPackages;
    Context mRegisteredContext;
    boolean mSomePackagesChanged;
    String[] mTempArray;
    final HashSet<String> mUpdatingPackages = new HashSet();

    static {
        sPackageFilt = new IntentFilter();
        sNonDataFilt = new IntentFilter();
        sExternalFilt = new IntentFilter();
        sPackageFilt.addAction("android.intent.action.PACKAGE_ADDED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_REMOVED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_CHANGED");
        sPackageFilt.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        sPackageFilt.addAction("android.intent.action.PACKAGE_RESTARTED");
        sPackageFilt.addAction("android.intent.action.UID_REMOVED");
        sPackageFilt.addDataScheme("package");
        sNonDataFilt.addAction("android.intent.action.UID_REMOVED");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
    }

    public PackageMonitor() {
        this.mTempArray = new String[1];
    }

    public boolean anyPackagesAppearing() {
        return this.mAppearingPackages != null;
    }

    public boolean anyPackagesDisappearing() {
        return this.mDisappearingPackages != null;
    }

    public boolean didSomePackagesChange() {
        return this.mSomePackagesChanged;
    }

    String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        if (uri != null) {
            return uri.getSchemeSpecificPart();
        }
        return null;
    }

    public int isPackageAppearing(String string2) {
        if (this.mAppearingPackages != null) {
            for (int i = this.mAppearingPackages.length - 1; i >= 0; --i) {
                if (!string2.equals(this.mAppearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public int isPackageDisappearing(String string2) {
        if (this.mDisappearingPackages != null) {
            for (int i = this.mDisappearingPackages.length - 1; i >= 0; --i) {
                if (!string2.equals(this.mDisappearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public boolean isPackageModified(String string2) {
        if (this.mModifiedPackages != null) {
            for (int i = this.mModifiedPackages.length - 1; i >= 0; --i) {
                if (!string2.equals(this.mModifiedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isPackageUpdating(String string2) {
        HashSet<String> hashSet = this.mUpdatingPackages;
        synchronized (hashSet) {
            return this.mUpdatingPackages.contains(string2);
        }
    }

    public void onBeginPackageChanges() {
    }

    public void onFinishPackageChanges() {
    }

    public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
        return false;
    }

    public void onPackageAdded(String string2, int n) {
    }

    public void onPackageAppeared(String string2, int n) {
    }

    public void onPackageChanged(String string2, int n, String[] stringArray) {
    }

    public void onPackageDisappeared(String string2, int n) {
    }

    public void onPackageModified(String string2) {
    }

    public void onPackageRemoved(String string2, int n) {
    }

    public void onPackageUpdateFinished(String string2, int n) {
    }

    public void onPackageUpdateStarted(String string2, int n) {
    }

    public void onPackagesAvailable(String[] stringArray) {
    }

    public void onPackagesUnavailable(String[] stringArray) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        block21: {
            String string2;
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block20: {
                                        this.onBeginPackageChanges();
                                        this.mAppearingPackages = null;
                                        this.mDisappearingPackages = null;
                                        this.mSomePackagesChanged = false;
                                        string2 = intent.getAction();
                                        if (!"android.intent.action.PACKAGE_ADDED".equals(string2)) break block20;
                                        String string3 = this.getPackageName(intent);
                                        int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                        this.mSomePackagesChanged = true;
                                        if (string3 == null) break block21;
                                        this.mAppearingPackages = this.mTempArray;
                                        this.mTempArray[0] = string3;
                                        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                            this.mModifiedPackages = this.mTempArray;
                                            this.mChangeType = 1;
                                            this.onPackageUpdateFinished(string3, n);
                                            this.onPackageModified(string3);
                                        } else {
                                            this.mChangeType = 3;
                                            this.onPackageAdded(string3, n);
                                        }
                                        this.onPackageAppeared(string3, this.mChangeType);
                                        if (this.mChangeType == 1) {
                                            HashSet<String> hashSet = this.mUpdatingPackages;
                                            // MONITORENTER : hashSet
                                            this.mUpdatingPackages.remove(string3);
                                            // MONITOREXIT : hashSet
                                        }
                                        break block21;
                                    }
                                    if (!"android.intent.action.PACKAGE_REMOVED".equals(string2)) break block22;
                                    String string4 = this.getPackageName(intent);
                                    int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                    if (string4 != null) {
                                        this.mDisappearingPackages = this.mTempArray;
                                        this.mTempArray[0] = string4;
                                        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                                            this.mChangeType = 1;
                                            HashSet<String> hashSet = this.mUpdatingPackages;
                                            // MONITORENTER : hashSet
                                            // MONITOREXIT : hashSet
                                            this.onPackageUpdateStarted(string4, n);
                                        } else {
                                            this.mChangeType = 3;
                                            this.mSomePackagesChanged = true;
                                            this.onPackageRemoved(string4, n);
                                        }
                                        this.onPackageDisappeared(string4, this.mChangeType);
                                    }
                                    break block21;
                                }
                                if (!"android.intent.action.PACKAGE_CHANGED".equals(string2)) break block23;
                                String string5 = this.getPackageName(intent);
                                int n = intent.getIntExtra("android.intent.extra.UID", 0);
                                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                                if (string5 != null) {
                                    this.mModifiedPackages = this.mTempArray;
                                    this.mTempArray[0] = string5;
                                    this.onPackageChanged(string5, n, stringArray);
                                    this.onPackageModified(string5);
                                }
                                break block21;
                            }
                            if (!"android.intent.action.QUERY_PACKAGE_RESTART".equals(string2)) break block24;
                            this.mDisappearingPackages = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                            this.mChangeType = 2;
                            if (this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), false)) {
                                this.setResultCode(-1);
                            }
                            break block21;
                        }
                        if (!"android.intent.action.PACKAGE_RESTARTED".equals(string2)) break block25;
                        String[] stringArray = new String[]{this.getPackageName(intent)};
                        this.mDisappearingPackages = stringArray;
                        this.mChangeType = 2;
                        this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), true);
                        break block21;
                    }
                    if (!"android.intent.action.UID_REMOVED".equals(string2)) break block26;
                    this.onUidRemoved(intent.getIntExtra("android.intent.extra.UID", 0));
                    break block21;
                }
                if (!"android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(string2)) break block27;
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mAppearingPackages = stringArray;
                this.mChangeType = 2;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    this.onPackagesAvailable(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.onPackageAppeared(stringArray[i], 2);
                    }
                }
                break block21;
            }
            if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(string2)) {
                String[] stringArray = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                this.mDisappearingPackages = stringArray;
                this.mChangeType = 2;
                this.mSomePackagesChanged = true;
                if (stringArray != null) {
                    this.onPackagesUnavailable(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.onPackageDisappeared(stringArray[i], 2);
                    }
                }
            }
        }
        if (this.mSomePackagesChanged) {
            this.onSomePackagesChanged();
        }
        this.onFinishPackageChanges();
    }

    public void onSomePackagesChanged() {
    }

    public void onUidRemoved(int n) {
    }

    public void register(Context context, boolean bl) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        context.registerReceiver(this, sPackageFilt);
        context.registerReceiver(this, sNonDataFilt);
        if (bl) {
            context.registerReceiver(this, sExternalFilt);
        }
    }

    public void unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver(this);
        this.mRegisteredContext = null;
    }
}

