/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.accounts.Account;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.android.internal.util.ArrayUtils;

public class SyncStateContentProviderHelper {
    private static final String[] ACCOUNT_PROJECTION;
    private static long DB_VERSION = 0L;
    public static final String PATH = "syncstate";
    private static final String QUERY_COUNT_SYNC_STATE_ROWS = "SELECT count(*) FROM _sync_state WHERE _id=?";
    private static final String SELECT_BY_ACCOUNT = "account_name=? AND account_type=?";
    private static final String SYNC_STATE_META_TABLE = "_sync_state_metadata";
    private static final String SYNC_STATE_META_VERSION_COLUMN = "version";
    private static final String SYNC_STATE_TABLE = "_sync_state";

    static {
        DB_VERSION = 1L;
        ACCOUNT_PROJECTION = new String[]{"account_name", "account_type"};
    }

    public void createDatabase(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS _sync_state");
        sQLiteDatabase.execSQL("CREATE TABLE _sync_state (_id INTEGER PRIMARY KEY,account_name TEXT NOT NULL,account_type TEXT NOT NULL,data TEXT,UNIQUE(account_name, account_type));");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS _sync_state_metadata");
        sQLiteDatabase.execSQL("CREATE TABLE _sync_state_metadata (version INTEGER);");
        ContentValues contentValues = new ContentValues();
        contentValues.put(SYNC_STATE_META_VERSION_COLUMN, DB_VERSION);
        sQLiteDatabase.insert(SYNC_STATE_META_TABLE, SYNC_STATE_META_VERSION_COLUMN, contentValues);
    }

    public int delete(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        return sQLiteDatabase.delete(SYNC_STATE_TABLE, string2, stringArray);
    }

    public long insert(SQLiteDatabase sQLiteDatabase, ContentValues contentValues) {
        return sQLiteDatabase.replace(SYNC_STATE_TABLE, "account_name", contentValues);
    }

    public void onAccountsChanged(SQLiteDatabase sQLiteDatabase, Account[] accountArray) {
        Cursor cursor = sQLiteDatabase.query(SYNC_STATE_TABLE, ACCOUNT_PROJECTION, null, null, null, null, null);
        try {
            while (cursor.moveToNext()) {
                String string2;
                String string3 = cursor.getString(0);
                if (ArrayUtils.contains(accountArray, new Account(string3, string2 = cursor.getString(1)))) continue;
                sQLiteDatabase.delete(SYNC_STATE_TABLE, SELECT_BY_ACCOUNT, new String[]{string3, string2});
            }
        }
        finally {
            cursor.close();
        }
    }

    public void onDatabaseOpened(SQLiteDatabase sQLiteDatabase) {
        if (DatabaseUtils.longForQuery(sQLiteDatabase, "SELECT version FROM _sync_state_metadata", null) != DB_VERSION) {
            this.createDatabase(sQLiteDatabase);
        }
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return sQLiteDatabase.query(SYNC_STATE_TABLE, stringArray, string2, stringArray2, null, null, string3);
    }

    public int update(SQLiteDatabase sQLiteDatabase, long l, Object object) {
        String[] stringArray = new String[]{Long.toString(l)};
        if (DatabaseUtils.longForQuery(sQLiteDatabase, QUERY_COUNT_SYNC_STATE_ROWS, stringArray) < 1L) {
            return 0;
        }
        sQLiteDatabase.execSQL("UPDATE _sync_state SET data=? WHERE _id=" + l, new Object[]{object});
        return 1;
    }

    public int update(SQLiteDatabase sQLiteDatabase, ContentValues contentValues, String string2, String[] stringArray) {
        return sQLiteDatabase.update(SYNC_STATE_TABLE, contentValues, string2, stringArray);
    }
}

