/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.android.internal.app.NetInitiatedActivity;
import java.io.UnsupportedEncodingException;

public class GpsNetInitiatedHandler {
    public static final String ACTION_NI_VERIFY = "android.intent.action.NETWORK_INITIATED_VERIFY";
    private static final boolean DEBUG = true;
    public static final int GPS_ENC_NONE = 0;
    public static final int GPS_ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GPS_ENC_SUPL_UCS2 = 3;
    public static final int GPS_ENC_SUPL_UTF8 = 2;
    public static final int GPS_ENC_UNKNOWN = -1;
    public static final int GPS_NI_NEED_NOTIFY = 1;
    public static final int GPS_NI_NEED_VERIFY = 2;
    public static final int GPS_NI_PRIVACY_OVERRIDE = 4;
    public static final int GPS_NI_RESPONSE_ACCEPT = 1;
    public static final int GPS_NI_RESPONSE_DENY = 2;
    public static final int GPS_NI_RESPONSE_NORESP = 3;
    public static final int GPS_NI_TYPE_UMTS_CTRL_PLANE = 3;
    public static final int GPS_NI_TYPE_UMTS_SUPL = 2;
    public static final int GPS_NI_TYPE_VOICE = 1;
    public static final String NI_EXTRA_CMD_NOTIF_ID = "notif_id";
    public static final String NI_EXTRA_CMD_RESPONSE = "response";
    public static final String NI_INTENT_KEY_DEFAULT_RESPONSE = "default_resp";
    public static final String NI_INTENT_KEY_MESSAGE = "message";
    public static final String NI_INTENT_KEY_NOTIF_ID = "notif_id";
    public static final String NI_INTENT_KEY_TIMEOUT = "timeout";
    public static final String NI_INTENT_KEY_TITLE = "title";
    public static final String NI_RESPONSE_EXTRA_CMD = "send_ni_response";
    private static final String TAG = "GpsNetInitiatedHandler";
    private static final boolean VERBOSE;
    private static boolean mIsHexInput;
    private final Context mContext;
    private final LocationManager mLocationManager;
    private Notification mNiNotification;
    private boolean mPlaySounds = false;
    private boolean mPopupImmediately = true;
    private boolean visible = true;

    static {
        mIsHexInput = true;
    }

    public GpsNetInitiatedHandler(Context context) {
        this.mContext = context;
        this.mLocationManager = (LocationManager)context.getSystemService("location");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String decodeGSMPackedString(byte[] byArray) {
        int n;
        byte[] byArray2;
        block7: {
            int n2 = byArray.length;
            int n3 = 0;
            int n4 = 0;
            byArray2 = new byte[2 * byArray.length];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                byte by = (byte)(n5 & 7);
                int n8 = n6 + 1;
                n4 = byArray[n6];
                if (n4 < 0) {
                    n4 += 256;
                }
                byte by2 = (byte)(0x7F & (n4 << by | n3 >> 8 - by));
                n = n5 + 1;
                byArray2[n5] = by2;
                if (by == 6) {
                    if (n8 == n2) break block7;
                    if (n4 >> 1 == 13) {
                        break block7;
                    }
                    byte by3 = (byte)(n4 >> 1);
                    n7 = n + 1;
                    byArray2[n] = by3;
                } else {
                    n7 = n;
                }
                n3 = n4;
                n5 = n7;
                n6 = n8;
            }
            n = n5;
        }
        try {
            return new String(byArray2, 0, n, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, unsupportedEncodingException.getMessage());
            return "";
        }
    }

    private static String decodeString(String string2, boolean bl, int n) {
        byte[] byArray = GpsNetInitiatedHandler.stringToByteArray(string2, bl);
        switch (n) {
            default: {
                Log.e(TAG, "Unknown encoding " + n + " for NI text " + string2);
                return string2;
            }
            case 0: {
                return string2;
            }
            case 1: {
                return GpsNetInitiatedHandler.decodeGSMPackedString(byArray);
            }
            case 2: {
                return GpsNetInitiatedHandler.decodeUTF8String(byArray);
            }
            case 3: {
                return GpsNetInitiatedHandler.decodeUCS2String(byArray);
            }
            case -1: 
        }
        return string2;
    }

    static String decodeUCS2String(byte[] byArray) {
        try {
            String string2 = new String(byArray, "UTF-16");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, unsupportedEncodingException.getMessage());
            return "";
        }
    }

    static String decodeUTF8String(byte[] byArray) {
        try {
            String string2 = new String(byArray, "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, unsupportedEncodingException.getMessage());
            return "";
        }
    }

    private static String getDialogMessage(GpsNiNotification gpsNiNotification) {
        return GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification);
    }

    public static String getDialogTitle(GpsNiNotification gpsNiNotification) {
        return GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification);
    }

    private Intent getDlgIntent(GpsNiNotification gpsNiNotification) {
        Intent intent = new Intent();
        String string2 = GpsNetInitiatedHandler.getDialogTitle(gpsNiNotification);
        String string3 = GpsNetInitiatedHandler.getDialogMessage(gpsNiNotification);
        intent.setFlags(0x10000000);
        intent.setClass(this.mContext, NetInitiatedActivity.class);
        intent.putExtra("notif_id", gpsNiNotification.notificationId);
        intent.putExtra(NI_INTENT_KEY_TITLE, string2);
        intent.putExtra(NI_INTENT_KEY_MESSAGE, string3);
        intent.putExtra(NI_INTENT_KEY_TIMEOUT, gpsNiNotification.timeout);
        intent.putExtra(NI_INTENT_KEY_DEFAULT_RESPONSE, gpsNiNotification.defaultResponse);
        Log.d(TAG, "generateIntent, title: " + string2 + ", message: " + string3 + ", timeout: " + gpsNiNotification.timeout);
        return intent;
    }

    private static String getNotifMessage(GpsNiNotification gpsNiNotification) {
        Object[] objectArray = new Object[]{GpsNetInitiatedHandler.decodeString(gpsNiNotification.requestorId, mIsHexInput, gpsNiNotification.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(gpsNiNotification.text, mIsHexInput, gpsNiNotification.textEncoding)};
        return String.format("NI Request received from [%s] for client [%s]!", objectArray);
    }

    private static String getNotifTicker(GpsNiNotification gpsNiNotification) {
        Object[] objectArray = new Object[]{GpsNetInitiatedHandler.decodeString(gpsNiNotification.requestorId, mIsHexInput, gpsNiNotification.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(gpsNiNotification.text, mIsHexInput, gpsNiNotification.textEncoding)};
        return String.format("Position request! ReqId: [%s] ClientName: [%s]", objectArray);
    }

    private static String getNotifTitle(GpsNiNotification gpsNiNotification) {
        return String.format("Position Request", new Object[0]);
    }

    private void openNiDialog(GpsNiNotification gpsNiNotification) {
        Intent intent = this.getDlgIntent(gpsNiNotification);
        Log.d(TAG, "openNiDialog, notifyId: " + gpsNiNotification.notificationId + ", requestorId: " + gpsNiNotification.requestorId + ", text: " + gpsNiNotification.text);
        this.mContext.startActivity(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNiNotification(GpsNiNotification gpsNiNotification) {
        synchronized (this) {
            NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            if (notificationManager != null) {
                String string2 = GpsNetInitiatedHandler.getNotifTitle(gpsNiNotification);
                String string3 = GpsNetInitiatedHandler.getNotifMessage(gpsNiNotification);
                Log.d(TAG, "setNiNotification, notifyId: " + gpsNiNotification.notificationId + ", title: " + string2 + ", message: " + string3);
                if (this.mNiNotification == null) {
                    this.mNiNotification = new Notification();
                    this.mNiNotification.icon = 17302203;
                    this.mNiNotification.when = 0L;
                }
                if (this.mPlaySounds) {
                    Notification notification = this.mNiNotification;
                    notification.defaults = 1 | notification.defaults;
                } else {
                    Notification notification = this.mNiNotification;
                    notification.defaults = 0xFFFFFFFE & notification.defaults;
                }
                this.mNiNotification.flags = 2;
                this.mNiNotification.tickerText = GpsNetInitiatedHandler.getNotifTicker(gpsNiNotification);
                Intent intent = !this.mPopupImmediately ? this.getDlgIntent(gpsNiNotification) : new Intent();
                PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
                this.mNiNotification.setLatestEventInfo(this.mContext, string2, string3, pendingIntent);
                if (this.visible) {
                    notificationManager.notify(gpsNiNotification.notificationId, this.mNiNotification);
                } else {
                    notificationManager.cancel(gpsNiNotification.notificationId);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static byte[] stringToByteArray(String string2, boolean bl) {
        int n = bl ? string2.length() / 2 : string2.length();
        byte[] byArray = new byte[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)Integer.parseInt(string2.substring(i * 2, 2 + i * 2), 16);
            }
            return byArray;
        } else {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)string2.charAt(i);
            }
        }
        return byArray;
    }

    public void handleNiNotification(GpsNiNotification gpsNiNotification) {
        Log.d(TAG, "handleNiNotification notificationId: " + gpsNiNotification.notificationId + " requestorId: " + gpsNiNotification.requestorId + " text: " + gpsNiNotification.text);
        if (gpsNiNotification.needNotify && gpsNiNotification.needVerify && this.mPopupImmediately) {
            this.openNiDialog(gpsNiNotification);
        }
        if (gpsNiNotification.needNotify && !gpsNiNotification.needVerify || gpsNiNotification.needNotify && gpsNiNotification.needVerify && !this.mPopupImmediately) {
            this.setNiNotification(gpsNiNotification);
        }
        if (gpsNiNotification.needNotify && !gpsNiNotification.needVerify || !gpsNiNotification.needNotify && !gpsNiNotification.needVerify || gpsNiNotification.privacyOverride) {
            this.mLocationManager.sendNiResponse(gpsNiNotification.notificationId, 1);
        }
    }

    public static class GpsNiNotification {
        public int defaultResponse;
        public Bundle extras;
        public boolean needNotify;
        public boolean needVerify;
        public int niType;
        public int notificationId;
        public boolean privacyOverride;
        public String requestorId;
        public int requestorIdEncoding;
        public String text;
        public int textEncoding;
        public int timeout;
    }

    public static class GpsNiResponse {
        Bundle extras;
        int userResponse;
    }
}

