/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.util.Log;
import java.io.IOException;
import javax.security.auth.x500.X500Principal;

public final class DNParser {
    private static final String ERROR_PARSE_ERROR = "Failed to parse DN";
    private static final String TAG = "DNParser";
    private int beg;
    private char[] chars;
    private int cur;
    private final String dn;
    private int end;
    private final int length;
    private int pos;

    public DNParser(X500Principal x500Principal) {
        this.dn = x500Principal.getName("RFC2253");
        this.length = this.dn.length();
    }

    private String escapedAV() throws IOException {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (true) {
            if (this.pos >= this.length) {
                return new String(this.chars, this.beg, this.end - this.beg);
            }
            switch (this.chars[this.pos]) {
                default: {
                    char[] cArray = this.chars;
                    int n = this.end;
                    this.end = n + 1;
                    cArray[n] = this.chars[this.pos];
                    this.pos = 1 + this.pos;
                    continue block5;
                }
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    char[] cArray = this.chars;
                    int n = this.end;
                    this.end = n + 1;
                    cArray[n] = this.getEscaped();
                    this.pos = 1 + this.pos;
                    continue block5;
                }
                case ' ': 
            }
            this.cur = this.end;
            this.pos = 1 + this.pos;
            char[] cArray = this.chars;
            int n = this.end;
            this.end = n + 1;
            cArray[n] = 32;
            while (this.pos < this.length && this.chars[this.pos] == ' ') {
                char[] cArray2 = this.chars;
                int n2 = this.end;
                this.end = n2 + 1;
                cArray2[n2] = 32;
                this.pos = 1 + this.pos;
            }
            if (this.pos == this.length || this.chars[this.pos] == ',' || this.chars[this.pos] == '+' || this.chars[this.pos] == ';') break;
        }
        return new String(this.chars, this.beg, this.cur - this.beg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getByte(int n) throws IOException {
        int n2;
        char c;
        int n3;
        if (n + 1 >= this.length) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        char c2 = this.chars[n];
        if (c2 >= '0' && c2 <= '9') {
            n3 = c2 - 48;
        } else if (c2 >= 'a' && c2 <= 'f') {
            n3 = c2 - 87;
        } else {
            if (c2 < 'A') throw new IOException(ERROR_PARSE_ERROR);
            if (c2 > 'F') throw new IOException(ERROR_PARSE_ERROR);
            n3 = c2 - 55;
        }
        if ((c = this.chars[n + 1]) >= '0' && c <= '9') {
            n2 = c - 48;
            return n2 + (n3 << 4);
        }
        if (c >= 'a' && c <= 'f') {
            n2 = c - 87;
            return n2 + (n3 << 4);
        }
        if (c < 'A') throw new IOException(ERROR_PARSE_ERROR);
        if (c > 'F') throw new IOException(ERROR_PARSE_ERROR);
        n2 = c - 55;
        return n2 + (n3 << 4);
    }

    private char getEscaped() throws IOException {
        this.pos = 1 + this.pos;
        if (this.pos == this.length) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        switch (this.chars[this.pos]) {
            default: {
                return this.getUTF8();
            }
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': 
        }
        return this.chars[this.pos];
    }

    /*
     * Enabled aggressive block sorting
     */
    private char getUTF8() throws IOException {
        int n;
        int n2;
        block9: {
            block10: {
                int n3 = this.getByte(this.pos);
                this.pos = 1 + this.pos;
                if (n3 < 128) {
                    return (char)n3;
                }
                if (n3 < 192 || n3 > 247) break block10;
                if (n3 <= 223) {
                    n2 = 1;
                    n = n3 & 0x1F;
                    break block9;
                } else if (n3 <= 239) {
                    n2 = 2;
                    n = n3 & 0xF;
                    break block9;
                } else {
                    n2 = 3;
                    n = n3 & 7;
                }
                break block9;
            }
            return '?';
        }
        int n4 = 0;
        while (n4 < n2) {
            this.pos = 1 + this.pos;
            if (this.pos == this.length || this.chars[this.pos] != '\\') {
                return '?';
            }
            this.pos = 1 + this.pos;
            int n5 = this.getByte(this.pos);
            this.pos = 1 + this.pos;
            if ((n5 & 0xC0) != 128) {
                return '?';
            }
            n = (n << 6) + (n5 & 0x3F);
            ++n4;
        }
        return (char)n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String hexAV() throws IOException {
        int n;
        if (4 + this.pos >= this.length) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        this.beg = this.pos;
        this.pos = 1 + this.pos;
        while (true) {
            block9: {
                block8: {
                    block7: {
                        if (this.pos != this.length && this.chars[this.pos] != '+' && this.chars[this.pos] != ',' && this.chars[this.pos] != ';') break block7;
                        this.end = this.pos;
                        break block8;
                    }
                    if (this.chars[this.pos] == ' ') {
                        this.end = this.pos;
                        this.pos = 1 + this.pos;
                        while (this.pos < this.length && this.chars[this.pos] == ' ') {
                            this.pos = 1 + this.pos;
                        }
                    }
                    break block9;
                }
                if ((n = this.end - this.beg) >= 5 && (n & 1) != 0) break;
                throw new IOException(ERROR_PARSE_ERROR);
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                char[] cArray = this.chars;
                int n2 = this.pos;
                cArray[n2] = (char)(32 + cArray[n2]);
            }
            this.pos = 1 + this.pos;
        }
        byte[] byArray = new byte[n / 2];
        int n3 = 0;
        int n4 = 1 + this.beg;
        while (n3 < byArray.length) {
            byArray[n3] = (byte)this.getByte(n4);
            n4 += 2;
            ++n3;
        }
        return new String(this.chars, this.beg, n);
    }

    private String nextAT() throws IOException {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            this.pos = 1 + this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos;
        this.pos = 1 + this.pos;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            this.pos = 1 + this.pos;
        }
        if (this.pos >= this.length) {
            throw new IOException(ERROR_PARSE_ERROR);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                this.pos = 1 + this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new IOException(ERROR_PARSE_ERROR);
            }
        }
        this.pos = 1 + this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            this.pos = 1 + this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[3 + this.beg] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[1 + this.beg] != 'I' && this.chars[1 + this.beg] != 'i' || this.chars[2 + this.beg] != 'D' && this.chars[2 + this.beg] != 'd')) {
            this.beg = 4 + this.beg;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String quotedAV() throws IOException {
        this.end = this.beg = (this.pos = 1 + this.pos);
        while (true) {
            if (this.pos == this.length) {
                throw new IOException(ERROR_PARSE_ERROR);
            }
            if (this.chars[this.pos] == '\"') {
                this.pos = 1 + this.pos;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    this.pos = 1 + this.pos;
                }
                return new String(this.chars, this.beg, this.end - this.beg);
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            this.pos = 1 + this.pos;
            this.end = 1 + this.end;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String find(String string2) {
        try {
            this.pos = 0;
            this.beg = 0;
            this.end = 0;
            this.cur = 0;
            this.chars = this.dn.toCharArray();
            String string3 = this.nextAT();
            if (string3 == null) {
                return null;
            }
            do {
                String string4 = "";
                if (this.pos == this.length) {
                    return null;
                }
                switch (this.chars[this.pos]) {
                    default: {
                        string4 = this.escapedAV();
                        break;
                    }
                    case '\"': {
                        string4 = this.quotedAV();
                        break;
                    }
                    case '#': {
                        string4 = this.hexAV();
                    }
                    case '+': 
                    case ',': 
                    case ';': 
                }
                if (string2.equalsIgnoreCase(string3)) {
                    return string4;
                }
                if (this.pos >= this.length) {
                    return null;
                }
                if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                    throw new IOException(ERROR_PARSE_ERROR);
                }
                this.pos = 1 + this.pos;
            } while ((string3 = this.nextAT()) != null);
            throw new IOException(ERROR_PARSE_ERROR);
        }
        catch (IOException iOException) {
            Log.e(TAG, "Failed to parse DN: " + this.dn);
            return null;
        }
    }
}

