/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.util.Log;
import com.android.internal.net.DNParser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DomainNameValidator {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;
    private static final boolean DEBUG = false;
    private static final boolean LOG_ENABLED = false;
    private static Pattern QUICK_IP_PATTERN;
    private static final String TAG = "DomainNameValidator";

    static {
        try {
            QUICK_IP_PATTERN = Pattern.compile("^[a-f0-9\\.:]+$");
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    private static boolean domainTokenMatch(String string2, String string3) {
        int n;
        if (string2 != null && string3 != null && (n = string3.indexOf(42)) >= 0 && string3.length() - 1 <= string2.length()) {
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            return string2.startsWith(string4) && string2.endsWith(string5);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isIpAddress(String string2) {
        if (string2 == null) return false;
        if (string2.length() == 0) return false;
        boolean bl = true;
        if (!bl) return bl;
        try {
            bl = QUICK_IP_PATTERN.matcher(string2).matches();
            if (!bl) return bl;
        }
        catch (UnknownHostException unknownHostException) {
            if (unknownHostException.getMessage() != null) return false;
            return false;
        }
        boolean bl2 = string2.equals(InetAddress.getByName(string2).getHostAddress());
        return bl2;
    }

    public static boolean match(X509Certificate x509Certificate, String string2) {
        if (x509Certificate == null || string2 == null || string2.length() == 0) {
            return false;
        }
        String string3 = string2.toLowerCase();
        if (!DomainNameValidator.isIpAddress(string3)) {
            return DomainNameValidator.matchDns(x509Certificate, string3);
        }
        return DomainNameValidator.matchIpAddress(x509Certificate, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchDns(String string2, String string3) {
        String[] stringArray;
        int n;
        if (string2 == null) return false;
        if (string2.length() == 0) return false;
        if (string3 == null) return false;
        if (string3.length() == 0) {
            return false;
        }
        String string4 = string3.toLowerCase();
        boolean bl = string2.equals(string4);
        if (bl) return bl;
        String[] stringArray2 = string2.split("\\.");
        int n2 = stringArray2.length;
        if (n2 < (n = (stringArray = string4.split("\\.")).length)) return string4.equals("*." + string2);
        int n3 = n - 1;
        while (n3 >= 0) {
            bl = stringArray2[n3].equals(stringArray[n3]);
            if (!bl) {
                if (n3 != 0) return false;
                if (n2 != n) return false;
                bl = true;
                if (!bl) return bl;
                bl = stringArray[0].equals("*");
                if (bl) return bl;
                return DomainNameValidator.domainTokenMatch(stringArray2[0], stringArray[0]);
            }
            --n3;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchDns(X509Certificate x509Certificate, String string2) {
        String string3;
        boolean bl;
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            bl = false;
            if (collection != null) {
                for (List<?> list : collection) {
                    boolean bl2;
                    Integer n;
                    if (list == null || 2 > list.size() || (n = (Integer)list.get(0)) == null || n != 2) continue;
                    bl = true;
                    String string4 = (String)list.get(1);
                    if (string4 == null || !(bl2 = DomainNameValidator.matchDns(string2, string4))) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            String string5 = certificateParsingException.getMessage();
            if (string5 == null) {
                string5 = "failed to parse certificate";
            }
            Log.w(TAG, "DomainNameValidator.matchDns(): " + string5);
            return false;
        }
        if (!bl && (string3 = new DNParser(x509Certificate.getSubjectX500Principal()).find("cn")) != null) {
            return DomainNameValidator.matchDns(string2, string3);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchIpAddress(X509Certificate x509Certificate, String string2) {
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) return false;
            for (List<?> list : collection) {
                boolean bl;
                String string3;
                Integer n;
                if (list == null || 2 > list.size() || (n = (Integer)list.get(0)) == null || n != 7 || (string3 = (String)list.get(1)) == null || !(bl = string2.equalsIgnoreCase(string3))) continue;
                return true;
            }
            return false;
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }
}

